/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementSurface;
import org.opensourcephysics.display3d.simple3d.AbstractTile;

public class ElementSurface
extends AbstractTile
implements org.opensourcephysics.display3d.core.ElementSurface {
    protected double[][][] data;
    protected int nu = -1;
    protected int nv = -1;

    public ElementSurface() {
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
    }

    public void setData(double[][][] dArray) {
        this.data = dArray;
        this.setElementChanged(true);
    }

    public double[][][] getData() {
        return this.data;
    }

    public void getExtrema(double[] dArray, double[] dArray2) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double[] dArray3 = new double[3];
        int n = 0;
        int n2 = this.data.length;
        while (n < n2) {
            int n3 = 0;
            int n4 = this.data[0].length;
            while (n3 < n4) {
                System.arraycopy(this.data[n][n3], 0, dArray3, 0, 3);
                this.sizeAndToSpaceFrame(dArray3);
                d = Math.min(d, dArray3[0]);
                d2 = Math.max(d2, dArray3[0]);
                d3 = Math.min(d3, dArray3[1]);
                d4 = Math.max(d4, dArray3[1]);
                d5 = Math.min(d5, dArray3[2]);
                d6 = Math.max(d6, dArray3[2]);
                ++n3;
            }
            ++n;
        }
        dArray[0] = d;
        dArray2[0] = d2;
        dArray[1] = d3;
        dArray2[1] = d4;
        dArray[2] = d5;
        dArray2[2] = d6;
    }

    protected synchronized void computeCorners() {
        int n;
        int n2;
        if (this.data == null) {
            return;
        }
        int n3 = this.data.length - 1;
        int n4 = this.data[0].length - 1;
        if (this.nu != n3 || this.nv != n4) {
            this.nu = n3;
            this.nv = n4;
            this.setCorners(new double[this.nu * this.nv][4][3]);
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.nv) {
            n2 = 0;
            while (n2 < this.nu) {
                n = 0;
                while (n < 3) {
                    this.corners[n5][0][n] = this.data[n2][n6][n];
                    this.corners[n5][1][n] = this.data[n2 + 1][n6][n];
                    this.corners[n5][2][n] = this.data[n2 + 1][n6 + 1][n];
                    this.corners[n5][3][n] = this.data[n2][n6 + 1][n];
                    ++n;
                }
                ++n2;
                ++n5;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < this.numberOfTiles) {
            n2 = 0;
            n = this.corners[n6].length;
            while (n2 < n) {
                this.sizeAndToSpaceFrame(this.corners[n6][n2]);
                ++n2;
            }
            ++n6;
        }
        this.setElementChanged(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementSurface.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementSurface();
        }
    }
}

