/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementCone;
import org.opensourcephysics.display3d.simple3d.AbstractTile;
import org.opensourcephysics.display3d.simple3d.Resolution;
import org.opensourcephysics.display3d.simple3d.utils.ConeUtils;

public class ElementCone
extends AbstractTile
implements org.opensourcephysics.display3d.core.ElementCone {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean closedLeft = true;
    private boolean closedRight = true;
    private int minAngle = 0;
    private int maxAngle = 360;
    private double truncationHeight = Double.NaN;
    private boolean changeNTiles = true;
    private int nr = -1;
    private int nu = -1;
    private int nz = -1;
    private double[][][] standardCone = null;
    protected static final double TO_RADIANS = Math.PI / 180;

    public ElementCone() {
        this.getStyle().setResolution(new Resolution(3, 12, 5));
    }

    public void setTruncationHeight(double d) {
        if (d < 0.0) {
            d = Double.NaN;
        }
        this.truncationHeight = d;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public double getTruncationHeight() {
        return this.truncationHeight;
    }

    public void setClosedBottom(boolean bl) {
        this.closedBottom = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean bl) {
        this.closedTop = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean bl) {
        this.closedLeft = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean bl) {
        this.closedRight = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setMinimumAngle(int n) {
        this.minAngle = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMinimumAngle() {
        return this.minAngle;
    }

    public void setMaximumAngle(int n) {
        this.maxAngle = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMaximumAngle() {
        return this.maxAngle;
    }

    protected synchronized void computeCorners() {
        double d;
        org.opensourcephysics.display3d.core.Resolution resolution;
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        double d2 = this.maxAngle;
        double d3 = this.minAngle;
        if (Math.abs(d2 - d3) > 360.0) {
            d2 = d3 + 360.0;
        }
        if ((resolution = this.getRealStyle().getResolution()) != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    n3 = Math.max(resolution.getN3(), 1);
                    break;
                }
                case 1: {
                    d = Math.abs(this.getSizeX()) / 2.0;
                    double d4 = Math.abs(this.getSizeY()) / 2.0;
                    double d5 = Math.abs(this.getSizeZ());
                    if (!Double.isNaN(this.truncationHeight)) {
                        d5 = Math.min(d5, this.truncationHeight);
                    }
                    n = Math.max((int)Math.round(0.49 + Math.max(d, d4) / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(d2 - d3) * (Math.PI / 180) * (d + d4) / resolution.getMaxLength()), 1);
                    n3 = Math.max((int)Math.round(0.49 + d5 / resolution.getMaxLength()), 1);
                }
            }
        }
        if (this.nr != n || this.nu != n2 || this.nz != n3 || this.changeNTiles) {
            this.nr = n;
            this.nu = n2;
            this.nz = n3;
            this.changeNTiles = false;
            d = this.truncationHeight / this.getSizeZ();
            if (!Double.isNaN(d)) {
                d = Math.min(d, 1.0);
            }
            this.standardCone = ConeUtils.createStandardCone(this.nr, this.nu, this.nz, d3, d2, this.closedTop, this.closedBottom, this.closedLeft, this.closedRight, d);
            this.setCorners(new double[this.standardCone.length][4][3]);
        }
        int n4 = 0;
        while (n4 < this.numberOfTiles) {
            int n5 = 0;
            int n6 = this.corners[n4].length;
            while (n5 < n6) {
                System.arraycopy(this.standardCone[n4][n5], 0, this.corners[n4][n5], 0, 3);
                this.sizeAndToSpaceFrame(this.corners[n4][n5]);
                ++n5;
            }
            ++n4;
        }
        this.setElementChanged(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends ElementCone.Loader {
        protected Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementCone();
        }
    }
}

