/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementArrow;
import org.opensourcephysics.display3d.simple3d.ElementSegment;

public class ElementArrow
extends ElementSegment
implements org.opensourcephysics.display3d.core.ElementArrow {
    private static final double ARROW_CST = 0.35;
    private static final double ARROW_MAX = 25.0;
    private int headPoints = 0;
    private int[] headA = new int[10];
    private int[] headB = new int[10];

    void draw(Graphics2D graphics2D, int n) {
        Color color = this.getDrawingPanel3D().projectColor(this.getRealStyle().getLineColor(), this.objects[n].getDistance());
        if (n < this.div - 1) {
            graphics2D.setStroke(this.getRealStyle().getLineStroke());
            graphics2D.setColor(color);
            graphics2D.drawLine(this.aCoord[n], this.bCoord[n], this.aCoord[n + 1], this.bCoord[n + 1]);
        } else {
            Color color2 = this.getDrawingPanel3D().projectColor(this.getRealStyle().getFillColor(), this.objects[n].getDistance());
            this.drawHead(graphics2D, this.aCoord[n], this.bCoord[n], color, color2);
        }
    }

    synchronized void drawQuickly(Graphics2D graphics2D) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged()) {
            this.computeDivisions();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        this.drawHead(graphics2D, this.aCoord[0], this.bCoord[0], this.getRealStyle().getLineColor(), this.getRealStyle().getFillColor());
    }

    void projectPoints() {
        super.projectPoints();
        double d = this.aCoord[this.div] - this.aCoord[0];
        double d2 = this.bCoord[this.div] - this.bCoord[0];
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            this.headPoints = 0;
            return;
        }
        d = 0.35 * d / d3;
        d2 = 0.35 * d2 / d3;
        if (d3 > 25.0) {
            d *= 25.0 / d3;
            d2 *= 25.0 / d3;
        }
        int n = (int)((double)this.aCoord[this.div] - d * d3);
        int n2 = (int)((double)this.bCoord[this.div] - d2 * d3);
        this.headPoints = 6;
        this.headA[0] = n;
        this.headB[0] = n2;
        this.headA[1] = n - (int)(d2 *= d3 / 2.0);
        this.headB[1] = n2 + (int)(d *= d3 / 2.0);
        this.headA[2] = this.aCoord[this.div];
        this.headB[2] = this.bCoord[this.div];
        this.headA[3] = n + (int)d2;
        this.headB[3] = n2 - (int)d;
        this.headA[4] = n;
        this.headB[4] = n2;
    }

    private void drawHead(Graphics2D graphics2D, int n, int n2, Color color, Color color2) {
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        if (this.headPoints == 0) {
            graphics2D.setColor(color);
            graphics2D.drawLine(n, n2, this.aCoord[this.div], this.bCoord[this.div]);
            return;
        }
        int n3 = this.headPoints - 1;
        this.headA[n3] = n;
        this.headB[n3] = n2;
        if (color2 != null && this.getRealStyle().isDrawingFill()) {
            graphics2D.setPaint(color2);
            graphics2D.fillPolygon(this.headA, this.headB, n3);
        }
        graphics2D.setColor(color);
        graphics2D.drawPolyline(this.headA, this.headB, this.headPoints);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementArrow.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementArrow();
        }
    }
}

