/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPLayout;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display.TextPanel;
import org.opensourcephysics.display3d.core.DrawingPanel3D;
import org.opensourcephysics.display3d.core.interaction.InteractionEvent;
import org.opensourcephysics.display3d.core.interaction.InteractionListener;
import org.opensourcephysics.display3d.simple3d.Camera;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.ElementArrow;
import org.opensourcephysics.display3d.simple3d.ElementSegment;
import org.opensourcephysics.display3d.simple3d.ElementText;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;
import org.opensourcephysics.display3d.simple3d.Resolution;
import org.opensourcephysics.display3d.simple3d.VisualizationHints;
import org.opensourcephysics.tools.VideoTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawingPanel3D
extends JPanel
implements Renderable,
org.opensourcephysics.display3d.core.DrawingPanel3D,
Printable,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int AXIS_DIVISIONS = 10;
    private static final Color bgColor = new Color(239, 239, 255);
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private double zmin;
    private double zmax;
    private VisualizationHints visHints = null;
    private Camera camera = null;
    private String imageFile = null;
    private boolean quickRedrawOn = false;
    private boolean squareAspect = true;
    private double centerX;
    private double centerY;
    private double centerZ;
    private double maximumSize;
    private double aconstant;
    private double bconstant;
    private int acenter;
    private int bcenter;
    private ArrayList<Object3D> list3D = new ArrayList();
    private ArrayList<org.opensourcephysics.display3d.core.Element> decorationList = new ArrayList();
    private ArrayList<Element> elementList = new ArrayList();
    private Object3D.Comparator3D comparator = new Object3D.Comparator3D();
    private ElementArrow xAxis;
    private ElementArrow yAxis;
    private ElementArrow zAxis;
    private ElementText xText;
    private ElementText yText;
    private ElementText zText;
    private ElementSegment[] boxSides = new ElementSegment[12];
    private final InteractionTarget myTarget = new InteractionTarget(null, 0);
    private int trackersVisible;
    private int keyPressed = -1;
    private int lastX = 0;
    private int lastY = 0;
    private InteractionTarget targetHit = null;
    private InteractionTarget targetEntered = null;
    private double[] trackerPoint = null;
    private ArrayList<InteractionListener> listeners = new ArrayList();
    private ElementSegment[] trackerLines = null;
    private volatile boolean dirtyImage = true;
    private volatile BufferedImage offscreenImage;
    private BufferedImage workingImage = this.offscreenImage = new BufferedImage(1, 1, 1);
    private Timer updateTimer = new Timer(100, this);
    private boolean needResize = true;
    private boolean needsToRecompute = true;
    protected TextPanel trMessageBox = new TextPanel();
    protected TextPanel tlMessageBox = new TextPanel();
    protected TextPanel brMessageBox = new TextPanel();
    protected TextPanel blMessageBox = new TextPanel();
    protected GlassPanel glassPanel = new GlassPanel();
    protected OSPLayout glassPanelLayout = new OSPLayout();
    protected Rectangle viewRect = null;
    private double factorX = 1.0;
    private double factorY = 1.0;
    private double factorZ = 1.0;
    private static int axisMode = 0;
    protected VideoTool vidCap;

    private void BuildAxesPanel(int n) {
        if (axisMode == n && this.xAxis != null) {
            return;
        }
        axisMode = n;
        if (this.xAxis == null) {
            Resolution resolution = new Resolution(10, 1, 1);
            int n2 = 0;
            int n3 = this.boxSides.length;
            while (n2 < n3) {
                this.boxSides[n2] = new ElementSegment();
                this.boxSides[n2].getRealStyle().setResolution(resolution);
                this.boxSides[n2].setPanel(this);
                this.decorationList.add(this.boxSides[n2]);
                ++n2;
            }
            this.boxSides[0].getStyle().setLineColor(new Color(128, 0, 0));
            this.boxSides[3].getStyle().setLineColor(new Color(0, 128, 0));
            this.boxSides[8].getStyle().setLineColor(new Color(0, 0, 255));
            String[] stringArray = this.visHints.getAxesLabels();
            this.xAxis = new ElementArrow();
            this.xAxis.getRealStyle().setResolution(resolution);
            this.xAxis.getStyle().setFillColor(new Color(128, 0, 0));
            this.xAxis.setPanel(this);
            this.decorationList.add(this.xAxis);
            this.xText = new ElementText();
            this.xText.setText(stringArray[0]);
            this.xText.setJustification(0);
            this.xText.getRealStyle().setLineColor(Color.BLACK);
            this.xText.setFont(new Font("Dialog", 0, 12));
            this.xText.setPanel(this);
            this.decorationList.add(this.xText);
            this.yAxis = new ElementArrow();
            this.yAxis.getRealStyle().setResolution(resolution);
            this.yAxis.getStyle().setFillColor(new Color(0, 128, 0));
            this.yAxis.setPanel(this);
            this.decorationList.add(this.yAxis);
            this.yText = new ElementText();
            this.yText.setText(stringArray[1]);
            this.yText.setJustification(0);
            this.yText.getRealStyle().setLineColor(Color.BLACK);
            this.yText.setFont(new Font("Dialog", 0, 12));
            this.yText.setPanel(this);
            this.decorationList.add(this.yText);
            this.zAxis = new ElementArrow();
            this.zAxis.getRealStyle().setResolution(resolution);
            this.zAxis.getStyle().setFillColor(new Color(0, 0, 255));
            this.zAxis.setPanel(this);
            this.decorationList.add(this.zAxis);
            this.zText = new ElementText();
            this.zText.setText(stringArray[2]);
            this.zText.setJustification(0);
            this.zText.getRealStyle().setLineColor(Color.BLACK);
            this.zText.setFont(new Font("Dialog", 0, 12));
            this.zText.setPanel(this);
            this.decorationList.add(this.zText);
            this.trackerLines = new ElementSegment[9];
            n3 = 0;
            int n4 = this.trackerLines.length;
            while (n3 < n4) {
                this.trackerLines[n3] = new ElementSegment();
                this.trackerLines[n3].getRealStyle().setResolution(resolution);
                this.trackerLines[n3].setVisible(false);
                this.trackerLines[n3].setPanel(this);
                this.decorationList.add(this.trackerLines[n3]);
                ++n3;
            }
            this.setCursorMode();
        } else {
            this.resetDecoration(this.xmax - this.xmin, this.ymax - this.ymin, this.zmax - this.zmin);
        }
    }

    public DrawingPanel3D() {
        this.glassPanel.setLayout(this.glassPanelLayout);
        super.setLayout(new BorderLayout());
        this.glassPanel.add((Component)this.trMessageBox, "TopRightCorner");
        this.glassPanel.add((Component)this.tlMessageBox, "TopLeftCorner");
        this.glassPanel.add((Component)this.brMessageBox, "BottomRightCorner");
        this.glassPanel.add((Component)this.blMessageBox, "BottomLeftCorner");
        this.glassPanel.setOpaque(false);
        super.add((Component)this.glassPanel, "Center");
        this.setBackground(bgColor);
        this.setPreferredSize(new Dimension(300, 300));
        this.visHints = new VisualizationHints(this);
        this.camera = new Camera(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DrawingPanel3D.this.needResize = true;
                DrawingPanel3D.this.dirtyImage = true;
            }
        });
        IADMouseController iADMouseController = new IADMouseController();
        this.addMouseListener(iADMouseController);
        this.addMouseMotionListener(iADMouseController);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DrawingPanel3D.this.keyPressed = keyEvent.getKeyCode();
            }

            public void keyReleased(KeyEvent keyEvent) {
                DrawingPanel3D.this.keyPressed = -1;
            }
        });
        this.setFocusable(true);
        this.BuildAxesPanel(axisMode);
        if (this.camera.is3dMode()) {
            this.visHints.setDecorationType(2);
            this.visHints.setUseColorDepth(true);
        } else {
            this.visHints.setDecorationType(0);
            this.visHints.setUseColorDepth(false);
        }
        this.setPreferredMinMax(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.dirtyImage || this.needsUpdate()) {
            this.render();
        }
    }

    @Override
    public void setIgnoreRepaint(boolean bl) {
        super.setIgnoreRepaint(bl);
        this.glassPanel.setIgnoreRepaint(bl);
    }

    private void updatePanel() {
        if (this.getIgnoreRepaint()) {
            return;
        }
        this.updateTimer.setRepeats(false);
        this.updateTimer.setCoalesce(true);
        this.updateTimer.start();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.viewRect = null;
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JViewport) {
                this.viewRect = ((JViewport)container).getViewRect();
                this.glassPanel.setBounds(this.viewRect);
                this.glassPanelLayout.checkLayoutRect(this.glassPanel, this.viewRect);
                break;
            }
            container = container.getParent();
        }
        int n = (this.getWidth() - this.offscreenImage.getWidth()) / 2;
        int n2 = (this.getHeight() - this.offscreenImage.getHeight()) / 2;
        graphics.drawImage(this.offscreenImage, n, n2, null);
        if (this.dirtyImage || this.needsUpdate()) {
            this.updatePanel();
        }
    }

    @Override
    public void invalidate() {
        this.needResize = true;
        super.invalidate();
    }

    @Override
    public BufferedImage render(BufferedImage bufferedImage) {
        Graphics graphics = bufferedImage.getGraphics();
        this.paintEverything(graphics, bufferedImage.getWidth(null), bufferedImage.getHeight(null));
        Rectangle rectangle = this.viewRect;
        if (rectangle != null) {
            Rectangle rectangle2 = new Rectangle(0, 0, bufferedImage.getWidth(null), bufferedImage.getHeight(null));
            this.glassPanel.setBounds(rectangle2);
            this.glassPanelLayout.checkLayoutRect(this.glassPanel, rectangle2);
            this.glassPanel.render(graphics);
            this.glassPanel.setBounds(rectangle);
            this.glassPanelLayout.checkLayoutRect(this.glassPanel, rectangle);
        } else {
            this.glassPanel.render(graphics);
        }
        graphics.dispose();
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage render() {
        if (!this.isShowing() || this.isIconified()) {
            this.needsToRecompute = true;
            return null;
        }
        BufferedImage bufferedImage = this.checkImageSize(this.workingImage);
        Object object = bufferedImage;
        synchronized (object) {
            if (this.needResize) {
                this.computeConstants(bufferedImage.getWidth(), bufferedImage.getHeight());
                this.needResize = false;
            }
            this.render(bufferedImage);
            this.workingImage = this.offscreenImage;
            this.offscreenImage = bufferedImage;
            this.dirtyImage = false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.paintImmediately(this.getVisibleRect());
        } else {
            object = new Runnable(){

                public void run() {
                    DrawingPanel3D.this.paintImmediately(DrawingPanel3D.this.getVisibleRect());
                }
            };
            try {
                SwingUtilities.invokeAndWait((Runnable)object);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.vidCap != null && this.offscreenImage != null && this.vidCap.isRecording()) {
            this.vidCap.addFrame(this.offscreenImage);
        }
        return bufferedImage;
    }

    private final boolean needsUpdate() {
        Iterator<Element> iterator = this.elementList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getElementChanged()) continue;
            return true;
        }
        return false;
    }

    private BufferedImage checkImageSize(BufferedImage bufferedImage) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n <= 2 || n2 <= 2) {
            return new BufferedImage(1, 1, 1);
        }
        if (bufferedImage == null || n != bufferedImage.getWidth() || n2 != bufferedImage.getHeight()) {
            return this.getGraphicsConfiguration().createCompatibleImage(n, n2);
        }
        return bufferedImage;
    }

    private boolean isIconified() {
        Container container = this.getTopLevelAncestor();
        if (container instanceof Frame) {
            return (((Frame)container).getExtendedState() & 1) == 1;
        }
        return false;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setBackgroundImage(String string) {
        this.imageFile = string;
    }

    @Override
    public String getBackgroundImage() {
        return this.imageFile;
    }

    @Override
    public void setPreferredMinMax(double d, double d2, double d3, double d4, double d5, double d6) {
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
        this.zmin = d5;
        this.zmax = d6;
        this.centerX = (this.xmax + this.xmin) / 2.0;
        this.centerY = (this.ymax + this.ymin) / 2.0;
        this.centerZ = (this.zmax + this.zmin) / 2.0;
        this.maximumSize = this.getMaximum3DSize();
        this.resetDecoration(this.xmax - this.xmin, this.ymax - this.ymin, this.zmax - this.zmin);
        this.camera.reset();
        this.needsToRecompute = true;
        this.dirtyImage = true;
    }

    @Override
    public final double getPreferredMinX() {
        return this.xmin;
    }

    @Override
    public final double getPreferredMaxX() {
        return this.xmax;
    }

    @Override
    public final double getPreferredMinY() {
        return this.ymin;
    }

    @Override
    public final double getPreferredMaxY() {
        return this.ymax;
    }

    @Override
    public final double getPreferredMinZ() {
        return this.zmin;
    }

    @Override
    public final double getPreferredMaxZ() {
        return this.zmax;
    }

    final double[] getCenter() {
        return new double[]{this.centerX, this.centerY, this.centerZ};
    }

    final double getMaximum3DSize() {
        double d = this.xmax - this.xmin;
        double d2 = this.ymax - this.ymin;
        double d3 = this.zmax - this.zmin;
        switch (this.camera.getProjectionMode()) {
            case 0: {
                return Math.max(d, d2);
            }
            case 1: {
                return Math.max(d, d3);
            }
            case 2: {
                return Math.max(d2, d3);
            }
        }
        return Math.max(Math.max(d, d2), d3);
    }

    @Override
    public void zoomToFit() {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        Iterator<org.opensourcephysics.display3d.core.Element> iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).getExtrema(dArray, dArray2);
            d = Math.min(Math.min(d, dArray[0]), dArray2[0]);
            d2 = Math.max(Math.max(d2, dArray[0]), dArray2[0]);
            d3 = Math.min(Math.min(d3, dArray[1]), dArray2[1]);
            d4 = Math.max(Math.max(d4, dArray[1]), dArray2[1]);
            d5 = Math.min(Math.min(d5, dArray[2]), dArray2[2]);
            d6 = Math.max(Math.max(d6, dArray[2]), dArray2[2]);
        }
        double d7 = Math.max(Math.max(d2 - d, d4 - d3), d6 - d5);
        if (d7 == 0.0) {
            d7 = 2.0;
        }
        if (d >= d2) {
            d = d2 - d7 / 2.0;
            d2 = d + d7;
        }
        if (d3 >= d4) {
            d3 = d4 - d7 / 2.0;
            d4 = d3 + d7;
        }
        if (d5 >= d6) {
            d5 = d6 - d7 / 2.0;
            d6 = d5 + d7;
        }
        this.setPreferredMinMax(d, d2, d3, d4, d5, d6);
    }

    @Override
    public void setSquareAspect(boolean bl) {
        if (this.squareAspect != bl) {
            this.needsToRecompute = true;
            this.updatePanel();
        }
        this.squareAspect = bl;
    }

    @Override
    public boolean isSquareAspect() {
        return this.squareAspect;
    }

    @Override
    public org.opensourcephysics.display3d.core.VisualizationHints getVisualizationHints() {
        return this.visHints;
    }

    @Override
    public org.opensourcephysics.display3d.core.Camera getCamera() {
        return this.camera;
    }

    @Override
    public VideoTool getVideoTool() {
        return this.vidCap;
    }

    @Override
    public void setVideoTool(VideoTool videoTool) {
        if (this.vidCap != null) {
            this.vidCap.setVisible(false);
        }
        this.vidCap = videoTool;
    }

    @Override
    public void addElement(org.opensourcephysics.display3d.core.Element element) {
        if (!(element instanceof Element)) {
            throw new UnsupportedOperationException("Can't add element to panel (incorrect implementation)");
        }
        if (!this.elementList.contains(element)) {
            this.elementList.add((Element)element);
        }
        switch (axisMode) {
            case 2: {
                ((Element)element).setSizeX(((Element)element).getSizeX() * this.factorX);
                ((Element)element).setSizeZ(((Element)element).getSizeY() * this.factorZ);
                ((Element)element).setSizeY(((Element)element).getSizeZ() * this.factorY);
                ((Element)element).setX(((Element)element).getX() * this.factorX);
                ((Element)element).setZ(((Element)element).getY() * this.factorZ);
                ((Element)element).setY(((Element)element).getZ() * this.factorY);
                break;
            }
            case 1: {
                ((Element)element).setSizeY(((Element)element).getSizeX() * this.factorY);
                ((Element)element).setSizeX(((Element)element).getSizeY() * this.factorX);
                ((Element)element).setSizeZ(((Element)element).getSizeZ() * this.factorZ);
                ((Element)element).setY(((Element)element).getX() * this.factorY);
                ((Element)element).setX(((Element)element).getY() * this.factorX);
                ((Element)element).setZ(((Element)element).getZ() * this.factorZ);
                break;
            }
            case 3: {
                ((Element)element).setSizeZ(((Element)element).getSizeX() * this.factorZ);
                ((Element)element).setSizeX(((Element)element).getSizeY() * this.factorX);
                ((Element)element).setSizeY(((Element)element).getSizeZ() * this.factorY);
                ((Element)element).setZ(((Element)element).getX() * this.factorZ);
                ((Element)element).setX(((Element)element).getY() * this.factorX);
                ((Element)element).setY(((Element)element).getZ() * this.factorY);
                break;
            }
            case 5: {
                ((Element)element).setSizeY(((Element)element).getSizeX() * this.factorY);
                ((Element)element).setSizeZ(((Element)element).getSizeY() * this.factorZ);
                ((Element)element).setSizeX(((Element)element).getSizeZ() * this.factorX);
                ((Element)element).setY(((Element)element).getX() * this.factorY);
                ((Element)element).setZ(((Element)element).getY() * this.factorZ);
                ((Element)element).setX(((Element)element).getZ() * this.factorX);
                break;
            }
            case 4: {
                ((Element)element).setSizeZ(((Element)element).getSizeX() * this.factorZ);
                ((Element)element).setSizeY(((Element)element).getSizeY() * this.factorY);
                ((Element)element).setSizeX(((Element)element).getSizeZ() * this.factorX);
                ((Element)element).setZ(((Element)element).getX() * this.factorZ);
                ((Element)element).setY(((Element)element).getY() * this.factorY);
                ((Element)element).setX(((Element)element).getZ() * this.factorX);
                break;
            }
            default: {
                ((Element)element).setSizeX(((Element)element).getSizeX() * this.factorX);
                ((Element)element).setSizeY(((Element)element).getSizeY() * this.factorY);
                ((Element)element).setSizeZ(((Element)element).getSizeZ() * this.factorZ);
                ((Element)element).setX(((Element)element).getX() * this.factorX);
                ((Element)element).setY(((Element)element).getY() * this.factorY);
                ((Element)element).setZ(((Element)element).getZ() * this.factorZ);
            }
        }
        ((Element)element).setPanel(this);
        this.dirtyImage = true;
    }

    @Override
    public void removeElement(org.opensourcephysics.display3d.core.Element element) {
        this.elementList.remove(element);
        this.dirtyImage = true;
    }

    @Override
    public void removeAllElements() {
        this.elementList.clear();
        this.dirtyImage = true;
    }

    @Override
    public synchronized List<org.opensourcephysics.display3d.core.Element> getElements() {
        return new ArrayList<org.opensourcephysics.display3d.core.Element>(this.elementList);
    }

    @Override
    public void setScaleFactor(double d, double d2, double d3) {
        this.factorX = d;
        this.factorY = d2;
        this.factorZ = d3;
    }

    @Override
    public double getScaleFactorX() {
        return this.factorX;
    }

    @Override
    public double getScaleFactorY() {
        return this.factorY;
    }

    @Override
    public double getScaleFactorZ() {
        return this.factorZ;
    }

    @Override
    public void setAxesMode(int n) {
        this.BuildAxesPanel(n);
        int n2 = 0;
        while (n2 < this.elementList.size()) {
            Element element = this.elementList.get(n2);
            element.setXYZ(element.getX(), element.getY(), element.getZ());
            element.setSizeXYZ(element.getSizeX(), element.getSizeY(), element.getSizeZ());
            ++n2;
        }
    }

    @Override
    public int getAxesMode() {
        return axisMode;
    }

    public void setMessage(String string) {
        this.brMessageBox.setText(string);
    }

    public void setMessage(String string, int n) {
        switch (n) {
            case 0: {
                this.blMessageBox.setText(string);
                break;
            }
            default: {
                this.brMessageBox.setText(string);
                break;
            }
            case 2: {
                this.trMessageBox.setText(string);
                break;
            }
            case 3: {
                this.tlMessageBox.setText(string);
            }
        }
    }

    @Override
    public org.opensourcephysics.display3d.core.interaction.InteractionTarget getInteractionTarget(int n) {
        return this.myTarget;
    }

    @Override
    public void addInteractionListener(InteractionListener interactionListener) {
        if (interactionListener == null || this.listeners.contains(interactionListener)) {
            return;
        }
        this.listeners.add(interactionListener);
    }

    @Override
    public void removeInteractionListener(InteractionListener interactionListener) {
        this.listeners.remove(interactionListener);
    }

    private void invokeActions(InteractionEvent interactionEvent) {
        Iterator<InteractionListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().interactionPerformed(interactionEvent);
        }
    }

    private synchronized void paintEverything(Graphics graphics, int n, int n2) {
        if (this.needsToRecompute || n != this.getWidth() || n2 != this.getHeight()) {
            this.computeConstants(n, n2);
        }
        List<org.opensourcephysics.display3d.core.Element> list = this.getElements();
        list.addAll(this.decorationList);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        this.paintDrawableList(graphics, list);
    }

    private void paintDrawableList(Graphics graphics, List<org.opensourcephysics.display3d.core.Element> list) {
        int n;
        int n2;
        Object3D[] object3DArray;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Iterator<org.opensourcephysics.display3d.core.Element> iterator = list.iterator();
        if (this.quickRedrawOn || !this.visHints.isRemoveHiddenLines()) {
            while (iterator.hasNext()) {
                ((Element)iterator.next()).drawQuickly(graphics2D);
            }
            return;
        }
        this.list3D.clear();
        while (iterator.hasNext()) {
            object3DArray = ((Element)iterator.next()).getObjects3D();
            if (object3DArray == null) continue;
            n2 = 0;
            n = object3DArray.length;
            while (n2 < n) {
                if (!Double.isNaN(object3DArray[n2].getDistance())) {
                    this.list3D.add(object3DArray[n2]);
                }
                ++n2;
            }
        }
        if (this.list3D.size() <= 0) {
            return;
        }
        object3DArray = this.list3D.toArray(new Object3D[0]);
        Arrays.sort(object3DArray, this.comparator);
        n2 = 0;
        n = object3DArray.length;
        while (n2 < n) {
            Object3D object3D = object3DArray[n2];
            object3D.getElement().draw(graphics2D, object3D.getIndex());
            ++n2;
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        if (graphics == null) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableWidth() / (double)this.getWidth();
        double d2 = pageFormat.getImageableHeight() / (double)this.getHeight();
        double d3 = Math.min(d, d2);
        graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics2D.scale(d3, d3);
        this.paintEverything(graphics2D, this.getWidth(), this.getHeight());
        return 0;
    }

    void hintChanged(int n) {
        switch (n) {
            case 7: {
                String[] stringArray = this.visHints.getAxesLabels();
                this.xText.setText(stringArray[0]);
                this.yText.setText(stringArray[1]);
                this.zText.setText(stringArray[2]);
                this.setCursorMode();
            }
            case 0: {
                switch (this.visHints.getDecorationType()) {
                    case 0: {
                        int n2 = 0;
                        int n3 = this.boxSides.length;
                        while (n2 < n3) {
                            this.boxSides[n2].setVisible(false);
                            ++n2;
                        }
                        this.xAxis.setVisible(false);
                        this.yAxis.setVisible(false);
                        this.zAxis.setVisible(false);
                        this.xText.setVisible(false);
                        this.yText.setVisible(false);
                        this.zText.setVisible(false);
                        break;
                    }
                    case 2: {
                        int n4 = 0;
                        int n5 = this.boxSides.length;
                        while (n4 < n5) {
                            this.boxSides[n4].setVisible(true);
                            ++n4;
                        }
                        this.xAxis.setVisible(false);
                        this.yAxis.setVisible(false);
                        this.zAxis.setVisible(false);
                        this.xText.setVisible(false);
                        this.yText.setVisible(false);
                        this.zText.setVisible(false);
                        break;
                    }
                    case 1: {
                        int n6 = 0;
                        int n7 = this.boxSides.length;
                        while (n6 < n7) {
                            this.boxSides[n6].setVisible(false);
                            ++n6;
                        }
                        this.xAxis.setVisible(true);
                        this.yAxis.setVisible(true);
                        this.zAxis.setVisible(true);
                        this.xText.setVisible(true);
                        this.yText.setVisible(true);
                        this.zText.setVisible(true);
                    }
                }
                break;
            }
            case 6: {
                String[] stringArray = this.visHints.getAxesLabels();
                this.xText.setText(stringArray[0]);
                this.yText.setText(stringArray[1]);
                this.zText.setText(stringArray[2]);
                break;
            }
            case 4: {
                this.setCursorMode();
                break;
            }
        }
        this.dirtyImage = true;
    }

    void cameraChanged(int n) {
        switch (n) {
            case 1: {
                double d = this.xmax - this.xmin;
                double d2 = this.ymax - this.ymin;
                double d3 = this.zmax - this.zmin;
                this.maximumSize = this.getMaximum3DSize();
                this.resetDecoration(d, d2, d3);
                this.needsToRecompute = true;
                this.updatePanel();
            }
        }
        this.reportTheNeedToProject();
        this.dirtyImage = true;
    }

    double[] project(double[] dArray, double[] dArray2) {
        double[] dArray3 = this.camera.getTransformation().direct((double[])dArray.clone());
        double d = 1.8;
        switch (this.camera.getProjectionMode()) {
            case 10: {
                d = 1.3;
                break;
            }
            case 11: {
                d = 1.0;
            }
        }
        dArray2[0] = (double)this.acenter + dArray3[0] * d * this.aconstant;
        dArray2[1] = (double)this.bcenter - dArray3[1] * d * this.bconstant;
        dArray2[2] = dArray3[2];
        return dArray2;
    }

    double[] projectSize(double[] dArray, double[] dArray2, double[] dArray3) {
        this.camera.projectSize(dArray, dArray2, dArray3);
        double d = 1.8;
        switch (this.camera.getProjectionMode()) {
            case 10: {
                d = 1.3;
                break;
            }
            case 11: {
                d = 1.0;
            }
        }
        dArray3[0] = dArray3[0] * (d * this.aconstant);
        dArray3[1] = dArray3[1] * (d * this.bconstant);
        return dArray3;
    }

    Color projectColor(Color color, double d) {
        if (!this.visHints.isUseColorDepth()) {
            return color;
        }
        float[] fArray = new float[4];
        try {
            color.getRGBComponents(fArray);
            int n = 0;
            while (n < 3) {
                int n2 = n;
                fArray[n2] = (float)((double)fArray[n2] / d);
                fArray[n] = (float)Math.max(Math.min((double)fArray[n], 1.0), 0.0);
                ++n;
            }
            return new Color(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
        catch (Exception exception) {
            return color;
        }
    }

    private double[] worldPoint(int n, int n2) {
        double d = 1.8;
        switch (this.camera.getProjectionMode()) {
            case 0: {
                return new double[]{this.centerX + (double)(n - this.acenter) / (d * this.aconstant), this.centerY + (double)(this.bcenter - n2) / (d * this.bconstant), this.zmax};
            }
            case 1: {
                return new double[]{this.centerX + (double)(n - this.acenter) / (d * this.aconstant), this.ymax, this.centerZ + (double)(this.bcenter - n2) / (d * this.bconstant)};
            }
            case 2: {
                return new double[]{this.xmax, this.centerY + (double)(n - this.acenter) / (d * this.aconstant), this.centerZ + (double)(this.bcenter - n2) / (d * this.bconstant)};
            }
        }
        return new double[]{this.centerX, this.centerY, this.centerZ};
    }

    private double[] worldDistance(int n, int n2) {
        double d = 1.8;
        switch (this.camera.getProjectionMode()) {
            case 0: {
                return new double[]{(double)n / (d * this.aconstant), (double)(-n2) / (d * this.bconstant), 0.0};
            }
            case 1: {
                return new double[]{(double)n / (d * this.aconstant), 0.0, (double)(-n2) / (d * this.bconstant)};
            }
            case 2: {
                return new double[]{0.0, (double)n / (d * this.aconstant), (double)(-n2) / (d * this.bconstant)};
            }
        }
        return new double[]{(double)n / (1.3 * this.aconstant), (double)n2 / (1.3 * this.bconstant), 0.0};
    }

    private void computeConstants(int n, int n2) {
        this.acenter = n / 2;
        this.bcenter = n2 / 2;
        if (this.squareAspect) {
            n = n2 = Math.min(n, n2);
        }
        this.aconstant = 0.5 * (double)n / this.maximumSize;
        this.bconstant = 0.5 * (double)n2 / this.maximumSize;
        this.reportTheNeedToProject();
        this.needsToRecompute = false;
    }

    private void reportTheNeedToProject() {
        Iterator<org.opensourcephysics.display3d.core.Element> iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).setNeedToProject(true);
        }
        iterator = new ArrayList<org.opensourcephysics.display3d.core.Element>(this.decorationList).iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).setNeedToProject(true);
        }
    }

    private void resetDecoration(double d, double d2, double d3) {
        this.boxSides[0].setXYZ(this.xmin, this.ymin, this.zmin);
        this.boxSides[0].setSizeXYZ(d, 0.0, 0.0);
        this.boxSides[1].setXYZ(this.xmax, this.ymin, this.zmin);
        this.boxSides[1].setSizeXYZ(0.0, d2, 0.0);
        this.boxSides[2].setXYZ(this.xmin, this.ymax, this.zmin);
        this.boxSides[2].setSizeXYZ(d, 0.0, 0.0);
        this.boxSides[3].setXYZ(this.xmin, this.ymin, this.zmin);
        this.boxSides[3].setSizeXYZ(0.0, d2, 0.0);
        this.boxSides[4].setXYZ(this.xmin, this.ymin, this.zmax);
        this.boxSides[4].setSizeXYZ(d, 0.0, 0.0);
        this.boxSides[5].setXYZ(this.xmax, this.ymin, this.zmax);
        this.boxSides[5].setSizeXYZ(0.0, d2, 0.0);
        this.boxSides[6].setXYZ(this.xmin, this.ymax, this.zmax);
        this.boxSides[6].setSizeXYZ(d, 0.0, 0.0);
        this.boxSides[7].setXYZ(this.xmin, this.ymin, this.zmax);
        this.boxSides[7].setSizeXYZ(0.0, d2, 0.0);
        this.boxSides[8].setXYZ(this.xmin, this.ymin, this.zmin);
        this.boxSides[8].setSizeXYZ(0.0, 0.0, d3);
        this.boxSides[9].setXYZ(this.xmax, this.ymin, this.zmin);
        this.boxSides[9].setSizeXYZ(0.0, 0.0, d3);
        this.boxSides[10].setXYZ(this.xmax, this.ymax, this.zmin);
        this.boxSides[10].setSizeXYZ(0.0, 0.0, d3);
        this.boxSides[11].setXYZ(this.xmin, this.ymax, this.zmin);
        this.boxSides[11].setSizeXYZ(0.0, 0.0, d3);
        this.xAxis.setXYZ(this.xmin, this.ymin, this.zmin);
        this.xAxis.setSizeXYZ(d, 0.0, 0.0);
        this.xText.setXYZ(this.xmax + d * 0.02, this.ymin, this.zmin);
        this.yAxis.setXYZ(this.xmin, this.ymin, this.zmin);
        this.yAxis.setSizeXYZ(0.0, d2, 0.0);
        this.yText.setXYZ(this.xmin, this.ymax + d2 * 0.02, this.zmin);
        this.zAxis.setXYZ(this.xmin, this.ymin, this.zmin);
        this.zAxis.setSizeXYZ(0.0, 0.0, d3);
        this.zText.setXYZ(this.xmin, this.ymin, this.zmax + d3 * 0.02);
    }

    private void setCursorMode() {
        switch (this.visHints.getCursorType()) {
            case 0: {
                this.trackersVisible = 0;
                break;
            }
            case 2: {
                this.trackersVisible = 9;
                break;
            }
            default: {
                this.trackersVisible = 3;
                break;
            }
            case 3: {
                this.trackersVisible = 3;
            }
        }
    }

    private void showTrackers(boolean bl) {
        int n = 0;
        int n2 = this.trackerLines.length;
        while (n < n2) {
            if (n < this.trackersVisible) {
                this.trackerLines[n].setVisible(bl);
            } else {
                this.trackerLines[n].setVisible(false);
            }
            ++n;
        }
    }

    private void positionTrackers() {
        switch (this.visHints.getCursorType()) {
            case 0: {
                return;
            }
            default: {
                this.trackerLines[0].setXYZ(this.trackerPoint[0], this.ymin, this.zmin);
                this.trackerLines[0].setSizeXYZ(0.0, this.trackerPoint[1] - this.ymin, 0.0);
                this.trackerLines[1].setXYZ(this.xmin, this.trackerPoint[1], this.zmin);
                this.trackerLines[1].setSizeXYZ(this.trackerPoint[0] - this.xmin, 0.0, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint[0], this.trackerPoint[1], this.zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - this.zmin);
                break;
            }
            case 2: {
                this.trackerLines[0].setXYZ(this.xmin, this.trackerPoint[1], this.trackerPoint[2]);
                this.trackerLines[0].setSizeXYZ(this.trackerPoint[0] - this.xmin, 0.0, 0.0);
                this.trackerLines[1].setXYZ(this.trackerPoint[0], this.ymin, this.trackerPoint[2]);
                this.trackerLines[1].setSizeXYZ(0.0, this.trackerPoint[1] - this.ymin, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint[0], this.trackerPoint[1], this.zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - this.zmin);
                this.trackerLines[3].setXYZ(this.trackerPoint[0], this.ymin, this.zmin);
                this.trackerLines[3].setSizeXYZ(0.0, this.trackerPoint[1] - this.ymin, 0.0);
                this.trackerLines[4].setXYZ(this.xmin, this.trackerPoint[1], this.zmin);
                this.trackerLines[4].setSizeXYZ(this.trackerPoint[0] - this.xmin, 0.0, 0.0);
                this.trackerLines[5].setXYZ(this.trackerPoint[0], this.ymin, this.zmin);
                this.trackerLines[5].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - this.zmin);
                this.trackerLines[6].setXYZ(this.xmin, this.ymin, this.trackerPoint[2]);
                this.trackerLines[6].setSizeXYZ(this.trackerPoint[0] - this.xmin, 0.0, 0.0);
                this.trackerLines[7].setXYZ(this.xmin, this.trackerPoint[1], this.zmin);
                this.trackerLines[7].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - this.zmin);
                this.trackerLines[8].setXYZ(this.xmin, this.ymin, this.trackerPoint[2]);
                this.trackerLines[8].setSizeXYZ(0.0, this.trackerPoint[1] - this.ymin, 0.0);
                break;
            }
            case 3: {
                this.trackerLines[0].setXYZ(this.xmin, this.trackerPoint[1], this.trackerPoint[2]);
                this.trackerLines[0].setSizeXYZ(this.xmax - this.xmin, 0.0, 0.0);
                this.trackerLines[1].setXYZ(this.trackerPoint[0], this.ymin, this.trackerPoint[2]);
                this.trackerLines[1].setSizeXYZ(0.0, this.ymax - this.ymin, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint[0], this.trackerPoint[1], this.zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.zmax - this.zmin);
            }
        }
    }

    private InteractionTarget getTargetHit(int n, int n2) {
        Iterator<org.opensourcephysics.display3d.core.Element> iterator = this.getElements().iterator();
        InteractionTarget interactionTarget = null;
        while (iterator.hasNext()) {
            interactionTarget = ((Element)iterator.next()).getTargetHit(n, n2);
            if (interactionTarget == null) continue;
            return interactionTarget;
        }
        return null;
    }

    private void setMouseCursor(Cursor cursor) {
        Container container = this.getTopLevelAncestor();
        this.setCursor(cursor);
        if (container != null) {
            container.setCursor(cursor);
        }
    }

    private void displayPosition(double[] dArray) {
        this.visHints.displayPosition(this.camera.getProjectionMode(), dArray);
    }

    private boolean mouseDraggedComputations(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown()) {
            if (this.camera.is3dMode()) {
                double d = this.camera.getFocusX();
                double d2 = this.camera.getFocusY();
                double d3 = this.camera.getFocusZ();
                double d4 = (double)(mouseEvent.getX() - this.lastX) * this.maximumSize * 0.01;
                double d5 = (double)(mouseEvent.getY() - this.lastY) * this.maximumSize * 0.01;
                switch (this.keyPressed) {
                    case 88: {
                        if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d + d5, d2, d3);
                            break;
                        }
                        if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                            this.camera.setFocusXYZ(d + d4, d2, d3);
                            break;
                        }
                        if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d - d5, d2, d3);
                            break;
                        }
                        this.camera.setFocusXYZ(d - d4, d2, d3);
                        break;
                    }
                    case 89: {
                        if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d, d2 - d4, d3);
                            break;
                        }
                        if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                            this.camera.setFocusXYZ(d, d2 + d5, d3);
                            break;
                        }
                        if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d, d2 + d4, d3);
                            break;
                        }
                        this.camera.setFocusXYZ(d, d2 - d5, d3);
                        break;
                    }
                    case 90: {
                        if (this.camera.cosBeta >= 0.0) {
                            this.camera.setFocusXYZ(d, d2, d3 + d5);
                            break;
                        }
                        this.camera.setFocusXYZ(d, d2, d3 - d5);
                        break;
                    }
                    default: {
                        if (this.camera.cosBeta < 0.0) {
                            d5 = -d5;
                        }
                        if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d, d2 - d4, d3 + d5);
                            break;
                        }
                        if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                            this.camera.setFocusXYZ(d + d4, d2, d3 + d5);
                            break;
                        }
                        if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d, d2 + d4, d3 - d5);
                            break;
                        }
                        this.camera.setFocusXYZ(d - d4, d2, d3 - d5);
                    }
                }
            }
            return false;
        }
        if (mouseEvent.isShiftDown()) {
            this.camera.setDistanceToScreen(this.camera.getDistanceToScreen() - (double)(mouseEvent.getY() - this.lastY) * this.maximumSize * 0.01);
            return false;
        }
        if (this.camera.is3dMode() && this.targetHit == null && !mouseEvent.isAltDown()) {
            this.camera.setAzimuthAndAltitude(this.camera.getAzimuth() - (double)(mouseEvent.getX() - this.lastX) * 0.01, this.camera.getAltitude() + (double)(mouseEvent.getY() - this.lastY) * 0.005);
            return false;
        }
        if (this.trackerPoint == null) {
            return true;
        }
        double[] dArray = this.worldDistance(mouseEvent.getX() - this.lastX, mouseEvent.getY() - this.lastY);
        if (!this.camera.is3dMode()) {
            switch (this.keyPressed) {
                case 88: {
                    this.trackerPoint[0] = this.trackerPoint[0] + dArray[0];
                    break;
                }
                case 89: {
                    this.trackerPoint[1] = this.trackerPoint[1] + dArray[1];
                    break;
                }
                case 90: {
                    this.trackerPoint[2] = this.trackerPoint[2] + dArray[2];
                    break;
                }
                default: {
                    this.trackerPoint[0] = this.trackerPoint[0] + dArray[0];
                    this.trackerPoint[1] = this.trackerPoint[1] + dArray[1];
                    this.trackerPoint[2] = this.trackerPoint[2] + dArray[2];
                    break;
                }
            }
        } else {
            switch (this.keyPressed) {
                case 88: {
                    if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] + dArray[1];
                        break;
                    }
                    if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] - dArray[0];
                        break;
                    }
                    if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] - dArray[1];
                        break;
                    }
                    this.trackerPoint[0] = this.trackerPoint[0] + dArray[0];
                    break;
                }
                case 89: {
                    if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] + dArray[0];
                        break;
                    }
                    if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] + dArray[1];
                        break;
                    }
                    if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] - dArray[0];
                        break;
                    }
                    this.trackerPoint[1] = this.trackerPoint[1] - dArray[1];
                    break;
                }
                case 90: {
                    if (this.camera.cosBeta >= 0.0) {
                        this.trackerPoint[2] = this.trackerPoint[2] - dArray[1];
                        break;
                    }
                    this.trackerPoint[2] = this.trackerPoint[2] - dArray[2];
                    break;
                }
                default: {
                    this.trackerPoint[2] = this.camera.cosBeta >= 0.0 ? this.trackerPoint[2] - dArray[1] : this.trackerPoint[2] + dArray[1];
                    if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] + dArray[0];
                        break;
                    }
                    if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] - dArray[0];
                        break;
                    }
                    if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] - dArray[0];
                        break;
                    }
                    this.trackerPoint[0] = this.trackerPoint[0] + dArray[0];
                }
            }
        }
        return true;
    }

    private void resetInteraction() {
        this.targetHit = null;
        this.showTrackers(false);
        this.displayPosition(null);
        this.dirtyImage = true;
        this.updatePanel();
    }

    @Override
    public void setLightEnabled(boolean bl, int n) {
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawingPanel3DLoader();
    }

    private static class DrawingPanel3DLoader
    extends DrawingPanel3D.Loader {
        private DrawingPanel3DLoader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new DrawingPanel3D();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            super.loadObject(xMLControl, object);
            DrawingPanel3D drawingPanel3D = (DrawingPanel3D)object;
            VisualizationHints visualizationHints = (VisualizationHints)xMLControl.getObject("visualization hints");
            visualizationHints.setPanel(drawingPanel3D);
            drawingPanel3D.visHints = visualizationHints;
            drawingPanel3D.hintChanged(0);
            Camera camera = (Camera)xMLControl.getObject("camera");
            camera.setPanel(drawingPanel3D);
            drawingPanel3D.camera = camera;
            drawingPanel3D.cameraChanged(0);
            drawingPanel3D.needsToRecompute = true;
            drawingPanel3D.dirtyImage = true;
            drawingPanel3D.updatePanel();
            return object;
        }
    }

    private class GlassPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private GlassPanel() {
        }

        public void render(Graphics graphics) {
            Component[] componentArray = DrawingPanel3D.this.glassPanelLayout.getComponents();
            int n = 0;
            int n2 = componentArray.length;
            while (n < n2) {
                if (componentArray[n] != null) {
                    graphics.translate(componentArray[n].getX(), componentArray[n].getY());
                    componentArray[n].print(graphics);
                    graphics.translate(-componentArray[n].getX(), -componentArray[n].getY());
                }
                ++n;
            }
        }
    }

    private class IADMouseController
    extends MouseInputAdapter {
        private IADMouseController() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void mousePressed(MouseEvent mouseEvent) {
            DrawingPanel3D.this.requestFocus();
            if (mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) {
                return;
            }
            DrawingPanel3D.this.lastX = mouseEvent.getX();
            DrawingPanel3D.this.lastY = mouseEvent.getY();
            DrawingPanel3D.this.targetHit = DrawingPanel3D.this.getTargetHit(DrawingPanel3D.this.lastX, DrawingPanel3D.this.lastY);
            if (DrawingPanel3D.this.targetHit != null) {
                Element element = DrawingPanel3D.this.targetHit.getElement();
                DrawingPanel3D.this.trackerPoint = element.getHotSpot(DrawingPanel3D.this.targetHit);
                element.invokeActions(new InteractionEvent((Object)element, 2000, DrawingPanel3D.this.targetHit.getActionCommand(), DrawingPanel3D.this.targetHit, mouseEvent));
                DrawingPanel3D.this.trackerPoint = element.getHotSpot(DrawingPanel3D.this.targetHit);
            } else {
                if (!DrawingPanel3D.this.myTarget.isEnabled()) {
                    DrawingPanel3D.this.resetInteraction();
                    return;
                }
                if (DrawingPanel3D.this.camera.is3dMode() && !mouseEvent.isAltDown()) {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2000, DrawingPanel3D.this.myTarget.getActionCommand(), null, mouseEvent));
                    DrawingPanel3D.this.resetInteraction();
                    return;
                }
                DrawingPanel3D.this.trackerPoint = DrawingPanel3D.this.worldPoint(mouseEvent.getX(), mouseEvent.getY());
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2000, DrawingPanel3D.this.myTarget.getActionCommand(), DrawingPanel3D.this.trackerPoint, mouseEvent));
            }
            DrawingPanel3D.this.displayPosition(DrawingPanel3D.this.trackerPoint);
            DrawingPanel3D.this.positionTrackers();
            DrawingPanel3D.this.showTrackers(true);
            DrawingPanel3D.this.dirtyImage = true;
            DrawingPanel3D.this.updatePanel();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) {
                return;
            }
            if (DrawingPanel3D.this.targetHit != null) {
                Element element = DrawingPanel3D.this.targetHit.getElement();
                element.invokeActions(new InteractionEvent((Object)element, 2002, DrawingPanel3D.this.targetHit.getActionCommand(), DrawingPanel3D.this.targetHit, mouseEvent));
            } else if (DrawingPanel3D.this.myTarget.isEnabled()) {
                if (!DrawingPanel3D.this.camera.is3dMode() || mouseEvent.isAltDown()) {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2002, DrawingPanel3D.this.myTarget.getActionCommand(), DrawingPanel3D.this.trackerPoint, mouseEvent));
                } else {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2002, DrawingPanel3D.this.myTarget.getActionCommand(), null, mouseEvent));
                }
            }
            DrawingPanel3D.this.quickRedrawOn = false;
            DrawingPanel3D.this.resetInteraction();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) {
                return;
            }
            DrawingPanel3D.this.quickRedrawOn = DrawingPanel3D.this.visHints.isAllowQuickRedraw() && DrawingPanel3D.this.keyPressed != 83;
            boolean bl = DrawingPanel3D.this.mouseDraggedComputations(mouseEvent);
            DrawingPanel3D.this.lastX = mouseEvent.getX();
            DrawingPanel3D.this.lastY = mouseEvent.getY();
            if (!bl) {
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2001, DrawingPanel3D.this.myTarget.getActionCommand(), null, mouseEvent));
                DrawingPanel3D.this.resetInteraction();
                return;
            }
            if (DrawingPanel3D.this.targetHit != null) {
                Element element = DrawingPanel3D.this.targetHit.getElement();
                element.updateHotSpot(DrawingPanel3D.this.targetHit, DrawingPanel3D.this.trackerPoint);
                element.invokeActions(new InteractionEvent((Object)element, 2001, DrawingPanel3D.this.targetHit.getActionCommand(), DrawingPanel3D.this.targetHit, mouseEvent));
                DrawingPanel3D.this.trackerPoint = element.getHotSpot(DrawingPanel3D.this.targetHit);
                DrawingPanel3D.this.displayPosition(DrawingPanel3D.this.trackerPoint);
                DrawingPanel3D.this.positionTrackers();
                DrawingPanel3D.this.showTrackers(true);
            } else if (DrawingPanel3D.this.myTarget.isEnabled()) {
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2001, DrawingPanel3D.this.myTarget.getActionCommand(), DrawingPanel3D.this.trackerPoint, mouseEvent));
                DrawingPanel3D.this.displayPosition(DrawingPanel3D.this.trackerPoint);
                DrawingPanel3D.this.positionTrackers();
                DrawingPanel3D.this.showTrackers(true);
            }
            DrawingPanel3D.this.dirtyImage = true;
            DrawingPanel3D.this.updatePanel();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            if (DrawingPanel3D.this.myTarget.isEnabled()) {
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2003, DrawingPanel3D.this.myTarget.getActionCommand(), null, mouseEvent));
            }
            DrawingPanel3D.this.targetEntered = null;
            DrawingPanel3D.this.targetHit = null;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(0));
            if (DrawingPanel3D.this.myTarget.isEnabled()) {
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2004, DrawingPanel3D.this.myTarget.getActionCommand(), null, mouseEvent));
            }
            DrawingPanel3D.this.targetEntered = null;
            DrawingPanel3D.this.targetHit = null;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            InteractionTarget interactionTarget = DrawingPanel3D.this.getTargetHit(mouseEvent.getX(), mouseEvent.getY());
            if (interactionTarget != null) {
                if (DrawingPanel3D.this.targetEntered == null) {
                    interactionTarget.getElement().invokeActions(new InteractionEvent((Object)interactionTarget.getElement(), 2003, interactionTarget.getActionCommand(), interactionTarget, mouseEvent));
                }
                DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(12));
            } else {
                if (DrawingPanel3D.this.targetEntered != null) {
                    DrawingPanel3D.this.targetEntered.getElement().invokeActions(new InteractionEvent((Object)DrawingPanel3D.this.targetEntered.getElement(), 2004, DrawingPanel3D.this.targetEntered.getActionCommand(), DrawingPanel3D.this.targetEntered, mouseEvent));
                } else if (DrawingPanel3D.this.myTarget.isEnabled()) {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2005, DrawingPanel3D.this.myTarget.getActionCommand(), null, mouseEvent));
                }
                DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            }
            DrawingPanel3D.this.targetEntered = interactionTarget;
        }
    }
}

