/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display3d.core.CameraInspector;
import org.opensourcephysics.display3d.core.DrawingFrame3D;
import org.opensourcephysics.display3d.simple3d.DrawingPanel3D;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.tools.ExportTool;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.VideoTool;

public class DrawingFrame3D
extends OSPFrame
implements ClipboardOwner,
org.opensourcephysics.display3d.core.DrawingFrame3D {
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenuItem copyItem;
    protected JMenuItem pasteItem;
    protected JMenuItem replaceItem;
    protected JMenu visualMenu;
    protected JMenu displayMenu;
    protected JMenu decorationMenu;
    protected JMenu cursorMenu;
    protected JMenuItem displayPerspectiveItem;
    protected JMenuItem displayNoPerspectiveItem;
    protected JMenuItem displayXYItem;
    protected JMenuItem displayXZItem;
    protected JMenuItem displayYZItem;
    protected JMenuItem decorationCubeItem;
    protected JMenuItem decorationNoneItem;
    protected JMenuItem decorationAxesItem;
    protected JMenuItem cursorNoneItem;
    protected JMenuItem cursorCubeItem;
    protected JMenuItem cursorXYZItem;
    protected JMenuItem cursorCrosshairItem;
    protected JMenuItem zoomToFitItem;
    protected JMenuItem resetCameraItem;
    protected JMenuItem cameraItem;
    protected JMenuItem lightItem;
    protected JFrame cameraInspectorFrame;
    protected JFrame lightInspectorFrame;
    protected JMenuBar menuBar = new JMenuBar();
    protected org.opensourcephysics.display3d.core.DrawingPanel3D drawingPanel;
    protected static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public DrawingFrame3D() {
        this(DisplayRes.getString("DrawingFrame.DefaultTitle"), (DrawingPanel3D)null);
    }

    public DrawingFrame3D(DrawingPanel3D drawingPanel3D) {
        this(DisplayRes.getString("DrawingFrame.DefaultTitle"), drawingPanel3D);
    }

    public DrawingFrame3D(String string, DrawingPanel3D drawingPanel3D) {
        super(string);
        this.drawingPanel = drawingPanel3D;
        if (this.drawingPanel != null) {
            this.getContentPane().add((Component)((JPanel)((Object)this.drawingPanel)), "Center");
        }
        this.pack();
        if (!OSPRuntime.appletMode) {
            this.createMenuBar();
        }
        this.setAnimated(true);
        this.setEnabledPaste(true);
        this.setEnabledReplace(true);
    }

    public void render() {
        this.drawingPanel.render();
    }

    public void setMessage(String string) {
        ((DrawingPanel3D)this.drawingPanel).setMessage(string);
    }

    public void setMessage(String string, int n) {
        ((DrawingPanel3D)this.drawingPanel).setMessage(string, n);
    }

    public org.opensourcephysics.display3d.core.DrawingPanel3D getDrawingPanel3D() {
        return this.drawingPanel;
    }

    public void setDrawingPanel3D(org.opensourcephysics.display3d.core.DrawingPanel3D drawingPanel3D) {
        if (this.drawingPanel != null) {
            this.getContentPane().remove((JPanel)((Object)this.drawingPanel));
        }
        this.drawingPanel = drawingPanel3D;
        if (this.drawingPanel != null) {
            this.getContentPane().add((Component)((JPanel)((Object)this.drawingPanel)), "Center");
        }
        this.pack();
    }

    public JFrame getJFrame() {
        return this;
    }

    public void setEnabledPaste(boolean bl) {
        this.pasteItem.setEnabled(bl);
    }

    protected void pasteAction() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(null);
            XMLControlElement xMLControlElement = new XMLControlElement();
            xMLControlElement.readXML((String)transferable.getTransferData(DataFlavor.stringFlavor));
            XMLTreeChooser xMLTreeChooser = new XMLTreeChooser(DisplayRes.getString("DrawingFrame3D.XMLChooser.Title"), DisplayRes.getString("DrawingFrame3D.XMLChooser.Message"), this);
            List<XMLProperty> list = xMLTreeChooser.choose(xMLControlElement, Element.class);
            if (!list.isEmpty()) {
                for (XMLControl xMLControl : list) {
                    Element element = (Element)xMLControl.loadObject(null);
                    System.out.println("Adding element " + element);
                    this.drawingPanel.addElement(element);
                }
            }
            if (this.drawingPanel != null) {
                this.drawingPanel.repaint();
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
        }
        catch (HeadlessException headlessException) {}
    }

    public void setEnabledReplace(boolean bl) {
        this.replaceItem.setEnabled(bl);
    }

    public void replaceAction() {
        this.drawingPanel.removeAllElements();
        this.pasteAction();
    }

    protected void copyAction() {
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        xMLControlElement.saveObject(null);
        StringSelection stringSelection = new StringSelection(xMLControlElement.toXML());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void setEnabledCopy(boolean bl) {
        this.copyItem.setEnabled(bl);
    }

    protected boolean supportsLightInspectors() {
        return false;
    }

    protected JFrame createLightInspectorFrame(org.opensourcephysics.display3d.core.DrawingPanel3D drawingPanel3D) {
        return null;
    }

    private void createMenuBar() {
        this.fileMenu = new JMenu(DisplayRes.getString("DrawingFrame.File_menu_item"));
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Print_menu_item"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable((Printable)((Object)DrawingFrame3D.this.drawingPanel));
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        JOptionPane.showMessageDialog(DrawingFrame3D.this, DisplayRes.getString("DrawingFrame.PrintErrorMessage"), DisplayRes.getString("DrawingFrame.Error"), 0);
                    }
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DrawingFrame.SaveXML_menu_item"));
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(83, MENU_SHORTCUT_KEY_MASK));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawingFrame3D.this.saveXML();
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(DisplayRes.getString("DrawingFrame.Export_menu_item"));
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(69, MENU_SHORTCUT_KEY_MASK));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExportTool.getTool().send(new LocalJob(DrawingFrame3D.this.drawingPanel), null);
                }
                catch (RemoteException remoteException) {}
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem(DisplayRes.getString("DrawingFrame.SaveFrameAsEPS_menu_item"));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIUtils.saveImage((JComponent)((JPanel)DrawingFrame3D.this.drawingPanel.getComponent()), "eps", DrawingFrame3D.this);
            }
        });
        JMenuItem jMenuItem5 = new JMenuItem(DisplayRes.getString("DrawingFrame.InspectMenuItem"));
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(73, MENU_SHORTCUT_KEY_MASK));
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawingFrame3D.this.inspectXML();
            }
        });
        this.fileMenu.add(jMenuItem);
        this.fileMenu.add(jMenuItem2);
        this.fileMenu.add(jMenuItem3);
        this.fileMenu.add(jMenuItem4);
        this.fileMenu.add(jMenuItem5);
        this.menuBar.add(this.fileMenu);
        this.editMenu = new JMenu(DisplayRes.getString("DrawingFrame.Edit_menu_title"));
        this.menuBar.add(this.editMenu);
        this.copyItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Copy_menu_item"));
        this.copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawingFrame3D.this.copyAction();
            }
        });
        this.editMenu.add(this.copyItem);
        this.pasteItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Paste_menu_item"));
        this.pasteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawingFrame3D.this.pasteAction();
            }
        });
        this.pasteItem.setEnabled(false);
        this.editMenu.add(this.pasteItem);
        this.replaceItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Replace_menu_item"));
        this.replaceItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawingFrame3D.this.replaceAction();
            }
        });
        this.replaceItem.setEnabled(false);
        this.editMenu.add(this.replaceItem);
        this.setJMenuBar(this.menuBar);
        this.cameraItem = new JMenuItem(DisplayRes.getString("DrawingFrame3D.Camera_menu_item"));
        this.cameraItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    if (DrawingFrame3D.this.cameraInspectorFrame == null) {
                        DrawingFrame3D.this.cameraInspectorFrame = CameraInspector.createFrame(DrawingFrame3D.this.drawingPanel);
                    }
                    DrawingFrame3D.this.cameraInspectorFrame.setVisible(true);
                }
            }
        });
        if (this.supportsLightInspectors()) {
            this.lightItem = new JMenuItem(DisplayRes.getString("DrawingFrame3D.Light_menu_item"));
            this.lightItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (DrawingFrame3D.this.drawingPanel != null) {
                        if (DrawingFrame3D.this.lightInspectorFrame == null) {
                            DrawingFrame3D.this.lightInspectorFrame = DrawingFrame3D.this.createLightInspectorFrame(DrawingFrame3D.this.drawingPanel);
                        }
                        DrawingFrame3D.this.lightInspectorFrame.setVisible(true);
                    }
                }
            });
        }
        this.decorationMenu = new JMenu(DisplayRes.getString("DrawingFrame3D.Decoration_menu"));
        this.decorationNoneItem = new JMenuItem(DisplayRes.getString("DrawingFrame3D.DecorationNone_menu_item"));
        this.decorationNoneItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.getVisualizationHints().setDecorationType(0);
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.decorationMenu.add(this.decorationNoneItem);
        this.decorationCubeItem = new JMenuItem(DisplayRes.getString("DrawingFrame3D.DecorationCube_menu_item"));
        this.decorationCubeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.getVisualizationHints().setDecorationType(2);
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.decorationMenu.add(this.decorationCubeItem);
        this.decorationAxesItem = new JMenuItem(DisplayRes.getString("DrawingFrame3D.DecorationAxes_menu_item"));
        this.decorationAxesItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.getVisualizationHints().setDecorationType(1);
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.decorationMenu.add(this.decorationAxesItem);
        this.cursorMenu = new JMenu(DisplayRes.getString("DrawingFrame3D.Cursor_menu"));
        this.cursorNoneItem = new JMenuItem(DisplayRes.getString("DrawingFrame3D.CursorNone_menu_item"));
        this.cursorNoneItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.getVisualizationHints().setCursorType(0);
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.cursorMenu.add(this.cursorNoneItem);
        this.cursorCubeItem = new JMenuItem(DisplayRes.getString("DrawingFrame3D.CursorCube_menu_item"));
        this.cursorCubeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.getVisualizationHints().setCursorType(2);
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.cursorMenu.add(this.cursorCubeItem);
        this.cursorXYZItem = new JMenuItem(DisplayRes.getString("DrawingFrame3D.CursorXYZ_menu_item"));
        this.cursorXYZItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.getVisualizationHints().setCursorType(1);
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.cursorMenu.add(this.cursorXYZItem);
        this.cursorCrosshairItem = new JMenuItem(DisplayRes.getString("DrawingFrame3D.CursorCrosshair_menu_item"));
        this.cursorCrosshairItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.getVisualizationHints().setCursorType(3);
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.cursorMenu.add(this.cursorCrosshairItem);
        this.zoomToFitItem = new JMenuItem(DisplayRes.getString("DrawingFrame3D.ZoomToFit_menu_item"));
        this.zoomToFitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.zoomToFit();
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.visualMenu = new JMenu(DisplayRes.getString("DrawingFrame3D.Visual_menu"));
        this.visualMenu.add(this.cameraItem);
        if (this.supportsLightInspectors()) {
            this.visualMenu.add(this.lightItem);
        }
        this.visualMenu.add(this.decorationMenu);
        this.visualMenu.add(this.cursorMenu);
        this.visualMenu.add(this.zoomToFitItem);
        this.menuBar.add(this.visualMenu);
        this.loadToolsMenu();
        JMenu jMenu = new JMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        this.menuBar.add(jMenu);
        JMenuItem jMenuItem6 = new JMenuItem(DisplayRes.getString("DrawingFrame.AboutOSP_menu_item"));
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OSPRuntime.showAboutDialog(DrawingFrame3D.this);
            }
        });
        jMenu.add(jMenuItem6);
    }

    protected JMenu loadToolsMenu() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        JMenu jMenu = new JMenu(DisplayRes.getString("DrawingFrame.Tools_menu_title"));
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DisplayPanel.Snapshot_menu_item"));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotTool snapshotTool = SnapshotTool.getTool();
                if (DrawingFrame3D.this.drawingPanel != null) {
                    snapshotTool.saveImage(null, DrawingFrame3D.this.drawingPanel.getComponent());
                } else {
                    snapshotTool.saveImage(null, DrawingFrame3D.this.getContentPane());
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DrawingFrame.MenuItem.Capture"));
        jMenu.add(jMenuItem2);
        Class<?> clazz = null;
        if (OSPRuntime.loadVideoTool) {
            try {
                clazz = Class.forName("org.opensourcephysics.tools.VideoCaptureTool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                OSPRuntime.loadVideoTool = false;
                jMenuItem2.setEnabled(false);
                OSPLog.finest("Cannot instantiate video capture tool class:\n" + classNotFoundException.toString());
            }
        }
        final Class<?> clazz2 = clazz;
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawingFrame3D.this.drawingPanel.getVideoTool() == null) {
                    try {
                        Method method = clazz2.getMethod("getTool", null);
                        Tool tool = (Tool)method.invoke(null, null);
                        DrawingFrame3D.this.drawingPanel.setVideoTool((VideoTool)((Object)tool));
                        ((VideoTool)((Object)tool)).setVisible(true);
                        ((VideoTool)((Object)tool)).clear();
                    }
                    catch (Exception exception) {}
                } else {
                    DrawingFrame3D.this.drawingPanel.getVideoTool().setVisible(true);
                }
            }
        });
        return jMenu;
    }

    public JMenu getMenuItem(String string) {
        string = string.trim();
        JMenu jMenu = null;
        int n = 0;
        while (n < this.menuBar.getMenuCount()) {
            JMenu jMenu2 = this.menuBar.getMenu(n);
            if (jMenu2.getText().equals(string)) {
                jMenu = jMenu2;
                break;
            }
            ++n;
        }
        return jMenu;
    }

    public JMenu removeMenuItem(String string) {
        string = string.trim();
        JMenu jMenu = null;
        int n = 0;
        while (n < this.menuBar.getMenuCount()) {
            JMenu jMenu2 = this.menuBar.getMenu(n);
            if (jMenu2.getText().equals(string)) {
                jMenu = jMenu2;
                this.menuBar.remove(n);
                break;
            }
            ++n;
        }
        return jMenu;
    }

    public void inspectXML() {
        Object object;
        XMLControlElement xMLControlElement = null;
        try {
            object = this.drawingPanel.getClass().getMethod("getLoader", null);
            if (object != null && Modifier.isStatic(((Method)object).getModifiers())) {
                xMLControlElement = new XMLControlElement(this.drawingPanel);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        object = new XMLTreePanel(xMLControlElement);
        JDialog jDialog = new JDialog(null, true);
        jDialog.setContentPane((Container)object);
        jDialog.setSize(new Dimension(600, 300));
        jDialog.setVisible(true);
    }

    public void saveXML() {
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            int n2;
            File file = jFileChooser.getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, String.valueOf(DisplayRes.getString("DrawingFrame.ReplaceExisting_message")) + file.getName() + DisplayRes.getString("DrawingFrame.QuestionMark"), DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"), 1)) != 0) {
                return;
            }
            String string = XML.getRelativePath(file.getAbsolutePath());
            if (string == null || string.trim().equals("")) {
                return;
            }
            int n3 = string.toLowerCase().lastIndexOf(".xml");
            if (n3 != string.length() - 4) {
                string = String.valueOf(string) + ".xml";
            }
            try {
                Method method = this.drawingPanel.getClass().getMethod("getLoader", null);
                if (method != null && Modifier.isStatic(method.getModifiers())) {
                    XMLControlElement xMLControlElement = new XMLControlElement(this.drawingPanel);
                    xMLControlElement.write(string);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawingFrame3D.Loader();
    }
}

