/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.display3d.jogl.Element;
import org.opensourcephysics.display3d.jogl.utils.GLTools;

public class ElementTrail
extends Element
implements org.opensourcephysics.display3d.core.ElementTrail {
    public static final int NO_MAXIMUM = -1;
    private TrailPoint first;
    private TrailPoint last;
    private int maximumPoints = -1;
    private int length = 0;
    private boolean connected = true;

    public ElementTrail() {
        this.getStyle().setDrawingFill(false);
        this.getStyle().setDrawingLines(true);
    }

    void draw(GLAutoDrawable gLAutoDrawable) {
        if (!this.isVisible() || this.first == null) {
            return;
        }
        GL gL = gLAutoDrawable.getGL();
        gL.glDisable(2896);
        GLTools.setColor(gL, this.getStyle().getLineColor());
        gL.glLineWidth(this.getStyle().getLineWidth());
        gL.glPushMatrix();
        this.transform(gL);
        this.preLinesGL(gLAutoDrawable);
        gL.glBegin(1);
        TrailPoint trailPoint = this.first;
        while (trailPoint.nextPoint != null) {
            if (trailPoint.pointConnected) {
                gL.glVertex3d(trailPoint.x, trailPoint.y, trailPoint.z);
                gL.glVertex3d(trailPoint.nextPoint.x, trailPoint.nextPoint.y, trailPoint.nextPoint.z);
            } else if (trailPoint.nextPoint.nextPoint == null || !trailPoint.nextPoint.pointConnected) {
                gL.glEnd();
                gL.glBegin(0);
                gL.glVertex3d(trailPoint.nextPoint.x, trailPoint.nextPoint.y, trailPoint.nextPoint.z);
                gL.glEnd();
                gL.glBegin(1);
            }
            trailPoint = trailPoint.nextPoint;
        }
        gL.glEnd();
        gL.glPopMatrix();
        this.setElementChanged(false);
    }

    public void addPoint(double d, double d2, double d3) {
        if (this.first == null) {
            this.last = this.first = new TrailPoint(d, d2, d3, this.connected);
            this.length = 1;
        } else {
            this.last = this.last.nextPoint = new TrailPoint(d, d2, d3, this.connected);
            ++this.length;
            if (this.maximumPoints != -1 && this.length > this.maximumPoints) {
                this.first = this.first.nextPoint;
            }
        }
    }

    public void addPoint(double[] dArray) {
        this.addPoint(dArray[0], dArray[1], dArray[2]);
    }

    public void setMaximumPoints(int n) {
        this.maximumPoints = n;
    }

    public int getMaximumPoints() {
        return this.maximumPoints;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void moveToPoint(double d, double d2, double d3) {
        boolean bl = this.connected;
        this.connected = false;
        this.addPoint(d, d2, d3);
        this.connected = bl;
    }

    public void clear() {
        this.last = null;
        this.first = null;
    }

    public int getBlendPriority() {
        return 2;
    }

    private class TrailPoint {
        private double x;
        private double y;
        private double z;
        private boolean pointConnected;
        public TrailPoint nextPoint;

        public TrailPoint(double d, double d2, double d3, boolean bl) {
            this.x = d;
            this.y = d2;
            this.z = d3;
            this.pointConnected = bl;
        }
    }
}

