/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import javax.media.j3d.Node;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.opensourcephysics.display3d.java3d.Element;
import org.opensourcephysics.display3d.java3d.ElementCone;
import org.opensourcephysics.display3d.java3d.ElementSegment;
import org.opensourcephysics.display3d.java3d.Group;

public class ElementArrow
extends Element
implements org.opensourcephysics.display3d.core.ElementArrow {
    public double headScale = 0.05;
    private Group subGroup = new Group();
    private ElementCone cone;
    private ElementSegment segment = new ElementSegment(){};
    private AxisAngle4d axisAngle;

    public ElementArrow() {
        this.cone = new ElementCone(){};
        this.cone.getStyle().setDrawingFill(true);
        this.resetConePosition();
        super.setSizeXYZ(1.0, 1.0, 1.0);
        this.subGroup.setSizeXYZ(1.0, 1.0, 1.0);
        this.segment.setSizeXYZ(1.0 - this.headScale, 1.0 - this.headScale, 1.0 - this.headScale);
        this.subGroup.addElement(this.segment);
        this.subGroup.addElement(this.cone);
        this.setNode((Node)this.subGroup.getBranch());
    }

    public void transformChanged() {
    }

    public void processChanges(int n) {
        super.processChanges(n);
        if (this.cone == null || this.segment == null) {
            return;
        }
        if (((n & 2) != 0 || (n & 1) != 0) && n == 2) {
            this.resetConePosition();
            this.segment.setElementChanged(2);
        }
        if ((n & 4) != 0) {
            this.segment.getStyle().setFillColor(this.getStyle().getFillColor());
            this.segment.getStyle().setLineColor(this.getStyle().getLineColor());
            this.cone.getStyle().setFillColor(this.getStyle().getFillColor());
            this.cone.getStyle().setLineColor(this.getStyle().getLineColor());
        }
        if ((n & 8) != 0) {
            this.cone.getStyle().setResolution(this.getStyle().getResolution());
            this.resetConePosition();
        }
        if ((n & 0x10) != 0) {
            this.segment.setVisible(this.isVisible());
            this.cone.setVisible(this.isVisible());
        }
    }

    private void resetConePosition() {
        Vector3d vector3d = new Vector3d(0.0, 0.0, 1.0);
        Vector3d vector3d2 = new Vector3d(this.segment.getSize());
        vector3d2.normalize();
        vector3d2.x = vector3d2.x == Double.NaN ? vector3d2.x : 0.0;
        vector3d2.y = vector3d2.y == Double.NaN ? vector3d2.y : 0.0;
        vector3d2.z = vector3d2.z == Double.NaN ? vector3d2.z : 0.0;
        this.axisAngle = new AxisAngle4d();
        this.axisAngle.angle = Math.acos(vector3d.dot(vector3d2));
        vector3d.cross(vector3d, this.segment.getSize());
        this.axisAngle.x = vector3d.x;
        this.axisAngle.y = vector3d.y;
        this.axisAngle.z = vector3d.z;
        vector3d2.scale(this.cone.getSizeZ() / 2.0);
        vector3d2.sub((Tuple3d)this.segment.getPosition());
        vector3d2.sub((Tuple3d)this.segment.getSize(), (Tuple3d)vector3d2);
        this.cone.position.x = vector3d2.x;
        this.cone.position.y = vector3d2.y;
        this.cone.position.z = vector3d2.z;
        double d = this.segment.getSize().length();
        this.cone.transform.set(this.axisAngle);
        this.cone.transform.setTranslation(this.cone.position);
        this.cone.transform.setScale(d * this.headScale);
        this.cone.transformGroup.setTransform(this.cone.transform);
    }

    public double getSizeX() {
        return this.segment.getSizeX();
    }

    public double getSizeY() {
        return this.segment.getSizeY();
    }

    public double getSizeZ() {
        return this.segment.getSizeZ();
    }

    public void setSizeX(double d) {
        this.segment.size.x = d;
        this.setElementChanged(2);
    }

    public void setSizeY(double d) {
        this.segment.size.y = d;
        this.setElementChanged(2);
    }

    public void setSizeZ(double d) {
        this.segment.size.z = d;
        this.setElementChanged(2);
    }

    public void setSizeXYZ(double d, double d2, double d3) {
        this.segment.size.x = d;
        this.segment.size.y = d2;
        this.segment.size.z = d3;
        this.setElementChanged(2);
    }

    public void setSizeXYZ(double[] dArray) {
        this.segment.size.x = dArray[0];
        this.segment.size.y = dArray[1];
        if (dArray.length >= 3) {
            this.segment.size.z = dArray[2];
        }
        this.setElementChanged(2);
    }
}

