/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.display3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.DataCollector;
import org.colos.ejs.library.control.Resetable;
import org.colos.ejs.library.control.display3d.ControlElement3D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.ElementTrail;
import org.opensourcephysics.display3d.factory.OSP3DFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlElement3DTrail
extends ControlElement3D
implements NeedsPreUpdate,
Resetable,
DataCollector {
    private static final int TRAIL_PROPERTIES_ADDED = 6;
    private ElementTrail trail;
    private double x;
    private double y;
    private double z;
    private boolean isSet = false;
    static List<String> infoList = null;

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.display3d.core.ElementTrail";
    }

    @Override
    protected Element createElement() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.trail = OSP3DFactory.ElementTrail();
        return this.trail;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 6;
    }

    @Override
    public void reset() {
        this.trail.clear();
    }

    @Override
    public void preupdate() {
        if (this.isSet) {
            this.trail.addPoint(this.x, this.y, this.z);
        }
        this.isSet = false;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("maximumPoints");
            infoList.add("connected");
            infoList.add("inputX");
            infoList.add("inputY");
            infoList.add("inputZ");
            infoList.add("depthFactor");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("maximumPoints")) {
            return "int";
        }
        if (string.equals("connected")) {
            return "boolean";
        }
        if (string.equals("inputX")) {
            return "int|double";
        }
        if (string.equals("inputY")) {
            return "int|double";
        }
        if (string.equals("inputZ")) {
            return "int|double";
        }
        if (string.equals("depthFactor")) {
            return "double";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getInteger() == this.trail.getMaximumPoints()) break;
                this.trail.setMaximumPoints(value.getInteger());
                break;
            }
            case 1: {
                this.trail.setConnected(value.getBoolean());
                break;
            }
            case 2: {
                this.x = value.getDouble();
                this.isSet = true;
                break;
            }
            case 3: {
                this.y = value.getDouble();
                this.isSet = true;
                break;
            }
            case 4: {
                this.z = value.getDouble();
                this.isSet = true;
                break;
            }
            case 5: {
                this.trail.getStyle().setDepthFactor(value.getDouble());
                break;
            }
            default: {
                super.setValue(n - 6, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.trail.setMaximumPoints(0);
                break;
            }
            case 1: {
                this.trail.setConnected(true);
                break;
            }
            case 2: {
                this.x = 0.0;
                break;
            }
            case 3: {
                this.y = 0.0;
                break;
            }
            case 4: {
                this.z = 0.0;
                break;
            }
            case 5: {
                this.trail.getStyle().setDepthFactor(1.0);
                break;
            }
            default: {
                super.setDefaultValue(n - 6);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return super.getValue(n - 6);
    }
}

