/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.opensourcephysics.display.ArrayTable;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayPanel
extends JPanel
implements PropertyChangeListener,
Data {
    JTabbedPane tabbedPane = new JTabbedPane();
    ArrayTable[] tables;
    JSpinner spinner;
    JScrollPane scrollpane;
    Object array;
    boolean changed;
    String format = null;
    int firstRowIndex = 0;
    int firstColIndex = 0;
    boolean rowNumberVisible = true;
    boolean editable = true;
    String[] colNames;
    private int ID = this.hashCode();

    public static ArrayPanel getArrayPanel(Object object) {
        ArrayPanel arrayPanel = new ArrayPanel();
        arrayPanel.setArray(object);
        return arrayPanel;
    }

    public void setArray(Object object) {
        if (!ArrayPanel.canDisplay(object)) {
            return;
        }
        if (object instanceof double[]) {
            this.setArray((double[])object);
        } else if (object instanceof double[][]) {
            this.setArray((double[][])object);
        } else if (object instanceof double[][][]) {
            this.setArray((double[][][])object);
        } else if (object instanceof int[]) {
            this.setArray((int[])object);
        } else if (object instanceof int[][]) {
            this.setArray((int[][])object);
        } else if (object instanceof int[][][]) {
            this.setArray((int[][][])object);
        } else if (object instanceof String[]) {
            this.setArray((String[])object);
        } else if (object instanceof String[][]) {
            this.setArray((String[][])object);
        } else if (object instanceof String[][][]) {
            this.setArray((String[][][])object);
        } else if (object instanceof boolean[]) {
            this.setArray((boolean[])object);
        } else if (object instanceof boolean[][]) {
            this.setArray((boolean[][])object);
        } else if (object instanceof boolean[][][]) {
            this.setArray((boolean[][][])object);
        }
        this.array = object;
    }

    public static boolean canDisplay(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof double[] || object instanceof double[][] || object instanceof double[][][] || object instanceof int[] || object instanceof int[][] || object instanceof int[][][] || object instanceof boolean[] || object instanceof boolean[][] || object instanceof boolean[][][] || object instanceof String[] || object instanceof String[][] || object instanceof String[][][];
    }

    public Object getArray() {
        return this.array;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.changed = true;
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    public void setNumericFormat(String string) {
        this.format = string;
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setNumericFormat(string);
            ++n;
        }
    }

    public void setNumericFormat(String[] stringArray) {
        this.format = null;
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setNumericFormat(stringArray);
            ++n;
        }
    }

    public void setRowNumberVisible(boolean bl) {
        this.rowNumberVisible = bl;
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setRowNumberVisible(bl);
            ++n;
        }
    }

    public void setColumnNames(String[] stringArray) {
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setColumnNames(stringArray);
            ++n;
        }
    }

    public void setColumnNames(String[][] stringArray) {
        int n = Math.min(this.tables.length, stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            this.tables[n2].setColumnNames(stringArray[n2]);
            ++n2;
        }
    }

    public void setPreferredColumnWidth(int n, int n2) {
        int n3 = 0;
        while (n3 < this.tables.length) {
            TableColumn tableColumn = this.tables[n3].getColumnModel().getColumn(n);
            tableColumn.setMinWidth(0);
            tableColumn.setMaxWidth(300);
            tableColumn.setPreferredWidth(n2);
            ++n3;
        }
    }

    public void setPreferredColumnWidth(int n) {
        int n2 = 0;
        while (n2 < this.tables.length) {
            int n3 = 0;
            while (n3 < this.tables[n2].getColumnCount()) {
                TableColumn tableColumn = this.tables[n2].getColumnModel().getColumn(n3);
                tableColumn.setMinWidth(0);
                tableColumn.setMaxWidth(300);
                tableColumn.setPreferredWidth(n);
                ++n3;
            }
            ++n2;
        }
    }

    public void setColumnAlignment(int n, int n2) {
        int n3 = 0;
        while (n3 < this.tables.length) {
            int n4 = 0;
            while (n4 < this.tables[n3].getRowCount()) {
                TableCellRenderer tableCellRenderer = this.tables[n3].getCellRenderer(n4, n);
                ((JLabel)((Object)tableCellRenderer)).setHorizontalAlignment(n2);
                ++n4;
            }
            ++n3;
        }
    }

    public void setColumnAlignment(int n) {
        int n2 = 0;
        while (n2 < this.tables.length) {
            int n3 = 0;
            while (n3 < this.tables[n2].getRowCount()) {
                int n4 = 0;
                while (n4 < this.tables[n2].getColumnCount()) {
                    TableCellRenderer tableCellRenderer = this.tables[n2].getCellRenderer(n3, n4);
                    ((JLabel)((Object)tableCellRenderer)).setHorizontalAlignment(n);
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public int getFirstRowIndex() {
        return this.firstRowIndex;
    }

    public void setFirstRowIndex(int n) {
        this.firstRowIndex = n;
        int n2 = 0;
        while (n2 < this.tables.length) {
            this.tables[n2].setFirstRowIndex(n);
            ++n2;
        }
    }

    public void setFirstColIndex(int n) {
        this.firstColIndex = n;
        int n2 = 0;
        while (n2 < this.tables.length) {
            this.tables[n2].setFirstColIndex(n);
            ++n2;
        }
    }

    public void setColumnLock(int n, boolean bl) {
        int n2 = 0;
        while (n2 < this.tables.length) {
            this.tables[n2].setColumnLock(n, bl);
            ++n2;
        }
    }

    public void setColumnLocks(boolean[] blArray) {
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setColumnLocks(blArray);
            ++n;
        }
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setEditable(bl);
            ++n;
        }
    }

    public void setTransposed(boolean bl) {
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setTransposed(bl);
            ++n;
        }
    }

    public int getNumColumns() {
        return this.tables[0].getColumnCount();
    }

    public void refreshTable() {
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].refreshTable();
            ++n;
        }
    }

    public void setRefreshDelay(int n) {
        int n2 = 0;
        while (n2 < this.tables.length) {
            this.tables[n2].setRefreshDelay(n);
            ++n2;
        }
    }

    protected void createGUI() {
        this.removeAll();
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new BorderLayout());
        this.scrollpane = new JScrollPane(this.tables[0]);
        if (this.tables.length > 1) {
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, this.tables.length - 1, 1);
            this.spinner = new JSpinner(spinnerNumberModel);
            JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.spinner);
            numberEditor.getTextField().setFont(this.tables[0].indexRenderer.getFont());
            this.spinner.setEditor(numberEditor);
            this.spinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = (Integer)ArrayPanel.this.spinner.getValue();
                    ArrayPanel.this.scrollpane.setViewportView(ArrayPanel.this.tables[n]);
                }
            });
            Dimension dimension = this.spinner.getMinimumSize();
            this.spinner.setMaximumSize(dimension);
            this.add((Component)this.scrollpane, "Center");
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.add(new JLabel(" index "));
            jToolBar.add(this.spinner);
            jToolBar.add(Box.createHorizontalGlue());
            this.add((Component)jToolBar, "North");
        } else {
            this.scrollpane.createHorizontalScrollBar();
            this.add((Component)this.scrollpane, "Center");
        }
        this.validate();
    }

    private void setArray(int[] nArray) {
        if (this.array instanceof int[]) {
            this.tables[0].tableModel.setArray(nArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(nArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(int[][] nArray) {
        if (this.array instanceof int[][]) {
            this.tables[0].tableModel.setArray(nArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(nArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(int[][][] nArray) {
        this.tables = new ArrayTable[nArray.length];
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n] = new ArrayTable(nArray[n]);
            this.tables[n].addPropertyChangeListener("cell", this);
            ++n;
        }
        this.createGUI();
    }

    private void setArray(double[] dArray) {
        if (this.array instanceof double[]) {
            this.tables[0].tableModel.setArray(dArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(dArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(double[][] dArray) {
        if (this.array instanceof double[][]) {
            this.tables[0].tableModel.setArray(dArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(dArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(double[][][] dArray) {
        this.tables = new ArrayTable[dArray.length];
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n] = new ArrayTable(dArray[n]);
            this.tables[n].addPropertyChangeListener("cell", this);
            ++n;
        }
        this.createGUI();
    }

    private void setArray(String[] stringArray) {
        if (this.array instanceof String[]) {
            this.tables[0].tableModel.setArray(stringArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(stringArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(String[][] stringArray) {
        if (this.array instanceof String[][]) {
            this.tables[0].tableModel.setArray(stringArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(stringArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(String[][][] stringArray) {
        this.tables = new ArrayTable[stringArray.length];
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n] = new ArrayTable(stringArray[n]);
            this.tables[n].addPropertyChangeListener("cell", this);
            ++n;
        }
        this.createGUI();
    }

    private void setArray(boolean[] blArray) {
        if (this.array instanceof boolean[]) {
            this.tables[0].tableModel.setArray(blArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(blArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(boolean[][] blArray) {
        if (this.array instanceof boolean[][]) {
            this.tables[0].tableModel.setArray(blArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(blArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(boolean[][][] blArray) {
        this.tables = new ArrayTable[blArray.length];
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n] = new ArrayTable(blArray[n]);
            this.tables[n].addPropertyChangeListener("cell", this);
            ++n;
        }
        this.createGUI();
    }

    @Override
    public String[] getColumnNames() {
        String[] stringArray;
        double[][] dArray = this.getData2D();
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        if (this.colNames == null || n != this.colNames.length) {
            this.colNames = new String[n];
        }
        int n2 = (stringArray = this.tables[0].tableModel.columnNames) == null ? 0 : Math.min(n, stringArray.length - 1);
        int n3 = 0;
        while (n3 < n2) {
            this.colNames[n3] = stringArray[n3 + 1];
            ++n3;
        }
        n3 = n2;
        while (n3 < n) {
            this.colNames[n3] = "C" + (n3 + 1);
            ++n3;
        }
        return this.colNames;
    }

    @Override
    public double[][] getData2D() {
        if (this.tables == null || this.tables[0] == null) {
            return null;
        }
        boolean bl = this.tables[0].tableModel.transposed;
        double[][] dArray = this.tables[0].tableModel.doubleArray2;
        if (!bl && dArray != null) {
            int n = dArray.length;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 = Math.max(n2, dArray[n3].length);
                ++n3;
            }
            double[][] dArray2 = new double[n2][n];
            int n4 = 0;
            while (n4 < n) {
                int n5 = dArray[n4].length;
                int n6 = 0;
                while (n6 < n5) {
                    dArray2[n6][n4] = dArray[n4][n6];
                    ++n6;
                }
                n6 = n5;
                while (n6 < n2) {
                    dArray2[n6][n4] = Double.NaN;
                    ++n6;
                }
                ++n4;
            }
            return dArray2;
        }
        return dArray;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    @Override
    public Color[] getFillColors() {
        return null;
    }

    @Override
    public Color[] getLineColors() {
        return null;
    }

    @Override
    public int getID() {
        boolean bl = this.tables[0].tableModel.transposed;
        if (bl) {
            return this.ID ^ 0xFFFF;
        }
        return this.ID;
    }

    @Override
    public void setID(int n) {
        this.ID = n;
    }
}

