/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Util;

public class Vec3D {
    public double x;
    public double y;
    public double z;

    public Vec3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vec3D(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public Vec3D(Vec3D vec3D) {
        this.x = vec3D.x;
        this.y = vec3D.y;
        this.z = vec3D.z;
    }

    public Vec3D() {
        this(0.0, 0.0, 0.0);
    }

    public final void subtract(Vec3D vec3D, Vec3D vec3D2) {
        this.x = vec3D.x - vec3D2.x;
        this.y = vec3D.y - vec3D2.y;
        this.z = vec3D.z - vec3D2.z;
    }

    public final void add(Vec3D vec3D, Vec3D vec3D2) {
        this.x = vec3D.x + vec3D2.x;
        this.y = vec3D.y + vec3D2.y;
        this.z = vec3D.z + vec3D2.z;
    }

    public void cross(Vec3D vec3D, Vec3D vec3D2) {
        double d = vec3D.y * vec3D2.z - vec3D.z * vec3D2.y;
        double d2 = vec3D2.x * vec3D.z - vec3D2.z * vec3D.x;
        this.z = vec3D.x * vec3D2.y - vec3D.y * vec3D2.x;
        this.x = d;
        this.y = d2;
    }

    public void multiply(Vec3D vec3D, double d) {
        this.x = vec3D.x * d;
        this.y = vec3D.y * d;
        this.z = vec3D.z * d;
    }

    public final void normalize() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z;
        if (d < Util.defaultNumericalPrecision) {
            return;
        }
        if (d == 1.0) {
            return;
        }
        d = 1.0 / Math.sqrt(d);
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public final double dot(Vec3D vec3D) {
        return this.x * vec3D.x + this.y * vec3D.y + this.z * vec3D.z;
    }

    public final double magnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final double angle(Vec3D vec3D) {
        double d = this.dot(vec3D) / (this.magnitude() * vec3D.magnitude());
        if (d < -1.0) {
            d = -1.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return Math.acos(d);
    }
}

