/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.opensourcephysics.drawing3d.DrawingPanel3D;

public class VisualizationHints {
    public static final int HINT_DECORATION_TYPE = 0;
    public static final int HINT_REMOVE_HIDDEN_LINES = 1;
    public static final int HINT_ALLOW_QUICK_REDRAW = 2;
    public static final int HINT_USE_COLOR_DEPTH = 3;
    public static final int HINT_CURSOR_TYPE = 4;
    public static final int HINT_SHOW_COORDINATES = 5;
    public static final int HINT_AXES_LABELS = 6;
    public static final int HINT_BACKGROUND_IMAGE = 7;
    public static final int HINT_BACKGROUND_MOVEABLE = 8;
    public static final int HINT_BACKGROUND_SCALE = 9;
    public static final int HINT_COLORS = 10;
    public static final int HINT_FONT = 11;
    public static final int HINT_DEFAULT_ILLUMINATION = 12;
    public static final int HINT_ANY = -1;
    public static final int DECORATION_NONE = 0;
    public static final int DECORATION_AXES = 1;
    public static final int DECORATION_CUBE = 2;
    public static final int DECORATION_CENTERED_AXES = 3;
    public static final int CURSOR_NONE = 0;
    public static final int CURSOR_XYZ = 1;
    public static final int CURSOR_CUBE = 2;
    public static final int CURSOR_CROSSHAIR = 3;
    private boolean removeHiddenLines = true;
    private boolean allowQuickRedraw = true;
    private boolean useColorDepth = true;
    private int cursorType = 1;
    private int showCoordinates = 0;
    private int decorationType = 2;
    private String formatX = "x = 0.00;x = -0.00";
    private String formatY = "y = 0.00;y = -0.00";
    private String formatZ = "z = 0.00;z = -0.00";
    private String[] axesLabels = new String[]{"X", "Y", "Z"};
    private String backgroundImageFilename = null;
    private Image backgroundImage = null;
    private Dimension backgroundTile = null;
    private boolean backgroundMoveable = true;
    private double scaleBackground = 0.0;
    private Color backgroundColor = new Color(239, 239, 255);
    private Color foregroundColor = Color.BLACK;
    private Font font = new Font("Dialog", 0, 12);
    private boolean ilumination = true;
    private NumberFormat theFormatX = new DecimalFormat(this.formatX);
    private NumberFormat theFormatY = new DecimalFormat(this.formatY);
    private NumberFormat theFormatZ = new DecimalFormat(this.formatZ);
    private DrawingPanel3D panel;

    public VisualizationHints(DrawingPanel3D drawingPanel3D) {
        this.panel = drawingPanel3D;
    }

    public void setBackgroundColor(Color color) {
        if (color == null || color.equals(this.backgroundColor)) {
            return;
        }
        this.backgroundColor = color;
        this.panel.hintChanged(10);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setForegroundColor(Color color) {
        if (color == null || color.equals(this.foregroundColor)) {
            return;
        }
        this.foregroundColor = color;
        this.panel.hintChanged(10);
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setFont(Font font) {
        if (font == null || font.equals(this.font)) {
            return;
        }
        this.font = font;
        this.panel.hintChanged(11);
    }

    public Font getFont() {
        return this.font;
    }

    public void setCursorType(int n) {
        this.cursorType = n;
        this.panel.hintChanged(4);
    }

    public final int getCursorType() {
        return this.cursorType;
    }

    public void setDecorationType(int n) {
        this.decorationType = n;
        this.panel.hintChanged(0);
    }

    public final int getDecorationType() {
        return this.decorationType;
    }

    public final void setAxesLabels(String[] stringArray) {
        this.axesLabels = stringArray;
        this.panel.hintChanged(6);
    }

    public final String[] getAxesLabels() {
        return this.axesLabels;
    }

    public void setRemoveHiddenLines(boolean bl) {
        this.removeHiddenLines = bl;
        this.panel.hintChanged(1);
    }

    public final boolean isRemoveHiddenLines() {
        return this.removeHiddenLines;
    }

    public void setAllowQuickRedraw(boolean bl) {
        this.allowQuickRedraw = bl;
        this.panel.hintChanged(2);
    }

    public final boolean isAllowQuickRedraw() {
        return this.allowQuickRedraw;
    }

    public void setUseColorDepth(boolean bl) {
        this.useColorDepth = bl;
        this.panel.hintChanged(3);
    }

    public final boolean isUseColorDepth() {
        return this.useColorDepth;
    }

    public void setShowCoordinates(int n) {
        this.showCoordinates = n;
        this.panel.hintChanged(5);
    }

    public int getShowCoordinates() {
        return this.showCoordinates;
    }

    public void setXFormat(String string) {
        this.formatX = string;
        if (this.formatX != null) {
            this.theFormatX = new DecimalFormat(this.formatX);
        }
    }

    public String getXFormat() {
        return this.formatX;
    }

    public void setYFormat(String string) {
        this.formatY = string;
        if (this.formatY != null) {
            this.theFormatY = new DecimalFormat(this.formatY);
        }
    }

    public String getYFormat() {
        return this.formatY;
    }

    public void setZFormat(String string) {
        this.formatZ = string;
        if (this.formatZ != null) {
            this.theFormatZ = new DecimalFormat(this.formatZ);
        }
    }

    public String getZFormat() {
        return this.formatZ;
    }

    public void setBackgroundImage(String string) {
        this.backgroundImageFilename = string;
        this.backgroundImage = null;
        this.panel.hintChanged(7);
    }

    public final String getBackgroundImageFilename() {
        return this.backgroundImageFilename;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageFilename = null;
        this.backgroundImage = image;
        this.panel.hintChanged(7);
    }

    public final Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundSize(Dimension dimension) {
        if (dimension != null && this.backgroundTile.height == dimension.height && this.backgroundTile.width == dimension.width) {
            return;
        }
        this.backgroundTile = dimension;
        this.panel.hintChanged(7);
    }

    public final Dimension getBackgroundTile() {
        return this.backgroundTile;
    }

    public void setBackgroundMoveable(boolean bl) {
        if (this.backgroundMoveable == bl) {
            return;
        }
        this.backgroundMoveable = bl;
        this.panel.hintChanged(8);
    }

    public final boolean getBackgroundMoveable() {
        if (this.backgroundImage != null) {
            return false;
        }
        return this.backgroundMoveable;
    }

    public void setScaleBackground(double d) {
        if (this.scaleBackground == d) {
            return;
        }
        this.scaleBackground = d;
        this.panel.hintChanged(9);
    }

    public final double getScaleBackground() {
        return this.scaleBackground;
    }

    public void setDefaultIllumination(boolean bl) {
        if (this.ilumination == bl) {
            return;
        }
        this.ilumination = bl;
        this.panel.hintChanged(12);
    }

    public final boolean getDefaultIllumination() {
        return this.ilumination;
    }

    public void displayPosition(int n, double[] dArray) {
        if (this.showCoordinates < 0) {
            return;
        }
        if (dArray == null) {
            this.panel.getImplementingPanel().setMessage(null, this.showCoordinates);
            return;
        }
        String string = "";
        switch (n) {
            case 0: {
                if (this.formatX != null) {
                    string = this.theFormatX.format(dArray[0]);
                }
                if (this.formatY == null) break;
                string = String.valueOf(string) + ", " + this.theFormatY.format(dArray[1]);
                break;
            }
            case 1: {
                if (this.formatX != null) {
                    string = this.theFormatX.format(dArray[0]);
                }
                if (this.formatZ == null) break;
                string = String.valueOf(string) + ", " + this.theFormatZ.format(dArray[2]);
                break;
            }
            case 2: {
                if (this.formatY != null) {
                    string = this.theFormatY.format(dArray[1]);
                }
                if (this.formatZ == null) break;
                string = String.valueOf(string) + ", " + this.theFormatZ.format(dArray[2]);
                break;
            }
            default: {
                if (this.formatX != null) {
                    string = this.theFormatX.format(dArray[0]);
                }
                if (this.formatY != null) {
                    string = String.valueOf(string) + ", " + this.theFormatY.format(dArray[1]);
                }
                if (this.formatZ == null) break;
                string = String.valueOf(string) + ", " + this.theFormatZ.format(dArray[2]);
            }
        }
        if (string.startsWith(", ")) {
            string = string.substring(2);
        }
        this.panel.getImplementingPanel().setMessage(string, this.showCoordinates);
    }

    public void copyFrom(VisualizationHints visualizationHints) {
        this.decorationType = visualizationHints.getDecorationType();
        this.cursorType = visualizationHints.getCursorType();
        this.axesLabels = visualizationHints.getAxesLabels();
        this.removeHiddenLines = visualizationHints.isRemoveHiddenLines();
        this.allowQuickRedraw = visualizationHints.isAllowQuickRedraw();
        this.useColorDepth = visualizationHints.isUseColorDepth();
        this.showCoordinates = visualizationHints.getShowCoordinates();
        this.formatX = visualizationHints.getXFormat();
        if (this.formatX != null) {
            this.theFormatX = new DecimalFormat(this.formatX);
        }
        this.formatZ = visualizationHints.getYFormat();
        if (this.formatY != null) {
            this.theFormatY = new DecimalFormat(this.formatY);
        }
        this.formatZ = visualizationHints.getZFormat();
        if (this.formatZ != null) {
            this.theFormatZ = new DecimalFormat(this.formatZ);
        }
        this.backgroundImageFilename = visualizationHints.getBackgroundImageFilename();
        this.backgroundImage = visualizationHints.getBackgroundImage();
        this.panel.hintChanged(-1);
    }
}

