/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Sphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import org.opensourcephysics.drawing3d.ElementEllipsoid;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;

public class Java3dElementEllipsoid
extends Java3dElement {
    private Sphere sphere;
    private TransformGroup tg;
    private BranchGroup bg;
    double[][][] standardSphere;
    private int nr = 0;
    private int nu = 0;
    private int nv = 0;

    public Java3dElementEllipsoid(ElementEllipsoid elementEllipsoid) {
        super(elementEllipsoid);
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(1.5707963267948966);
        this.tg = new TransformGroup();
        this.tg.setCapability(14);
        this.tg.setCapability(13);
        this.tg.setTransform(transform3D);
    }

    public void processChanges(int n, int n2) {
        super.processChanges(n, n2);
        if ((n & 0x10) != 0) {
            if (this.element.getStyle().getResolution().getType() == 1) {
                double d = Math.max(Math.max(Math.abs(this.element.getSizeX()), Math.abs(this.element.getSizeY())), Math.abs(this.element.getSizeZ())) / 2.0;
                this.nr = Math.max((int)Math.round(0.49 + d / this.element.getStyle().getResolution().getMaxLength()), 1);
                this.nu = Math.max((int)Math.round(0.49 + (double)Math.abs(((ElementEllipsoid)this.element).getMaximumAngleU() - ((ElementEllipsoid)this.element).getMinimumAngleU()) * (Math.PI / 180) * d / this.element.getStyle().getResolution().getMaxLength()), 1);
                this.nv = Math.max((int)Math.round(0.49 + (double)Math.abs(((ElementEllipsoid)this.element).getMaximumAngleV() - ((ElementEllipsoid)this.element).getMinimumAngleV()) * (Math.PI / 180) * d / this.element.getStyle().getResolution().getMaxLength()), 1);
            } else {
                this.nr = Math.max(this.element.getStyle().getResolution().getN1(), 1);
                this.nu = Math.max(this.element.getStyle().getResolution().getN2(), 1);
                this.nv = Math.max(this.element.getStyle().getResolution().getN3(), 1);
            }
            if (((ElementEllipsoid)this.element).checkStandarEllipsoid() && this.element.getStyle().isDrawingFill()) {
                this.primitive = true;
                this.createPrimitiveEllipsoid(2 * Math.max(this.nu, this.nv));
            } else {
                this.primitive = false;
                this.createTileEllipsoid();
            }
            this.styleChanged(10);
        }
        if ((n & 8) != 0) {
            if (((ElementEllipsoid)this.element).checkStandarEllipsoid() && this.element.getStyle().isDrawingFill()) {
                if (this.primitive) {
                    return;
                }
                this.primitive = true;
                this.createPrimitiveEllipsoid(2 * Math.max(this.nu, this.nv));
            } else {
                this.primitive = false;
                this.createTileEllipsoid();
            }
            this.styleChanged(10);
        }
    }

    private void createPrimitiveEllipsoid(int n) {
        if (this.sphere != null || this.standardSphere != null) {
            this.tg.removeChild((Node)this.bg);
        }
        this.sphere = new Sphere(0.5f, 35, n);
        this.sphere.setAppearance(this.getAppearance());
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)this.sphere);
        this.tg.addChild((Node)this.bg);
        this.addNode((Node)this.tg);
    }

    private void createTileEllipsoid() {
        this.standardSphere = ElementEllipsoid.createStandardEllipsoid(this.nr, this.nu, this.nv, ((ElementEllipsoid)this.element).getMinimumAngleU(), ((ElementEllipsoid)this.element).getMaximumAngleU(), ((ElementEllipsoid)this.element).getMinimumAngleV(), ((ElementEllipsoid)this.element).getMaximumAngleV(), ((ElementEllipsoid)this.element).isClosedTop(), ((ElementEllipsoid)this.element).isClosedBottom(), ((ElementEllipsoid)this.element).isClosedLeft(), ((ElementEllipsoid)this.element).isClosedRight());
        int n = this.standardSphere.length;
        int n2 = this.standardSphere[0].length;
        Point3d[] point3dArray = new Point3d[n * n2 * 2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                point3dArray[n3 * n2 + n4 + n * n2] = new Point3d(this.standardSphere[n3][n4][0], this.standardSphere[n3][n4][1], this.standardSphere[n3][n4][2]);
                if (n4 == 0) {
                    point3dArray[n3 * n2 + n4 + 3] = new Point3d(this.standardSphere[n3][n4][0], this.standardSphere[n3][n4][1], this.standardSphere[n3][n4][2]);
                } else if (n4 == 1) {
                    point3dArray[n3 * n2 + n4 + 1] = new Point3d(this.standardSphere[n3][n4][0], this.standardSphere[n3][n4][1], this.standardSphere[n3][n4][2]);
                } else if (n4 == 2) {
                    point3dArray[n3 * n2 + n4 - 1] = new Point3d(this.standardSphere[n3][n4][0], this.standardSphere[n3][n4][1], this.standardSphere[n3][n4][2]);
                } else {
                    point3dArray[n3 * n2 + n4 - 3] = new Point3d(this.standardSphere[n3][n4][0], this.standardSphere[n3][n4][1], this.standardSphere[n3][n4][2]);
                }
                ++n4;
            }
            ++n3;
        }
        GeometryInfo geometryInfo = new GeometryInfo(2);
        geometryInfo.setCoordinates(point3dArray);
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.setCreaseAngle((double)((float)Math.toRadians(40.0)));
        normalGenerator.generateNormals(geometryInfo);
        GeometryArray geometryArray = geometryInfo.getGeometryArray();
        Shape3D shape3D = new Shape3D((Geometry)geometryArray, this.getAppearance());
        this.addNode((Node)shape3D);
    }

    public void styleChanged(int n) {
        super.styleChanged(n);
        if (n == 4 || n == 3) {
            if (this.element.getStyle().isDrawingLines() && !this.element.getStyle().isDrawingFill()) {
                if (this.nr == 0 && this.nv == 0 && this.nu == 0) {
                    this.processChanges(16, 0);
                }
                this.primitive = false;
                this.createTileEllipsoid();
            }
            if (this.element.getStyle().isDrawingFill() && ((ElementEllipsoid)this.element).checkStandarEllipsoid()) {
                if (this.primitive) {
                    return;
                }
                if (this.nr == 0 && this.nv == 0 && this.nu == 0) {
                    this.processChanges(16, 0);
                }
                this.primitive = true;
                this.createPrimitiveEllipsoid(2 * Math.max(this.nu, this.nv));
            }
        }
    }

    public boolean isPrimitive() {
        return this.primitive;
    }
}

