/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.LogMeasurable;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.Drawable3D;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetTracePoint;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.displayejs.Point3D;
import org.opensourcephysics.displayejs.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveTrace
extends AbstractInteractiveElement
implements Data,
LogMeasurable {
    public static final int SHOW_ALL = 0;
    public static final int ORDER_OF_APPEARANCE = 1;
    public static final int X_COORDINATE = 2;
    public static final int Y_COORDINATE = 3;
    public static final int Z_COORDINATE = 4;
    public static final int BAR = 14;
    public static final int POST = 15;
    private static final int MAX_POINTS = 100000;
    protected boolean connected = true;
    protected boolean ignore = false;
    protected boolean active = true;
    protected boolean clearAtInput = false;
    protected int maxPoints = 100000;
    protected int skip = 0;
    protected int shapeSize;
    protected int drivenBy = 0;
    protected int memorySets = 1;
    private int shapeType = -1;
    protected Color memoryColor = null;
    protected String name = "trace";
    private int counter = 0;
    private int pointsAdded = 0;
    private int pointsNotProjected = 0;
    private double[] point = new double[3];
    private String xLabel = "x";
    private String yLabel = "y";
    private String zLabel = "z";
    protected ArrayList<OnePoint> list;
    protected ArrayList<OnePoint> displayList;
    private OnePoint nullPoint;
    private OnePoint lastPoint = this.nullPoint = new OnePoint(this, Double.NaN, Double.NaN, Double.NaN, false, 0, this.style);
    private OnePoint flushPoint = this.nullPoint;
    private Object3D[] minimalObjects = new Object3D[1];
    private AffineTransform transform = new AffineTransform();
    private ArrayList<ArrayList<OnePoint>> memoryLists = new ArrayList();
    protected double xmaxLogscale;
    protected double ymaxLogscale;
    protected double xminLogscale;
    protected double yminLogscale;
    private boolean showZ = false;
    private boolean allowTable = false;

    public InteractiveTrace() {
        this.list = new ArrayList();
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof InteractiveTrace) {
            this.setMaximumPoints(((InteractiveTrace)interactiveElement).getMaximumPoints());
            this.setConnected(((InteractiveTrace)interactiveElement).isConnected());
            this.setIgnoreEqualPoints(((InteractiveTrace)interactiveElement).isIgnoreEqualPoints());
            this.setActive(((InteractiveTrace)interactiveElement).isActive());
            this.setSkip(((InteractiveTrace)interactiveElement).getSkip());
            this.setMemorySets(((InteractiveTrace)interactiveElement).getMemorySets());
            this.setMemoryColor(((InteractiveTrace)interactiveElement).getMemoryColor());
            this.setName(((InteractiveTrace)interactiveElement).getName());
            this.setAllowTable(((InteractiveTrace)interactiveElement).allowTable);
        }
    }

    @Override
    public void initializeMemberOfSet() {
        this.setAllowTable(true);
    }

    public void setMaximumPoints(int n) {
        if (n < 0 || n == this.maxPoints) {
            return;
        }
        this.maxPoints = n == 0 ? 100000 : n;
        this.counter = 0;
        this.initialize();
    }

    public int getMaximumPoints() {
        return this.maxPoints;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setIgnoreEqualPoints(boolean bl) {
        this.ignore = bl;
    }

    public boolean isIgnoreEqualPoints() {
        return this.ignore;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setClearAtInput(boolean bl) {
        this.clearAtInput = bl;
    }

    public boolean isClearAtInput() {
        return this.clearAtInput;
    }

    public void setSkip(int n) {
        if (n == this.skip) {
            return;
        }
        this.skip = n;
        this.counter = 0;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setMemorySets(int n) {
        if (n == this.memorySets || n < 0) {
            return;
        }
        this.memoryLists.clear();
        this.memorySets = n;
    }

    public int getMemorySets() {
        return this.memorySets;
    }

    public void setMemoryDrivenBy(int n) {
        this.drivenBy = n;
    }

    public int getMemoryDrivenBy() {
        return this.drivenBy;
    }

    public void setMemoryColor(Color color) {
        this.memoryColor = color;
    }

    public Color getMemoryColor() {
        return this.memoryColor;
    }

    public void setAllowTable(boolean bl) {
        this.allowTable = bl;
    }

    public void setXLabel(String string) {
        this.xLabel = string;
    }

    public void setYLabel(String string) {
        this.yLabel = string;
    }

    public void setZLabel(String string) {
        this.zLabel = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        ArrayList<Object> arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
        arrayList = this.memoryLists;
        synchronized (arrayList) {
            this.memoryLists.clear();
        }
        this.pointsNotProjected = 0;
        this.pointsAdded = 0;
        this.lastPoint = this.nullPoint;
        this.flushPoint = this.nullPoint;
        this.counter = 0;
        this.showZ = false;
    }

    public synchronized void initialize() {
        if (this.memorySets == 1) {
            return;
        }
        this.pointsNotProjected = 0;
        this.pointsAdded = 0;
        this.lastPoint = this.nullPoint;
        this.flushPoint = this.nullPoint;
        if (this.list.size() <= 0) {
            return;
        }
        switch (this.memorySets) {
            default: {
                if (this.memoryLists.size() < this.memorySets - 1) break;
                this.memoryLists.remove(0);
            }
            case 0: 
        }
        if (this.memoryColor != null) {
            for (OnePoint onePoint : this.list) {
                onePoint.pointStyle.setEdgeColor(this.memoryColor);
            }
        }
        this.memoryLists.add(this.list);
        this.list = new ArrayList();
    }

    public void addPoint(double d, double d2) {
        if (this.clearAtInput) {
            this.clear();
        }
        this.addThePoint(d, d2, 0.0);
    }

    public void addPoints(double[] dArray, double[] dArray2) {
        if (this.clearAtInput) {
            this.clear();
        }
        int n = Math.min(dArray.length, dArray2.length);
        int n2 = 0;
        while (n2 < n) {
            this.addThePoint(dArray[n2], dArray2[n2], 0.0);
            ++n2;
        }
    }

    public void addPoint(double d, double d2, double d3) {
        if (this.clearAtInput) {
            this.clear();
        }
        this.showZ = true;
        this.addThePoint(d, d2, d3);
    }

    public void addPoints(double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.clearAtInput) {
            this.clear();
        }
        int n = Math.min(Math.min(dArray.length, dArray2.length), dArray3.length);
        int n2 = 0;
        while (n2 < n) {
            this.addThePoint(dArray[n2], dArray2[n2], dArray3[n2]);
            ++n2;
        }
    }

    public void moveToPoint(double d, double d2) {
        if (this.clearAtInput) {
            this.clear();
        }
        boolean bl = this.connected;
        this.connected = false;
        this.addThePoint(d, d2, 0.0);
        this.connected = bl;
    }

    public void moveToPoint(double d, double d2, double d3) {
        if (this.clearAtInput) {
            this.clear();
        }
        this.showZ = true;
        boolean bl = this.connected;
        this.connected = false;
        this.addThePoint(d, d2, d3);
        this.connected = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addThePoint(double d, double d2, double d3) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            return;
        }
        if (this.ignore && d == this.lastPoint.coordinates[0] && d2 == this.lastPoint.coordinates[1] && d3 == this.lastPoint.coordinates[2]) {
            return;
        }
        if (this.skip > 0) {
            if (this.counter > 0) {
                ++this.counter;
                if (this.counter >= this.skip) {
                    this.counter = 0;
                }
                this.lastPoint = this.flushPoint = new OnePoint(this, d, d2, d3, this.connected && this.pointsAdded != 0, this.shapeType, this.style);
                return;
            }
            ++this.counter;
        }
        this.flushPoint = this.nullPoint;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            if (this.maxPoints > 0 && this.list.size() >= this.maxPoints) {
                this.list.remove(0);
                if (this.list.size() > 0) {
                    this.list.get((int)0).isConnected = false;
                }
            }
            this.lastPoint = new OnePoint(this, d, d2, d3, this.connected && this.pointsAdded != 0, this.shapeType, this.style);
            this.list.add(this.lastPoint);
        }
        ++this.pointsAdded;
        ++this.pointsNotProjected;
    }

    public void setShapeType(int n) {
        if (this.shapeType == n) {
            return;
        }
        this.shapeType = n;
        switch (this.shapeType) {
            default: {
                this.style.displayObject = null;
                break;
            }
            case 1: {
                this.style.displayObject = new Ellipse2D.Float();
                break;
            }
            case 2: 
            case 14: 
            case 15: {
                this.style.displayObject = new Rectangle2D.Float();
                break;
            }
            case 3: {
                this.style.displayObject = new RoundRectangle2D.Float();
            }
        }
        this.hasChanged = true;
    }

    public void setShapeSize(int n) {
        if (this.shapeSize != n) {
            this.shapeSize = n;
            this.hasChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] getData2D() {
        double[][] dArrayArray;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            int n = this.list.size();
            double[][] dArrayArray2 = dArrayArray = this.flushPoint == this.nullPoint ? new double[n][] : new double[n + 1][];
            if (this.showZ) {
                int n2 = 0;
                while (n2 < n) {
                    dArrayArray[n2] = (double[])this.list.get((int)n2).coordinates.clone();
                    ++n2;
                }
                if (this.flushPoint != this.nullPoint) {
                    dArrayArray[n] = (double[])this.flushPoint.coordinates.clone();
                }
            } else {
                int n3 = 0;
                while (n3 < n) {
                    OnePoint onePoint = this.list.get(n3);
                    dArrayArray[n3] = new double[]{onePoint.coordinates[0], onePoint.coordinates[1]};
                    ++n3;
                }
                if (this.flushPoint != this.nullPoint) {
                    dArrayArray[n] = new double[]{this.flushPoint.coordinates[0], this.flushPoint.coordinates[1]};
                }
            }
        }
        return dArrayArray;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        String[] stringArray;
        if (this.showZ) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = this.xLabel;
            stringArray2[1] = this.yLabel;
            stringArray = stringArray2;
            stringArray2[2] = this.zLabel;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = this.xLabel;
            stringArray = stringArray3;
            stringArray3[1] = this.yLabel;
        }
        return stringArray;
    }

    @Override
    public Color getLineColor() {
        return this.getStyle().getEdgeColor();
    }

    @Override
    public Color getFillColor() {
        Color color = new Color(125, 125, 125);
        if (this.getStyle().getFillPattern() instanceof Color) {
            color = (Color)this.getStyle().getFillPattern();
        }
        return color;
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        Dataset dataset = new Dataset();
        dataset.setName(this.getName());
        dataset.setConnected(true);
        dataset.setLineColor(this.getLineColor());
        int n = 2;
        switch (this.shapeType) {
            default: {
                n = 6;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 14: {
                n = 7;
                break;
            }
            case 15: {
                n = 8;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 2;
            }
        }
        dataset.setMarkerShape(n);
        dataset.setMarkerColor(this.getFillColor(), this.getLineColor());
        double[][] dArray = this.getData2D();
        int n2 = 0;
        int n3 = dArray.length;
        while (n2 < n3) {
            dataset.append(dArray[n2][0], dArray[n2][1]);
            ++n2;
        }
        ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
        arrayList.add(dataset);
        return arrayList;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.visible) {
            return null;
        }
        if (drawingPanel instanceof DrawingPanel3D) {
            if (this.hasChanged || drawingPanel != this.panelWithValidProjection) {
                this.projectPoints(drawingPanel, true);
            } else if (this.pointsNotProjected > 0) {
                this.projectPoints(drawingPanel, false);
            }
        } else {
            this.projectPoints(drawingPanel, true);
        }
        if (this.positionEnabled && Math.abs(this.lastPoint.pixel[0] - (double)n) < (double)SENSIBILITY && Math.abs(this.lastPoint.pixel[1] - (double)n2) < (double)SENSIBILITY) {
            return new InteractionTargetTracePoint(this, new Point3D(this.lastPoint.coordinates[0], this.lastPoint.coordinates[1], this.lastPoint.coordinates[2]));
        }
        if (this.allowTable) {
            for (OnePoint onePoint : this.displayList) {
                if (!(Math.abs(onePoint.pixel[0] - (double)n) < (double)SENSIBILITY) || !(Math.abs(onePoint.pixel[1] - (double)n2) < (double)SENSIBILITY)) continue;
                return this;
            }
        }
        return null;
    }

    @Override
    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (this.list.size() <= 0 || !this.visible) {
            return null;
        }
        if (this.hasChanged || drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D, true);
        } else if (this.pointsNotProjected > 0) {
            this.projectPoints(drawingPanel3D, false);
        }
        return this.displayList.toArray(this.minimalObjects);
    }

    @Override
    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        try {
            Object object;
            OnePoint onePoint = this.displayList.get(n);
            Color color = drawingPanel3D.projectColor(onePoint.pointStyle.edgeColor, onePoint.distance);
            if (onePoint.isConnected) {
                graphics2D.setColor(color);
                graphics2D.setStroke(onePoint.pointStyle.edgeStroke);
                object = this.displayList.get(n - 1);
                graphics2D.drawLine((int)onePoint.pixel[0], (int)onePoint.pixel[1], (int)((OnePoint)object).pixel[0], (int)((OnePoint)object).pixel[1]);
            }
            if (onePoint.pointStyle.displayObject != null) {
                object = onePoint.pointStyle.fillPattern;
                if (object instanceof Color) {
                    object = drawingPanel3D.projectColor((Color)object, onePoint.distance);
                }
                this.drawMarker(graphics2D, onePoint, color, (Paint)object);
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.list.size() <= 0 || !this.visible) {
            return;
        }
        this.projectPoints(drawingPanel, true);
        int n = 0;
        int n2 = 0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        for (OnePoint onePoint : this.displayList) {
            if (onePoint.pointStyle.edgeColor != null) {
                graphics2D.setColor(onePoint.pointStyle.edgeColor);
                graphics2D.setStroke(onePoint.pointStyle.edgeStroke);
                if (onePoint.isConnected) {
                    graphics2D.drawLine((int)onePoint.pixel[0], (int)onePoint.pixel[1], n, n2);
                }
                if (onePoint.pointStyle.displayObject != null) {
                    this.drawMarker(graphics2D, onePoint, onePoint.pointStyle.edgeColor, onePoint.pointStyle.fillPattern);
                }
            }
            n = (int)onePoint.pixel[0];
            n2 = (int)onePoint.pixel[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void projectPoints(DrawingPanel drawingPanel, boolean bl) {
        Iterator<ArrayList<OnePoint>> iterator;
        this.displayList = new ArrayList();
        if (this.memorySets != 1) {
            switch (this.drivenBy) {
                default: {
                    iterator = this.memoryLists.iterator();
                    while (iterator.hasNext()) {
                        this.displayList.addAll((Collection<OnePoint>)iterator.next());
                    }
                    break;
                }
                case 1: {
                    int n;
                    int n2;
                    for (ArrayList<OnePoint> arrayList : this.memoryLists) {
                        n2 = 0;
                        n = Math.min(this.pointsAdded, arrayList.size());
                        while (n2 < n) {
                            this.displayList.add(arrayList.get(n2));
                            ++n2;
                        }
                    }
                    break;
                }
                case 2: {
                    OnePoint onePoint;
                    int n;
                    int n2;
                    block12: for (ArrayList<OnePoint> arrayList : this.memoryLists) {
                        n2 = 0;
                        n = arrayList.size();
                        while (n2 < n) {
                            onePoint = arrayList.get(n2);
                            if (!(onePoint.coordinates[0] <= this.lastPoint.coordinates[0])) continue block12;
                            this.displayList.add(onePoint);
                            ++n2;
                        }
                    }
                    break;
                }
                case 3: {
                    OnePoint onePoint;
                    int n;
                    int n2;
                    block14: for (ArrayList<OnePoint> arrayList : this.memoryLists) {
                        n2 = 0;
                        n = arrayList.size();
                        while (n2 < n) {
                            onePoint = arrayList.get(n2);
                            if (!(onePoint.coordinates[1] <= this.lastPoint.coordinates[1])) continue block14;
                            this.displayList.add(onePoint);
                            ++n2;
                        }
                    }
                    break;
                }
                case 4: {
                    OnePoint onePoint;
                    int n;
                    int n2;
                    block16: for (ArrayList<OnePoint> arrayList : this.memoryLists) {
                        n2 = 0;
                        n = arrayList.size();
                        while (n2 < n) {
                            onePoint = arrayList.get(n2);
                            if (!(onePoint.coordinates[2] <= this.lastPoint.coordinates[2])) continue block16;
                            this.displayList.add(onePoint);
                            ++n2;
                        }
                    }
                }
            }
        }
        iterator = this.list;
        synchronized (iterator) {
            this.displayList.addAll((ArrayList)this.list.clone());
        }
        if (this.flushPoint != this.nullPoint) {
            this.displayList.add(this.flushPoint);
        }
        int n = 0;
        int n3 = this.displayList.size();
        while (n < n3) {
            this.displayList.get(n).project(drawingPanel, n, bl);
            ++n;
        }
        this.hasChanged = false;
        this.panelWithValidProjection = drawingPanel;
        this.pointsNotProjected = 0;
    }

    private void drawMarker(Graphics2D graphics2D, OnePoint onePoint, Color color, Paint paint) {
        if (!(onePoint.pointStyle.displayObject instanceof RectangularShape)) {
            graphics2D.setColor(color);
            graphics2D.drawOval((int)onePoint.pixel[0], (int)onePoint.pixel[1], 1, 1);
            return;
        }
        RectangularShape rectangularShape = (RectangularShape)onePoint.pointStyle.displayObject;
        AffineTransform affineTransform = graphics2D.getTransform();
        this.transform.setTransform(affineTransform);
        this.transform.rotate(-onePoint.pointStyle.angle, onePoint.pixel[0], onePoint.pixel[1]);
        graphics2D.setTransform(this.transform);
        if (this.shapeType == 14) {
            if (onePoint.b1 < onePoint.zeroB) {
                rectangularShape.setFrame(onePoint.a1, onePoint.b1, this.shapeSize, onePoint.zeroB - onePoint.b1);
            } else {
                rectangularShape.setFrame(onePoint.a1, onePoint.zeroB, this.shapeSize, onePoint.b1 - onePoint.zeroB);
            }
        } else {
            rectangularShape.setFrame(onePoint.a1, onePoint.b1, this.shapeSize, this.shapeSize);
        }
        if (this.shapeType == 15) {
            graphics2D.setColor(color);
            graphics2D.drawLine(onePoint.zeroA, onePoint.b1, onePoint.zeroA, onePoint.zeroB);
        }
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(rectangularShape);
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(onePoint.pointStyle.edgeStroke);
        graphics2D.draw(rectangularShape);
        graphics2D.setTransform(affineTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getXMinLogscale() {
        double d;
        double d2 = Double.MAX_VALUE;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            for (OnePoint object : this.list) {
                double d3 = object.coordinates[0];
                if (!(d3 > 0.0)) continue;
                d2 = Math.min(d2, d3);
            }
        }
        if (this.flushPoint != this.nullPoint && (d = this.flushPoint.coordinates[0]) > 0.0) {
            d2 = Math.min(d2, d);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> arrayList2 : this.memoryLists) {
                for (Object object : arrayList2) {
                    double d4 = ((OnePoint)object).coordinates[0];
                    if (!(d4 > 0.0)) continue;
                    d2 = Math.min(d2, d4);
                }
            }
        }
        if (this.group == null) {
            return this.x + d2 * this.sizex;
        }
        return this.group.x + (this.x + d2 * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getXMaxLogscale() {
        double d;
        double d2 = -1.7976931348623157E308;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            for (OnePoint object : this.list) {
                double d3 = object.coordinates[0];
                if (!(d3 > 0.0)) continue;
                d2 = Math.max(d2, d3);
            }
        }
        if (this.flushPoint != this.nullPoint && (d = this.flushPoint.coordinates[0]) > 0.0) {
            d2 = Math.max(d2, d);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> arrayList2 : this.memoryLists) {
                for (Object object : arrayList2) {
                    double d4 = ((OnePoint)object).coordinates[0];
                    if (!(d4 > 0.0)) continue;
                    d2 = Math.max(d2, d4);
                }
            }
        }
        if (this.group == null) {
            return this.x + d2 * this.sizex;
        }
        return this.group.x + (this.x + d2 * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getYMinLogscale() {
        double d;
        double d2 = Double.MAX_VALUE;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            for (OnePoint object : this.list) {
                double d3 = object.coordinates[1];
                if (!(d3 > 0.0)) continue;
                d2 = Math.min(d2, d3);
            }
        }
        if (this.flushPoint != this.nullPoint && (d = this.flushPoint.coordinates[1]) > 0.0) {
            d2 = Math.min(d2, d);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> arrayList2 : this.memoryLists) {
                for (Object object : arrayList2) {
                    double d4 = ((OnePoint)object).coordinates[1];
                    if (!(d4 > 0.0)) continue;
                    d2 = Math.min(d2, d4);
                }
            }
        }
        if (this.group == null) {
            return this.y + d2 * this.sizey;
        }
        return this.group.y + (this.y + d2 * this.sizey) * this.group.sizey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getYMaxLogscale() {
        double d;
        double d2 = -1.7976931348623157E308;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            for (OnePoint object : this.list) {
                double d3 = object.coordinates[1];
                if (!(d3 > 0.0)) continue;
                d2 = Math.max(d2, d3);
            }
        }
        if (this.flushPoint != this.nullPoint && (d = this.flushPoint.coordinates[1]) > 0.0) {
            d2 = Math.max(d2, d);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> arrayList2 : this.memoryLists) {
                for (Object object : arrayList2) {
                    double d4 = ((OnePoint)object).coordinates[1];
                    if (!(d4 > 0.0)) continue;
                    d2 = Math.max(d2, d4);
                }
            }
        }
        if (this.group == null) {
            return this.y + d2 * this.sizey;
        }
        return this.group.y + (this.y + d2 * this.sizey) * this.group.sizey;
    }

    @Override
    public boolean isMeasured() {
        return this.canBeMeasured && this.visible && this.list.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getXMin() {
        double d = Double.MAX_VALUE;
        ArrayList<OnePoint> arrayList2 = this.list;
        synchronized (arrayList2) {
            for (OnePoint onePoint : this.list) {
                d = Math.min(d, onePoint.coordinates[0]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            d = Math.min(d, this.flushPoint.coordinates[0]);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> arrayList : this.memoryLists) {
                for (Object object : arrayList) {
                    d = Math.min(d, ((OnePoint)object).coordinates[0]);
                }
            }
        }
        if (this.group == null) {
            return this.x + d * this.sizex;
        }
        return this.group.x + (this.x + d * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getXMax() {
        double d = -1.7976931348623157E308;
        ArrayList<OnePoint> arrayList2 = this.list;
        synchronized (arrayList2) {
            for (OnePoint onePoint : this.list) {
                d = Math.max(d, onePoint.coordinates[0]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            d = Math.max(d, this.flushPoint.coordinates[0]);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> arrayList : this.memoryLists) {
                for (Object object : arrayList) {
                    d = Math.max(d, ((OnePoint)object).coordinates[0]);
                }
            }
        }
        if (this.group == null) {
            return this.x + d * this.sizex;
        }
        return this.group.x + (this.x + d * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getYMin() {
        double d = Double.MAX_VALUE;
        ArrayList<OnePoint> arrayList2 = this.list;
        synchronized (arrayList2) {
            for (OnePoint onePoint : this.list) {
                d = Math.min(d, onePoint.coordinates[1]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            d = Math.min(d, this.flushPoint.coordinates[1]);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> arrayList : this.memoryLists) {
                for (Object object : arrayList) {
                    d = Math.min(d, ((OnePoint)object).coordinates[1]);
                }
            }
        }
        if (this.group == null) {
            return this.y + d * this.sizey;
        }
        return this.group.y + (this.y + d * this.sizey) * this.group.sizey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getYMax() {
        double d = -1.7976931348623157E308;
        ArrayList<OnePoint> arrayList2 = this.list;
        synchronized (arrayList2) {
            for (OnePoint onePoint : this.list) {
                d = Math.max(d, onePoint.coordinates[1]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            d = Math.max(d, this.flushPoint.coordinates[1]);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> arrayList : this.memoryLists) {
                for (Object object : arrayList) {
                    d = Math.max(d, ((OnePoint)object).coordinates[1]);
                }
            }
        }
        if (this.group == null) {
            return this.y + d * this.sizey;
        }
        return this.group.y + (this.y + d * this.sizey) * this.group.sizey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getZMin() {
        double d = Double.MAX_VALUE;
        ArrayList<OnePoint> arrayList2 = this.list;
        synchronized (arrayList2) {
            for (OnePoint onePoint : this.list) {
                d = Math.min(d, onePoint.coordinates[2]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            d = Math.min(d, this.flushPoint.coordinates[2]);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> arrayList : this.memoryLists) {
                for (Object object : arrayList) {
                    d = Math.min(d, ((OnePoint)object).coordinates[2]);
                }
            }
        }
        if (this.group == null) {
            return this.z + d * this.sizez;
        }
        return this.group.z + (this.z + d * this.sizez) * this.group.sizez;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getZMax() {
        double d = -1.7976931348623157E308;
        ArrayList<OnePoint> arrayList2 = this.list;
        synchronized (arrayList2) {
            for (OnePoint onePoint : this.list) {
                d = Math.max(d, onePoint.coordinates[2]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            d = Math.max(d, this.flushPoint.coordinates[2]);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> arrayList : this.memoryLists) {
                for (Object object : arrayList) {
                    d = Math.max(d, ((OnePoint)object).coordinates[2]);
                }
            }
        }
        if (this.group == null) {
            return this.z + d * this.sizez;
        }
        return this.group.z + (this.z + d * this.sizez) * this.group.sizez;
    }

    private class OnePoint
    extends Object3D {
        boolean isConnected;
        boolean alreadyProjected;
        double[] coordinates;
        double[] pixel;
        int a1;
        int b1;
        int zeroA;
        int zeroB;
        int pointShapeType;
        Style pointStyle;

        OnePoint(Drawable3D drawable3D, double d, double d2, double d3, boolean bl, int n, Style style) {
            super(drawable3D, -1);
            this.coordinates = new double[3];
            this.pixel = new double[3];
            this.zeroA = 0;
            this.zeroB = 0;
            this.pointStyle = null;
            this.coordinates[0] = d;
            this.coordinates[1] = d2;
            this.coordinates[2] = d3;
            this.isConnected = bl;
            this.pointShapeType = n;
            if (style != null) {
                this.pointStyle = new Style(style);
            }
            this.alreadyProjected = false;
        }

        protected void project(DrawingPanel drawingPanel, int n, boolean bl) {
            this.index = n;
            if (!bl && this.alreadyProjected) {
                return;
            }
            if (this.pointShapeType == 14 || this.pointShapeType == 15) {
                if (InteractiveTrace.this.group == null) {
                    ((InteractiveTrace)InteractiveTrace.this).point[0] = InteractiveTrace.this.x + this.coordinates[0] * InteractiveTrace.this.sizex;
                    ((InteractiveTrace)InteractiveTrace.this).point[1] = 0.0;
                    ((InteractiveTrace)InteractiveTrace.this).point[2] = 0.0;
                } else {
                    ((InteractiveTrace)InteractiveTrace.this).point[0] = InteractiveTrace.this.group.x + (InteractiveTrace.this.x + this.coordinates[0] * InteractiveTrace.this.sizex) * InteractiveTrace.this.group.sizex;
                    ((InteractiveTrace)InteractiveTrace.this).point[1] = 0.0;
                    ((InteractiveTrace)InteractiveTrace.this).point[2] = 0.0;
                }
                drawingPanel.project(InteractiveTrace.this.point, this.pixel);
                this.zeroA = (int)this.pixel[0];
                this.zeroB = (int)this.pixel[1];
            }
            if (InteractiveTrace.this.group == null) {
                ((InteractiveTrace)InteractiveTrace.this).point[0] = InteractiveTrace.this.x + this.coordinates[0] * InteractiveTrace.this.sizex;
                ((InteractiveTrace)InteractiveTrace.this).point[1] = InteractiveTrace.this.y + this.coordinates[1] * InteractiveTrace.this.sizey;
                ((InteractiveTrace)InteractiveTrace.this).point[2] = InteractiveTrace.this.z + this.coordinates[2] * InteractiveTrace.this.sizez;
            } else {
                ((InteractiveTrace)InteractiveTrace.this).point[0] = InteractiveTrace.this.group.x + (InteractiveTrace.this.x + this.coordinates[0] * InteractiveTrace.this.sizex) * InteractiveTrace.this.group.sizex;
                ((InteractiveTrace)InteractiveTrace.this).point[1] = InteractiveTrace.this.group.y + (InteractiveTrace.this.y + this.coordinates[1] * InteractiveTrace.this.sizey) * InteractiveTrace.this.group.sizey;
                ((InteractiveTrace)InteractiveTrace.this).point[2] = InteractiveTrace.this.group.z + (InteractiveTrace.this.z + this.coordinates[2] * InteractiveTrace.this.sizez) * InteractiveTrace.this.group.sizez;
            }
            drawingPanel.project(InteractiveTrace.this.point, this.pixel);
            this.alreadyProjected = true;
            this.distance = this.pixel[2];
            if (this.pointStyle.displayObject instanceof RectangularShape) {
                double d;
                double d2;
                switch (this.pointStyle.position) {
                    default: {
                        d2 = (double)InteractiveTrace.this.shapeSize / 2.0;
                        d = (double)InteractiveTrace.this.shapeSize / 2.0;
                        break;
                    }
                    case 1: {
                        d2 = (double)InteractiveTrace.this.shapeSize / 2.0;
                        d = 0.0;
                        break;
                    }
                    case 2: {
                        d2 = (double)InteractiveTrace.this.shapeSize / 2.0;
                        d = InteractiveTrace.this.shapeSize;
                        break;
                    }
                    case 3: {
                        d2 = InteractiveTrace.this.shapeSize;
                        d = (double)InteractiveTrace.this.shapeSize / 2.0;
                        break;
                    }
                    case 7: {
                        d2 = InteractiveTrace.this.shapeSize;
                        d = InteractiveTrace.this.shapeSize;
                        break;
                    }
                    case 5: {
                        d2 = InteractiveTrace.this.shapeSize;
                        d = 0.0;
                        break;
                    }
                    case 4: {
                        d2 = 0.0;
                        d = (double)InteractiveTrace.this.shapeSize / 2.0;
                        break;
                    }
                    case 8: {
                        d2 = 0.0;
                        d = InteractiveTrace.this.shapeSize;
                        break;
                    }
                    case 6: {
                        d2 = 0.0;
                        d = 0.0;
                    }
                }
                if (this.pointShapeType == 14) {
                    this.a1 = (int)(this.pixel[0] - d2);
                    this.b1 = (int)this.pixel[1];
                } else {
                    this.a1 = (int)(this.pixel[0] - d2);
                    this.b1 = (int)(this.pixel[1] - d);
                }
            }
        }
    }
}

