/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.model_elements.input_output;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.util.StringTokenizer;
import org.colos.ejs.library.Model;
import org.colos.ejs.model_elements.Utilities;

public class WebServerReader {
    private Model model;
    private String serverAddress;

    public WebServerReader(Model model, String string) {
        this.model = model;
        this.setServerAddress(string);
    }

    public void setServerAddress(String string) {
        this.serverAddress = string;
    }

    public String getServerAddress() {
        return Utilities.getValue((Model)this.model, (String)this.serverAddress);
    }

    public String readOutput(String string) {
        Object object;
        if (this.serverAddress != null) {
            object = this.getServerAddress();
            string = ((String)object).endsWith("/") || string.startsWith("/") ? String.valueOf(object) + string : String.valueOf(object) + "/" + string;
        }
        string = WebServerReader.correctUrlString(string);
        try {
            object = new URL(string);
            InputStreamReader inputStreamReader = new InputStreamReader(((URL)object).openStream());
            LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = lineNumberReader.readLine();
            while (string2 != null) {
                stringBuffer.append(String.valueOf(string2) + "\n");
                string2 = lineNumberReader.readLine();
            }
            ((Reader)inputStreamReader).close();
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.err.println("Error reading command <" + string + ">");
            exception.printStackTrace();
            return null;
        }
    }

    public static String correctUrlString(String string) {
        String string2;
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", true);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            string3 = string2.equals(" ") ? String.valueOf(string3) + "%20" : String.valueOf(string3) + string2;
        }
        string2 = "";
        stringTokenizer = new StringTokenizer(string3, "&", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            string2 = string4.equals("&") ? String.valueOf(string2) + "%26" : String.valueOf(string2) + string4;
        }
        return string2;
    }
}

