/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.tools.ExportFormat;
import org.opensourcephysics.tools.ToolsRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportGnuplotFormat
implements ExportFormat {
    @Override
    public String description() {
        return "Text";
    }

    @Override
    public String extension() {
        return "txt";
    }

    void exportDataset(PrintWriter printWriter, Dataset dataset, int n) throws IOException {
        double[] dArray = dataset.getXPoints();
        double[] dArray2 = dataset.getYPoints();
        printWriter.print("\n# name: data" + n + "\n" + "# type: matrix\n" + "# rows: " + dArray.length + "\n" + "# columns: " + 2 + "\n");
        int n2 = 0;
        while (n2 < dArray.length) {
            printWriter.println(String.valueOf(dArray[n2]) + " " + dArray2[n2]);
            ++n2;
        }
    }

    void exportGridData(PrintWriter printWriter, GridData gridData, int n) throws IOException {
        int n2 = gridData.getNx();
        int n3 = gridData.getNy();
        double d = gridData.getLeft();
        double d2 = gridData.getDx();
        printWriter.println("\n# name: col_range" + n + "\n" + "# type: matrix\n" + "# rows: 1\n" + "# columns: " + n2);
        int n4 = 0;
        while (n4 < n2) {
            printWriter.print(String.valueOf(d + (double)n4 * d2) + " ");
            ++n4;
        }
        printWriter.println("\n");
        double d3 = gridData.getTop();
        double d4 = gridData.getDy();
        printWriter.println("# name: row_range" + n + "\n" + "# type: matrix\n" + "# rows: 1\n" + "# columns: " + n3);
        int n5 = 0;
        while (n5 < n3) {
            printWriter.print(String.valueOf(d3 + (double)n5 * d4) + " ");
            ++n5;
        }
        printWriter.println("\n");
        n5 = gridData.getComponentCount();
        int n6 = 0;
        while (n6 < n5) {
            String string = gridData.getComponentName(n6);
            printWriter.println("# name: grid_" + n + '_' + string + '\n' + "# type: matrix\n" + "# rows: " + n3 + '\n' + "# columns: " + n2);
            int n7 = 0;
            while (n7 < n3) {
                int n8 = 0;
                while (n8 < n2) {
                    printWriter.print(String.valueOf(gridData.getValue(n8, n7, n6)) + " ");
                    ++n8;
                }
                printWriter.println();
                ++n7;
            }
            ++n6;
        }
    }

    @Override
    public void export(File file, List<Object> list) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println("# Created by the Open Source Physics library");
            Iterator<Object> iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof Dataset) {
                    this.exportDataset(printWriter, (Dataset)object, n);
                } else if (object instanceof GridData) {
                    this.exportGridData(printWriter, (GridData)object, n);
                }
                ++n;
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, ToolsRes.getString("ExportFormat.Dialog.WriteError.Message"), ToolsRes.getString("ExportFormat.Dialog.WriteError.Title"), 0);
        }
    }
}

