/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementEllipsoid;
import org.opensourcephysics.display3d.simple3d.AbstractTile;
import org.opensourcephysics.display3d.simple3d.Resolution;
import org.opensourcephysics.display3d.simple3d.utils.EllipsoidUtils;

public class ElementEllipsoid
extends AbstractTile
implements org.opensourcephysics.display3d.core.ElementEllipsoid {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean closedLeft = true;
    private boolean closedRight = true;
    private int minAngleU = 0;
    private int maxAngleU = 360;
    private int minAngleV = -90;
    private int maxAngleV = 90;
    private boolean changeNTiles = true;
    private int nr = -1;
    private int nu = -1;
    private int nv = -1;
    private double[][][] standardSphere = null;
    protected static final double TO_RADIANS = Math.PI / 180;

    public ElementEllipsoid() {
        this.getStyle().setResolution(new Resolution(3, 12, 12));
    }

    public void setClosedBottom(boolean bl) {
        this.closedBottom = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean bl) {
        this.closedTop = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean bl) {
        this.closedLeft = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean bl) {
        this.closedRight = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setMinimumAngleU(int n) {
        this.minAngleU = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMinimumAngleU() {
        return this.minAngleU;
    }

    public void setMaximumAngleU(int n) {
        this.maxAngleU = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMaximumAngleU() {
        return this.maxAngleU;
    }

    public void setMinimumAngleV(int n) {
        this.minAngleV = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMinimumAngleV() {
        return this.minAngleV;
    }

    public void setMaximumAngleV(int n) {
        this.maxAngleV = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMaximumAngleV() {
        return this.maxAngleV;
    }

    protected synchronized void computeCorners() {
        org.opensourcephysics.display3d.core.Resolution resolution;
        double d;
        double d2;
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        double d3 = this.maxAngleU;
        double d4 = this.minAngleU;
        if (Math.abs(d3 - d4) > 360.0) {
            d3 = d4 + 360.0;
        }
        if (Math.abs((d2 = (double)this.maxAngleV) - (d = (double)this.minAngleV)) > 180.0) {
            d2 = d + 180.0;
        }
        if ((resolution = this.getRealStyle().getResolution()) != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    n3 = Math.max(resolution.getN3(), 1);
                    break;
                }
                case 1: {
                    double d5 = Math.max(Math.max(Math.abs(this.getSizeX()), Math.abs(this.getSizeY())), Math.abs(this.getSizeZ())) / 2.0;
                    n = Math.max((int)Math.round(0.49 + d5 / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(d3 - d4) * (Math.PI / 180) * d5 / resolution.getMaxLength()), 1);
                    n3 = Math.max((int)Math.round(0.49 + Math.abs(d2 - d) * (Math.PI / 180) * d5 / resolution.getMaxLength()), 1);
                }
            }
        }
        if (this.nr != n || this.nu != n2 || this.nv != n3 || this.changeNTiles) {
            this.nr = n;
            this.nu = n2;
            this.nv = n3;
            this.standardSphere = EllipsoidUtils.createStandardEllipsoid(this.nr, this.nu, this.nv, d4, d3, d, d2, this.closedTop, this.closedBottom, this.closedLeft, this.closedRight);
            this.setCorners(new double[this.standardSphere.length][4][3]);
            this.changeNTiles = false;
        }
        int n4 = 0;
        while (n4 < this.numberOfTiles) {
            int n5 = 0;
            int n6 = this.corners[n4].length;
            while (n5 < n6) {
                System.arraycopy(this.standardSphere[n4][n5], 0, this.corners[n4][n5], 0, 3);
                this.sizeAndToSpaceFrame(this.corners[n4][n5]);
                ++n5;
            }
            ++n4;
        }
        this.setElementChanged(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementEllipsoid.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementEllipsoid();
        }
    }
}

