/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementCircle;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;

public class ElementCircle
extends Element
implements org.opensourcephysics.display3d.core.ElementCircle {
    private double angle = 0.0;
    private double[] coordinates = new double[3];
    private double[] size = new double[3];
    private double[] pixel = new double[3];
    private double[] pixelSize = new double[2];
    private Object3D[] objects = new Object3D[]{new Object3D(this, 0)};
    private AffineTransform transform = new AffineTransform();
    private AffineTransform originalTransform = null;

    public ElementCircle() {
        this.setSizeXYZ(0.0, 0.0, 0.0);
    }

    public void setRotationAngle(double d) {
        this.angle = d;
    }

    public double getRotationAngle() {
        return this.angle;
    }

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        return this.objects;
    }

    void draw(Graphics2D graphics2D, int n) {
        Color color = this.getDrawingPanel3D().projectColor(this.getRealStyle().getLineColor(), this.objects[0].getDistance());
        Color color2 = this.getDrawingPanel3D().projectColor(this.getRealStyle().getFillColor(), this.objects[0].getDistance());
        this.drawIt(graphics2D, color, color2);
    }

    void drawQuickly(Graphics2D graphics2D) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        this.drawIt(graphics2D, this.getRealStyle().getLineColor(), null);
    }

    protected InteractionTarget getTargetHit(int n, int n2) {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        if (this.targetPosition.isEnabled() && Math.abs(this.pixel[0] - (double)n) < 5.0 && Math.abs(this.pixel[1] - (double)n2) < 5.0) {
            return this.targetPosition;
        }
        return null;
    }

    private void projectPoints() {
        this.coordinates[2] = 0.0;
        this.coordinates[1] = 0.0;
        this.coordinates[0] = 0.0;
        this.sizeAndToSpaceFrame(this.coordinates);
        this.getDrawingPanel3D().project(this.coordinates, this.pixel);
        this.objects[0].setDistance(this.pixel[2] * this.getStyle().getDepthFactor());
        this.size[0] = this.getSizeX();
        this.size[1] = this.getSizeY();
        this.size[2] = this.getSizeZ();
        this.getDrawingPanel3D().projectSize(this.coordinates, this.size, this.pixelSize);
        this.setElementChanged(false);
        this.setNeedToProject(false);
    }

    private void drawIt(Graphics2D graphics2D, Color color, Color color2) {
        int n = (int)(this.pixel[0] - this.pixelSize[0] / 2.0);
        int n2 = (int)(this.pixel[1] - this.pixelSize[1] / 2.0);
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        if (this.angle != 0.0) {
            this.originalTransform = graphics2D.getTransform();
            this.transform.setTransform(this.originalTransform);
            this.transform.rotate(-this.angle, this.pixel[0], this.pixel[1]);
            graphics2D.setTransform(this.transform);
        }
        if (this.getRealStyle().isDrawingFill() && color2 != null) {
            graphics2D.setPaint(color2);
            graphics2D.fillOval(n, n2, (int)this.pixelSize[0] + 1, (int)this.pixelSize[1] + 1);
        }
        if (this.getRealStyle().isDrawingLines() && color != null) {
            graphics2D.setColor(color);
            graphics2D.drawOval(n, n2, (int)this.pixelSize[0], (int)this.pixelSize[1]);
        }
        if (this.angle != 0.0) {
            graphics2D.setTransform(this.originalTransform);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementCircle.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementCircle();
        }
    }
}

