/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import java.awt.Color;
import java.awt.Font;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.display3d.jogl.Camera;
import org.opensourcephysics.display3d.jogl.DrawingPanel3D;
import org.opensourcephysics.display3d.jogl.Element;
import org.opensourcephysics.display3d.jogl.utils.GLTools;
import org.opensourcephysics.numerics.Vec3D;

public class ElementText
extends Element
implements org.opensourcephysics.display3d.core.ElementText {
    private String text;
    private Font font;
    private int justification;
    private double rotationAngle;

    public ElementText() {
        this.getStyle().setLineColor(Color.black);
        this.getStyle().setLineWidth(0.7f);
        this.getStyle().setDrawingLines(true);
        this.rotationAngle = 0.0;
        this.justification = 0;
    }

    public ElementText(String string) {
        this();
        this.setText(string);
    }

    void draw(GLAutoDrawable gLAutoDrawable) {
        Vec3D vec3D;
        if (!this.isVisible()) {
            return;
        }
        GL gL = gLAutoDrawable.getGL();
        float f = DrawingPanel3D.GLUT.glutStrokeLengthf(1, this.text);
        gL.glDisable(3552);
        gL.glDisable(2896);
        gL.glLineWidth(this.getStyle().getLineWidth());
        GLTools.setColor(gL, this.getStyle().getLineColor());
        gL.glPushMatrix();
        gL.glTranslated(this.getX(), this.getY(), this.getZ());
        Camera camera = (Camera)this.getDrawingPanel3D().getCamera();
        if (this.getSizeX() == 0.0 || this.getSizeY() == 0.0) {
            vec3D = camera.getPosition();
            vec3D.subtract(vec3D, new Vec3D(this.getX(), this.getY(), this.getZ()));
            double d = vec3D.magnitude();
            double d2 = 2.0E-4 * d;
            gL.glScaled(d2, d2, d2);
        } else {
            gL.glScaled(0.003 * this.getSizeX(), 0.003 * this.getSizeY(), 0.003 * this.getSizeZ());
        }
        vec3D = camera.getDirection();
        double[] dArray = new double[]{0.0, 0.0, 1.0};
        Vec3D vec3D2 = new Vec3D(dArray[0], dArray[1], dArray[2]);
        vec3D2.normalize();
        Vec3D vec3D3 = new Vec3D();
        vec3D3.cross(vec3D2, vec3D);
        vec3D.normalize();
        this.getRotation().setAxis(vec3D3);
        this.getRotation().angle = Math.toDegrees(Math.acos(vec3D2.dot(vec3D)));
        this.getRotation().glRotate(gL);
        gL.glRotated(57.29577951308232 * camera.getAzimuth() + 90.0, 0.0, 0.0, 1.0);
        gL.glRotated(180.0, 1.0, 0.0, 0.0);
        if (this.justification == 1) {
            gL.glTranslated((double)(-f), 0.0, 0.0);
        } else if (this.justification == 0) {
            gL.glTranslated((double)(-f) * 0.5, 0.0, 0.0);
        }
        DrawingPanel3D.GLUT.glutStrokeString(1, this.text);
        gL.glPopMatrix();
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setJustification(int n) {
        this.justification = n;
    }

    public int getJustification() {
        return this.justification;
    }

    public void setRotationAngle(double d) {
        this.rotationAngle = d;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public int getBlendPriority() {
        return 2;
    }
}

