/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.jogl.DrawingPanel3D;
import org.opensourcephysics.display3d.jogl.ElementSurface;
import org.opensourcephysics.display3d.jogl.utils.GLTools;

public class ElementCone
extends ElementSurface
implements org.opensourcephysics.display3d.core.ElementCone {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean closedLeft = true;
    private boolean closedRight = true;
    private int minAngle = 0;
    private int maxAngle = 360;
    private double truncationHeight = Double.NaN;
    private boolean changeNTiles = true;
    private int nr = -1;
    private int nu = -1;
    private int nz = -1;
    protected static final double TO_RADIANS = Math.PI / 180;
    protected static final double[] vectorx = new double[]{1.0, 0.0, 0.0};
    protected static final double[] vectory = new double[]{0.0, 1.0, 0.0};
    protected static final double[] vectorz = new double[]{0.0, 0.0, 1.0};

    public ElementCone() {
        this.getStyle().setResolution(new Resolution(3, 12, 5));
    }

    void draw(GLAutoDrawable gLAutoDrawable) {
        if (!this.isVisible()) {
            return;
        }
        if (this.minAngle != 0 || this.maxAngle != 360 || !Double.isNaN(this.truncationHeight)) {
            this.computeCorners();
            super.draw(gLAutoDrawable);
        } else {
            int n;
            int n2;
            double d;
            double d2;
            GL gL = gLAutoDrawable.getGL();
            gL.glPushMatrix();
            this.transform(gL);
            this.getRotation().glRotate(gL);
            gL.glTranslated(0.0, 0.0, -this.getSizeZ() / 2.0);
            gL.glScaled(1.0, this.getSizeY() / this.getSizeX(), 1.0);
            if (this.getStyle().getResolution().getType() == 1) {
                d2 = Math.abs(this.getSizeX()) / 2.0;
                d = Math.abs(this.getSizeY()) / 2.0;
                n2 = Math.max((int)Math.round(0.49 + Math.max(d2, d) / this.getStyle().getResolution().getMaxLength()), 1);
                n = Math.max((int)Math.round(0.49 + Math.PI * 2 * (d2 + d) / this.getStyle().getResolution().getMaxLength()), 1);
            } else {
                n = this.getStyle().getResolution().getN2();
                n2 = this.getStyle().getResolution().getN1();
            }
            n = Math.max(3, n);
            n2 = Math.max(1, n2);
            if (this.getStyle().isDrawingFill()) {
                GLTools.setColor(gL, this.getStyle().getFillColor());
                gL.glEnable(2896);
                gL.glMaterialfv(1032, 5634, this.getStyle().getFillColor().getRGBComponents(null), 0);
                if (this.closedBottom) {
                    gL.glDisable(2884);
                }
                this.preFillGL(gLAutoDrawable);
                d2 = -90.0;
                gL.glRotated(d2, 0.0, 0.0, 1.0);
                DrawingPanel3D.GLUT.glutSolidCone(this.getSizeX() / 2.0, this.getSizeZ(), n, n2);
                gL.glRotated(-d2, 0.0, 0.0, 1.0);
                if (this.closedBottom) {
                    gL.glBegin(9);
                    d = 360.0;
                    while (d >= 0.0) {
                        double d3 = d * Math.PI / 180.0;
                        gL.glVertex3d(Math.cos(d3) * this.getSizeX() * 0.5, Math.sin(d3) * this.getSizeX() * 0.5, 0.0);
                        d -= 360.0 / (double)n;
                    }
                    gL.glEnd();
                }
            }
            if (this.getStyle().isDrawingLines()) {
                GLTools.setColor(gL, this.getStyle().getLineColor());
                gL.glEnable(2896);
                gL.glMaterialfv(1032, 5634, this.getStyle().getLineColor().getRGBComponents(null), 0);
                gL.glLineWidth(this.getStyle().getLineWidth());
                this.preLinesGL(gLAutoDrawable);
                DrawingPanel3D.GLUT.glutWireCone(this.getSizeX() / 2.0, this.getSizeZ(), n, n2);
                if (this.closedBottom) {
                    gL.glBegin(2);
                    int n3 = 0;
                    while (n3 < 360) {
                        double d4 = (double)n3 * Math.PI / 180.0;
                        gL.glVertex3d(Math.cos(d4) * this.getSizeX() / 2.0, Math.sin(d4) * this.getSizeX() / 2.0, 0.0);
                        n3 += 360 / n;
                    }
                    gL.glEnd();
                }
            }
            gL.glPopMatrix();
            this.setElementChanged(false);
        }
    }

    public void setTruncationHeight(double d) {
        if (d < 0.0) {
            d = Double.NaN;
        }
        this.truncationHeight = d;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public double getTruncationHeight() {
        return this.truncationHeight;
    }

    public void setClosedBottom(boolean bl) {
        this.closedBottom = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean bl) {
        this.closedTop = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean bl) {
        this.closedLeft = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean bl) {
        this.closedRight = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setMinimumAngle(int n) {
        this.minAngle = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMinimumAngle() {
        return this.minAngle;
    }

    public void setMaximumAngle(int n) {
        this.maxAngle = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMaximumAngle() {
        return this.maxAngle;
    }

    protected synchronized void computeCorners() {
        double d;
        Resolution resolution;
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        double d2 = this.maxAngle;
        double d3 = this.minAngle;
        if (Math.abs(d2 - d3) > 360.0) {
            d2 = d3 + 360.0;
        }
        if ((resolution = this.getStyle().getResolution()) != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    n3 = Math.max(resolution.getN3(), 1);
                    break;
                }
                case 1: {
                    d = Math.abs(this.getSizeX()) / 2.0;
                    double d4 = Math.abs(this.getSizeY()) / 2.0;
                    double d5 = Math.abs(this.getSizeZ());
                    if (!Double.isNaN(this.truncationHeight)) {
                        d5 = Math.min(d5, this.truncationHeight);
                    }
                    n = Math.max((int)Math.round(0.49 + Math.max(d, d4) / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(d2 - d3) * (Math.PI / 180) * (d + d4) / resolution.getMaxLength()), 1);
                    n3 = Math.max((int)Math.round(0.49 + d5 / resolution.getMaxLength()), 1);
                }
            }
        }
        if (this.nr != n || this.nu != n2 || this.nz != n3 || this.changeNTiles) {
            this.nr = n;
            this.nu = n2;
            this.nz = n3;
            this.changeNTiles = false;
            d = this.truncationHeight / this.getSizeZ();
            if (!Double.isNaN(d)) {
                d = Math.min(d, 1.0);
            }
            this.setData(ElementCone.createStandardCone(this.nr, this.nu, this.nz, d3, d2, this.closedTop, this.closedBottom, this.closedLeft, this.closedRight, d));
        }
        this.setElementChanged(false);
    }

    private static double[][][] createStandardCone(int n, int n2, int n3, double d, double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d3) {
        int n4;
        int n5;
        int n6 = n2 * n3;
        if (bl2) {
            n6 += n * n2;
        }
        if (!Double.isNaN(d3) && bl) {
            n6 += n * n2;
        }
        if (Math.abs(d2 - d) < 360.0) {
            if (bl3) {
                n6 += n * n3;
            }
            if (bl4) {
                n6 += n * n3;
            }
        }
        double[][][] dArray = new double[n6][4][3];
        double[] dArray2 = new double[n2 + 1];
        double[] dArray3 = new double[n2 + 1];
        int n7 = 0;
        while (n7 <= n2) {
            double d4 = ((double)(n2 - n7) * d + (double)n7 * d2) * (Math.PI / 180) / (double)n2;
            dArray2[n7] = Math.cos(d4) / 2.0;
            dArray3[n7] = Math.sin(d4) / 2.0;
            ++n7;
        }
        n7 = 0;
        double[] dArray4 = new double[]{-vectorz[0] / 2.0, -vectorz[1] / 2.0, -vectorz[2] / 2.0};
        double d5 = Double.isNaN(d3) ? (double)n3 : (d3 == 0.0 ? 2.147483647E9 : (double)n3 / d3);
        double d6 = 1.0 / d5;
        int n8 = 0;
        while (n8 < n3) {
            int n9 = 0;
            while (n9 < n2) {
                n5 = 0;
                while (n5 < 3) {
                    dArray[n7][0][n5] = dArray4[n5] + (dArray2[n9] * vectorx[n5] + dArray3[n9] * vectory[n5]) * (d5 - (double)n8) / d5 + (double)n8 * d6 * vectorz[n5];
                    dArray[n7][1][n5] = dArray4[n5] + (dArray2[n9 + 1] * vectorx[n5] + dArray3[n9 + 1] * vectory[n5]) * (d5 - (double)n8) / d5 + (double)n8 * d6 * vectorz[n5];
                    dArray[n7][2][n5] = dArray4[n5] + (dArray2[n9 + 1] * vectorx[n5] + dArray3[n9 + 1] * vectory[n5]) * (d5 - (double)n8 - 1.0) / d5 + (double)(n8 + 1) * d6 * vectorz[n5];
                    dArray[n7][3][n5] = dArray4[n5] + (dArray2[n9] * vectorx[n5] + dArray3[n9] * vectory[n5]) * (d5 - (double)n8 - 1.0) / d5 + (double)(n8 + 1) * d6 * vectorz[n5];
                    ++n5;
                }
                ++n9;
                ++n7;
            }
            ++n8;
        }
        if (bl2) {
            int n10 = 0;
            while (n10 < n2) {
                n4 = 0;
                while (n4 < n) {
                    int n11 = 0;
                    while (n11 < 3) {
                        dArray[n7][0][n11] = ((double)(n - n4) * dArray4[n11] + (double)n4 * dArray[n10][0][n11]) / (double)n;
                        dArray[n7][1][n11] = ((double)(n - n4 - 1) * dArray4[n11] + (double)(n4 + 1) * dArray[n10][0][n11]) / (double)n;
                        dArray[n7][2][n11] = ((double)(n - n4 - 1) * dArray4[n11] + (double)(n4 + 1) * dArray[n10][1][n11]) / (double)n;
                        dArray[n7][3][n11] = ((double)(n - n4) * dArray4[n11] + (double)n4 * dArray[n10][1][n11]) / (double)n;
                        ++n11;
                    }
                    ++n4;
                    ++n7;
                }
                ++n10;
            }
        }
        if (!Double.isNaN(d3) && bl) {
            int n12 = n2 * (n3 - 1);
            dArray4[0] = vectorz[0];
            dArray4[1] = vectorz[1];
            dArray4[2] = Double.isNaN(d3) ? vectorz[2] - 0.5 : d3 * vectorz[2] - 0.5;
            n4 = 0;
            while (n4 < n2) {
                int n13 = 0;
                while (n13 < n) {
                    int n14 = 0;
                    while (n14 < 3) {
                        dArray[n7][0][n14] = ((double)(n - n13) * dArray4[n14] + (double)n13 * dArray[n12 + n4][3][n14]) / (double)n;
                        dArray[n7][1][n14] = ((double)(n - n13 - 1) * dArray4[n14] + (double)(n13 + 1) * dArray[n12 + n4][3][n14]) / (double)n;
                        dArray[n7][2][n14] = ((double)(n - n13 - 1) * dArray4[n14] + (double)(n13 + 1) * dArray[n12 + n4][2][n14]) / (double)n;
                        dArray[n7][3][n14] = ((double)(n - n13) * dArray4[n14] + (double)n13 * dArray[n12 + n4][2][n14]) / (double)n;
                        ++n14;
                    }
                    ++n13;
                    ++n7;
                }
                ++n4;
            }
        }
        if (Math.abs(d2 - d) < 360.0) {
            int n15;
            int n16;
            dArray4[0] = -vectorz[0] / 2.0;
            dArray4[1] = -vectorz[1] / 2.0;
            dArray4[2] = -vectorz[2] / 2.0;
            if (bl4) {
                int n17 = 0;
                double[] dArray5 = new double[3];
                double d7 = Double.isNaN(d3) ? (double)n3 : (d3 == 0.0 ? 2.147483647E9 : (double)n3 / d3);
                double d8 = 1.0 / d7;
                n5 = 0;
                while (n5 < n3) {
                    dArray4[0] = (double)n5 * d8 * vectorz[0];
                    dArray4[1] = (double)n5 * d8 * vectorz[1];
                    dArray4[2] = (double)n5 * d8 * vectorz[2] - 0.5;
                    dArray5[0] = (double)(n5 + 1) * d8 * vectorz[0];
                    dArray5[1] = (double)(n5 + 1) * d8 * vectorz[1];
                    dArray5[2] = (double)(n5 + 1) * d8 * vectorz[2] - 0.5;
                    n16 = 0;
                    while (n16 < n) {
                        n15 = 0;
                        while (n15 < 3) {
                            dArray[n7][0][n15] = ((double)(n - n16) * dArray4[n15] + (double)n16 * dArray[n17][0][n15]) / (double)n;
                            dArray[n7][1][n15] = ((double)(n - n16 - 1) * dArray4[n15] + (double)(n16 + 1) * dArray[n17][0][n15]) / (double)n;
                            dArray[n7][2][n15] = ((double)(n - n16 - 1) * dArray5[n15] + (double)(n16 + 1) * dArray[n17][3][n15]) / (double)n;
                            dArray[n7][3][n15] = ((double)(n - n16) * dArray5[n15] + (double)n16 * dArray[n17][3][n15]) / (double)n;
                            ++n15;
                        }
                        ++n16;
                        ++n7;
                    }
                    ++n5;
                    n17 += n2;
                }
            }
            if (bl3) {
                int n18 = n2 - 1;
                double[] dArray6 = new double[3];
                double d9 = Double.isNaN(d3) ? (double)n3 : (d3 == 0.0 ? 2.147483647E9 : (double)n3 / d3);
                double d10 = 1.0 / d9;
                n5 = 0;
                while (n5 < n3) {
                    dArray4[0] = (double)n5 * d10 * vectorz[0];
                    dArray4[1] = (double)n5 * d10 * vectorz[1];
                    dArray4[2] = (double)n5 * d10 * vectorz[2] - 0.5;
                    dArray6[0] = (double)(n5 + 1) * d10 * vectorz[0];
                    dArray6[1] = (double)(n5 + 1) * d10 * vectorz[1];
                    dArray6[2] = (double)(n5 + 1) * d10 * vectorz[2] - 0.5;
                    n16 = 0;
                    while (n16 < n) {
                        n15 = 0;
                        while (n15 < 3) {
                            dArray[n7][0][n15] = ((double)(n - n16) * dArray4[n15] + (double)n16 * dArray[n18][1][n15]) / (double)n;
                            dArray[n7][1][n15] = ((double)(n - n16 - 1) * dArray4[n15] + (double)(n16 + 1) * dArray[n18][1][n15]) / (double)n;
                            dArray[n7][2][n15] = ((double)(n - n16 - 1) * dArray6[n15] + (double)(n16 + 1) * dArray[n18][2][n15]) / (double)n;
                            dArray[n7][3][n15] = ((double)(n - n16) * dArray6[n15] + (double)n16 * dArray[n18][2][n15]) / (double)n;
                            ++n15;
                        }
                        ++n16;
                        ++n7;
                    }
                    ++n5;
                    n18 += n2;
                }
            }
        }
        return dArray;
    }

    public int getBlendPriority() {
        if (this.getStyle().isDrawingFill()) {
            if (this.getStyle().getFillColor().getAlpha() < 255) {
                return 1;
            }
            return 0;
        }
        return 1;
    }
}

