/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.interaction.InteractionEvent;
import org.opensourcephysics.display3d.core.interaction.InteractionListener;
import org.opensourcephysics.display3d.java3d.Branch;
import org.opensourcephysics.display3d.java3d.DrawingPanel3D;
import org.opensourcephysics.display3d.java3d.Group;
import org.opensourcephysics.display3d.java3d.InteractionTarget;
import org.opensourcephysics.display3d.java3d.Style;
import org.opensourcephysics.numerics.Matrix3DTransformation;
import org.opensourcephysics.numerics.Quaternion;
import org.opensourcephysics.numerics.Transformation;

public abstract class Element
extends Behavior
implements org.opensourcephysics.display3d.core.Element {
    private String name;
    private boolean visible = true;
    private Group group;
    protected org.opensourcephysics.display3d.core.Style style = new Style(this);
    private Transformation transformation;
    private DrawingPanel3D panel;
    private ArrayList<InteractionListener> listeners = new ArrayList();
    protected final InteractionTarget targetPosition = new InteractionTarget(this, 0);
    protected final InteractionTarget targetSize = new InteractionTarget(this, 1);
    private int elementChanged;
    public static final int CHANGE_NONE = 0;
    public static final int CHANGE_POSITION = 1;
    public static final int CHANGE_SIZE = 2;
    public static final int CHANGE_COLOR = 4;
    public static final int CHANGE_RESOLUTION = 8;
    public static final int CHANGE_VISIBILITY = 16;
    Transform3D transform = new Transform3D();
    protected TransformGroup transformGroup;
    protected Vector3d position = new Vector3d();
    protected Vector3d size = new Vector3d();
    protected Branch branch = new Branch();
    private BranchGroup lastBg;
    private double[] matrixBuffer = new double[16];
    private Quat4d quatBuffer = new Quat4d();
    private WakeupCondition wc;

    public Element() {
        this.transformGroup = new TransformGroup(this.transform);
        this.transformGroup.setCapability(18);
        this.transformGroup.setCapability(14);
        this.transformGroup.setCapability(13);
        this.transformGroup.setCapability(1);
        this.branch.setCapability(14);
        this.branch.setCapability(13);
        this.transform.setTranslation(this.position);
        this.transform.setScale(this.size);
    }

    protected void setNode(Node node) {
        if (this.lastBg != null) {
            this.lastBg.detach();
            this.lastBg.removeAllChildren();
            this.transformGroup.removeAllChildren();
        }
        this.transformGroup.addChild(node);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(13);
        branchGroup.setCapability(14);
        branchGroup.addChild((Node)this.transformGroup);
        this.branch.addChild((Node)branchGroup);
        this.lastBg = branchGroup;
    }

    void setPickingEnabled(boolean bl) {
        if (this.lastBg != null) {
            Enumeration enumeration = this.lastBg.getAllChildren();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                node.setPickable(bl);
            }
        }
    }

    public double getX() {
        return this.position.x;
    }

    public double getY() {
        return this.position.y;
    }

    public double getZ() {
        return this.position.z;
    }

    public void setX(double d) {
        this.position.x = d;
        this.setElementChanged(1);
    }

    public void setY(double d) {
        this.position.y = d;
        this.setElementChanged(1);
    }

    public void setZ(double d) {
        this.position.z = d;
        this.setElementChanged(1);
    }

    public void setXYZ(double[] dArray) {
        this.position.x = dArray[0];
        this.position.y = dArray[1];
        if (dArray.length >= 3) {
            this.position.z = dArray[2];
        }
        this.setElementChanged(1);
    }

    public void setXYZ(double d, double d2, double d3) {
        this.position.x = d;
        this.position.y = d2;
        this.position.z = d3;
        this.setElementChanged(1);
    }

    public void setPosition(Vector3d vector3d) {
        this.setXYZ(vector3d.x, vector3d.y, vector3d.z);
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public double getSizeX() {
        return this.size.x;
    }

    public double getSizeY() {
        return this.size.y;
    }

    public double getSizeZ() {
        return this.size.z;
    }

    public void setSizeX(double d) {
        this.size.x = d;
        this.setElementChanged(2);
    }

    public void setSizeY(double d) {
        this.size.y = d;
        this.setElementChanged(2);
    }

    public void setSizeZ(double d) {
        this.size.z = d;
        this.setElementChanged(2);
    }

    public void setSizeXYZ(double[] dArray) {
        this.size.x = dArray[0];
        this.size.y = dArray[1];
        if (dArray.length >= 3) {
            this.size.z = dArray[2];
        }
        this.setElementChanged(2);
    }

    public void setSizeXYZ(double d, double d2, double d3) {
        this.size.x = d;
        this.size.y = d2;
        this.size.z = d3;
        this.setElementChanged(2);
    }

    public Vector3d getSize() {
        return this.size;
    }

    void getExtrema(double[] dArray, double[] dArray2) {
        dArray[0] = this.getX() - this.getSizeX() / 2.0;
        dArray2[0] = dArray[0] + this.getSizeX();
        dArray[1] = this.getY() - this.getSizeY() / 2.0;
        dArray2[1] = dArray[1] + this.getSizeY();
        dArray[2] = this.getZ() - this.getSizeZ() / 2.0;
        dArray2[2] = dArray[2] + this.getSizeZ();
    }

    public void addInteractionListener(InteractionListener interactionListener) {
        if (interactionListener == null || this.listeners.contains(interactionListener)) {
            return;
        }
        this.listeners.add(interactionListener);
    }

    public org.opensourcephysics.display3d.core.interaction.InteractionTarget getInteractionTarget(int n) {
        switch (n) {
            case 0: {
                return this.targetPosition;
            }
            case 1: {
                return this.targetSize;
            }
        }
        return null;
    }

    public void removeInteractionListener(InteractionListener interactionListener) {
        this.listeners.remove(interactionListener);
    }

    /*
     * Unable to fully structure code
     */
    final Group getTopGroup() {
        var1_1 = this.group;
        if (var1_1 != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getGroup();
lbl5:
            // 2 sources

            ** while (var1_1.getGroup() != null)
        }
lbl6:
        // 1 sources

        return var1_1;
    }

    protected double[] getHotSpotBodyCoordinates(InteractionTarget interactionTarget) {
        if (interactionTarget == this.targetPosition) {
            return new double[]{0.0, 0.0, 0.0};
        }
        if (interactionTarget == this.targetSize) {
            double[] dArray = new double[]{1.0, 1.0, 1.0};
            if (this.getSizeX() == 0.0) {
                dArray[0] = 0.0;
            }
            if (this.getSizeY() == 0.0) {
                dArray[1] = 0.0;
            }
            if (this.getSizeZ() == 0.0) {
                dArray[2] = 0.0;
            }
            return dArray;
        }
        return null;
    }

    final double[] getHotSpot(InteractionTarget interactionTarget) {
        double[] dArray = this.getHotSpotBodyCoordinates(interactionTarget);
        if (dArray != null) {
            this.sizeAndToSpaceFrame(dArray);
        }
        return dArray;
    }

    final void updateHotSpot(InteractionTarget interactionTarget, double[] dArray) {
        Group group = this.getTopGroup();
        switch (interactionTarget.getType()) {
            case 0: {
                if (interactionTarget.getAffectsGroup() && group != null) {
                    double[] dArray2 = this.getHotSpot(interactionTarget);
                    group.setXYZ(group.getX() + dArray[0] - dArray2[0], group.getY() + dArray[1] - dArray2[1], group.getZ() + dArray[2] - dArray2[2]);
                    break;
                }
                double[] dArray3 = new double[]{dArray[0], dArray[1], dArray[2]};
                this.groupInverseTransformations(dArray3);
                double[] dArray4 = this.getHotSpotBodyCoordinates(interactionTarget);
                dArray4[0] = dArray4[0] * this.getSizeX();
                dArray4[1] = dArray4[1] * this.getSizeY();
                dArray4[2] = dArray4[2] * this.getSizeZ();
                if (this.transformation != null) {
                    this.transformation.direct(dArray4);
                }
                this.setXYZ(dArray3[0] - dArray4[0], dArray3[1] - dArray4[1], dArray3[2] - dArray4[2]);
                break;
            }
            case 1: {
                if (interactionTarget.getAffectsGroup() && group != null) {
                    double[] dArray5 = new double[]{dArray[0], dArray[1], dArray[2]};
                    dArray5[0] = dArray5[0] - group.getX();
                    dArray5[1] = dArray5[1] - group.getY();
                    dArray5[2] = dArray5[2] - group.getZ();
                    if (group.transformation != null) {
                        group.transformation.inverse(dArray5);
                    }
                    double[] dArray6 = this.getHotSpotBodyCoordinates(interactionTarget);
                    this.elementDirectTransformations(dArray6);
                    dArray5[0] = dArray6[0] != 0.0 ? dArray5[0] / dArray6[0] : group.getSizeX();
                    dArray5[1] = dArray6[1] != 0.0 ? dArray5[1] / dArray6[1] : group.getSizeY();
                    dArray5[2] = dArray6[2] != 0.0 ? dArray5[2] / dArray6[2] : group.getSizeZ();
                    group.setSizeXYZ(dArray5);
                    break;
                }
                double[] dArray7 = new double[]{dArray[0], dArray[1], dArray[2]};
                this.groupInverseTransformations(dArray7);
                dArray7[0] = dArray7[0] - this.getX();
                dArray7[1] = dArray7[1] - this.getY();
                dArray7[2] = dArray7[2] - this.getZ();
                if (this.transformation != null) {
                    this.transformation.inverse(dArray7);
                }
                double[] dArray8 = this.getHotSpotBodyCoordinates(interactionTarget);
                int n = 0;
                while (n < 3) {
                    if (dArray8[n] != 0.0) {
                        int n2 = n;
                        dArray7[n2] = dArray7[n2] / dArray8[n];
                    }
                    ++n;
                }
                this.setSizeXYZ(dArray7);
            }
        }
    }

    private final void elementDirectTransformations(double[] dArray) {
        Element element = this;
        do {
            if (element.getSizeX() != 0.0) {
                dArray[0] = dArray[0] * element.getSizeX();
            }
            if (element.getSizeY() != 0.0) {
                dArray[1] = dArray[1] * element.getSizeY();
            }
            if (element.getSizeZ() != 0.0) {
                dArray[2] = dArray[2] * element.getSizeZ();
            }
            if (element.transformation != null) {
                element.transformation.direct(dArray);
            }
            dArray[0] = dArray[0] + element.getX();
            dArray[1] = dArray[1] + element.getY();
            dArray[2] = dArray[2] + element.getZ();
        } while ((element = element.group) != null && element.group != null);
    }

    private final void groupInverseTransformations(double[] dArray) throws UnsupportedOperationException {
        ArrayList<Group> arrayList = new ArrayList<Group>();
        Element element = this.group;
        while (element != null) {
            arrayList.add((Group)element);
            element = element.group;
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element = (Element)arrayList.get(n);
            dArray[0] = dArray[0] - element.getX();
            dArray[1] = dArray[1] - element.getY();
            dArray[2] = dArray[2] - element.getZ();
            if (element.transformation != null) {
                element.transformation.inverse(dArray);
            }
            if (element.getSizeX() != 0.0) {
                dArray[0] = dArray[0] / element.getSizeX();
            }
            if (element.getSizeY() != 0.0) {
                dArray[1] = dArray[1] / element.getSizeY();
            }
            if (element.getSizeZ() != 0.0) {
                dArray[2] = dArray[2] / element.getSizeZ();
            }
            --n;
        }
    }

    final void invokeActions(InteractionEvent interactionEvent) {
        Iterator<InteractionListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().interactionPerformed(interactionEvent);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        this.getAppearance().getRenderingAttributes().setVisible(bl);
        this.setElementChanged(16);
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public Group getGroup() {
        return this.group;
    }

    public org.opensourcephysics.display3d.core.Style getStyle() {
        return this.style;
    }

    protected Appearance getAppearance() {
        return ((Style)this.style).getAppearance();
    }

    public final synchronized void setElementChanged(int n) {
        this.elementChanged |= n;
        this.processChanges(this.elementChanged);
        this.elementChanged = 0;
    }

    public void transformChanged() {
    }

    public int elementChanged() {
        return this.elementChanged;
    }

    public void setTransformation(Transformation transformation) {
        if (transformation == null) {
            this.transformation = null;
        } else {
            this.transformation = (Transformation)transformation.clone();
            if (transformation instanceof Quaternion) {
                Quaternion quaternion = (Quaternion)this.transformation;
                double[] dArray = quaternion.getCoordinates();
                this.quatBuffer.set(dArray[1], dArray[2], dArray[3], dArray[0]);
                this.transform.set(this.quatBuffer);
            } else {
                Matrix3DTransformation matrix3DTransformation = (Matrix3DTransformation)this.transformation;
                this.transform.set(matrix3DTransformation.getTransposedFlatMatrix(this.matrixBuffer));
            }
            this.transform.setTranslation(this.position);
            this.transform.setScale(this.size);
            this.transformGroup.setTransform(this.transform);
        }
        this.setElementChanged(1);
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public double[] toSpaceFrame(double[] dArray) {
        if (this.transformation != null) {
            this.transformation.direct(dArray);
        }
        dArray[0] = dArray[0] + this.getX();
        dArray[1] = dArray[1] + this.getY();
        dArray[2] = dArray[2] + this.getZ();
        Group group = this.group;
        while (group != null) {
            dArray[0] = dArray[0] * group.getSizeX();
            dArray[1] = dArray[1] * group.getSizeY();
            dArray[2] = dArray[2] * group.getSizeZ();
            if (group.transformation != null) {
                group.transformation.direct(dArray);
            }
            dArray[0] = dArray[0] + group.getX();
            dArray[1] = dArray[1] + group.getY();
            dArray[2] = dArray[2] + group.getZ();
            group = group.group;
        }
        return dArray;
    }

    public double[] toBodyFrame(double[] dArray) throws UnsupportedOperationException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = this;
        do {
            arrayList.add(element);
        } while ((element = element.group) != null);
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element = (Element)arrayList.get(n);
            dArray[0] = dArray[0] - element.getX();
            dArray[1] = dArray[1] - element.getY();
            dArray[2] = dArray[2] - element.getZ();
            if (element.transformation != null) {
                element.transformation.inverse(dArray);
            }
            if (element != this) {
                if (element.getSizeX() != 0.0) {
                    dArray[0] = dArray[0] / element.getSizeX();
                }
                if (element.getSizeY() != 0.0) {
                    dArray[1] = dArray[1] / element.getSizeY();
                }
                if (element.getSizeZ() != 0.0) {
                    dArray[2] = dArray[2] / element.getSizeZ();
                }
            }
            --n;
        }
        return dArray;
    }

    final void sizeAndToSpaceFrame(double[] dArray) {
        dArray[0] = dArray[0] * this.getSizeX();
        dArray[1] = dArray[1] * this.getSizeY();
        dArray[2] = dArray[2] * this.getSizeZ();
        this.toSpaceFrame(dArray);
    }

    public DrawingPanel3D getDrawingPanel3D() {
        return this.panel;
    }

    public void setDrawingPanel3D(DrawingPanel3D drawingPanel3D) {
        this.panel = drawingPanel3D;
        drawingPanel3D.addBehavior(this);
        if (this instanceof Group) {
            Iterator<org.opensourcephysics.display3d.core.Element> iterator = ((Group)this).getElements().iterator();
            while (iterator.hasNext()) {
                ((Element)iterator.next()).setDrawingPanel3D(drawingPanel3D);
            }
        }
    }

    public Branch getBranch() {
        return this.branch;
    }

    public void loadUnmutableObjects(XMLControl xMLControl) {
        this.style = (org.opensourcephysics.display3d.core.Style)xMLControl.getObject("style");
        ((Style)this.style).setElement(this);
        this.setElementChanged(4);
        this.setElementChanged(1);
        this.setElementChanged(8);
        this.setElementChanged(2);
    }

    public void initialize() {
        this.wc = new WakeupOr(new WakeupCriterion[]{new WakeupOnBehaviorPost((Behavior)this, 0), new WakeupOnElapsedFrames(0)});
        this.wakeupOn(this.wc);
        this.postId(0);
    }

    public void wakeUpOnNextFrame() {
        this.wakeupOn((WakeupCondition)new WakeupOnElapsedFrames(0));
    }

    public void processStimulus(Enumeration enumeration) {
        if ((this.elementChanged & 1) != 0) {
            this.processChanges(1);
        }
        if ((this.elementChanged & 2) != 0) {
            this.processChanges(2);
        }
        if ((this.elementChanged & 4) != 0) {
            this.processChanges(4);
        }
        if (false) {
            this.processChanges(0);
        }
        if ((this.elementChanged & 8) != 0) {
            this.processChanges(8);
        }
        if ((this.elementChanged & 0x10) != 0) {
            this.processChanges(16);
        }
        this.elementChanged = 0;
        this.wakeupOn(this.wc);
    }

    public void processChanges(int n) {
        if (((n & 1) != 0 || (n & 2) != 0) && this.transformation == null) {
            this.transform.setIdentity();
            this.transform.setTranslation(this.position);
            this.transform.setScale(this.size);
            this.transformGroup.setTransform(this.transform);
        }
    }
}

