/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.onespring2hand_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ntnu.fkh.onespring2hand_pkg.onespring2handSimulation;
import users.ntnu.fkh.onespring2hand_pkg.onespring2handView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class onespring2hand
extends AbstractModel {
    public onespring2handSimulation _simulation = null;
    public onespring2handView _view = null;
    public onespring2hand _model = this;
    public double range = 50.0;
    public double xmin = -this.range;
    public double xmax = this.range;
    public double ymin = -this.range / 2.0;
    public double ymax = this.range / 2.0;
    public double t = 0.0;
    public double dt = 0.05;
    public double size = this.range / 10.0;
    public double size2 = this.size / 2.0;
    public double stroke = 3.0;
    public double pi = Math.PI;
    public int npt = 600;
    public double L0;
    public double L = this.L0 = 8.0 * this.size;
    public double x = -this.L / 2.0;
    public double y = 0.0;
    public double k = 10.0;
    public double xhr = this.x + 2.0 * this.L;
    public double xhl = this.x - this.L;
    public boolean touchL = false;
    public boolean touchR = false;
    public boolean shows = true;
    public boolean showh = true;
    double dv;

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/ntnu/fkh/onespring2hand.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/ntnu/fkh/_data/graspingHand.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
        }
        onespring2hand onespring2hand2 = new onespring2hand(stringArray);
    }

    public onespring2hand() {
        this(null, null, null, null, null, false);
    }

    public onespring2hand(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public onespring2hand(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new onespring2handSimulation(this, string, frame, uRL, bl);
        this._view = (onespring2handView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _constraints1() {
    }

    public double dvalue(double d) {
        this.dv = d > 0.0 ? 0.5 : (d < 0.0 ? -0.5 : 0.0);
        return (double)((int)(d * 100.0 + this.dv)) / 100.0;
    }

    public double _method_for_spring_solenoid() {
        return this.size2 / 100.0;
    }

    public double _method_for_imagehandR_y() {
        return this.y + 0.0;
    }

    public void _method_for_imagehandR_dragAction() {
        this._simulation.disableLoop();
        if (this.touchR) {
            if (this.touchL) {
                if (this.xhr < this.x + this.size2) {
                    this.xhr = this.x + this.size2;
                }
                this.L = this.xhr - this.x;
            } else {
                this.x = this.xhr - this.L;
                if (this.x < this.xhl) {
                    this.touchL = true;
                    this.x = this.xhl;
                }
            }
        } else if (this.xhr < this.x + this.L) {
            this.xhr = this.x + this.L;
            this.touchR = true;
        }
        this._simulation.enableLoop();
    }

    public double _method_for_imagehandL_y() {
        return this.y + 0.0;
    }

    public double _method_for_imagehandL_sizeX() {
        return -this.size;
    }

    public void _method_for_imagehandL_dragAction() {
        this._simulation.disableLoop();
        if (this.touchL) {
            if (this.touchR) {
                if (this.xhl + this.size2 > this.xhr) {
                    this.xhl = this.xhr - this.size2;
                }
                this.L = this.xhr - this.xhl;
            } else if (this.xhl + this.L0 > this.xhr) {
                this.touchR = true;
            }
            this.x = this.xhl;
        } else if (this.xhl > this.x) {
            this.xhl = this.x;
            this.touchL = true;
        }
        this._simulation.enableLoop();
    }

    public double _method_for_arrowHL_sizeX() {
        return this.k * (this.L - this.L0);
    }

    public double _method_for_arrowHR_x() {
        return this.x + this.L;
    }

    public double _method_for_arrowHR_sizeX() {
        return -this.k * (this.L - this.L0);
    }

    public double _method_for_arrowSL_sizeX() {
        return -this.k * (this.L - this.L0);
    }

    public double _method_for_arrowSR_x() {
        return this.x + this.L;
    }

    public double _method_for_arrowSR_sizeX() {
        return this.k * (this.L - this.L0);
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public boolean _method_for_buttoninit_enabled() {
        return this._isPaused();
    }

    public void _method_for_buttoninit_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public double _method_for_sliderL_minimum() {
        return this.size * 2.0;
    }

    public double _method_for_sliderL_maximum() {
        return this.size * 8.0;
    }

    public void _method_for_sliderL_dragaction() {
        this._simulation.disableLoop();
        if (this.x + this.L0 > this.xhr) {
            this.xhr = this.x + this.L;
            this.L = this.L0;
        }
        if (this.touchR) {
            if (!this.touchL) {
                this.L = this.L0;
            }
        } else if (this.touchL) {
            if (!this.touchR) {
                this.L = this.L0;
            }
        } else {
            this.L = this.L0;
        }
        this._simulation.enableLoop();
    }

    public double _method_for_barF_variable() {
        return this.k * (this.L - this.L0);
    }

    public double _method_for_barF2_variable() {
        return -this.k * (this.L - this.L0);
    }

    public void _method_for_checkBoxtouchL_actionoff() {
        this._simulation.disableLoop();
        if (this.touchR) {
            this.x = this.xhr - this.L0;
            this.L = this.L0;
        }
        this.xhl = this.x - this.size;
        this._simulation.enableLoop();
    }

    public void _method_for_checkBoxtouchR_actionoff() {
        this._simulation.disableLoop();
        this.L = this.L0;
        this.xhr = this.x + this.L0 + this.size;
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.range = 50.0;
        this.xmin = -this.range;
        this.xmax = this.range;
        this.ymin = -this.range / 2.0;
        this.ymax = this.range / 2.0;
        this.t = 0.0;
        this.dt = 0.05;
        this.size = this.range / 10.0;
        this.size2 = this.size / 2.0;
        this.stroke = 3.0;
        this.pi = Math.PI;
        this.npt = 600;
        this.L = this.L0 = 8.0 * this.size;
        this.x = -this.L / 2.0;
        this.y = 0.0;
        this.k = 10.0;
        this.xhr = this.x + 2.0 * this.L;
        this.xhl = this.x - this.L;
        this.touchL = false;
        this.touchR = false;
        this.shows = true;
        this.showh = true;
    }

    @Override
    public synchronized void initialize() {
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        System.gc();
    }
}

