/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.mass2spring_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.RK4;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ntnu.fkh.mass2spring_pkg.mass2springSimulation;
import users.ntnu.fkh.mass2spring_pkg.mass2springView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mass2spring
extends AbstractModel {
    public mass2springSimulation _simulation = null;
    public mass2springView _view = null;
    public mass2spring _model = this;
    public double range = 20.0;
    public double xmin = -this.range / 2.0;
    public double xmax = this.range / 2.0;
    public double ymin = -this.range / 2.0;
    public double ymax = this.range / 2.0;
    public double t = 0.0;
    public double dt = 0.05;
    public double size = this.range / 20.0;
    public double size2 = this.size / 2.0;
    public double stroke = 2.0;
    public double pi = Math.PI;
    public double w = 5.0 * this.size;
    public int npt = 200;
    public int ntrace = 1;
    public double L0 = this.ymax * 0.8;
    public double k = 50.0;
    public double g = 10.0;
    public double m2 = 1.0;
    public double x2 = 0.0;
    public double y2 = this.ymin + this.size2;
    public double vy2 = 0.0;
    public double m1 = 5.0;
    public double x1 = 0.0;
    public double y1 = this.y2 + this.L0 - this.m1 * this.g / this.k;
    public double vy1 = 0.0;
    public double f;
    public double Fext;
    public double b = 0.0;
    private _ODE_evolution1 _ODEi_evolution1;

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/ntnu/fkh/mass2spring.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
        }
        mass2spring mass2spring2 = new mass2spring(stringArray);
    }

    public mass2spring() {
        this(null, null, null, null, null, false);
    }

    public mass2spring(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public mass2spring(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new mass2springSimulation(this, string, frame, uRL, bl);
        this._view = (mass2springView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.vy2 = 0.0;
        this.vy1 = 0.0;
        this.y2 = this.ymin + this.size2;
        this.y1 = this.y2 + this.L0 - this.m1 * this.g / this.k;
    }

    public void _constraints1() {
    }

    public double calF(double d, double d2) {
        this.f = this.k * (d2 - d - this.L0) - this.m2 * this.g;
        if (d <= this.ymin + this.size2 && this.f < 0.0) {
            return 0.0;
        }
        return this.f - this.b * this.vy2;
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public boolean _method_for_buttoninit_enabled() {
        return this._isPaused();
    }

    public void _method_for_buttoninit_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_playPauseButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_playPauseButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_buttonF_0_action() {
        this._simulation.disableLoop();
        this.Fext = 0.0;
        this._pause();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_sliderm1_enabled() {
        return this._isPaused();
    }

    public void _method_for_sliderm1_dragaction() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_sliderm2_enabled() {
        return this._isPaused();
    }

    public void _method_for_sliderm2_dragaction() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_sliderk_enabled() {
        return this._isPaused();
    }

    public void _method_for_sliderk_dragaction() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public double _method_for_sliderF_maximum() {
        return this.k * this.L0 - 2.0 * this.m1 * this.g;
    }

    public boolean _method_for_sliderF_enabled() {
        return this._isPaused();
    }

    public void _method_for_sliderF_dragaction() {
        this._simulation.disableLoop();
        this.y1 = this.y2 + this.L0 - (this.Fext + this.m1 * this.g) / this.k;
        this._simulation.enableLoop();
    }

    public void _method_for_sliderF_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public boolean _method_for_sliderb_enabled() {
        return this._isPaused();
    }

    public double _method_for_shape2_x() {
        return this.x2 + 0.0;
    }

    public double _method_for_shape1_x() {
        return this.x1 + 0.0;
    }

    public boolean _method_for_shape1_enabledPosition() {
        return this._isPaused();
    }

    public void _method_for_shape1_dragAction() {
        this._simulation.disableLoop();
        this.Fext = this.k * (this.L0 - (this.y1 - this.y2)) - this.m1 * this.g;
        this._simulation.enableLoop();
    }

    public void _method_for_shape1_releaseAction() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public double _method_for_spring_sizeY() {
        return this.y2 - this.y1;
    }

    public double _method_for_text1_x() {
        return this.x1 + this.w / 2.0 + this.size2;
    }

    public boolean _method_for_text1_visible() {
        return this._isPaused();
    }

    public double _method_for_text12_x() {
        return this.x2 + this.w / 2.0 + this.size2;
    }

    public boolean _method_for_text12_visible() {
        return this._isPaused();
    }

    public boolean _method_for_tracey1_active() {
        return this._isPlaying();
    }

    public boolean _method_for_tracey1_connected() {
        return this._isPlaying();
    }

    public boolean _method_for_tracey12_active() {
        return this._isPlaying();
    }

    public boolean _method_for_tracey12_connected() {
        return this._isPlaying();
    }

    public boolean _method_for_tracevy1_active() {
        return this._isPlaying();
    }

    public boolean _method_for_tracevy1_connected() {
        return this._isPlaying();
    }

    public boolean _method_for_tracevy12_active() {
        return this._isPlaying();
    }

    public boolean _method_for_tracevy12_connected() {
        return this._isPlaying();
    }

    @Override
    public synchronized void reset() {
        this.range = 20.0;
        this.xmin = -this.range / 2.0;
        this.xmax = this.range / 2.0;
        this.ymin = -this.range / 2.0;
        this.ymax = this.range / 2.0;
        this.t = 0.0;
        this.dt = 0.05;
        this.size = this.range / 20.0;
        this.size2 = this.size / 2.0;
        this.stroke = 2.0;
        this.pi = Math.PI;
        this.w = 5.0 * this.size;
        this.npt = 200;
        this.ntrace = 1;
        this.L0 = this.ymax * 0.8;
        this.k = 50.0;
        this.g = 10.0;
        this.m2 = 1.0;
        this.x2 = 0.0;
        this.y2 = this.ymin + this.size2;
        this.vy2 = 0.0;
        this.m1 = 5.0;
        this.x1 = 0.0;
        this.y1 = this.y2 + this.L0 - this.m1 * this.g / this.k;
        this.vy1 = 0.0;
        this.b = 0.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[5];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = mass2spring.this.y1;
            this.__state[n++] = mass2spring.this.y2;
            this.__state[n++] = mass2spring.this.vy1;
            this.__state[n++] = mass2spring.this.vy2;
            this.__state[n++] = mass2spring.this.t;
            this.__solver = new ODEBisectionEventSolver(this, RK4.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.initialize(mass2spring.this.dt);
        }

        void step() {
            if (mass2spring.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(mass2spring.this.dt);
            }
            int n = 0;
            this.__state[n++] = mass2spring.this.y1;
            this.__state[n++] = mass2spring.this.y2;
            this.__state[n++] = mass2spring.this.vy1;
            this.__state[n++] = mass2spring.this.vy2;
            this.__state[n++] = mass2spring.this.t;
            this.__solver.step();
            n = 0;
            mass2spring.this.y1 = this.__state[n++];
            mass2spring.this.y2 = this.__state[n++];
            mass2spring.this.vy1 = this.__state[n++];
            mass2spring.this.vy2 = this.__state[n++];
            mass2spring.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            double d4 = dArray[n++];
            double d5 = dArray[n++];
            n = 0;
            dArray2[n++] = d3;
            dArray2[n++] = d4;
            dArray2[n++] = -mass2spring.this.k * (d - d2 - mass2spring.this.L0) / mass2spring.this.m1 - mass2spring.this.g - mass2spring.this.b * d3;
            dArray2[n++] = mass2spring.this.calF(d2, d) / mass2spring.this.m2;
            dArray2[n++] = 1.0;
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "Event";
            }

            public double getTolerance() {
                return 0.001;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                double d = dArray[n++];
                double d2 = dArray[n++];
                double d3 = dArray[n++];
                double d4 = dArray[n++];
                double d5 = dArray[n++];
                return d2 - (mass2spring.this.ymin + mass2spring.this.size2);
            }

            public boolean action() {
                int n = 0;
                mass2spring.this.y1 = _ODE_evolution1.this.__state[n++];
                mass2spring.this.y2 = _ODE_evolution1.this.__state[n++];
                mass2spring.this.vy1 = _ODE_evolution1.this.__state[n++];
                mass2spring.this.vy2 = _ODE_evolution1.this.__state[n++];
                mass2spring.this.t = _ODE_evolution1.this.__state[n++];
                boolean bl = this.userDefinedAction();
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = mass2spring.this.y1;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = mass2spring.this.y2;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = mass2spring.this.vy1;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = mass2spring.this.vy2;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = mass2spring.this.t;
                return bl;
            }

            private boolean userDefinedAction() {
                mass2spring.this.y2 = mass2spring.this.ymin + mass2spring.this.size2;
                mass2spring.this.vy2 = 0.0;
                return true;
            }
        }
    }
}

