/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.DormandPrince45;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEAdaptiveSolver;
import org.opensourcephysics.numerics.ODESolverException;
import org.opensourcephysics.numerics.RK45;

public class ODEMultistepSolver
implements ODEAdaptiveSolver {
    private static int maxMessages = 3;
    protected int err_code = 0;
    protected int maxIterations = 200;
    protected boolean enableExceptions = false;
    protected String err_msg = "";
    protected ODEAdaptiveSolver odeEngine;
    protected double fixedStepSize = 0.1;
    protected InternalODE internalODE;

    public ODEMultistepSolver(ODE oDE) {
        this.odeEngine = new DormandPrince45(this.setODE(oDE));
    }

    protected ODEMultistepSolver() {
    }

    protected InternalODE setODE(ODE oDE) {
        this.internalODE = new InternalODE(oDE);
        return this.internalODE;
    }

    public static ODEAdaptiveSolver MultistepRK45(ODE oDE) {
        ODEMultistepSolver oDEMultistepSolver = new ODEMultistepSolver();
        oDEMultistepSolver.odeEngine = new RK45(oDEMultistepSolver.setODE(oDE));
        return oDEMultistepSolver;
    }

    public void enableRuntimeExpecptions(boolean bl) {
        this.enableExceptions = bl;
    }

    public void setMaxIterations(int n) {
        this.maxIterations = Math.max(1, n);
    }

    public void setTolerance(double d) {
        d = Math.abs(d);
        this.odeEngine.setTolerance(d);
    }

    public double getTolerance() {
        return this.odeEngine.getTolerance();
    }

    public int getErrorCode() {
        return this.err_code;
    }

    public double step() {
        this.err_code = 0;
        this.internalODE.setInitialConditions();
        double d = 0.0;
        d = this.fixedStepSize > 0.0 ? this.plus() : this.minus();
        this.internalODE.update();
        return this.fixedStepSize - d;
    }

    private double plus() {
        double d = this.odeEngine.getTolerance();
        double d2 = this.fixedStepSize;
        if (this.odeEngine.getStepSize() <= 0.0 || this.odeEngine.getStepSize() > this.fixedStepSize || this.fixedStepSize - this.odeEngine.getStepSize() == this.fixedStepSize) {
            this.odeEngine.setStepSize(this.fixedStepSize);
        }
        int n = 0;
        while (d2 > d * this.fixedStepSize) {
            ++n;
            double d3 = d2;
            if (d2 < this.odeEngine.getStepSize()) {
                double d4 = this.odeEngine.getStepSize();
                this.odeEngine.setStepSize(d2);
                double d5 = this.odeEngine.step();
                d2 -= d5;
                this.odeEngine.setStepSize(d4);
            } else {
                d2 -= this.odeEngine.step();
            }
            if (this.odeEngine.getErrorCode() == 0 && !(Math.abs(d3 - d2) <= (double)1.4E-45f) && !(d * this.fixedStepSize / 10.0 > this.odeEngine.getStepSize()) && n <= this.maxIterations) continue;
            this.err_msg = "ODEMultiStep did not converge. Remainder=" + d2;
            this.err_code = 1;
            if (this.enableExceptions) {
                throw new ODESolverException(this.err_msg);
            }
            if (maxMessages <= 0) break;
            --maxMessages;
            System.out.println(this.err_msg);
            break;
        }
        return d2;
    }

    private double minus() {
        double d = this.odeEngine.getTolerance();
        double d2 = this.fixedStepSize;
        if (this.odeEngine.getStepSize() >= 0.0 || this.odeEngine.getStepSize() < this.fixedStepSize || this.fixedStepSize - this.odeEngine.getStepSize() == this.fixedStepSize) {
            this.odeEngine.setStepSize(this.fixedStepSize);
        }
        int n = 0;
        while (d2 < d * this.fixedStepSize) {
            ++n;
            double d3 = d2;
            if (d2 > this.odeEngine.getStepSize()) {
                double d4 = this.odeEngine.getStepSize();
                this.odeEngine.setStepSize(d2);
                double d5 = this.odeEngine.step();
                d2 -= d5;
                this.odeEngine.setStepSize(d4);
            } else {
                d2 -= this.odeEngine.step();
            }
            if (this.odeEngine.getErrorCode() == 0 && !(Math.abs(d3 - d2) <= (double)1.4E-45f) && !(d * this.fixedStepSize / 10.0 < this.odeEngine.getStepSize()) && n <= this.maxIterations) continue;
            this.err_msg = "ODEMultiStep did not converge. Remainder=" + d2;
            this.err_code = 1;
            if (this.enableExceptions) {
                throw new ODESolverException(this.err_msg);
            }
            if (maxMessages <= 0) continue;
            --maxMessages;
            System.out.println(this.err_msg);
        }
        return d2;
    }

    public void initialize(double d) {
        maxMessages = 4;
        this.err_msg = "";
        this.err_code = 0;
        this.fixedStepSize = d;
        this.internalODE.setInitialConditions();
        this.odeEngine.initialize(d);
    }

    public void setStepSize(double d) {
        maxMessages = 4;
        this.fixedStepSize = d;
        if (d < 0.0) {
            this.odeEngine.setStepSize(Math.max(-Math.abs(this.odeEngine.getStepSize()), d));
        } else {
            this.odeEngine.setStepSize(Math.min(this.odeEngine.getStepSize(), d));
        }
    }

    public void setMaximumNumberOfErrorMessages(int n) {
        maxMessages = n;
    }

    public double getStepSize() {
        return this.fixedStepSize;
    }

    protected final class InternalODE
    implements ODE {
        private ODE ode;
        private double[] engineState = new double[0];

        InternalODE(ODE oDE) {
            this.ode = oDE;
            this.setInitialConditions();
        }

        public void getRate(double[] dArray, double[] dArray2) {
            this.ode.getRate(dArray, dArray2);
        }

        public double[] getState() {
            return this.engineState;
        }

        public void setInitialConditions() {
            double[] dArray = this.ode.getState();
            if (dArray == null) {
                return;
            }
            if (this.engineState == null || this.engineState.length != dArray.length) {
                this.engineState = new double[dArray.length];
            }
            System.arraycopy(dArray, 0, this.engineState, 0, dArray.length);
        }

        public void update() {
            System.arraycopy(this.engineState, 0, this.ode.getState(), 0, this.engineState.length);
        }
    }
}

