/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.Function;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlDrawable3D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.InteractionTargetElementSize;
import org.opensourcephysics.displayejs.InteractionTargetSetElement;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Resolution;
import org.opensourcephysics.displayejs.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlElementSet
extends ControlDrawable3D
implements InteractionListener {
    protected static final int SET_ADDED = 36;
    protected static final int IMAGE = 1;
    protected static final int TEXT = 2;
    protected static final int RADIUS = 3;
    protected static final int POSITION = 33;
    protected static final int POSITION_X = 4;
    protected static final int POSITION_Y = 5;
    protected static final int POSITION_Z = 6;
    protected static final int SIZE = 34;
    protected static final int SIZE_X = 7;
    protected static final int SIZE_Y = 8;
    protected static final int SIZE_Z = 9;
    protected static final int ENABLED = 11;
    protected static final int ENABLED_SECONDARY = 12;
    protected static final int STYLE = 18;
    protected static final int PRIMARY_COLOR = 22;
    protected static final int SECONDARY_COLOR = 23;
    protected static final int ELEMENT_SELECTED = 31;
    protected static final int MEASURED = 35;
    protected ElementSet elementSet;
    protected ObjectValue[] allposValues;
    protected ObjectValue[] allsizesValue;
    protected IntegerValue selectedValue = new IntegerValue(-1);
    protected double[] theXs;
    protected double[] theYs;
    protected double[] theZs;
    protected double[][] thePos = null;
    protected double[][] theSize = null;
    protected double[] theSizeXs;
    protected double[] theSizeYs;
    protected double[] theSizeZs;
    protected double scalex = 1.0;
    protected double scaley = 1.0;
    protected double scalez = 1.0;
    protected double lineWidth = 1.0;
    protected Font font;
    protected Font defaultFont;
    protected int sensitivity = AbstractInteractiveElement.SENSIBILITY;
    protected boolean numberOfElements_isSet = false;
    private int[] posSpot;
    private int[] sizeSpot;
    private int fullPosition;
    private int fullSize;
    private int elementSelectedSpot;
    protected Function elementFunction = new MyFunction();
    private static List<String> infoList = null;

    public ControlElementSet() {
        this.allposValues = new ObjectValue[3];
        this.theXs = this.elementSet.getXs();
        this.allposValues[0] = new ObjectValue(this.theXs);
        this.theYs = this.elementSet.getYs();
        this.allposValues[1] = new ObjectValue(this.theYs);
        this.theZs = this.elementSet.getZs();
        this.allposValues[2] = new ObjectValue(this.theZs);
        this.allsizesValue = new ObjectValue[3];
        this.theSizeXs = this.elementSet.getSizeXs();
        this.allsizesValue[0] = new ObjectValue(this.theSizeXs);
        this.theSizeYs = this.elementSet.getSizeYs();
        this.allsizesValue[1] = new ObjectValue(this.theSizeYs);
        this.theSizeZs = this.elementSet.getSizeZs();
        this.allsizesValue[2] = new ObjectValue(this.theSizeZs);
        this.elementSet.addListener(this);
        this.defaultFont = this.font = this.elementSet.elementAt(0).getStyle().getFont();
        int n = this.getPropertiesDisplacement();
        this.posSpot = new int[]{4 + n, 5 + n, 6 + n};
        this.sizeSpot = new int[]{7 + n, 8 + n, 9 + n};
        this.fullPosition = 33 + n;
        this.fullSize = 34 + n;
        this.elementSelectedSpot = 31 + n;
    }

    protected abstract int getPropertiesDisplacement();

    protected int[] getPosSpot() {
        return this.posSpot;
    }

    protected int[] getSizeSpot() {
        return this.sizeSpot;
    }

    protected int getFullPositionSpot() {
        return this.fullPosition;
    }

    protected int getFullSizeSpot() {
        return this.fullSize;
    }

    protected int getElementSpot() {
        return this.elementSelectedSpot;
    }

    @Override
    public Object getObject(String string) {
        if (string.equals("elementSelected")) {
            return this.elementFunction;
        }
        return null;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("elementnumber");
            infoList.add("image");
            infoList.add("text");
            infoList.add("radius");
            infoList.add("x");
            infoList.add("y");
            infoList.add("z");
            infoList.add("sizex");
            infoList.add("sizey");
            infoList.add("sizez");
            infoList.add("visible");
            infoList.add("enabled");
            infoList.add("enabledSecondary");
            infoList.add("scalex");
            infoList.add("scaley");
            infoList.add("scalez");
            infoList.add("group");
            infoList.add("groupEnabled");
            infoList.add("style");
            infoList.add("elementposition");
            infoList.add("angle");
            infoList.add("resolution");
            infoList.add("color");
            infoList.add("secondaryColor");
            infoList.add("stroke");
            infoList.add("font");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("elementSelected");
            infoList.add("sensitivity");
            infoList.add("position");
            infoList.add("size");
            infoList.add("measured");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyCommonName(String string) {
        if (string.equals("elementnumber")) {
            return "numberOfElements";
        }
        if (string.equals("angle")) {
            return "rotationAngle";
        }
        if (string.equals("color")) {
            return "fillColor";
        }
        if (string.equals("secondaryColor")) {
            return "lineColor";
        }
        if (string.equals("action")) {
            return "releaseAction";
        }
        if (string.equals("pressaction")) {
            return "pressAction";
        }
        if (string.equals("dragaction")) {
            return "dragAction";
        }
        if (string.equals("enabled")) {
            return "enabledPosition";
        }
        if (string.equals("enabledSecondary")) {
            return "enabledSize";
        }
        if (string.equals("sizex")) {
            return "sizeX";
        }
        if (string.equals("sizey")) {
            return "sizeY";
        }
        if (string.equals("sizez")) {
            return "sizeZ";
        }
        if (string.equals("size")) {
            return "sizeArray";
        }
        return super.getPropertyCommonName(string);
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("elementnumber")) {
            return "int PREVIOUS";
        }
        if (string.equals("x")) {
            return "int|double|double[]";
        }
        if (string.equals("y")) {
            return "int|double|double[]";
        }
        if (string.equals("z")) {
            return "int|double|double[] DEPRECATED";
        }
        if (string.equals("sizex")) {
            return "int|double|double[]";
        }
        if (string.equals("sizey")) {
            return "int|double|double[]";
        }
        if (string.equals("sizez")) {
            return "int|double|double[] DEPRECATED";
        }
        if (string.equals("visible")) {
            return "boolean|boolean[]";
        }
        if (string.equals("enabled")) {
            return "boolean|boolean[]";
        }
        if (string.equals("enabledSecondary")) {
            return "boolean|boolean[]";
        }
        if (string.equals("scalex")) {
            return "int|double";
        }
        if (string.equals("scaley")) {
            return "int|double";
        }
        if (string.equals("scalez")) {
            return "int|double DEPRECATED";
        }
        if (string.equals("style")) {
            return "MarkerShape|int|int[]";
        }
        if (string.equals("elementposition")) {
            return "ElementPosition|int|int[]";
        }
        if (string.equals("angle")) {
            return "int|int[]|double|double[]";
        }
        if (string.equals("resolution")) {
            return "Resolution";
        }
        if (string.equals("color")) {
            return "int|int[]|Color|Object|Object[]";
        }
        if (string.equals("secondaryColor")) {
            return "int|int[]|Color|Object|Object[]";
        }
        if (string.equals("stroke")) {
            return "int|double|Object";
        }
        if (string.equals("font")) {
            return "Font|Object ";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("elementSelected")) {
            return "int";
        }
        if (string.equals("sensitivity")) {
            return "int";
        }
        if (string.equals("position")) {
            return "double[][]";
        }
        if (string.equals("size")) {
            return "double[][]";
        }
        if (string.equals("measured")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    protected void checkNumberOfElements(int n, boolean bl) {
        if (this.elementSet.getNumberOfElements() == n && !bl) {
            return;
        }
        this.elementSet.setNumberOfElements(n);
        this.theXs = this.elementSet.getXs();
        this.allposValues[0].value = this.theXs;
        this.theYs = this.elementSet.getYs();
        this.allposValues[1].value = this.theYs;
        this.theZs = this.elementSet.getZs();
        this.allposValues[2].value = this.theZs;
        this.theSizeXs = this.elementSet.getSizeXs();
        this.allsizesValue[0].value = this.theSizeXs;
        this.theSizeYs = this.elementSet.getSizeYs();
        this.allsizesValue[1].value = this.theSizeYs;
        this.theSizeZs = this.elementSet.getSizeZs();
        this.allsizesValue[2].value = this.theSizeZs;
        int n2 = 0;
        while (n2 < n) {
            InteractiveElement interactiveElement = this.elementSet.elementAt(n2);
            this.theSizeXs[n2] = this.scalex != 0.0 ? interactiveElement.getSizeX() / this.scalex : interactiveElement.getSizeX();
            this.theSizeYs[n2] = this.scaley != 0.0 ? interactiveElement.getSizeY() / this.scaley : interactiveElement.getSizeY();
            this.theSizeZs[n2] = this.scalez != 0.0 ? interactiveElement.getSizeZ() / this.scalez : interactiveElement.getSizeZ();
            interactiveElement.initializeMemberOfSet();
            interactiveElement.setSensitivity(this.sensitivity);
            ++n2;
        }
        EjsControl ejsControl = this.getGroup();
        if (ejsControl != null && !ejsControl.isReportingChange()) {
            ejsControl.propagateValues();
        }
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getInteger() != this.elementSet.getNumberOfElements()) {
                    this.checkNumberOfElements(value.getInteger(), true);
                }
                this.numberOfElements_isSet = true;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 33: {
                if (!(value.getObject() instanceof double[][])) break;
                this.thePos = (double[][])value.getObject();
                double[][] dArray = this.thePos;
                if (!this.numberOfElements_isSet) {
                    this.checkNumberOfElements(dArray.length, false);
                }
                int n2 = 0;
                int n3 = Math.min(this.theXs.length, dArray.length);
                while (n2 < n3) {
                    this.theXs[n2] = dArray[n2][0];
                    this.elementSet.elementAt(n2).setX(this.theXs[n2]);
                    ++n2;
                }
                if (dArray[0].length > 1) {
                    n2 = 0;
                    n3 = Math.min(this.theYs.length, dArray.length);
                    while (n2 < n3) {
                        this.theYs[n2] = dArray[n2][1];
                        this.elementSet.elementAt(n2).setY(this.theYs[n2]);
                        ++n2;
                    }
                }
                if (dArray[0].length <= 2) break;
                n2 = 0;
                n3 = Math.min(this.theZs.length, dArray.length);
                while (n2 < n3) {
                    this.theZs[n2] = dArray[n2][2];
                    this.elementSet.elementAt(n2).setZ(this.theZs[n2]);
                    ++n2;
                }
                break;
            }
            case 4: {
                this.thePos = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n4 = 0;
                    int n5 = Math.min(this.theXs.length, dArray.length);
                    while (n4 < n5) {
                        this.theXs[n4] = dArray[n4];
                        this.elementSet.elementAt(n4).setX(this.theXs[n4]);
                        ++n4;
                    }
                } else {
                    double d = value.getDouble();
                    int n6 = 0;
                    int n7 = this.theXs.length;
                    while (n6 < n7) {
                        this.theXs[n6] = d;
                        this.elementSet.elementAt(n6).setX(this.theXs[n6]);
                        ++n6;
                    }
                }
                break;
            }
            case 5: {
                this.thePos = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n8 = 0;
                    int n9 = Math.min(this.theYs.length, dArray.length);
                    while (n8 < n9) {
                        this.theYs[n8] = dArray[n8];
                        this.elementSet.elementAt(n8).setY(this.theYs[n8]);
                        ++n8;
                    }
                } else {
                    double d = value.getDouble();
                    int n10 = 0;
                    int n11 = this.theYs.length;
                    while (n10 < n11) {
                        this.theYs[n10] = d;
                        this.elementSet.elementAt(n10).setY(this.theYs[n10]);
                        ++n10;
                    }
                }
                break;
            }
            case 6: {
                this.thePos = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n12 = 0;
                    int n13 = Math.min(this.theZs.length, dArray.length);
                    while (n12 < n13) {
                        this.theZs[n12] = dArray[n12];
                        this.elementSet.elementAt(n12).setZ(this.theZs[n12]);
                        ++n12;
                    }
                } else {
                    double d = value.getDouble();
                    int n14 = 0;
                    int n15 = this.theZs.length;
                    while (n14 < n15) {
                        this.theZs[n14] = d;
                        this.elementSet.elementAt(n14).setZ(this.theZs[n14]);
                        ++n14;
                    }
                }
                break;
            }
            case 34: {
                if (!(value.getObject() instanceof double[][])) break;
                this.theSize = (double[][])value.getObject();
                double[][] dArray = this.theSize;
                if (!this.numberOfElements_isSet) {
                    this.checkNumberOfElements(dArray.length, false);
                }
                int n16 = 0;
                int n17 = Math.min(this.theSizeXs.length, dArray.length);
                while (n16 < n17) {
                    this.theSizeXs[n16] = dArray[n16][0];
                    this.elementSet.elementAt(n16).setSizeX(this.theSizeXs[n16]);
                    ++n16;
                }
                if (dArray[0].length > 1) {
                    n16 = 0;
                    n17 = Math.min(this.theSizeYs.length, dArray.length);
                    while (n16 < n17) {
                        this.theSizeYs[n16] = dArray[n16][1];
                        this.elementSet.elementAt(n16).setSizeY(this.theSizeYs[n16]);
                        ++n16;
                    }
                }
                if (dArray[0].length <= 2) break;
                n16 = 0;
                n17 = Math.min(this.theSizeZs.length, dArray.length);
                while (n16 < n17) {
                    this.theSizeZs[n16] = dArray[n16][2];
                    this.elementSet.elementAt(n16).setSizeZ(this.theSizeZs[n16]);
                    ++n16;
                }
                break;
            }
            case 7: {
                this.theSize = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n18 = 0;
                    int n19 = Math.min(this.theSizeXs.length, dArray.length);
                    while (n18 < n19) {
                        this.theSizeXs[n18] = dArray[n18];
                        this.elementSet.elementAt(n18).setSizeX(this.theSizeXs[n18] * this.scalex);
                        ++n18;
                    }
                } else {
                    double d = value.getDouble();
                    int n20 = 0;
                    int n21 = this.theSizeXs.length;
                    while (n20 < n21) {
                        this.theSizeXs[n20] = d;
                        this.elementSet.elementAt(n20).setSizeX(this.theSizeXs[n20] * this.scalex);
                        ++n20;
                    }
                }
                break;
            }
            case 8: {
                this.theSize = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n22 = 0;
                    int n23 = Math.min(this.theSizeYs.length, dArray.length);
                    while (n22 < n23) {
                        this.theSizeYs[n22] = dArray[n22];
                        this.elementSet.elementAt(n22).setSizeY(this.theSizeYs[n22] * this.scaley);
                        ++n22;
                    }
                } else {
                    double d = value.getDouble();
                    int n24 = 0;
                    int n25 = this.theSizeYs.length;
                    while (n24 < n25) {
                        this.theSizeYs[n24] = d;
                        this.elementSet.elementAt(n24).setSizeY(this.theSizeYs[n24] * this.scaley);
                        ++n24;
                    }
                }
                break;
            }
            case 9: {
                this.theSize = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n26 = 0;
                    int n27 = Math.min(this.theSizeZs.length, dArray.length);
                    while (n26 < n27) {
                        this.theSizeZs[n26] = dArray[n26];
                        this.elementSet.elementAt(n26).setSizeZ(this.theSizeZs[n26] * this.scalez);
                        ++n26;
                    }
                } else {
                    double d = value.getDouble();
                    int n28 = 0;
                    int n29 = this.theSizeZs.length;
                    while (n28 < n29) {
                        this.theSizeZs[n28] = d;
                        this.elementSet.elementAt(n28).setSizeZ(this.theSizeZs[n28] * this.scalez);
                        ++n28;
                    }
                }
                break;
            }
            case 10: {
                if (value.getObject() instanceof boolean[]) {
                    this.elementSet.setVisibles((boolean[])value.getObject());
                    break;
                }
                this.elementSet.setVisible(value.getBoolean());
                break;
            }
            case 11: {
                if (value.getObject() instanceof boolean[]) {
                    this.elementSet.setEnableds(0, (boolean[])value.getObject());
                    break;
                }
                this.elementSet.setEnabled(0, value.getBoolean());
                break;
            }
            case 12: {
                if (value.getObject() instanceof boolean[]) {
                    this.elementSet.setEnableds(1, (boolean[])value.getObject());
                    break;
                }
                this.elementSet.setEnabled(1, value.getBoolean());
                break;
            }
            case 13: {
                this.scalex = value.getDouble();
                int n30 = 0;
                int n31 = this.theSizeXs.length;
                while (n30 < n31) {
                    this.elementSet.elementAt(n30).setSizeX(this.theSizeXs[n30] * this.scalex);
                    ++n30;
                }
                break;
            }
            case 14: {
                this.scaley = value.getDouble();
                int n32 = 0;
                int n33 = this.theSizeYs.length;
                while (n32 < n33) {
                    this.elementSet.elementAt(n32).setSizeY(this.theSizeYs[n32] * this.scaley);
                    ++n32;
                }
                break;
            }
            case 15: {
                this.scalez = value.getDouble();
                int n34 = 0;
                int n35 = this.theSizeZs.length;
                while (n34 < n35) {
                    this.elementSet.elementAt(n34).setSizeZ(this.theSizeZs[n34] * this.scalez);
                    ++n34;
                }
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                int n36 = 0;
                int n37 = this.elementSet.getNumberOfElements();
                while (n36 < n37) {
                    this.elementSet.elementAt(n36).setGroupEnabled(value.getBoolean());
                    ++n36;
                }
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n38 = 0;
                    int n39 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    while (n38 < n39) {
                        this.elementSet.elementAt(n38).getStyle().setPosition(nArray[n38]);
                        ++n38;
                    }
                } else {
                    int n40 = value.getInteger();
                    int n41 = 0;
                    int n42 = this.elementSet.getNumberOfElements();
                    while (n41 < n42) {
                        this.elementSet.elementAt(n41).getStyle().setPosition(n40);
                        ++n41;
                    }
                }
                break;
            }
            case 20: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n43 = 0;
                    int n44 = Math.min(this.elementSet.getNumberOfElements(), dArray.length);
                    while (n43 < n44) {
                        this.elementSet.elementAt(n43).getStyle().setAngle(dArray[n43]);
                        ++n43;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n45 = 0;
                    int n46 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    while (n45 < n46) {
                        this.elementSet.elementAt(n45).getStyle().setAngle((double)nArray[n45] * (Math.PI / 180));
                        ++n45;
                    }
                } else if (value instanceof IntegerValue) {
                    double d = (double)value.getInteger() * (Math.PI / 180);
                    int n47 = 0;
                    int n48 = this.elementSet.getNumberOfElements();
                    while (n47 < n48) {
                        this.elementSet.elementAt(n47).getStyle().setAngle(d);
                        ++n47;
                    }
                } else {
                    double d = value.getDouble();
                    int n49 = 0;
                    int n50 = this.elementSet.getNumberOfElements();
                    while (n49 < n50) {
                        this.elementSet.elementAt(n49).getStyle().setAngle(d);
                        ++n49;
                    }
                }
                break;
            }
            case 21: {
                int n51 = 0;
                int n52 = this.elementSet.getNumberOfElements();
                while (n51 < n52) {
                    this.elementSet.elementAt(n51).setResolution((Resolution)value.getObject());
                    ++n51;
                }
                break;
            }
            case 22: {
                if (value instanceof IntegerValue) {
                    Color color = DisplayColors.getLineColor(value.getInteger());
                    int n53 = 0;
                    int n54 = this.elementSet.getNumberOfElements();
                    while (n53 < n54) {
                        this.elementSet.elementAt(n53).getStyle().setEdgeColor(color);
                        ++n53;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n55 = 0;
                    int n56 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    while (n55 < n56) {
                        this.elementSet.elementAt(n55).getStyle().setEdgeColor(DisplayColors.getLineColor(nArray[n55]));
                        ++n55;
                    }
                } else if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n57 = 0;
                    int n58 = Math.min(this.elementSet.getNumberOfElements(), objectArray.length);
                    while (n57 < n58) {
                        this.elementSet.elementAt(n57).getStyle().setEdgeColor((Color)objectArray[n57]);
                        ++n57;
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Color color = (Color)value.getObject();
                    int n59 = 0;
                    int n60 = this.elementSet.getNumberOfElements();
                    while (n59 < n60) {
                        this.elementSet.elementAt(n59).getStyle().setEdgeColor(color);
                        ++n59;
                    }
                }
                break;
            }
            case 23: {
                if (value instanceof IntegerValue) {
                    Color color = DisplayColors.getLineColor(value.getInteger());
                    int n61 = 0;
                    int n62 = this.elementSet.getNumberOfElements();
                    while (n61 < n62) {
                        this.elementSet.elementAt(n61).getStyle().setFillPattern(color);
                        ++n61;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n63 = 0;
                    int n64 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    while (n63 < n64) {
                        this.elementSet.elementAt(n63).getStyle().setFillPattern(DisplayColors.getLineColor(nArray[n63]));
                        ++n63;
                    }
                } else if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n65 = 0;
                    int n66 = Math.min(this.elementSet.getNumberOfElements(), objectArray.length);
                    while (n65 < n66) {
                        this.elementSet.elementAt(n65).getStyle().setFillPattern((Paint)objectArray[n65]);
                        ++n65;
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Paint paint = (Paint)value.getObject();
                    if (paint == NULL_COLOR) {
                        paint = null;
                    }
                    int n67 = 0;
                    int n68 = this.elementSet.getNumberOfElements();
                    while (n67 < n68) {
                        this.elementSet.elementAt(n67).getStyle().setFillPattern(paint);
                        ++n67;
                    }
                }
                break;
            }
            case 24: {
                if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n69 = 0;
                    int n70 = Math.min(this.elementSet.getNumberOfElements(), objectArray.length);
                    while (n69 < n70) {
                        this.elementSet.elementAt(n69).getStyle().setEdgeStroke((Stroke)objectArray[n69]);
                        ++n69;
                    }
                } else if (value.getObject() instanceof Stroke) {
                    Stroke stroke = (Stroke)value.getObject();
                    int n71 = 0;
                    int n72 = this.elementSet.getNumberOfElements();
                    while (n71 < n72) {
                        this.elementSet.elementAt(n71).getStyle().setEdgeStroke(stroke);
                        ++n71;
                    }
                } else if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n73 = 0;
                    int n74 = Math.min(this.elementSet.getNumberOfElements(), dArray.length);
                    while (n73 < n74) {
                        BasicStroke basicStroke = dArray[n73] < 0.0 ? new BasicStroke((float)(-dArray[n73]), 0, 0, 10.0f, Style.DASHED_STROKE, 0.0f) : new BasicStroke((float)dArray[n73]);
                        this.elementSet.elementAt(n73).getStyle().setEdgeStroke(basicStroke);
                        ++n73;
                    }
                } else {
                    if (this.lineWidth == value.getDouble()) break;
                    this.lineWidth = value.getDouble();
                    BasicStroke basicStroke = this.lineWidth < 0.0 ? new BasicStroke((float)(-this.lineWidth), 0, 0, 10.0f, Style.DASHED_STROKE, 0.0f) : new BasicStroke((float)this.lineWidth);
                    int n75 = 0;
                    int n76 = this.elementSet.getNumberOfElements();
                    while (n75 < n76) {
                        this.elementSet.elementAt(n75).getStyle().setEdgeStroke(basicStroke);
                        ++n75;
                    }
                }
                break;
            }
            case 25: {
                Font font;
                if (!(value.getObject() instanceof Font) || (font = (Font)value.getObject()) == this.font) break;
                this.font = font;
                int n77 = 0;
                int n78 = this.elementSet.getNumberOfElements();
                while (n77 < n78) {
                    this.elementSet.elementAt(n77).getStyle().setFont(font);
                    ++n77;
                }
                break;
            }
            case 26: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, value.getString());
                return;
            }
            case 27: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, value.getString());
                return;
            }
            case 28: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                return;
            }
            case 29: {
                this.removeAction(11, this.getProperty("enteredAction"));
                this.addAction(11, value.getString());
                return;
            }
            case 30: {
                this.removeAction(12, this.getProperty("exitedAction"));
                this.addAction(12, value.getString());
                return;
            }
            case 31: {
                this.selectedValue.value = value.getInteger();
                break;
            }
            case 32: {
                this.sensitivity = value.getInteger();
                int n79 = 0;
                int n80 = this.elementSet.getNumberOfElements();
                while (n79 < n80) {
                    this.elementSet.elementAt(n79).setSensitivity(this.sensitivity);
                    ++n79;
                }
                break;
            }
            case 35: {
                this.elementSet.canBeMeasured(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 36, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.checkNumberOfElements(1, true);
                this.numberOfElements_isSet = false;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 33: {
                this.thePos = null;
                break;
            }
            case 4: {
                int n2 = 0;
                int n3 = this.theXs.length;
                while (n2 < n3) {
                    this.theXs[n2] = 0.0;
                    this.elementSet.elementAt(n2).setX(0.0);
                    ++n2;
                }
                break;
            }
            case 5: {
                int n4 = 0;
                int n5 = this.theYs.length;
                while (n4 < n5) {
                    this.theYs[n4] = 0.0;
                    this.elementSet.elementAt(n4).setY(0.0);
                    ++n4;
                }
                break;
            }
            case 6: {
                int n6 = 0;
                int n7 = this.theZs.length;
                while (n6 < n7) {
                    this.theZs[n6] = 0.0;
                    this.elementSet.elementAt(n6).setZ(0.0);
                    ++n6;
                }
                break;
            }
            case 34: {
                this.theSize = null;
                break;
            }
            case 7: {
                int n8 = 0;
                int n9 = this.theSizeXs.length;
                while (n8 < n9) {
                    this.theSizeXs[n8] = 0.1;
                    this.elementSet.elementAt(n8).setSizeX(0.1 * this.scalex);
                    ++n8;
                }
                break;
            }
            case 8: {
                int n10 = 0;
                int n11 = this.theSizeYs.length;
                while (n10 < n11) {
                    this.theSizeYs[n10] = 0.1;
                    this.elementSet.elementAt(n10).setSizeY(0.1 * this.scaley);
                    ++n10;
                }
                break;
            }
            case 9: {
                int n12 = 0;
                int n13 = this.theSizeZs.length;
                while (n12 < n13) {
                    this.theSizeZs[n12] = 0.1;
                    this.elementSet.elementAt(n12).setSizeZ(0.1 * this.scalez);
                    ++n12;
                }
                break;
            }
            case 10: {
                this.elementSet.setVisible(true);
                break;
            }
            case 11: {
                this.elementSet.setEnabled(0, true);
                break;
            }
            case 12: {
                this.elementSet.setEnabled(1, false);
                break;
            }
            case 13: {
                this.scalex = 1.0;
                int n14 = 0;
                int n15 = this.theSizeXs.length;
                while (n14 < n15) {
                    this.elementSet.elementAt(n14).setSizeX(this.theSizeXs[n14]);
                    ++n14;
                }
                break;
            }
            case 14: {
                this.scaley = 1.0;
                int n16 = 0;
                int n17 = this.theSizeYs.length;
                while (n16 < n17) {
                    this.elementSet.elementAt(n16).setSizeY(this.theSizeYs[n16]);
                    ++n16;
                }
                break;
            }
            case 15: {
                this.scalez = 1.0;
                int n18 = 0;
                int n19 = this.theSizeZs.length;
                while (n18 < n19) {
                    this.elementSet.elementAt(n18).setSizeZ(this.theSizeZs[n18]);
                    ++n18;
                }
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                int n20 = 0;
                int n21 = this.elementSet.getNumberOfElements();
                while (n20 < n21) {
                    this.elementSet.elementAt(n20).setGroupEnabled(true);
                    ++n20;
                }
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                int n22 = 0;
                int n23 = this.elementSet.getNumberOfElements();
                while (n22 < n23) {
                    this.elementSet.elementAt(n22).getStyle().setPosition(0);
                    ++n22;
                }
                break;
            }
            case 20: {
                int n24 = 0;
                int n25 = this.elementSet.getNumberOfElements();
                while (n24 < n25) {
                    this.elementSet.elementAt(n24).getStyle().setAngle(0.0);
                    ++n24;
                }
                break;
            }
            case 21: {
                int n26 = 0;
                int n27 = this.elementSet.getNumberOfElements();
                while (n26 < n27) {
                    this.elementSet.elementAt(n26).setResolution(null);
                    ++n26;
                }
                break;
            }
            case 22: {
                int n28 = 0;
                int n29 = this.elementSet.getNumberOfElements();
                while (n28 < n29) {
                    this.elementSet.elementAt(n28).getStyle().setEdgeColor(Color.black);
                    ++n28;
                }
                break;
            }
            case 23: {
                int n30 = 0;
                int n31 = this.elementSet.getNumberOfElements();
                while (n30 < n31) {
                    this.elementSet.elementAt(n30).getStyle().setFillPattern(Color.blue);
                    ++n30;
                }
                break;
            }
            case 24: {
                this.lineWidth = 1.0;
                BasicStroke basicStroke = new BasicStroke((float)1.0);
                int n32 = 0;
                int n33 = this.elementSet.getNumberOfElements();
                while (n32 < n33) {
                    this.elementSet.elementAt(n32).getStyle().setEdgeStroke(basicStroke);
                    ++n32;
                }
                break;
            }
            case 25: {
                this.font = this.defaultFont;
                int n34 = 0;
                int n35 = this.elementSet.getNumberOfElements();
                while (n34 < n35) {
                    this.elementSet.elementAt(n34).getStyle().setFont(this.font);
                    ++n34;
                }
                break;
            }
            case 26: {
                this.removeAction(10, this.getProperty("pressaction"));
                return;
            }
            case 27: {
                this.removeAction(1, this.getProperty("dragaction"));
                return;
            }
            case 28: {
                this.removeAction(0, this.getProperty("action"));
                return;
            }
            case 29: {
                this.removeAction(11, this.getProperty("enteredAction"));
                return;
            }
            case 30: {
                this.removeAction(12, this.getProperty("exitedAction"));
                return;
            }
            case 31: {
                this.selectedValue.value = -1;
                break;
            }
            case 32: {
                this.sensitivity = AbstractInteractiveElement.SENSIBILITY;
                int n36 = 0;
                int n37 = this.elementSet.getNumberOfElements();
                while (n36 < n37) {
                    this.elementSet.elementAt(n36).setSensitivity(this.sensitivity);
                    ++n36;
                }
                break;
            }
            case 35: {
                this.elementSet.canBeMeasured(true);
                break;
            }
            default: {
                super.setDefaultValue(n - 36);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "1";
            }
            case 1: 
            case 2: 
            case 3: {
                return "<none>";
            }
            case 33: {
                return "<none>";
            }
            case 4: 
            case 5: 
            case 6: {
                return "0";
            }
            case 34: {
                return "<none>";
            }
            case 7: 
            case 8: 
            case 9: {
                return "0.1";
            }
            case 10: {
                return "true";
            }
            case 11: {
                return "true";
            }
            case 12: {
                return "false";
            }
            case 13: 
            case 14: 
            case 15: {
                return "1";
            }
            case 16: {
                return "<none>";
            }
            case 17: {
                return "true";
            }
            case 18: {
                return "<none>";
            }
            case 19: {
                return "CENTERED";
            }
            case 20: {
                return "0";
            }
            case 21: {
                return "<none>";
            }
            case 22: {
                return "BLACK";
            }
            case 23: {
                return "BLUE";
            }
            case 24: {
                return "1";
            }
            case 25: {
                return "<none>";
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return "<no_action>";
            }
            case 31: {
                return "-1";
            }
            case 32: {
                return "" + AbstractInteractiveElement.SENSIBILITY;
            }
            case 35: {
                return "true";
            }
        }
        return super.getDefaultValueString(n - 36);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 33: {
                return new ObjectValue(this.thePos);
            }
            case 4: {
                return this.allposValues[0];
            }
            case 5: {
                return this.allposValues[1];
            }
            case 6: {
                return this.allposValues[2];
            }
            case 34: {
                return new ObjectValue(this.theSize);
            }
            case 7: {
                return this.allsizesValue[0];
            }
            case 8: {
                return this.allsizesValue[1];
            }
            case 9: {
                return this.allsizesValue[2];
            }
            case 31: {
                return this.selectedValue;
            }
        }
        if (n < 36) {
            return null;
        }
        return super.getValue(n - 36);
    }

    @Override
    public void interactionPerformed(InteractionEvent interactionEvent) {
        switch (interactionEvent.getID()) {
            case 2004: {
                this.invokeActions(12);
                this.selectedValue.value = -1;
                this.variableExtraChanged(this.getElementSpot(), this.selectedValue);
                break;
            }
            case 2003: {
                this.selectedValue.value = this.elementSet.getInteractedIndex();
                this.variableExtraChanged(this.getElementSpot(), this.selectedValue);
                this.invokeActions(11);
                break;
            }
            case 2000: {
                this.selectedValue.value = this.elementSet.getInteractedIndex();
                this.variableExtraChanged(this.getElementSpot(), this.selectedValue);
                this.invokeActions(10);
            }
            case 2001: {
                InteractionTargetSetElement interactionTargetSetElement = (InteractionTargetSetElement)interactionEvent.getTarget();
                int n = interactionTargetSetElement.getElementIndex();
                if (interactionTargetSetElement.getElementTarget().getClass() == InteractionTargetElementSize.class) {
                    this.theSizeXs[n] = this.scalex != 0.0 ? this.elementSet.elementAt(n).getSizeX() / this.scalex : this.elementSet.elementAt(n).getSizeX();
                    this.theSizeYs[n] = this.scaley != 0.0 ? this.elementSet.elementAt(n).getSizeY() / this.scaley : this.elementSet.elementAt(n).getSizeY();
                    this.theSizeZs[n] = this.scalez != 0.0 ? this.elementSet.elementAt(n).getSizeZ() / this.scalez : this.elementSet.elementAt(n).getSizeZ();
                    if (this.theSize != null) {
                        this.theSize[n][0] = this.theSizeXs[n];
                        this.theSize[n][1] = this.theSizeYs[n];
                        if (this.theSize[n].length > 2) {
                            this.theSize[n][2] = this.theSizeZs[n];
                        }
                        ObjectValue objectValue = new ObjectValue(this.theSize);
                        this.variableChanged(this.getFullSizeSpot(), objectValue);
                        if (!this.isUnderEjs) break;
                        this.setFieldListValue(this.getFullSizeSpot(), objectValue);
                        break;
                    }
                    this.variablesChanged(this.getSizeSpot(), this.allsizesValue);
                    if (!this.isUnderEjs) break;
                    this.setFieldListValues(this.getSizeSpot(), this.allsizesValue);
                    break;
                }
                this.theXs[n] = this.elementSet.elementAt(n).getX();
                this.theYs[n] = this.elementSet.elementAt(n).getY();
                this.theZs[n] = this.elementSet.elementAt(n).getZ();
                if (this.thePos != null) {
                    this.thePos[n][0] = this.theXs[n];
                    this.thePos[n][1] = this.theYs[n];
                    if (this.thePos[n].length > 2) {
                        this.thePos[n][2] = this.theZs[n];
                    }
                    ObjectValue objectValue = new ObjectValue(this.thePos);
                    this.variableChanged(this.getFullPositionSpot(), objectValue);
                    if (!this.isUnderEjs) break;
                    this.setFieldListValue(this.getFullPositionSpot(), objectValue);
                    break;
                }
                this.variablesChanged(this.getPosSpot(), this.allposValues);
                if (!this.isUnderEjs) break;
                this.setFieldListValues(this.getPosSpot(), this.allposValues);
                break;
            }
            case 2002: {
                this.invokeActions(0);
                this.selectedValue.value = -1;
                this.variableExtraChanged(this.getElementSpot(), this.selectedValue);
            }
        }
    }

    private class MyFunction
    extends Function {
        private MyFunction() {
        }

        public double eval() {
            return ControlElementSet.this.elementSet.getInteractedIndex();
        }
    }
}

