/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing2d.Element;

public class ElementShape
extends Element {
    public static final int NONE = 0;
    public static final int ELLIPSE = 1;
    public static final int RECTANGLE = 2;
    public static final int ROUND_RECTANGLE = 3;
    public static final int WHEEL = 4;
    protected int shapeType = -1;
    protected boolean trueSize = false;
    private double[] coordinates = new double[2];
    private double[] pixel = new double[2];
    private double[] pixelSize = new double[2];
    private RectangularShape shape;
    private Line2D line1;
    private Line2D line2;
    private AffineTransform trueSizeTransform = new AffineTransform();

    public ElementShape() {
        this.setSize(new double[]{0.1, 0.1});
        this.setShapeType(1);
    }

    public void setShapeType(int n) {
        if (this.shapeType == n) {
            return;
        }
        this.shapeType = n;
        this.recreateShape();
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public void setPixelSize(boolean bl) {
        this.trueSize = bl;
        this.setNeedToProject(true);
    }

    public boolean isPixelSize() {
        return this.trueSize;
    }

    protected void styleChanged(int n) {
        if (n == 5) {
            this.recreateShape();
            this.setNeedToProject(true);
        }
    }

    protected int getCorners(double[] dArray) {
        if (this.trueSize) {
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            return 1;
        }
        switch (this.getStyle().getRelativePosition()) {
            default: {
                dArray[0] = -0.5;
                dArray[1] = -0.5;
                break;
            }
            case 1: {
                dArray[0] = -0.5;
                dArray[1] = -1.0;
                break;
            }
            case 2: {
                dArray[0] = -0.5;
                dArray[1] = 0.0;
                break;
            }
            case 3: {
                dArray[0] = -1.0;
                dArray[1] = -0.5;
                break;
            }
            case 4: {
                dArray[0] = 0.0;
                dArray[1] = -0.5;
                break;
            }
            case 5: {
                dArray[0] = -1.0;
                dArray[1] = -1.0;
                break;
            }
            case 6: {
                dArray[0] = 0.0;
                dArray[1] = -1.0;
                break;
            }
            case 7: {
                dArray[0] = -1.0;
                dArray[1] = 0.0;
                break;
            }
            case 8: {
                dArray[0] = 0.0;
                dArray[1] = 0.0;
            }
        }
        dArray[4] = dArray[2] = dArray[0] + 1.0;
        dArray[6] = dArray[0];
        dArray[3] = dArray[1];
        dArray[5] = dArray[7] = dArray[1] + 1.0;
        return 4;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        AffineTransform affineTransform;
        if (!this.isReallyVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(this.getStyle().getLineStroke());
        Color color = this.getStyle().getLineColor();
        if (this.shape == null) {
            if (this.hasChanged() || this.needsToProject()) {
                this.projectPoints();
            }
            graphics2D.setColor(color);
            graphics2D.drawOval((int)this.pixel[0], (int)this.pixel[1], 1, 1);
            return;
        }
        Paint paint = this.getStyle().getFillColor();
        if (this.trueSize) {
            if (this.hasChanged() || this.needsToProject()) {
                this.projectPoints();
            }
            affineTransform = new AffineTransform(this.trueSizeTransform);
            affineTransform.preConcatenate(this.getPixelTransform(drawingPanel));
        } else {
            affineTransform = this.getPixelTransform(drawingPanel);
        }
        Shape shape = affineTransform.createTransformedShape(this.shape);
        if (paint != null && this.getStyle().isDrawingFill()) {
            graphics2D.setPaint(paint);
            graphics2D.fill(shape);
        }
        if (color != null && this.getStyle().isDrawingLines()) {
            graphics2D.setColor(color);
            if (this.shapeType == 4) {
                graphics2D.draw(affineTransform.createTransformedShape(this.line1));
                graphics2D.draw(affineTransform.createTransformedShape(this.line2));
            }
            graphics2D.draw(shape);
        }
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        int n3;
        if (!this.targetPosition.isEnabled()) {
            return null;
        }
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        if ((n3 = this.getStyle().getSensitivity()) <= 0) {
            AffineTransform affineTransform;
            if (this.shape == null) {
                if (Math.abs(this.pixel[0] - (double)n) < 1.0 && Math.abs(this.pixel[1] - (double)n2) < 1.0) {
                    return this.targetPosition;
                }
                return null;
            }
            if (this.trueSize) {
                affineTransform = new AffineTransform(this.trueSizeTransform);
                affineTransform.preConcatenate(this.getPixelTransform(drawingPanel));
            } else {
                affineTransform = this.getPixelTransform(drawingPanel);
            }
            Shape shape = affineTransform.createTransformedShape(this.shape);
            if (shape.contains(n, n2)) {
                return this.targetPosition;
            }
        } else if (Math.abs(this.pixel[0] - (double)n) < (double)n3 && Math.abs(this.pixel[1] - (double)n2) < (double)n3) {
            return this.targetPosition;
        }
        return null;
    }

    private void recreateShape() {
        double d;
        double d2;
        if (this.shapeType == 0) {
            this.shape = null;
            return;
        }
        switch (this.getStyle().getRelativePosition()) {
            default: {
                d2 = -0.5;
                d = -0.5;
                break;
            }
            case 1: {
                d2 = -0.5;
                d = -1.0;
                break;
            }
            case 2: {
                d2 = -0.5;
                d = 0.0;
                break;
            }
            case 3: {
                d2 = -1.0;
                d = -0.5;
                break;
            }
            case 4: {
                d2 = 0.0;
                d = -0.5;
                break;
            }
            case 5: {
                d2 = -1.0;
                d = -1.0;
                break;
            }
            case 6: {
                d2 = 0.0;
                d = -1.0;
                break;
            }
            case 7: {
                d2 = -1.0;
                d = 0.0;
                break;
            }
            case 8: {
                d2 = 0.0;
                d = 0.0;
            }
        }
        double d3 = d2 + 1.0;
        double d4 = d + 1.0;
        switch (this.shapeType) {
            case 4: {
                this.line1 = new Line2D.Double(d2 + 0.5, d, d2 + 0.5, d4);
                this.line2 = new Line2D.Double(d2, d + 0.5, d3, d + 0.5);
            }
            default: {
                this.shape = new Ellipse2D.Double(d2, d, 1.0, 1.0);
                break;
            }
            case 2: {
                this.shape = new Rectangle2D.Double(d2, d, 1.0, 1.0);
                break;
            }
            case 3: {
                this.shape = new RoundRectangle2D.Double(d2, d, 1.0, 1.0, 0.3, 0.3);
            }
        }
        this.setElementChanged();
    }

    private void projectPoints() {
        this.coordinates[0] = 0.0;
        this.coordinates[1] = 0.0;
        this.getTotalTransform().transform(this.coordinates, 0, this.coordinates, 0, 1);
        this.getPanel().projectPosition(this.coordinates, this.pixel);
        if (this.trueSize) {
            this.getPanel().projectSize(this.coordinates, this.getSize(), this.pixelSize);
            this.trueSizeTransform = AffineTransform.getScaleInstance(this.pixelSize[0] == 0.0 ? 0.0 : this.getSizeX() / this.pixelSize[0], this.pixelSize[1] == 0.0 ? 0.0 : this.getSizeY() / this.pixelSize[1]);
        }
        this.setNeedToProject(false);
    }
}

