/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Graphics2D;
import org.opensourcephysics.drawing2d.utils.VectorAlgebra;
import org.opensourcephysics.drawing3d.ElementSpring;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementSegment;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class SimpleElementSpring
extends SimpleElementSegment {
    private int loops = -1;
    private int pointsPerLoop = -1;

    public SimpleElementSpring(ElementSpring elementSpring) {
        super(elementSpring);
    }

    public void processChanges(int n, int n2) {
        if ((n2 & 0x136) != 0 || (n2 & 8) != 0) {
            this.computePoints();
            this.projectPoints();
        } else if ((n2 & 0x40) != 0) {
            this.projectPoints();
        }
    }

    public void draw(Graphics2D graphics2D, int n) {
        graphics2D.setStroke(this.style.getLineStroke());
        graphics2D.setColor(this.element.getPanel().projectColor(this.style.getLineColor(), this.objects[n].getDistance()));
        graphics2D.drawLine(this.aCoord[n], this.bCoord[n], this.aCoord[n + 1], this.bCoord[n + 1]);
    }

    public void drawQuickly(Graphics2D graphics2D) {
        graphics2D.setStroke(this.style.getLineStroke());
        graphics2D.setColor(this.style.getLineColor());
        graphics2D.drawPolyline(this.aCoord, this.bCoord, this.aCoord.length);
    }

    private void computePoints() {
        int n;
        int n2 = this.loops;
        int n3 = this.pointsPerLoop;
        Resolution resolution = this.style.getResolution();
        if (resolution == null) {
            n2 = 8;
            n3 = 15;
        } else {
            switch (resolution.getType()) {
                case 0: {
                    n2 = Math.max(resolution.getN1(), 0);
                    n3 = Math.max(resolution.getN2(), 1);
                    break;
                }
                case 1: {
                    n2 = Math.max((int)Math.round(0.49 + this.element.getDiagonalSize() / resolution.getMaxLength()), 1);
                    n3 = 15;
                }
            }
        }
        if (n2 != this.loops || n3 != this.pointsPerLoop) {
            int n4;
            this.loops = n2;
            this.pointsPerLoop = n3;
            this.div = n4 = this.loops * this.pointsPerLoop;
            this.points = new double[n4 + 1][3];
            this.aCoord = new int[n4 + 1];
            this.bCoord = new int[n4 + 1];
            this.objects = new Object3D[n4];
            n = 0;
            while (n < n4) {
                this.objects[n] = new Object3D(this, n);
                ++n;
            }
        }
        ElementSpring elementSpring = (ElementSpring)this.element;
        this.div = n = this.objects.length;
        double d = Math.PI * 2 / (double)this.pointsPerLoop;
        double d2 = elementSpring.getRadius();
        double d3 = elementSpring.getSolenoid();
        if (d2 < 0.0) {
            d *= -1.0;
        }
        int n5 = this.pointsPerLoop / 2;
        double[] dArray = this.element.getSize();
        double[] dArray2 = new double[]{1.0, 0.0, 0.0};
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[1];
        dArray2[2] = dArray[2];
        if (dArray[0] == 0.0) {
            dArray[0] = 1.0;
        }
        if (dArray[1] == 0.0) {
            dArray[1] = 1.0;
        }
        if (dArray[2] == 0.0) {
            dArray[2] = 1.0;
        }
        double[] dArray3 = VectorAlgebra.normalTo(dArray2);
        double[] dArray4 = VectorAlgebra.normalize(VectorAlgebra.crossProduct(dArray2, dArray3));
        int n6 = 0;
        while (n6 <= n) {
            int n7 = elementSpring.isThinExtremes() ? (n6 < n5 ? 0 : (n6 < this.pointsPerLoop ? n6 - n5 : (n6 > n - n5 ? 0 : (n6 > n - this.pointsPerLoop ? n - n6 - n5 : n5)))) : n5;
            double d4 = (double)n6 * d;
            double d5 = Math.cos(d4);
            double d6 = Math.sin(d4);
            if (d3 != 0.0) {
                double d7 = (double)n7 * Math.cos((double)(n6 * 2) * Math.PI / (double)this.pointsPerLoop) / (double)n5;
                int n8 = 0;
                while (n8 < 3) {
                    this.points[n6][n8] = d3 * d7 * dArray2[n8] + (double)n6 * dArray2[n8] / (double)n + (double)n7 * d2 * (d5 * dArray3[n8] + d6 * dArray4[n8]) / (double)n5;
                    ++n8;
                }
            } else {
                int n9 = 0;
                while (n9 < 3) {
                    this.points[n6][n9] = (double)n6 * dArray2[n9] / (double)n + (double)n7 * d2 * (d5 * dArray3[n9] + d6 * dArray4[n9]) / (double)n5;
                    ++n9;
                }
            }
            this.element.toSpaceFrame(this.points[n6]);
            ++n6;
        }
    }
}

