/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3d;
import org.opensourcephysics.display3d.simple3d.utils.VectorAlgebra;
import org.opensourcephysics.drawing3d.ElementSpring;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class Java3dElementSpring
extends Java3dElement {
    private LineStripArray lines = null;
    private BranchGroup bg;
    private TexCoord2f[] texCoord = null;
    private int[] stripVertexCounts = null;
    private double[] points = new double[300];
    private int length = 0;
    private double[] nextPoint = new double[3];

    public Java3dElementSpring(ElementSpring elementSpring) {
        super(elementSpring);
        this.getAppearance().getLineAttributes().setLineAntialiasingEnable(true);
        this.getAppearance().getPointAttributes().setPointSize(0.1f);
        this.element.getStyle().setResolution(new Resolution(8, 15, 1));
        this.element.addChange(8);
    }

    public void processChanges(int n, int n2) {
        super.processChanges(n, n2);
        if ((n & 8) != 0 || (n & 4) != 0) {
            this.computePoints();
        }
        if ((n & 2) != 0 || (n & 0x26) != 0) {
            this.setScaleSpring();
        }
    }

    public void styleChanged(int n) {
        super.styleChanged(n);
        switch (n) {
            case 0: {
                this.element.getStyle().setFillColor(this.element.getStyle().getLineColor());
            }
        }
    }

    public boolean isPrimitive() {
        return true;
    }

    private void init() {
        this.stripVertexCounts = new int[]{Math.max(2, this.length)};
        this.lines = new LineStripArray(this.points.length / 3, 39, this.stripVertexCounts);
        this.lines.setCapability(3);
        this.lines.setCapability(20);
        this.lines.setCapability(1);
        this.lines.setCapability(7);
        this.lines.setCoordinates(0, this.points);
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)new Shape3D((Geometry)this.lines, this.getAppearance()));
        this.addNode((Node)this.bg);
    }

    private void computePoints() {
        this.clear();
        int n = 0;
        int n2 = 0;
        Resolution resolution = this.element.getStyle().getResolution();
        if (resolution != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 0);
                    n2 = Math.max(resolution.getN2(), 1);
                    break;
                }
                case 1: {
                    n = Math.max((int)Math.round(0.49 + this.element.getDiagonalSize() / resolution.getMaxLength()), 1);
                    n2 = 15;
                }
            }
        } else {
            n = 8;
            n2 = 15;
        }
        ElementSpring elementSpring = (ElementSpring)this.element;
        int n3 = n * n2 + 3;
        this.texCoord = new TexCoord2f[n3 + 1];
        double d = Math.PI * 2 / (double)n2;
        double d2 = elementSpring.getRadius();
        double d3 = elementSpring.getSolenoid();
        if (d2 < 0.0) {
            d *= -1.0;
        }
        int n4 = n2 / 2;
        double[] dArray = this.element.getSize();
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[1];
        dArray2[2] = dArray[2];
        if (dArray[0] == 0.0) {
            dArray[0] = 1.0;
        }
        if (dArray[1] == 0.0) {
            dArray[1] = 1.0;
        }
        if (dArray[2] == 0.0) {
            dArray[2] = 1.0;
        }
        this.setScaleSpring();
        double[] dArray3 = VectorAlgebra.normalTo(dArray2);
        double[] dArray4 = VectorAlgebra.normalize(VectorAlgebra.crossProduct(dArray2, dArray3));
        int n5 = 0;
        while (n5 <= n3) {
            double d4;
            double d5;
            double d6;
            int n6 = elementSpring.isThinExtremes() ? (n5 < n4 ? 0 : (n5 < n2 ? n5 - n4 : (n5 > n3 - n4 ? 0 : (n5 > n3 - n2 ? n3 - n5 - n4 : n4)))) : n4;
            double d7 = (double)n5 * d;
            double d8 = Math.cos(d7);
            double d9 = Math.sin(d7);
            if (d3 != 0.0) {
                double d10 = (double)n6 * Math.cos((double)(n5 * 2) * Math.PI / (double)n2) / (double)n4;
                d6 = d3 * d10 * dArray2[0] + (double)n5 * dArray2[0] / (double)n3 + (double)n6 * d2 * (d8 * dArray3[0] + d9 * dArray4[0]) / (double)n4;
                d5 = d3 * d10 * dArray2[1] + (double)n5 * dArray2[1] / (double)n3 + (double)n6 * d2 * (d8 * dArray3[1] + d9 * dArray4[1]) / (double)n4;
                d4 = d3 * d10 * dArray2[2] + (double)n5 * dArray2[2] / (double)n3 + (double)n6 * d2 * (d8 * dArray3[2] + d9 * dArray4[2]) / (double)n4;
                this.addPoint(d6, d5, d4);
            } else {
                d6 = (double)n5 * dArray2[0] / (double)n3 + (double)n6 * d2 * (d8 * dArray3[0] + d9 * dArray4[0]) / (double)n4;
                d5 = (double)n5 * dArray2[1] / (double)n3 + (double)n6 * d2 * (d8 * dArray3[1] + d9 * dArray4[1]) / (double)n4;
                d4 = (double)n5 * dArray2[2] / (double)n3 + (double)n6 * d2 * (d8 * dArray3[2] + d9 * dArray4[2]) / (double)n4;
                this.addPoint(d6, d5, d4);
            }
            ++n5;
        }
    }

    private void setScaleSpring() {
        Transform3D transform3D = new Transform3D();
        Vector3d vector3d = new Vector3d();
        this.getTransformGroup().getTransform(transform3D);
        transform3D.getScale(vector3d);
        vector3d.x = 1.0;
        vector3d.y = 1.0;
        vector3d.z = 1.0;
        transform3D.setScale(vector3d);
        this.getTransformGroup().setTransform(transform3D);
    }

    private void clear() {
        this.length = 0;
        this.init();
    }

    private void addPoint(double d, double d2, double d3) {
        this.nextPoint[0] = d;
        this.nextPoint[1] = d2;
        this.nextPoint[2] = d3;
        if (this.length * 3 == this.points.length) {
            double[] dArray = new double[this.length * 3 * 2];
            System.arraycopy(this.points, 0, dArray, 0, this.length * 3);
            this.points = dArray;
            this.init();
            this.styleChanged(10);
        } else {
            if (this.lines == null) {
                this.init();
            }
            this.updatePoints();
        }
    }

    private void updatePoints() {
        this.points[this.length * 3] = this.nextPoint[0];
        this.points[this.length * 3 + 1] = this.nextPoint[1];
        this.points[this.length * 3 + 2] = this.nextPoint[2];
        this.lines.setCoordinate(this.length, new double[]{this.points[this.length * 3], this.points[this.length * 3 + 1], this.points[this.length * 3 + 2]});
        this.texCoord[this.length] = new TexCoord2f();
        this.texCoord[this.length].x = (float)(this.nextPoint[0] / Math.sqrt(this.nextPoint[0] * this.nextPoint[0] + this.nextPoint[1] * this.nextPoint[1] + this.nextPoint[2] * this.nextPoint[2]));
        this.texCoord[this.length].y = (float)(this.nextPoint[1] / Math.sqrt(this.nextPoint[0] * this.nextPoint[0] + this.nextPoint[1] * this.nextPoint[1] + this.nextPoint[2] * this.nextPoint[2]));
        this.lines.setTextureCoordinate(0, this.length, this.texCoord[this.length]);
        ++this.length;
        if (this.length < 2) {
            this.points[this.length * 3] = this.nextPoint[0];
            this.points[this.length * 3 + 1] = this.nextPoint[1];
            this.points[this.length * 3 + 2] = this.nextPoint[2];
            this.lines.setCoordinate(this.length, new double[]{this.points[this.length * 3], this.points[this.length * 3 + 1], this.points[this.length * 3 + 2]});
            this.texCoord[this.length] = new TexCoord2f();
            this.texCoord[this.length].x = (float)(this.nextPoint[0] / Math.sqrt(this.nextPoint[0] * this.nextPoint[0] + this.nextPoint[1] * this.nextPoint[1] + this.nextPoint[2] * this.nextPoint[2]));
            this.texCoord[this.length].y = (float)(this.nextPoint[1] / Math.sqrt(this.nextPoint[0] * this.nextPoint[0] + this.nextPoint[1] * this.nextPoint[1] + this.nextPoint[2] * this.nextPoint[2]));
            this.lines.setTextureCoordinate(0, this.length, this.texCoord[this.length]);
        }
        this.stripVertexCounts[0] = Math.max(2, this.length);
        this.lines.setStripVertexCounts(this.stripVertexCounts);
    }
}

