/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementSpring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlSpring3D
extends ControlElement3D {
    private static final int SPRING3D_PROPERTIES_ADDED = 5;
    private ElementSpring spring;
    static List<String> infoList = null;

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.ElementSpring";
    }

    @Override
    protected Element createElement() {
        this.spring = new ElementSpring();
        return this.spring;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 5;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("radius");
            infoList.add("solenoid");
            infoList.add("thinExtremes");
            infoList.add("loops");
            infoList.add("pointsPerLoop");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("radius")) {
            return "int|double";
        }
        if (string.equals("solenoid")) {
            return "int|double";
        }
        if (string.equals("thinExtremes")) {
            return "boolean";
        }
        if (string.equals("loops")) {
            return "int";
        }
        if (string.equals("pointsPerLoop")) {
            return "int";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.spring.setRadius(value.getDouble());
                break;
            }
            case 1: {
                this.spring.setSolenoid(value.getDouble());
                break;
            }
            case 2: {
                this.spring.setThinExtremes(value.getBoolean());
                break;
            }
            case 3: {
                this.spring.setResolution(value.getInteger(), this.spring.getPointsPerLoop());
                break;
            }
            case 4: {
                this.spring.setResolution(this.spring.getLoops(), value.getInteger());
                break;
            }
            default: {
                super.setValue(n - 5, value);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.spring.setRadius(0.05);
                break;
            }
            case 1: {
                this.spring.setSolenoid(0.0);
                break;
            }
            case 2: {
                this.spring.setThinExtremes(true);
                break;
            }
            case 3: {
                this.spring.setResolution(8, this.spring.getPointsPerLoop());
                break;
            }
            case 4: {
                this.spring.setResolution(this.spring.getLoops(), 15);
                break;
            }
            default: {
                super.setDefaultValue(n - 5);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return Double.toString(0.05);
            }
            case 1: {
                return "0.0";
            }
            case 2: {
                return "true";
            }
            case 3: {
                return Integer.toString(8);
            }
            case 4: {
                return Integer.toString(15);
            }
        }
        return super.getDefaultValueString(n - 5);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(n - 5);
    }
}

