/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing2d.DrawingPanel;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.interaction.InteractionTarget;

public class ElementSegment
extends Element {
    protected static final Line2D.Double NORMAL_LINE = new Line2D.Double(0.0, 0.0, 1.0, 1.0);
    protected static final Line2D.Double CENTERED_LINE = new Line2D.Double(-0.5, -0.5, 0.5, 0.5);
    protected static final double[] STD_CENTERED_ORIGIN = new double[]{-0.5, -0.5};
    protected static final double[] STD_CENTERED_END = new double[]{0.5, 0.5};
    protected static final double[] STD_CENTERED_TRIANGLE_ORIGIN = new double[]{-0.4, -0.4};
    protected static final double[] STD_CENTERED_TRIANGLE_END = new double[]{0.6, 0.6};
    protected double[] origin = new double[2];
    protected double[] end = new double[2];
    protected double[] pixelOrigin = new double[2];
    protected double[] pixelEnd = new double[2];
    protected double[] center = new double[2];
    protected double[] pixelCenter = new double[2];
    protected Line2D.Double line = NORMAL_LINE;
    protected int arrowType = 0;

    public ElementSegment() {
        this.setSize(new double[]{0.1, 0.1});
        this.getStyle().setRelativePosition(5);
    }

    @Override
    protected void styleChanged(int styleThatChanged) {
        if (styleThatChanged == 5) {
            switch (this.getStyle().getRelativePosition()) {
                default: {
                    this.line = NORMAL_LINE;
                    break;
                }
                case 0: {
                    this.line = CENTERED_LINE;
                }
            }
            this.setNeedToProject(true);
        }
    }

    @Override
    public void draw(org.opensourcephysics.display.DrawingPanel _panel, Graphics _g) {
        if (!this.isReallyVisible()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)_g;
        g2.setStroke(this.getStyle().getLineStroke());
        g2.setColor(this.getStyle().getLineColor());
        g2.draw(this.getPixelTransform(_panel).createTransformedShape(this.line));
    }

    @Override
    protected double[] getHotSpotBodyCoordinates(InteractionTarget target) {
        switch (this.getStyle().getRelativePosition()) {
            default: {
                if (target == this.targetPosition) {
                    return new double[]{0.0, 0.0};
                }
                if (target != this.targetSize) break;
                return new double[]{this.getSizeX() != 0.0 ? 1 : 0, this.getSizeY() != 0.0 ? 1 : 0};
            }
            case 0: {
                if (target == this.targetPosition) {
                    return new double[]{0.0, 0.0};
                }
                if (target != this.targetSize) break;
                return new double[]{this.getSizeX() == 0.0 ? 0.0 : 0.5, this.getSizeY() == 0.0 ? 0.0 : 0.5};
            }
        }
        return null;
    }

    @Override
    public Interactive findInteractive(org.opensourcephysics.display.DrawingPanel _panel, int _xpix, int _ypix) {
        if (!this.targetPosition.isEnabled() && !this.targetSize.isEnabled()) {
            return null;
        }
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.needsToProject()) {
            this.projectPoints();
        }
        int sensitivity = this.getStyle().getSensitivity();
        switch (this.getStyle().getRelativePosition()) {
            default: {
                if (this.targetPosition.isEnabled() && Math.abs(this.pixelOrigin[0] - (double)_xpix) < (double)sensitivity && Math.abs(this.pixelOrigin[1] - (double)_ypix) < (double)sensitivity) {
                    return this.targetPosition;
                }
                if (!this.targetSize.isEnabled() || !(Math.abs(this.pixelEnd[0] - (double)_xpix) < (double)sensitivity) || !(Math.abs(this.pixelEnd[1] - (double)_ypix) < (double)sensitivity)) break;
                return this.targetSize;
            }
            case 0: {
                if (this.targetPosition.isEnabled() && Math.abs(this.pixelCenter[0] - (double)_xpix) < (double)sensitivity && Math.abs(this.pixelCenter[1] - (double)_ypix) < (double)sensitivity) {
                    return this.targetPosition;
                }
                if (!this.targetSize.isEnabled() || !(Math.abs(this.pixelEnd[0] - (double)_xpix) < (double)sensitivity) || !(Math.abs(this.pixelEnd[1] - (double)_ypix) < (double)sensitivity)) break;
                return this.targetSize;
            }
            case 8: {
                if (this.targetPosition.isEnabled() && Math.abs(this.pixelEnd[0] - (double)_xpix) < (double)sensitivity && Math.abs(this.pixelEnd[1] - (double)_ypix) < (double)sensitivity) {
                    return this.targetPosition;
                }
                if (!this.targetSize.isEnabled() || !(Math.abs(this.pixelOrigin[0] - (double)_xpix) < (double)sensitivity) || !(Math.abs(this.pixelOrigin[1] - (double)_ypix) < (double)sensitivity)) break;
                return this.targetSize;
            }
        }
        return null;
    }

    protected void projectPoints() {
        switch (this.getStyle().getRelativePosition()) {
            default: {
                this.getTotalTransform().transform(STD_ORIGIN, 0, this.origin, 0, 1);
                this.getTotalTransform().transform(STD_END, 0, this.end, 0, 1);
                break;
            }
            case 0: {
                if (this.arrowType == 3) {
                    this.getTotalTransform().transform(STD_CENTERED_TRIANGLE_ORIGIN, 0, this.origin, 0, 1);
                    this.getTotalTransform().transform(STD_CENTERED_TRIANGLE_END, 0, this.end, 0, 1);
                } else {
                    this.getTotalTransform().transform(STD_CENTERED_ORIGIN, 0, this.origin, 0, 1);
                    this.getTotalTransform().transform(STD_CENTERED_END, 0, this.end, 0, 1);
                }
                this.getTotalTransform().transform(STD_ORIGIN, 0, this.center, 0, 1);
                this.getPanel().projectPosition(this.center, this.pixelCenter);
                break;
            }
            case 8: {
                this.getTotalTransform().transform(STD_ORIGIN, 0, this.end, 0, 1);
                this.getTotalTransform().transform(STD_END, 0, this.origin, 0, 1);
            }
        }
        DrawingPanel panel = this.getPanel();
        if (panel != null) {
            panel.projectPosition(this.origin, this.pixelOrigin);
            panel.projectPosition(this.end, this.pixelEnd);
            this.setNeedToProject(false);
        }
    }
}

