/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.bartonpendulum_pkg;

import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JOptionPane;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEInterpolatorEventSolver;
import org.opensourcephysics.numerics.ODESolverInterpolator;
import org.opensourcephysics.numerics.rk.RK4;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.ntnu.fkh.bartonpendulum_pkg.bartonpendulumSimulation;
import users.ntnu.fkh.bartonpendulum_pkg.bartonpendulumView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class bartonpendulum
extends AbstractModel {
    public bartonpendulumSimulation _simulation = null;
    public bartonpendulumView _view = null;
    public bartonpendulum _model = this;
    protected Hashtable<String, __PrivateODE> _privateOdesList = new Hashtable();
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double range = 20.0;
    public double xmin = -this.range / 2.0;
    public double xmax = this.range / 2.0;
    public double ymin = -this.range / 2.0;
    public double ymax = this.range / 2.0;
    public double zmin = -this.range / 2.0;
    public double zmax = this.range / 2.0;
    public double t = 0.0;
    public double dt = 0.05;
    public double size = this.range / 40.0;
    public double size2 = this.size / 2.0;
    public double stroke = 2.0;
    public double pi = Math.PI;
    public int npt = 500;
    public double g = 10.0;
    public double couple = 0.2;
    public double gcst = this.g * this.couple;
    public boolean show = false;
    public int n = 10;
    public double[] x;
    public double[] y;
    public double[] z;
    public double[] c;
    public double[] w;
    public int nd = 20;
    public double d = (this.xmax - this.xmin) / (double)this.nd;
    public double[] L;
    public double[] dx;
    public double[] dy;
    public double[] dz;
    public double[] xm;
    public double[] ym;
    public double[] zm;
    public double[] zm2;
    public String[] sid;
    public double[] vy;
    public double[] vz;
    public double ci;
    public double c0 = this.pi / 6.0;
    public double w0 = 0.0;
    public double cc = this.c0 * 3.0 / 8.0;
    public int nd2 = 5;
    public double xc = this.xmax - (double)this.nd2 * this.d;
    public double dd = 3.0 * this.d;
    public double yc = this.dd * Math.sin(this.cc);
    public double zc = this.zmax - this.dd * Math.cos(this.cc);
    public double L0 = (double)this.nd2 * this.d;
    public double dxc;
    public double dyc;
    public double dzc;
    public double mxc;
    public double myc;
    public double mzc;
    public double sd;
    public double gcst2 = this.gcst / (double)this.n;
    public int ID = 5;
    public double ci0 = this.pi / 6.0;
    public double ci0a = 30.0;
    public double vyc;
    public double vzc;
    public int fps = 20;
    public boolean faster = false;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_constraints1 = true;
    private _ODE_evolution1 _ODEi_evolution1;

    public ODEInterpolatorEventSolver _getEventSolver(String string) {
        try {
            return this._privateOdesList.get(string).__getEventSolver();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void _setSolverClass(String string, Class<?> clazz) {
        try {
            this._privateOdesList.get(string).__setSolverClass(clazz);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
        }
    }

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/ntnu/fkh/bartonpendulum.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.2/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.2/bin/config/");
        }
        bartonpendulum bartonpendulum2 = new bartonpendulum(stringArray);
    }

    public bartonpendulum() {
        this(null, null, null, null, null, false);
    }

    public bartonpendulum(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public bartonpendulum(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new bartonpendulumSimulation(this, string, frame, uRL, bl);
        this._view = (bartonpendulumView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.__resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("Evol Page".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
            this._resetSolvers();
        }
        if ("FixRel Page".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.t = 0.0;
        this.ci0 = this.ci0a * this.pi / 180.0;
        for (int i = 0; i < this.n; ++i) {
            this.L[i] = (double)(i + 1) * this.d;
            this.xm[i] = this.x[i] = this.xmin + (double)(i + 1) * this.d;
            this.dx[i] = 0.0;
            this.c[i] = 0.0;
            this.w[i] = 0.0;
            this.sid[i] = i + 1 + "";
        }
        this.c0 = this.ci0;
        this.w0 = 0.0;
        this.xc = this.xmax - (double)this.nd2 * this.d;
        this.dxc = 0.0;
        this.mxc = this.xc + this.dxc;
        this._setFPS(this.fps);
    }

    public void _constraints1() {
        this.cc = this.c0 * this.dd / this.L0;
        this.yc = this.dd * Math.sin(this.cc);
        this.zc = this.zmax - 3.0 * this.d * Math.cos(this.cc);
        for (int i = 0; i < this.n; ++i) {
            this.ci = this.cc * (double)(i + 1) / (double)(this.nd - this.nd2);
            this.y[i] = (double)(i + 1) * this.dd * Math.sin(this.ci) / (double)(this.nd - this.nd2);
            this.z[i] = this.zmax - this.dd * (double)(i + 1) / (double)(this.nd - this.nd2) * Math.cos(this.ci);
            this.dy[i] = this.L[i] * Math.sin(this.c[i]);
            this.dz[i] = -this.L[i] * Math.cos(this.c[i]);
            this.ym[i] = this.y[i] + this.dy[i];
            this.zm[i] = this.z[i] + this.dz[i];
            this.zm2[i] = this.zm[i] - this.size * 2.5;
            this.vy[i] = this.L[i] * this.w[i] * Math.cos(this.c[i]);
            this.vz[i] = this.L[i] * this.w[i] * Math.sin(this.c[i]);
        }
        this.vyc = this.L0 * this.w0 * Math.cos(this.c0);
        this.vzc = this.L0 * this.w0 * Math.sin(this.c0);
        this.dyc = this.L0 * Math.sin(this.c0);
        this.dzc = -this.L0 * Math.cos(this.c0);
        this.myc = this.yc + this.dyc;
        this.mzc = this.zc + this.dzc;
    }

    public double _method_for_segment3D_sizeX() {
        return this.xmax - this.xmin;
    }

    public double _method_for_particle3D_sizeX() {
        return this.size * 2.0;
    }

    public double _method_for_particle3D_sizeY() {
        return this.size * 2.0;
    }

    public double _method_for_particle3D_sizeZ() {
        return this.size * 2.0;
    }

    public double _method_for_segment3D3L_sizeX() {
        return this.xc - this.xmax;
    }

    public double _method_for_segment3D3L_sizeZ() {
        return this.zc - this.zmax;
    }

    public double _method_for_segment3D3R_sizeX() {
        return this.xc - this.xmin;
    }

    public double _method_for_segment3D3R_sizeZ() {
        return this.zc - this.zmax;
    }

    public void _method_for_playPauseButton_actionOn() {
        this._play();
    }

    public void _method_for_playPauseButton_actionOff() {
        this._pause();
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public void _method_for_sliderIDC_dragaction() {
        this.L0 = (double)this.ID * this.d;
    }

    public void _method_for_slider_dragaction() {
        this._initialize();
    }

    public void _method_for_checkBox2_action() {
        this.fps = this.faster ? 50 : 20;
        this._setFPS(this.fps);
    }

    @Override
    public void reset() {
        int n;
        this._isEnabled_initialization1 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_constraints1 = true;
        this.range = 20.0;
        this.xmin = -this.range / 2.0;
        this.xmax = this.range / 2.0;
        this.ymin = -this.range / 2.0;
        this.ymax = this.range / 2.0;
        this.zmin = -this.range / 2.0;
        this.zmax = this.range / 2.0;
        this.t = 0.0;
        this.dt = 0.05;
        this.size = this.range / 40.0;
        this.size2 = this.size / 2.0;
        this.stroke = 2.0;
        this.pi = Math.PI;
        this.npt = 500;
        this.g = 10.0;
        this.couple = 0.2;
        this.gcst = this.g * this.couple;
        this.show = false;
        this.n = 10;
        this.x = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.x[n] = 0.0;
        }
        this.y = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.y[n] = 0.0;
        }
        this.z = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.z[n] = 0.0;
        }
        this.c = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.c[n] = 0.0;
        }
        this.w = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.w[n] = 0.0;
        }
        this.nd = 20;
        this.d = (this.xmax - this.xmin) / (double)this.nd;
        this.L = new double[this.n];
        this.dx = new double[this.n];
        this.dy = new double[this.n];
        this.dz = new double[this.n];
        this.xm = new double[this.n];
        this.ym = new double[this.n];
        this.zm = new double[this.n];
        this.zm2 = new double[this.n];
        this.sid = new String[this.n];
        this.vy = new double[this.n];
        this.vz = new double[this.n];
        this.c0 = this.pi / 6.0;
        this.w0 = 0.0;
        this.cc = this.c0 * 3.0 / 8.0;
        this.nd2 = 5;
        this.xc = this.xmax - (double)this.nd2 * this.d;
        this.dd = 3.0 * this.d;
        this.yc = this.dd * Math.sin(this.cc);
        this.zc = this.zmax - this.dd * Math.cos(this.cc);
        this.L0 = (double)this.nd2 * this.d;
        this.gcst2 = this.gcst / (double)this.n;
        this.ID = 5;
        this.ci0 = this.pi / 6.0;
        this.ci0a = 30.0;
        this.fps = 20;
        this.faster = false;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public void initialize() {
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        this._resetSolvers();
    }

    @Override
    public void step() {
        if (this._isEnabled_evolution1) {
            this._ODEi_evolution1.__stepODE();
        }
    }

    @Override
    public void update() {
        if (this._isEnabled_constraints1) {
            this._constraints1();
        }
    }

    @Override
    public void _freeMemory() {
        this.x = null;
        this.y = null;
        this.z = null;
        this.c = null;
        this.w = null;
        this.L = null;
        this.dx = null;
        this.dy = null;
        this.dz = null;
        this.xm = null;
        this.ym = null;
        this.zm = null;
        this.zm2 = null;
        this.sid = null;
        this.vy = null;
        this.vz = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _ODE_evolution1
    implements __PrivateODE {
        private ODESolverInterpolator __solver = null;
        private ODEInterpolatorEventSolver __eventSolver = null;
        private Class<?> __solverClass = RK4.class;
        private double[] __state = null;
        private boolean __ignoreErrors = false;
        private boolean __mustReinitialize = true;
        private double[] _c;
        private double[] _w;

        _ODE_evolution1() {
            this.__initializeSolver();
            bartonpendulum.this._privateOdesList.put("Evol Page", this);
        }

        @Override
        public ODEInterpolatorEventSolver __getEventSolver() {
            return this.__eventSolver;
        }

        @Override
        public void __setSolverClass(Class<?> clazz) {
            this.__solverClass = clazz;
            this.__initializeSolver();
        }

        private void __initializeSolver() {
            this.__state = new double[3 + bartonpendulum.this.c.length + bartonpendulum.this.w.length];
            this._c = new double[bartonpendulum.this.c.length];
            this._w = new double[bartonpendulum.this.w.length];
            this.__pushState();
            try {
                Class[] classArray = new Class[]{ODE.class};
                Object[] objectArray = new Object[]{this};
                Constructor<?> constructor = this.__solverClass.getDeclaredConstructor(classArray);
                this.__solver = (ODESolverInterpolator)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.__eventSolver = new ODEInterpolatorEventSolver(this.__solver);
            this.__eventSolver.initialize(bartonpendulum.this.dt);
            this.__eventSolver.setBestInterpolation(false);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setEstimateFirstStep(false);
            this.__eventSolver.setEnableExceptions(false);
            this.__mustReinitialize = true;
            this.__eventSolver.setTolerances(1.0E-5, 1.0E-5);
        }

        private void __pushState() {
            int n;
            int n2;
            int n3 = 0;
            if (this.__state[n3] != bartonpendulum.this.c0) {
                this.__mustReinitialize = true;
            }
            this.__state[n3++] = bartonpendulum.this.c0;
            if (this.__state[n3] != bartonpendulum.this.w0) {
                this.__mustReinitialize = true;
            }
            this.__state[n3++] = bartonpendulum.this.w0;
            if (!this.__mustReinitialize) {
                n2 = 0;
                n = n3;
                while (n2 < bartonpendulum.this.c.length) {
                    if (this.__state[n] != bartonpendulum.this.c[n2]) {
                        this.__mustReinitialize = true;
                        break;
                    }
                    ++n2;
                    ++n;
                }
            }
            System.arraycopy(bartonpendulum.this.c, 0, this.__state, n3, bartonpendulum.this.c.length);
            n3 += bartonpendulum.this.c.length;
            if (!this.__mustReinitialize) {
                n2 = 0;
                n = n3;
                while (n2 < bartonpendulum.this.w.length) {
                    if (this.__state[n] != bartonpendulum.this.w[n2]) {
                        this.__mustReinitialize = true;
                        break;
                    }
                    ++n2;
                    ++n;
                }
            }
            System.arraycopy(bartonpendulum.this.w, 0, this.__state, n3, bartonpendulum.this.w.length);
            if (this.__state[n3 += bartonpendulum.this.w.length] != bartonpendulum.this.t) {
                this.__mustReinitialize = true;
            }
            this.__state[n3++] = bartonpendulum.this.t;
        }

        private boolean __arraysChanged() {
            if (bartonpendulum.this.c.length != this._c.length) {
                return true;
            }
            return bartonpendulum.this.w.length != this._w.length;
        }

        public void __resetSolver() {
            this.__mustReinitialize = true;
        }

        private void __errorAction() {
            if (this.__ignoreErrors) {
                return;
            }
            System.err.println(this.__eventSolver.getErrorMessage());
            bartonpendulumSimulation cfr_ignored_0 = bartonpendulum.this._simulation;
            bartonpendulumSimulation cfr_ignored_1 = bartonpendulum.this._simulation;
            int n = JOptionPane.showConfirmDialog(bartonpendulum.this._view.getComponent(bartonpendulum.this._simulation.getMainWindow()), bartonpendulumSimulation.getEjsString("ODEError.Continue"), bartonpendulumSimulation.getEjsString("Error"), 1);
            if (n == 0) {
                this.__ignoreErrors = true;
            } else if (n == 2) {
                bartonpendulum.this._pause();
            }
        }

        void __stepODE() {
            if (this.__arraysChanged()) {
                this.__initializeSolver();
            }
            this.__eventSolver.setStepSize(bartonpendulum.this.dt);
            this.__eventSolver.setInternalStepSize(bartonpendulum.this.dt);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setTolerances(1.0E-5, 1.0E-5);
            this.__pushState();
            if (this.__mustReinitialize) {
                this.__eventSolver.reinitialize();
                this.__mustReinitialize = false;
            }
            double d = this.__eventSolver.step();
            int n = 0;
            bartonpendulum.this.c0 = this.__state[n++];
            bartonpendulum.this.w0 = this.__state[n++];
            System.arraycopy(this.__state, n, bartonpendulum.this.c, 0, bartonpendulum.this.c.length);
            System.arraycopy(this.__state, n += bartonpendulum.this.c.length, bartonpendulum.this.w, 0, bartonpendulum.this.w.length);
            n += bartonpendulum.this.w.length;
            bartonpendulum.this.t = this.__state[n++];
            if (Double.isNaN(d)) {
                this.__errorAction();
            }
        }

        @Override
        public double[] getState() {
            return this.__state;
        }

        @Override
        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            dArray2[dArray2.length - 1] = 0.0;
            int n2 = -1;
            int n3 = 0;
            double d = dArray[n3++];
            double d2 = dArray[n3++];
            double[] dArray3 = this._c;
            System.arraycopy(dArray, n3, this._c, 0, this._c.length);
            double[] dArray4 = this._w;
            System.arraycopy(dArray, n3 += this._c.length, this._w, 0, this._w.length);
            n3 += this._w.length;
            double d3 = dArray[n3++];
            bartonpendulum.this.cc = d * bartonpendulum.this.dd / bartonpendulum.this.L0;
            n3 = 0;
            dArray2[n3++] = d2;
            dArray2[n3++] = -bartonpendulum.this.g * Math.sin(d) / bartonpendulum.this.L0 - bartonpendulum.this.gcst * Math.sin(d * bartonpendulum.this.dd / bartonpendulum.this.L0) / bartonpendulum.this.L0;
            int n4 = this._c.length;
            for (n = 0; n < n4; ++n) {
                dArray2[n3++] = dArray4[n];
            }
            n4 = this._w.length;
            for (n = 0; n < n4; ++n) {
                dArray2[n3++] = -bartonpendulum.this.g * Math.sin(dArray3[n]) / bartonpendulum.this.L[n] + bartonpendulum.this.gcst * Math.sin(d * bartonpendulum.this.dd / bartonpendulum.this.L0) / bartonpendulum.this.L[n] / (double)bartonpendulum.this.n;
            }
            dArray2[n3++] = 1.0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface __PrivateODE
    extends ODE {
        public ODEInterpolatorEventSolver __getEventSolver();

        public void __setSolverClass(Class<?> var1);
    }
}

