/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display3d.java3d.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementTrail
extends Element
implements org.opensourcephysics.display3d.core.ElementTrail,
GeometryUpdater {
    private String[] inputLabels = new String[]{"x", "y", "z"};
    public static final int NO_MAXIMUM = -1;
    private int maximumPoints = -1;
    private int length;
    private boolean connected = true;
    private LineStripArray lines;
    private double[] points;
    private double[] nextPoint;
    private int[] stripVertexCounts;
    protected int datasetID = this.hashCode();

    public ElementTrail() {
        this.setSizeXYZ(1.0, 1.0, 1.0);
        this.length = 0;
        this.points = new double[300];
        this.nextPoint = new double[3];
        this.getStyle().setDrawingFill(false);
        this.getStyle().setDrawingLines(true);
        this.getStyle().setLineColor(Color.black);
        this.init();
    }

    void init() {
        this.stripVertexCounts = new int[]{Math.max(2, this.length)};
        this.lines = new LineStripArray(this.points.length / 3, 129, this.stripVertexCounts);
        this.lines.setCapability(19);
        this.lines.setCapability(21);
        this.lines.setCapability(8);
        this.lines.setCapability(20);
        this.lines.setCapability(1);
        this.lines.setCoordRefDouble(this.points);
        this.setNode((Node)new Shape3D((Geometry)this.lines, this.getAppearance()));
    }

    @Override
    public void addPoint(double d, double d2, double d3) {
        this.nextPoint[0] = d;
        this.nextPoint[1] = d2;
        this.nextPoint[2] = d3;
        if (this.length == this.maximumPoints * 2) {
            this.lines.updateData((GeometryUpdater)this);
        } else if (this.length * 3 == this.points.length) {
            int n = this.maximumPoints == -1 ? this.length * 3 * 2 : Math.min(this.length * 3 * 2, this.maximumPoints * 3 * 2);
            double[] dArray = new double[n];
            System.arraycopy(this.points, 0, dArray, 0, this.length * 3);
            this.points = dArray;
            this.init();
        } else {
            this.lines.updateData((GeometryUpdater)this);
        }
    }

    public void updateData(Geometry geometry) {
        if (this.length == this.maximumPoints * 2) {
            int n = 0;
            while (n < this.length - 2) {
                this.points[n * 3] = this.points[(n + 1) * 3];
                this.points[n * 3 + 1] = this.points[(n + 1) * 3 + 1];
                this.points[n * 3 + 2] = this.points[(n + 1) * 3 + 2];
                ++n;
            }
            --this.length;
        }
        this.points[this.length * 3] = this.nextPoint[0];
        this.points[this.length * 3 + 1] = this.nextPoint[1];
        this.points[this.length * 3 + 2] = this.nextPoint[2];
        ++this.length;
        this.stripVertexCounts[0] = Math.max(2, this.length);
        if (this.length < 2) {
            this.points[this.length * 3] = this.nextPoint[0];
            this.points[this.length * 3 + 1] = this.nextPoint[1];
            this.points[this.length * 3 + 2] = this.nextPoint[2];
        }
        ((LineStripArray)geometry).setStripVertexCounts(this.stripVertexCounts);
    }

    @Override
    public void addPoint(double[] dArray) {
        this.addPoint(dArray[0], dArray[1], dArray[2]);
    }

    @Override
    public void setMaximumPoints(int n) {
        this.maximumPoints = n;
    }

    @Override
    public int getMaximumPoints() {
        return this.maximumPoints;
    }

    @Override
    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void moveToPoint(double d, double d2, double d3) {
        boolean bl = this.connected;
        this.connected = false;
        this.addPoint(d, d2, d3);
        this.connected = bl;
    }

    @Override
    public void clear() {
        this.length = 0;
        this.init();
    }

    @Override
    public void setXLabel(String string) {
        this.inputLabels[0] = string;
    }

    @Override
    public void setYLabel(String string) {
        this.inputLabels[1] = string;
    }

    @Override
    public void setZLabel(String string) {
        this.inputLabels[2] = string;
    }

    public int getNumberOfPoints() {
        return this.length;
    }

    @Override
    public void setGhostPoint(double[] dArray, boolean bl) {
    }

    @Override
    public void setID(int n) {
        this.datasetID = n;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    @Override
    public double[][] getData2D() {
        double[][] dArray = new double[this.points.length / 3][3];
        int n = 0;
        int n2 = dArray.length;
        int n3 = -1;
        while (n < n2) {
            dArray[0][n] = this.points[++n3];
            dArray[1][n] = this.points[++n3];
            dArray[2][n] = this.points[++n3];
            ++n;
        }
        return dArray;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return this.inputLabels;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), DisplayColors.getLineColor(2)};
    }

    @Override
    public Color[] getFillColors() {
        return new Color[]{this.getStyle().getFillColor(), this.getStyle().getFillColor(), this.getStyle().getFillColor()};
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }
}

