/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.java3d.ElementSurface;

public class ElementPlane
extends ElementSurface
implements org.opensourcephysics.display3d.core.ElementPlane {
    private double[] vectorU = new double[]{1.0, 0.0, 0.0};
    private double[] vectorV = new double[]{0.0, 1.0, 0.0};
    private double[] sizeArray = new double[]{1.0, 1.0, 1.0};
    private int nu = -1;
    private int nv = -1;
    private double vectorUSize = 1.0;
    private double vectorVSize = 1.0;

    public ElementPlane() {
        this.setXYZ(0.0, 0.0, 0.0);
        super.setSizeXYZ(1.0, 1.0, 1.0);
    }

    public void processChanges(int n) {
        super.processChanges(n);
        if ((n & 2) != 0 || (n & 8) != 0) {
            this.computeCorners();
        }
    }

    public void setFirstDirection(double[] dArray) {
        this.vectorU[0] = dArray[0];
        this.vectorU[1] = dArray[1];
        this.vectorU[2] = dArray[2];
        this.vectorUSize = Math.sqrt(this.vectorU[0] * this.vectorU[0] + this.vectorU[1] * this.vectorU[1] + this.vectorU[2] * this.vectorU[2]);
        this.setElementChanged(2);
    }

    public double[] getFirstDirection() {
        return new double[]{this.vectorU[0], this.vectorU[1], this.vectorU[2]};
    }

    public void setSecondDirection(double[] dArray) {
        this.vectorV[0] = dArray[0];
        this.vectorV[1] = dArray[1];
        this.vectorV[2] = dArray[2];
        this.vectorVSize = Math.sqrt(this.vectorV[0] * this.vectorV[0] + this.vectorV[1] * this.vectorV[1] + this.vectorV[2] * this.vectorV[2]);
        this.setElementChanged(2);
    }

    public double[] getSecondDirection() {
        return new double[]{this.vectorU[0], this.vectorU[1], this.vectorU[2]};
    }

    protected synchronized void computeCorners() {
        if (this.vectorU == null || this.vectorV == null) {
            return;
        }
        int n = 1;
        int n2 = 1;
        Resolution resolution = this.getStyle().getResolution();
        if (resolution != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    break;
                }
                case 1: {
                    n = Math.max((int)Math.round(0.49 + Math.abs(this.sizeArray[0]) * this.vectorUSize / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(this.sizeArray[1]) * this.vectorVSize / resolution.getMaxLength()), 1);
                }
            }
        }
        if (this.nu != ++n || this.nv != ++n2) {
            this.nu = n;
            this.nv = n2;
            this.data = new double[this.nu][this.nv][3];
        }
        double d = this.sizeArray[0] / (double)(this.nu - 1);
        double d2 = this.sizeArray[1] / (double)(this.nv - 1);
        int n3 = 0;
        while (n3 < this.nu) {
            double d3 = (double)n3 * d - this.sizeArray[0] / 2.0;
            int n4 = 0;
            while (n4 < this.nv) {
                double d4 = (double)n4 * d2 - this.sizeArray[1] / 2.0;
                int n5 = 0;
                while (n5 < 3) {
                    this.data[n3][n4][n5] = d3 * this.vectorU[n5] + d4 * this.vectorV[n5];
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        this.setData(this.data);
    }

    public void setSizeX(double d) {
        this.sizeArray[0] = d;
        this.setElementChanged(2);
    }

    public void setSizeY(double d) {
        this.sizeArray[1] = d;
        this.setElementChanged(2);
    }

    public void setSizeZ(double d) {
        this.sizeArray[2] = d;
        this.setElementChanged(2);
    }

    public void setSizeXYZ(double d, double d2, double d3) {
        if (this.sizeArray == null) {
            return;
        }
        this.sizeArray[0] = d;
        this.sizeArray[1] = d2;
        this.sizeArray[2] = d3;
        this.setElementChanged(2);
    }

    public void setSizeXYZ(double[] dArray) {
        this.sizeArray[0] = dArray[0];
        this.sizeArray[1] = dArray[1];
        if (dArray.length > 2) {
            this.sizeArray[2] = dArray[2];
        }
        this.setElementChanged(2);
    }

    public double getSizeX() {
        return this.sizeArray[0];
    }

    public double getSizeY() {
        return this.sizeArray[1];
    }

    public double getSizeZ() {
        return this.sizeArray[2];
    }
}

