/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.vecmath.Vector3f;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.java3d.Element;

public class ElementBox
extends Element
implements org.opensourcephysics.display3d.core.ElementBox {
    private double[][][] data;
    private Vector3f[] normals;
    private boolean hasTop = true;
    private boolean hasBottom = true;
    private QuadArray qa;
    private Shape3D shape = new Shape3D();

    public ElementBox() {
        this.shape.setAppearance(this.getAppearance());
        this.getStyle().setResolution(new Resolution(3, 3, 3));
        this.getStyle().setDrawingLines(false);
        this.setNode((Node)this.shape);
    }

    public void setClosedBottom(boolean bl) {
        if (bl != this.hasBottom) {
            this.hasBottom = bl;
            this.data = null;
            this.checkData();
        }
        if (bl) {
            this.getAppearance().getPolygonAttributes().setCullFace(1);
        } else {
            this.getAppearance().getPolygonAttributes().setCullFace(0);
        }
    }

    public boolean isClosedBottom() {
        return this.hasBottom;
    }

    public void setClosedTop(boolean bl) {
        if (bl != this.hasTop) {
            this.hasTop = bl;
            this.data = null;
            this.checkData();
        }
        if (bl) {
            this.getAppearance().getPolygonAttributes().setCullFace(1);
        } else {
            this.getAppearance().getPolygonAttributes().setCullFace(0);
        }
    }

    public boolean isClosedTop() {
        return this.hasTop;
    }

    public void processChanges(int n) {
        super.processChanges(n);
        if ((n & 8) != 0) {
            this.data = null;
            this.checkData();
        }
    }

    private void createStandardBox(int n, int n2, int n3, boolean bl, boolean bl2) {
        double d;
        int n4;
        double d2;
        int n5 = 2 * n * n3 + 2 * n2 * n3;
        if (bl2) {
            n5 += n * n2;
        }
        if (bl) {
            n5 += n * n2;
        }
        this.data = new double[n5][4][3];
        this.normals = new Vector3f[n5];
        int n6 = 0;
        double d3 = 1.0 / (double)n;
        double d4 = 1.0 / (double)n2;
        double d5 = 1.0 / (double)n3;
        int n7 = 0;
        while (n7 < n) {
            d2 = (double)n7 * d3 - 0.5;
            n4 = 0;
            while (n4 < n2) {
                d = (double)n4 * d4 - 0.5;
                if (bl2) {
                    this.normals[n6] = new Vector3f(0.0f, 0.0f, -1.0f);
                    this.data[n6][3][0] = d2;
                    this.data[n6][3][1] = d;
                    this.data[n6][3][2] = -0.5;
                    this.data[n6][2][0] = d2 + d3;
                    this.data[n6][2][1] = d;
                    this.data[n6][2][2] = -0.5;
                    this.data[n6][1][0] = d2 + d3;
                    this.data[n6][1][1] = d + d4;
                    this.data[n6][1][2] = -0.5;
                    this.data[n6][0][0] = d2;
                    this.data[n6][0][1] = d + d4;
                    this.data[n6][0][2] = -0.5;
                    ++n6;
                }
                if (bl) {
                    this.normals[n6] = new Vector3f(0.0f, 0.0f, 1.0f);
                    this.data[n6][0][0] = d2;
                    this.data[n6][0][1] = d;
                    this.data[n6][0][2] = 0.5;
                    this.data[n6][1][0] = d2 + d3;
                    this.data[n6][1][1] = d;
                    this.data[n6][1][2] = 0.5;
                    this.data[n6][2][0] = d2 + d3;
                    this.data[n6][2][1] = d + d4;
                    this.data[n6][2][2] = 0.5;
                    this.data[n6][3][0] = d2;
                    this.data[n6][3][1] = d + d4;
                    this.data[n6][3][2] = 0.5;
                    ++n6;
                }
                ++n4;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n) {
            d2 = (double)n7 * d3 - 0.5;
            n4 = 0;
            while (n4 < n3) {
                this.normals[n6] = new Vector3f(-1.0f, 0.0f, 0.0f);
                d = (double)n4 * d5 - 0.5;
                this.data[n6][0][0] = d2;
                this.data[n6][0][2] = d;
                this.data[n6][0][1] = -0.5;
                this.data[n6][1][0] = d2 + d3;
                this.data[n6][1][2] = d;
                this.data[n6][1][1] = -0.5;
                this.data[n6][2][0] = d2 + d3;
                this.data[n6][2][2] = d + d5;
                this.data[n6][2][1] = -0.5;
                this.data[n6][3][0] = d2;
                this.data[n6][3][2] = d + d5;
                this.data[n6][3][1] = -0.5;
                this.normals[++n6] = new Vector3f(1.0f, 0.0f, 0.0f);
                this.data[n6][3][0] = d2;
                this.data[n6][3][2] = d;
                this.data[n6][3][1] = 0.5;
                this.data[n6][2][0] = d2 + d3;
                this.data[n6][2][2] = d;
                this.data[n6][2][1] = 0.5;
                this.data[n6][1][0] = d2 + d3;
                this.data[n6][1][2] = d + d5;
                this.data[n6][1][1] = 0.5;
                this.data[n6][0][0] = d2;
                this.data[n6][0][2] = d + d5;
                this.data[n6][0][1] = 0.5;
                ++n6;
                ++n4;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n3) {
            d2 = (double)n7 * d5 - 0.5;
            n4 = 0;
            while (n4 < n2) {
                this.normals[n6] = new Vector3f(0.0f, -1.0f, 0.0f);
                d = (double)n4 * d4 - 0.5;
                this.data[n6][0][2] = d2;
                this.data[n6][0][1] = d;
                this.data[n6][0][0] = -0.5;
                this.data[n6][1][2] = d2 + d5;
                this.data[n6][1][1] = d;
                this.data[n6][1][0] = -0.5;
                this.data[n6][2][2] = d2 + d5;
                this.data[n6][2][1] = d + d4;
                this.data[n6][2][0] = -0.5;
                this.data[n6][3][2] = d2;
                this.data[n6][3][1] = d + d4;
                this.data[n6][3][0] = -0.5;
                this.normals[++n6] = new Vector3f(0.0f, 1.0f, 0.0f);
                this.data[n6][3][2] = d2;
                this.data[n6][3][1] = d;
                this.data[n6][3][0] = 0.5;
                this.data[n6][2][2] = d2 + d5;
                this.data[n6][2][1] = d;
                this.data[n6][2][0] = 0.5;
                this.data[n6][1][2] = d2 + d5;
                this.data[n6][1][1] = d + d4;
                this.data[n6][1][0] = 0.5;
                this.data[n6][0][2] = d2;
                this.data[n6][0][1] = d + d4;
                this.data[n6][0][0] = 0.5;
                ++n6;
                ++n4;
            }
            ++n7;
        }
    }

    private void checkData() {
        if (this.data == null) {
            int n;
            int n2;
            int n3;
            Resolution resolution = this.getStyle().getResolution();
            switch (resolution.getType()) {
                case 0: {
                    n3 = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    n = Math.max(resolution.getN3(), 1);
                    break;
                }
                default: {
                    n3 = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeX()) / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeY()) / resolution.getMaxLength()), 1);
                    n = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeZ()) / resolution.getMaxLength()), 1);
                }
            }
            this.createStandardBox(n3, n2, n, this.hasTop, this.hasBottom);
            this.qa = new QuadArray(this.data.length * this.data[0].length * this.data[1].length, 35);
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.data.length) {
                this.qa.setCoordinate(n4, this.data[n5][0]);
                this.qa.setNormal(n4++, this.normals[n5]);
                this.qa.setCoordinate(n4, this.data[n5][1]);
                this.qa.setNormal(n4++, this.normals[n5]);
                this.qa.setCoordinate(n4, this.data[n5][2]);
                this.qa.setNormal(n4++, this.normals[n5]);
                this.qa.setCoordinate(n4, this.data[n5][3]);
                this.qa.setNormal(n4++, this.normals[n5]);
                ++n5;
            }
            this.shape.setGeometry((Geometry)this.qa);
        }
    }
}

