/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.display3d;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.display3d.ControlSet3D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.ElementText;
import org.opensourcephysics.display3d.factory.OSP3DFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlTextSet3D
extends ControlSet3D {
    private static final int TEXTSET_PROPERTIES_ADDED = 4;
    private Font setDefaultFont;
    private static List<String> infoList = null;

    @Override
    protected int getPropertiesDisplacement() {
        return 4;
    }

    @Override
    protected Element createAnElement() {
        ElementText elementText = OSP3DFactory.ElementText();
        this.setDefaultFont = elementText.getFont();
        return elementText;
    }

    @Override
    protected void copyAnElement(Element element, Element element2) {
        super.copyAnElement(element, element2);
        ((ElementText)element2).setText(((ElementText)element).getText());
        ((ElementText)element2).setFont(((ElementText)element).getFont());
        ((ElementText)element2).setJustification(((ElementText)element).getJustification());
        ((ElementText)element2).setRotationAngle(((ElementText)element).getRotationAngle());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("text");
            infoList.add("font");
            infoList.add("justification");
            infoList.add("rotationAngle");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("text")) {
            return "String|String[] TRANSLATABLE";
        }
        if (string.equals("font")) {
            return "Font|Object|Object[]";
        }
        if (string.equals("justification")) {
            return "3DJustification|int|int[]";
        }
        if (string.equals("rotationAngle")) {
            return "int|double|int[]|double[]";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof String[]) {
                    String[] stringArray = (String[])value.getObject();
                    int n2 = 0;
                    while (n2 < this.numElements) {
                        ((ElementText)this.elements[n2]).setText(stringArray[n2]);
                        ++n2;
                    }
                } else {
                    String string = value.getString();
                    int n3 = 0;
                    while (n3 < this.numElements) {
                        ((ElementText)this.elements[n3]).setText(string);
                        ++n3;
                    }
                }
                break;
            }
            case 1: {
                if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n4 = 0;
                    while (n4 < this.numElements) {
                        ((ElementText)this.elements[n4]).setFont((Font)objectArray[n4]);
                        ++n4;
                    }
                } else {
                    if (!(value.getObject() instanceof Font)) break;
                    Font font = (Font)value.getObject();
                    int n5 = 0;
                    while (n5 < this.numElements) {
                        ((ElementText)this.elements[n5]).setFont(font);
                        ++n5;
                    }
                }
                break;
            }
            case 2: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n6 = 0;
                    while (n6 < this.numElements) {
                        ((ElementText)this.elements[n6]).setJustification(nArray[n6]);
                        ++n6;
                    }
                } else {
                    int n7 = value.getInteger();
                    int n8 = 0;
                    while (n8 < this.numElements) {
                        ((ElementText)this.elements[n8]).setJustification(n7);
                        ++n8;
                    }
                }
                break;
            }
            case 3: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n9 = 0;
                    while (n9 < this.numElements) {
                        ((ElementText)this.elements[n9]).setRotationAngle(dArray[n9]);
                        ++n9;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n10 = 0;
                    while (n10 < this.numElements) {
                        ((ElementText)this.elements[n10]).setRotationAngle((double)nArray[n10] * (Math.PI / 180));
                        ++n10;
                    }
                } else if (value instanceof IntegerValue) {
                    double d = (double)value.getInteger() * (Math.PI / 180);
                    int n11 = 0;
                    while (n11 < this.numElements) {
                        ((ElementText)this.elements[n11]).setRotationAngle(d);
                        ++n11;
                    }
                } else {
                    double d = value.getDouble();
                    int n12 = 0;
                    while (n12 < this.numElements) {
                        ((ElementText)this.elements[n12]).setRotationAngle(d);
                        ++n12;
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 4, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < this.numElements) {
                    ((ElementText)this.elements[n2]).setText("");
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < this.numElements) {
                    ((ElementText)this.elements[n3]).setJustification(0);
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < this.numElements) {
                    ((ElementText)this.elements[n4]).setFont(this.setDefaultFont);
                    ++n4;
                }
                break;
            }
            case 3: {
                int n5 = 0;
                while (n5 < this.numElements) {
                    ((ElementText)this.elements[n5]).setRotationAngle(0.0);
                    ++n5;
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 4);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        return super.getValue(n - 4);
    }
}

