/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.display3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.display3d.ControlSet3D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.ElementCircle;
import org.opensourcephysics.display3d.factory.OSP3DFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlCircleSet3D
extends ControlSet3D {
    private static final int CIRCLESET_ROPERTIES_ADDED = 1;
    static List<String> infoList = null;

    @Override
    protected int getPropertiesDisplacement() {
        return 1;
    }

    @Override
    protected Element createAnElement() {
        ElementCircle elementCircle = OSP3DFactory.ElementCircle();
        elementCircle.setSizeXYZ(0.1, 0.1, 0.1);
        return elementCircle;
    }

    @Override
    protected void copyAnElement(Element element, Element element2) {
        super.copyAnElement(element, element2);
        ((ElementCircle)element2).setRotationAngle(((ElementCircle)element).getRotationAngle());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("rotationAngle");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("rotationAngle")) {
            return "int|double|int[]|double[]";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n2 = 0;
                    while (n2 < this.numElements) {
                        ((ElementCircle)this.elements[n2]).setRotationAngle(dArray[n2]);
                        ++n2;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n3 = 0;
                    while (n3 < this.numElements) {
                        ((ElementCircle)this.elements[n3]).setRotationAngle((double)nArray[n3] * (Math.PI / 180));
                        ++n3;
                    }
                } else if (value instanceof IntegerValue) {
                    double d = (double)value.getInteger() * (Math.PI / 180);
                    int n4 = 0;
                    while (n4 < this.numElements) {
                        ((ElementCircle)this.elements[n4]).setRotationAngle(d);
                        ++n4;
                    }
                } else {
                    double d = value.getDouble();
                    int n5 = 0;
                    while (n5 < this.numElements) {
                        ((ElementCircle)this.elements[n5]).setRotationAngle(d);
                        ++n5;
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 1, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < this.numElements) {
                    ((ElementCircle)this.elements[n2]).setRotationAngle(0.0);
                    ++n2;
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 1);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
        }
        return super.getValue(n - 1);
    }
}

