/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.MultiTrail;
import org.opensourcephysics.drawing3d.interaction.InteractionTarget;
import org.opensourcephysics.drawing3d.java3d.Java3dGroup;
import org.opensourcephysics.drawing3d.simple3d.SimpleGroup;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends Element
implements Data {
    protected ArrayList<Element> elementList = new ArrayList();
    private int elementInteracted = -1;
    protected int datasetID;

    public Group() {
        this.setEnabled(true);
        this.datasetID = this.hashCode();
    }

    @Override
    protected ImplementingObject createImplementingObject(int n) {
        switch (n) {
            default: {
                return new SimpleGroup(this);
            }
            case 1: 
        }
        return new Java3dGroup(this);
    }

    @Override
    protected void setImplementation(int n) {
        super.setImplementation(n);
        for (Element element : this.elementList) {
            element.setImplementation(n);
        }
    }

    @Override
    public void setPanel(DrawingPanel3D drawingPanel3D) {
        super.setPanel(drawingPanel3D);
        for (Element element : this.elementList) {
            if (element.getPanel() == null) continue;
            element.setPanel(drawingPanel3D);
        }
    }

    @Override
    public void removePanel() {
        super.removePanel();
        for (Element element : this.elementList) {
            element.removePanel();
        }
    }

    public void addElement(Element element) {
        if (!this.elementList.contains(element)) {
            this.elementList.add(element);
        }
        element.setGroup(this);
    }

    public void addElementAtIndex(int n, Element element) {
        if (!this.elementList.contains(element)) {
            n = Math.max(n, this.elementList.size() - 1);
            this.elementList.add(n, element);
        }
        element.setGroup(this);
    }

    public void addElements(Collection<Element> collection) {
        if (collection != null) {
            for (Element element : collection) {
                this.addElement(element);
            }
        }
    }

    public void removeElement(Element element) {
        element.setGroup(null);
        this.elementList.remove(element);
    }

    public void removeAllElements() {
        for (Element element : this.elementList) {
            element.setGroup(null);
        }
        this.elementList.clear();
    }

    public synchronized List<Element> getElements() {
        return new ArrayList<Element>(this.elementList);
    }

    public int getNumberOfElements() {
        return this.elementList.size();
    }

    public Element getElement(int n) {
        try {
            return this.elementList.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public void processChanges(int n) {
        n |= this.changeType;
        ImplementingObject implementingObject = this.getImplementingObject();
        if (implementingObject != null) {
            implementingObject.processChanges(this.changeType, n);
        }
        for (Element element : this.elementList) {
            element.processChanges(n);
        }
        this.changeType = 0;
    }

    @Override
    public boolean hasChanged() {
        if (this.changeType != 0) {
            return true;
        }
        for (Element element : this.elementList) {
            if (!element.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getDiagonalSize() {
        double d = 0.0;
        for (Element element : this.elementList) {
            d = Math.max(d, element.getDiagonalSize());
        }
        return d;
    }

    @Override
    public void getExtrema(double[] dArray, double[] dArray2) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        for (Element element : this.elementList) {
            if (!element.getCanBeMeasured()) continue;
            element.getExtrema(dArray, dArray2);
            d = Math.min(Math.min(d, dArray[0]), dArray2[0]);
            d2 = Math.max(Math.max(d2, dArray[0]), dArray2[0]);
            d3 = Math.min(Math.min(d3, dArray[1]), dArray2[1]);
            d4 = Math.max(Math.max(d4, dArray[1]), dArray2[1]);
            d5 = Math.min(Math.min(d5, dArray[2]), dArray2[2]);
            d6 = Math.max(Math.max(d6, dArray[2]), dArray2[2]);
        }
        dArray[0] = d;
        dArray2[0] = d2;
        dArray[1] = d3;
        dArray2[1] = d4;
        dArray[2] = d5;
        dArray2[2] = d6;
    }

    @Override
    public InteractionTarget getTargetHit(int n, int n2) {
        if (!this.isEnabled()) {
            return null;
        }
        List<Element> list = this.getElements();
        int n3 = list.size() - 1;
        while (n3 >= 0) {
            InteractionTarget interactionTarget;
            Element element = list.get(n3);
            if (element.isVisible() && (interactionTarget = element.getTargetHit(n, n2)) != null) {
                this.elementInteracted = n3;
                return interactionTarget;
            }
            --n3;
        }
        this.elementInteracted = -1;
        return null;
    }

    public int getInteractedIndex() {
        return this.elementInteracted;
    }

    @Override
    public boolean getCanBeMeasured() {
        if (!super.getCanBeMeasured()) {
            return false;
        }
        for (Element element : this.getElements()) {
            if (!element.getCanBeMeasured()) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        for (Element element : this.getElements()) {
            if (!(element instanceof MultiTrail)) continue;
            ((MultiTrail)element).clear();
        }
    }

    public void initialize() {
        for (Element element : this.getElements()) {
            if (!(element instanceof MultiTrail)) continue;
            ((MultiTrail)element).initialize();
        }
    }

    @Override
    public void setID(int n) {
        this.datasetID = n;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    @Override
    public double[][] getData2D() {
        return null;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        for (Element element : this.elementList) {
            if (!(element instanceof Data)) continue;
            return ((Data)((Object)element)).getColumnNames();
        }
        return null;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), this.getStyle().getLineColor()};
    }

    @Override
    public Color[] getFillColors() {
        Paint paint = this.getStyle().getFillColor();
        if (paint instanceof Color) {
            return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), (Color)paint};
        }
        return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), DisplayColors.getLineColor(2)};
    }

    @Override
    public List<Data> getDataList() {
        ArrayList<Data> arrayList = new ArrayList<Data>();
        for (Element element : this.elementList) {
            if (!(element instanceof Data)) continue;
            arrayList.add((Data)((Object)element));
        }
        return arrayList;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }
}

