/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.utils;

import com.sun.image.codec.jpeg.JPEGCodec;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import org.colos.ejs.library.utils.WebVideoListener;
import org.colos.ejs.library.utils.WebVideoMPEGutil;

public class WebVideo {
    private boolean mEnabled = false;
    private boolean mMPEGformat = false;
    private long mDelay = 100L;
    private String mURL = null;
    private Thread mRunningThread;
    private WebVideoMPEGutil mMPEGutil = null;
    private ArrayList<WebVideoListener> mListeners = new ArrayList();

    public boolean addListener(WebVideoListener webVideoListener) {
        if (!this.mListeners.contains(webVideoListener)) {
            return this.mListeners.add(webVideoListener);
        }
        return false;
    }

    public String getURL() {
        return this.mURL;
    }

    public void setURL(String string) {
        if (string == null || !string.equals(this.mURL)) {
            this.stopRunning();
        }
        this.mURL = string;
        this.startRunning();
    }

    public boolean isMJPEGFormat() {
        return this.mMPEGformat;
    }

    public void setMJPEGFormat(boolean bl) {
        if (this.mMPEGformat != bl) {
            this.stopRunning();
            this.mMPEGformat = bl;
            this.startRunning();
        }
    }

    public long getDelay() {
        return this.mDelay;
    }

    public void setDelay(long l) {
        this.mDelay = Math.max(0L, l);
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean bl) {
        this.mEnabled = bl;
        if (this.mEnabled) {
            this.startRunning();
        } else {
            this.stopRunning();
        }
    }

    void sendErrorMessage(String string) {
        for (WebVideoListener webVideoListener : this.mListeners) {
            webVideoListener.connectionError(string);
        }
    }

    void sendImage(Image image) {
        for (WebVideoListener webVideoListener : this.mListeners) {
            webVideoListener.imageChanged(image);
        }
    }

    private void startRunning() {
        if (!this.mEnabled) {
            return;
        }
        if (this.mURL == null) {
            return;
        }
        if (this.mRunningThread != null) {
            return;
        }
        if (this.mMPEGformat) {
            if (this.mMPEGutil == null) {
                this.mMPEGutil = new WebVideoMPEGutil(this);
            }
            this.mRunningThread = new Thread(new Runnable(){

                public void run() {
                    WebVideo.this.mMPEGutil.readMJPGStream();
                }
            });
        } else {
            this.mRunningThread = new Thread(new Runnable(){

                public void run() {
                    WebVideo.this.readJPEG();
                }
            });
        }
        this.mRunningThread.setPriority(1);
        this.mRunningThread.setDaemon(true);
        this.mRunningThread.start();
    }

    public void stopRunning() {
        if (this.mRunningThread == null) {
            this.sendImage(null);
            return;
        }
        if (this.mMPEGutil != null) {
            this.mMPEGutil.stop();
        }
        Thread thread = this.mRunningThread;
        this.mRunningThread = null;
        if (Thread.currentThread() == thread) {
            this.sendImage(null);
            return;
        }
        try {
            thread.interrupt();
            thread.join(100L);
        }
        catch (Exception exception) {}
        this.sendImage(null);
    }

    /*
     * Unable to fully structure code
     */
    public void readJPEG() {
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        try {
            var4_4 = new URL(this.mURL);
            if (true) ** GOTO lbl70
        }
        catch (Exception v0) {
            this.sendErrorMessage("Incorrect URL address");
            this.stopRunning();
            return;
        }
        do {
            block21: {
                try {
                    var2_2 = (HttpURLConnection)var4_4.openConnection();
                    var5_5 = var2_2.getInputStream();
                    var6_7 = new BufferedInputStream(var5_5);
                    var1_1 = new DataInputStream(var6_7);
                    var7_8 = JPEGCodec.createJPEGDecoder((InputStream)var1_1);
                    var8_9 = var7_8.decodeAsBufferedImage();
                    System.err.println("Image read ok " + var8_9);
                    var9_10 = var8_9.getWidth(null);
                    var10_11 = var8_9.getHeight(null);
                    System.out.println("Image = " + var9_10 + "," + var10_11);
                    this.sendImage(var8_9);
                    if (this.mDelay < 10L) {
                        Thread.yield();
                    } else {
                        try {
                            Thread.sleep(this.mDelay);
                        }
                        catch (InterruptedException v1) {}
                    }
                    var1_1.close();
                }
                catch (IOException v2) {
                    var3_3 = "Connection failed";
                    try {
                        var2_2.disconnect();
                        var1_1.close();
                    }
                    catch (Exception v3) {}
                    break block21;
                }
                catch (Exception var5_6) {
                    try {
                        var5_6.printStackTrace();
                        var3_3 = "Error when reading image from camera";
                    }
                    catch (Throwable var11_12) {
                        try {
                            var2_2.disconnect();
                            var1_1.close();
                        }
                        catch (Exception v4) {}
                        throw var11_12;
                    }
                    try {
                        var2_2.disconnect();
                        var1_1.close();
                    }
                    catch (Exception v5) {}
                    break block21;
                }
                try {
                    var2_2.disconnect();
                    var1_1.close();
                }
                catch (Exception v6) {}
            }
            if (var3_3 == null) continue;
            this.sendErrorMessage(var3_3);
            this.stopRunning();
            return;
lbl70:
            // 2 sources

        } while (this.mRunningThread == Thread.currentThread());
        this.sendImage(null);
    }
}

