/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d.utils;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.drawing3d.ControlDrawingPanel3D;
import org.colos.ejs.library.control.value.Value;
import org.colos.ejs.library.utils.WebVideo;
import org.colos.ejs.library.utils.WebVideoListener;
import org.opensourcephysics.drawing3d.DrawingPanel3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlWebCam3D
extends ControlElement
implements WebVideoListener {
    public static final int WEBCAM_NAME = 0;
    public static final int WEBCAM_PARENT = 1;
    public static final int WEBCAM_URL = 2;
    public static final int WEBCAM_MJPEG = 3;
    public static final int WEBCAM_DELAY = 4;
    public static final int WEBCAM_ENABLED = 5;
    private WebVideo mWebVideo = new WebVideo();
    private DrawingPanel3D mPanel3D;
    private static List<String> infoList = null;

    public ControlWebCam3D() {
        this.mWebVideo.addListener(this);
        this.mPanel3D = null;
    }

    @Override
    public Object getObject() {
        return this.mWebVideo;
    }

    @Override
    public String getObjectClassname() {
        return "org.colos.ejs.library.utils.WebVideo";
    }

    private final void setParent(ControlDrawingPanel3D controlDrawingPanel3D) {
        boolean bl = this.mWebVideo.isEnabled();
        if (this.mPanel3D != null) {
            this.mPanel3D.getVisualizationHints().setBackgroundImage((Image)null);
            this.mPanel3D = null;
            this.mWebVideo.setEnabled(false);
        }
        if (controlDrawingPanel3D != null) {
            this.mPanel3D = controlDrawingPanel3D.getDrawingPanel3D();
            if (bl) {
                this.mWebVideo.setEnabled(true);
            }
            this.mPanel3D.update();
        }
    }

    @Override
    public void onExit() {
        this.mWebVideo.stopRunning();
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("name");
            infoList.add("parent");
            infoList.add("url");
            infoList.add("mjpeg");
            infoList.add("delay");
            infoList.add("enabled");
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("name")) {
            return "String CONSTANT";
        }
        if (string.equals("parent")) {
            return "ControlElement CONSTANT";
        }
        if (string.equals("url")) {
            return "String";
        }
        if (string.equals("mjpeg")) {
            return "boolean";
        }
        if (string.equals("delay")) {
            return "int";
        }
        if (string.equals("enabled")) {
            return "boolean";
        }
        return null;
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                super.setValue(0, value);
                break;
            }
            case 1: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement != null) {
                    this.setParent(null);
                }
                if ((controlElement = this.myGroup.getElement(value.toString())) == null) {
                    System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> not found for " + this.toString());
                    break;
                }
                if (controlElement instanceof ControlDrawingPanel3D) {
                    this.setParent((ControlDrawingPanel3D)controlElement);
                    break;
                }
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> is not a ControlDrawingPanel3D");
                break;
            }
            case 2: {
                this.mWebVideo.setURL(value.getString());
                break;
            }
            case 3: {
                this.mWebVideo.setMJPEGFormat(value.getBoolean());
                break;
            }
            case 4: {
                this.mWebVideo.setDelay(value.getInteger());
                break;
            }
            case 5: {
                this.mWebVideo.setEnabled(value.getBoolean());
                this.mPanel3D.getVisualizationHints().setBackgroundImage((Image)null);
                break;
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                super.setDefaultValue(0);
                break;
            }
            case 1: {
                if (this.myGroup.getElement(this.getProperty("parent")) == null) break;
                this.setParent(null);
                break;
            }
            case 2: {
                this.mWebVideo.setURL(null);
                break;
            }
            case 3: {
                this.mWebVideo.setMJPEGFormat(false);
                break;
            }
            case 4: {
                this.mWebVideo.setDelay(100L);
                break;
            }
            case 5: {
                this.mWebVideo.setEnabled(false);
                break;
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return "<none>";
            }
            case 3: {
                return "false";
            }
            case 4: {
                return "100";
            }
            case 5: {
                return "true";
            }
        }
        return "<none>";
    }

    @Override
    public Value getValue(int n) {
        return null;
    }

    @Override
    public void imageChanged(Image image) {
        if (this.mPanel3D != null) {
            this.mPanel3D.getVisualizationHints().setBackgroundImage(image);
        }
    }

    @Override
    public void connectionError(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.colos.ejs.library.resources.ejs_res", Locale.getDefault());
        JOptionPane.showMessageDialog(this.mPanel3D.getComponent(), string, String.valueOf(this.getProperty("Name")) + ": " + resourceBundle.getString("Error"), 0);
    }
}

