/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.pendulum2m_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.RK4;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ntnu.fkh.pendulum2m_pkg.pendulum2mSimulation;
import users.ntnu.fkh.pendulum2m_pkg.pendulum2mView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class pendulum2m
extends AbstractModel {
    public pendulum2mSimulation _simulation = null;
    public pendulum2mView _view = null;
    public pendulum2m _model = this;
    public double range = 200.0;
    public double xmin = -this.range / 2.0;
    public double xmax = this.range / 2.0;
    public double ymin = -this.range / 2.0;
    public double ymax = this.range / 2.0;
    public double t = 0.0;
    public double dt = 0.05;
    public double size = this.range / 20.0;
    public double size2 = this.size / 2.0;
    public double stroke = 2.0;
    public double L = 1.2 * this.xmax;
    public double pi = Math.PI;
    public double xc = 0.0;
    public double yc = this.ymax;
    public double m1 = 1.0;
    public double m2 = 1.0;
    public double size1 = this.size * Math.sqrt(this.m1);
    public double g = 9.8;
    public double d = (this.size + this.size1) / 2.0;
    public double omega = 0.0;
    public double xc1 = this.size1 / 2.0;
    public double cta1 = this.pi / 6.0;
    public double omega1 = 0.0;
    public double x1 = this.xc1 + this.L * Math.sin(this.cta1);
    public double y1 = this.yc - this.L * Math.cos(this.cta1);
    public double vx1 = 0.0;
    public double vy1 = 0.0;
    public double cta1a = 29.9988;
    public double a2c = this.pi / 180.0;
    public double T1 = 0.0;
    public double xc2 = -this.size / 2.0;
    public double cta2 = 0.0;
    public double omega2 = 0.0;
    public double x2 = this.xc2 + this.L * Math.sin(this.cta2);
    public double y2 = this.yc - this.L * Math.cos(this.cta2);
    public double vx2 = 0.0;
    public double vy2 = 0.0;
    public double T2 = 0.0;
    public String l_play = "play";
    public String l_pause = "pause";
    public String l_reset = "reset";
    public String l_init = "initialize";
    public String label = "play";
    public String l_step = "step";
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ntnu/fkh/pendulum2m.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
        }
        pendulum2m pendulum2m2 = new pendulum2m(stringArray);
    }

    public pendulum2m() {
        this(null, null, null, null, null, false);
    }

    public pendulum2m(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public pendulum2m(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new pendulum2mSimulation(this, string, frame, uRL, bl);
        this._view = (pendulum2mView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.cta1 = this.pi / 6.0;
        this.cta2 = 0.0;
        this.omega2 = 0.0;
        this.omega1 = 0.0;
    }

    public void _constraints1() {
        this.x1 = this.xc1 + this.L * Math.sin(this.cta1);
        this.y1 = this.yc - this.L * Math.cos(this.cta1);
        this.x2 = this.xc2 + this.L * Math.sin(this.cta2);
        this.y2 = this.yc - this.L * Math.cos(this.cta2);
        this.vx1 = this.L * this.omega1 * Math.cos(this.cta1);
        this.vy1 = this.L * this.omega1 * Math.sin(this.cta1);
        this.vx2 = this.L * this.omega2 * Math.cos(this.cta2);
        this.vy2 = this.L * this.omega2 * Math.sin(this.cta2);
        this.T1 = this.m1 * this.g * Math.cos(this.cta1) + this.L * this.omega1 * this.omega1;
        this.T2 = this.m2 * this.g * Math.cos(this.cta2) + this.L * this.omega2 * this.omega2;
    }

    public void zh_tw() {
        this.l_play = "\u64ad\u653e";
        this.l_init = "\u521d\u59cb\u5316";
        this.l_reset = "\u91cd\u8a2d";
        this.l_pause = "\u66ab\u505c";
        this.l_step = "\u524d\u9032\u4e00\u683c";
        this.label = this.l_play;
    }

    public void locale(String string) {
        if (string.equals("zh_tw")) {
            this.zh_tw();
        }
        this._initialize();
    }

    public void playpause() {
        if (this.label == this.l_play) {
            this.label = this.l_pause;
            this._play();
        } else {
            this.label = this.l_play;
            this._pause();
        }
    }

    public void _method_for_Sliderm1_dragaction() {
        this._simulation.disableLoop();
        this.size1 = this.size * Math.sqrt(this.m1);
        this.d = (this.size + this.size1) / 2.0;
        this.xc1 = this.size1 / 2.0;
        this._simulation.enableLoop();
    }

    public void _method_for_Slidercta1_dragaction() {
        this._simulation.disableLoop();
        this.cta1 = this.cta1a * this.a2c;
        this.omega1 = 0.0;
        this._simulation.enableLoop();
    }

    public void _method_for_reset_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_initialize_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_playpause_action() {
        this._simulation.disableLoop();
        this.playpause();
        this._simulation.enableLoop();
    }

    public double _method_for_ArrowLine1_sizex() {
        return this.x1 - this.xc1;
    }

    public double _method_for_ArrowLine1_sizey() {
        return this.y1 - this.yc;
    }

    public double _method_for_ArrowLine2_sizex() {
        return this.x2 - this.xc2;
    }

    public double _method_for_ArrowLine2_sizey() {
        return this.y2 - this.yc;
    }

    public double _method_for_ArrowT1_sizex() {
        return -this.T1 * Math.sin(this.cta1);
    }

    public double _method_for_ArrowT1_sizey() {
        return this.T1 * Math.cos(this.cta1);
    }

    public double _method_for_ArrowT2_sizex() {
        return -this.T2 * Math.sin(this.cta2);
    }

    public double _method_for_ArrowT2_sizey() {
        return this.T2 * Math.cos(this.cta2);
    }

    @Override
    public synchronized void reset() {
        this.range = 200.0;
        this.xmin = -this.range / 2.0;
        this.xmax = this.range / 2.0;
        this.ymin = -this.range / 2.0;
        this.ymax = this.range / 2.0;
        this.t = 0.0;
        this.dt = 0.05;
        this.size = this.range / 20.0;
        this.size2 = this.size / 2.0;
        this.stroke = 2.0;
        this.L = 1.2 * this.xmax;
        this.pi = Math.PI;
        this.xc = 0.0;
        this.yc = this.ymax;
        this.m1 = 1.0;
        this.m2 = 1.0;
        this.size1 = this.size * Math.sqrt(this.m1);
        this.g = 9.8;
        this.d = (this.size + this.size1) / 2.0;
        this.omega = 0.0;
        this.xc1 = this.size1 / 2.0;
        this.cta1 = this.pi / 6.0;
        this.omega1 = 0.0;
        this.x1 = this.xc1 + this.L * Math.sin(this.cta1);
        this.y1 = this.yc - this.L * Math.cos(this.cta1);
        this.vx1 = 0.0;
        this.vy1 = 0.0;
        this.cta1a = 29.9988;
        this.a2c = this.pi / 180.0;
        this.T1 = 0.0;
        this.xc2 = -this.size / 2.0;
        this.cta2 = 0.0;
        this.omega2 = 0.0;
        this.x2 = this.xc2 + this.L * Math.sin(this.cta2);
        this.y2 = this.yc - this.L * Math.cos(this.cta2);
        this.vx2 = 0.0;
        this.vy2 = 0.0;
        this.T2 = 0.0;
        this.l_play = "play";
        this.l_pause = "pause";
        this.l_reset = "reset";
        this.l_init = "initialize";
        this.label = "play";
        this.l_step = "step";
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[5];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = pendulum2m.this.cta1;
            this.__state[n++] = pendulum2m.this.omega1;
            this.__state[n++] = pendulum2m.this.cta2;
            this.__state[n++] = pendulum2m.this.omega2;
            this.__state[n++] = pendulum2m.this.t;
            this.__solver = new ODEBisectionEventSolver(this, RK4.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.initialize(pendulum2m.this.dt);
        }

        void step() {
            if (pendulum2m.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(pendulum2m.this.dt);
            }
            int n = 0;
            this.__state[n++] = pendulum2m.this.cta1;
            this.__state[n++] = pendulum2m.this.omega1;
            this.__state[n++] = pendulum2m.this.cta2;
            this.__state[n++] = pendulum2m.this.omega2;
            this.__state[n++] = pendulum2m.this.t;
            this.__solver.step();
            n = 0;
            pendulum2m.this.cta1 = this.__state[n++];
            pendulum2m.this.omega1 = this.__state[n++];
            pendulum2m.this.cta2 = this.__state[n++];
            pendulum2m.this.omega2 = this.__state[n++];
            pendulum2m.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            double d4 = dArray[n++];
            double d5 = dArray[n++];
            n = 0;
            dArray2[n++] = d2;
            dArray2[n++] = -pendulum2m.this.g * Math.sin(d) / pendulum2m.this.L;
            dArray2[n++] = d4;
            dArray2[n++] = -pendulum2m.this.g * Math.sin(d3) / pendulum2m.this.L;
            dArray2[n++] = 1.0;
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "Event";
            }

            public double getTolerance() {
                return 0.001;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                double d = dArray[n++];
                double d2 = dArray[n++];
                double d3 = dArray[n++];
                double d4 = dArray[n++];
                double d5 = dArray[n++];
                pendulum2m.this.x1 = pendulum2m.this.xc1 + pendulum2m.this.L * Math.sin(d);
                pendulum2m.this.x2 = pendulum2m.this.xc2 + pendulum2m.this.L * Math.sin(d3);
                pendulum2m.this.y1 = pendulum2m.this.yc - pendulum2m.this.L * Math.cos(d);
                pendulum2m.this.y2 = pendulum2m.this.yc - pendulum2m.this.L * Math.cos(d3);
                return Math.sqrt((pendulum2m.this.x1 - pendulum2m.this.x2) * (pendulum2m.this.x1 - pendulum2m.this.x2) + (pendulum2m.this.y1 - pendulum2m.this.y2) * (pendulum2m.this.y1 - pendulum2m.this.y2)) - pendulum2m.this.d;
            }

            public boolean action() {
                int n = 0;
                pendulum2m.this.cta1 = _ODE_evolution1.this.__state[n++];
                pendulum2m.this.omega1 = _ODE_evolution1.this.__state[n++];
                pendulum2m.this.cta2 = _ODE_evolution1.this.__state[n++];
                pendulum2m.this.omega2 = _ODE_evolution1.this.__state[n++];
                pendulum2m.this.t = _ODE_evolution1.this.__state[n++];
                boolean bl = this.userDefinedAction();
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = pendulum2m.this.cta1;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = pendulum2m.this.omega1;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = pendulum2m.this.cta2;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = pendulum2m.this.omega2;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = pendulum2m.this.t;
                return bl;
            }

            private boolean userDefinedAction() {
                pendulum2m.this.omega = pendulum2m.this.omega1;
                pendulum2m.this.omega1 = ((pendulum2m.this.m1 - pendulum2m.this.m2) * pendulum2m.this.omega1 + 2.0 * pendulum2m.this.m2 * pendulum2m.this.omega2) / (pendulum2m.this.m1 + pendulum2m.this.m2);
                pendulum2m.this.omega2 = (2.0 * pendulum2m.this.m1 * pendulum2m.this.omega + (pendulum2m.this.m2 - pendulum2m.this.m1) * pendulum2m.this.omega2) / (pendulum2m.this.m1 + pendulum2m.this.m2);
                return true;
            }
        }
    }
}

