/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.value;

import java.util.StringTokenizer;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.StringValue;

public abstract class Value {
    public abstract boolean getBoolean();

    public abstract int getInteger();

    public abstract double getDouble();

    public abstract String getString();

    public abstract Object getObject();

    public void copyValue(Value value) {
        if (this instanceof DoubleValue) {
            ((DoubleValue)this).value = value.getDouble();
        } else if (this instanceof IntegerValue) {
            ((IntegerValue)this).value = value.getInteger();
        } else if (this instanceof BooleanValue) {
            ((BooleanValue)this).value = value.getBoolean();
        } else if (this instanceof StringValue) {
            ((StringValue)this).value = value.getString();
        } else if (this instanceof ObjectValue) {
            ((ObjectValue)this).value = value.getObject();
        }
    }

    public Value cloneValue() {
        if (this instanceof DoubleValue) {
            return new DoubleValue(this.getDouble());
        }
        if (this instanceof IntegerValue) {
            return new IntegerValue(this.getInteger());
        }
        if (this instanceof BooleanValue) {
            return new BooleanValue(this.getBoolean());
        }
        if (this instanceof StringValue) {
            return new StringValue(this.getString());
        }
        if (this instanceof ObjectValue) {
            return new ObjectValue(this.getObject());
        }
        return null;
    }

    public String toString() {
        return this.getString();
    }

    public static Value parseConstantOrArray(String string, boolean bl) {
        int n;
        String string2 = string.trim();
        boolean bl2 = false;
        if (string2.startsWith("new ") && (n = string2.indexOf(123)) > 0) {
            string2 = string2.substring(n);
        }
        if (string2.startsWith("{") && string2.endsWith("}")) {
            string = string2.substring(1, string2.length() - 1);
            bl2 = true;
        }
        if (string2.startsWith("\"") && string2.endsWith("\"")) {
            return Value.parseConstant(string, bl);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = stringTokenizer.countTokens();
        if (!bl2 && n2 <= 1) {
            return Value.parseConstant(string, bl);
        }
        Value[] valueArray = new Value[n2];
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n3 = 0;
        while (n3 < n2) {
            String string3 = stringTokenizer.nextToken();
            valueArray[n3] = Value.parseConstant(string3, bl);
            if (valueArray[n3] == null) {
                return Value.parseConstant(string, bl);
            }
            if (valueArray[n3] instanceof DoubleValue) {
                bl3 = true;
            } else if (valueArray[n3] instanceof IntegerValue) {
                bl4 = true;
            } else if (valueArray[n3] instanceof BooleanValue) {
                bl5 = true;
            } else if (valueArray[n3] instanceof StringValue) {
                bl6 = true;
            }
            ++n3;
        }
        if (bl3) {
            double[] dArray = new double[n2];
            int n4 = 0;
            while (n4 < n2) {
                dArray[n4] = valueArray[n4].getDouble();
                ++n4;
            }
            return new ObjectValue(dArray);
        }
        if (bl4) {
            int[] nArray = new int[n2];
            int n5 = 0;
            while (n5 < n2) {
                nArray[n5] = valueArray[n5].getInteger();
                ++n5;
            }
            return new ObjectValue(nArray);
        }
        if (bl5) {
            boolean[] blArray = new boolean[n2];
            int n6 = 0;
            while (n6 < n2) {
                blArray[n6] = valueArray[n6].getBoolean();
                ++n6;
            }
            return new ObjectValue(blArray);
        }
        if (bl6) {
            String[] stringArray = new String[n2];
            int n7 = 0;
            while (n7 < n2) {
                stringArray[n7] = valueArray[n7].getString();
                ++n7;
            }
            return new ObjectValue(stringArray);
        }
        return Value.parseConstant(string, bl);
    }

    public static Value parseConstant(String string, boolean bl) {
        if ((string = string.trim()).length() <= 0) {
            return null;
        }
        if (string.equals("null")) {
            return new ObjectValue(null);
        }
        if (string.startsWith("\"")) {
            if (string.length() <= 1) {
                return null;
            }
            if (!string.endsWith("\"")) {
                return null;
            }
            return new StringValue(string.substring(1, string.length() - 1));
        }
        if (string.startsWith("'")) {
            if (!string.endsWith("'")) {
                return null;
            }
            return new StringValue(string.substring(1, string.length() - 1));
        }
        if (string.equals("true")) {
            return new BooleanValue(true);
        }
        if (string.equals("false")) {
            return new BooleanValue(false);
        }
        if (string.indexOf(46) >= 0) {
            try {
                double d = Double.parseDouble(string);
                return new DoubleValue(d);
            }
            catch (Exception exception) {
                if (!bl) {
                    System.err.println("Value : Error 2! Incorrect input to parse " + string);
                }
                return null;
            }
        }
        try {
            int n = Integer.parseInt(string);
            return new IntegerValue(n);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

