/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.KeplerMotion_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ntnu.fkh.KeplerMotion_pkg.KeplerMotionSimulation;
import users.ntnu.fkh.KeplerMotion_pkg.KeplerMotionView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeplerMotion
extends AbstractModel {
    public KeplerMotionSimulation _simulation = null;
    public KeplerMotionView _view = null;
    public KeplerMotion _model = this;
    public double range = 200.0;
    public double xmin = -this.range;
    public double xmax = this.range;
    public double ymin = -this.range / 2.0;
    public double ymax = this.range / 2.0;
    public double t = 0.0;
    public double dt = 0.05;
    public double size = this.range / 40.0;
    public double size2 = this.size / 2.0;
    public double stroke = 2.0;
    public double zero = 0.0;
    public int npt = 1200;
    public double pi = Math.PI;
    public double Ecst = 0.12;
    public String selected = "Fixed Kinetic Energy";
    public double x;
    public double x0 = this.x = this.xmax / 2.0;
    public double y = 0.0;
    public double vx = 0.0;
    public double vy0;
    public double vy = this.vy0 = this.ymax / 10.0;
    public double M = 1.0;
    public double G = this.xmax * this.xmax / this.M;
    public double m = 1.0;
    public double GMm = this.G * this.M * this.m;
    public double mc = 2.0;
    public double r = this.x;
    public double L = this.r * this.m * this.vy;
    public double U = -this.GMm / this.r + this.L * this.L / (2.0 * this.m * this.r * this.r);
    public double r2 = 0.0;
    public double r1 = 0.0;
    public double R = 0.0;
    public double xc = 0.0;
    public double b = 0.0;
    public double T = 0.0;
    public double er = 0.001;
    public double rt = 100.0;
    public double Et = 0.0;
    public double E0 = 0.0;
    public String l_play = "play";
    public String l_pause = "pause";
    public String l_reset = "reset";
    public String l_init = "initialize";
    public String label = "play";
    public String l_step = "step";
    public String l_Ueff = "U_{effect}=GMm/r+L^{2}/(2mr^{2})";
    public String l_showU = "show U_effect";
    public String l_select = "Fixed Kinetic Energy;Fixed Angular Momentum;arbitrary";
    private _ODE_evolution1 _ODEi_evolution1;

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/ntnu/fkh/KeplerMotion.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("E:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("E:/EJS_4.1/bin/config/");
        }
        KeplerMotion keplerMotion = new KeplerMotion(stringArray);
    }

    public KeplerMotion() {
        this(null, null, null, null, null, false);
    }

    public KeplerMotion(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public KeplerMotion(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new KeplerMotionSimulation(this, string, frame, uRL, bl);
        this._view = (KeplerMotionView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.vx = 0.0;
        this.y = 0.0;
        this.vy = this.vy0;
        this.r = this.x = this.x0;
        this.L = this.r * this.m * this.vy;
        this.U = -this.GMm / this.r + this.L * this.L / (2.0 * this.m * this.r * this.r);
        this.r1 = (-this.GMm - Math.sqrt(this.GMm * this.GMm + 2.0 * this.U * this.L * this.L / this.m)) / (2.0 * this.U);
        this.r2 = (-this.GMm + Math.sqrt(this.GMm * this.GMm + 2.0 * this.U * this.L * this.L / this.m)) / (2.0 * this.U);
        if (Math.abs(this.r1 - this.r) > Math.abs(this.r2 - this.r)) {
            this.r2 = this.r1;
        }
        this.R = (this.r2 + this.r) / 2.0;
        this.T = 2.0 * this.pi * this.R * Math.sqrt(this.R / (this.G * this.M));
        this.b = this.L * this.T / (this.pi * this.R);
        this.xc = this.x - this.R;
        this.E0 = -this.GMm / this.r + this.L * this.L / (2.0 * this.m * this.r * this.r);
    }

    public void _constraints1() {
        this.zero = 0.0;
        this.rt = Math.sqrt(this.x * this.x + this.y * this.y);
        this.Et = (-this.GMm / this.rt + this.L * this.L / (2.0 * this.m * this.rt * this.rt)) * this.Ecst;
    }

    public void zh_tw() {
        this.l_play = "\u64ad\u653e";
        this.l_init = "\u521d\u59cb\u5316";
        this.l_reset = "\u91cd\u8a2d";
        this.l_pause = "\u66ab\u505c";
        this.l_step = "\u524d\u9032\u4e00\u683c";
        this.label = this.l_play;
    }

    public void locale(String string) {
        if (string.equals("zh_tw")) {
            this.zh_tw();
        }
        this._initialize();
    }

    public void playpause() {
        if (this.label == this.l_play) {
            this.label = this.l_pause;
            this._play();
        } else {
            this.label = this.l_play;
            this._pause();
        }
    }

    public double getF(double d, double d2) {
        double d3 = d * d + d2 * d2;
        double d4 = Math.sqrt(d3) * d3;
        return -this.G * this.M * this.m * d / d4;
    }

    public void _method_for_reset_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_initialize_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_step_enabled() {
        return this._isPaused();
    }

    public void _method_for_step_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_playpause_action() {
        this._simulation.disableLoop();
        this.playpause();
        this._simulation.enableLoop();
    }

    public boolean _method_for_ComboBox_editable() {
        return this._isPaused();
    }

    public boolean _method_for_ArrowVi_visible() {
        return this._isPlaying();
    }

    public boolean _method_for_Trace_active() {
        return this._isPlaying();
    }

    public boolean _method_for_Trace_connected() {
        return this._isPlaying();
    }

    public double _method_for_Particle0_sizex() {
        return this.size * this.mc;
    }

    public double _method_for_Particle0_sizey() {
        return this.size * this.mc;
    }

    public double _method_for_ParticleTrace_sizex() {
        return 2.0 * this.R;
    }

    public boolean _method_for_ParticleTrace_visible() {
        return this._isPaused();
    }

    public double _method_for_ArrowEt_y() {
        return this.E0 * this.Ecst;
    }

    public double _method_for_ArrowEt_sizex() {
        return -this.r2 - this.r;
    }

    public boolean _method_for_Arrowdrag_visible() {
        return this._isPaused();
    }

    public boolean _method_for_Arrowdrag_enabled() {
        return !this.selected.equals("Fixed Kinetic Energy");
    }

    public void _method_for_Arrowdrag_dragaction() {
        this._simulation.disableLoop();
        if (!this.selected.equals("Fixed Kinetic Energy") && this.selected.equals("Fixed Angular Momentum")) {
            this.vy0 = this.L / (this.m * this.x0);
        }
        this._initialize();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.range = 200.0;
        this.xmin = -this.range;
        this.xmax = this.range;
        this.ymin = -this.range / 2.0;
        this.ymax = this.range / 2.0;
        this.t = 0.0;
        this.dt = 0.05;
        this.size = this.range / 40.0;
        this.size2 = this.size / 2.0;
        this.stroke = 2.0;
        this.zero = 0.0;
        this.npt = 1200;
        this.pi = Math.PI;
        this.Ecst = 0.12;
        this.selected = "Fixed Kinetic Energy";
        this.x0 = this.x = this.xmax / 2.0;
        this.y = 0.0;
        this.vx = 0.0;
        this.vy = this.vy0 = this.ymax / 10.0;
        this.M = 1.0;
        this.G = this.xmax * this.xmax / this.M;
        this.m = 1.0;
        this.GMm = this.G * this.M * this.m;
        this.mc = 2.0;
        this.r = this.x;
        this.L = this.r * this.m * this.vy;
        this.U = -this.GMm / this.r + this.L * this.L / (2.0 * this.m * this.r * this.r);
        this.r2 = 0.0;
        this.r1 = 0.0;
        this.R = 0.0;
        this.xc = 0.0;
        this.b = 0.0;
        this.T = 0.0;
        this.er = 0.001;
        this.rt = 100.0;
        this.Et = 0.0;
        this.E0 = 0.0;
        this.l_play = "play";
        this.l_pause = "pause";
        this.l_reset = "reset";
        this.l_init = "initialize";
        this.label = "play";
        this.l_step = "step";
        this.l_Ueff = "U_{effect}=GMm/r+L^{2}/(2mr^{2})";
        this.l_showU = "show U_effect";
        this.l_select = "Fixed Kinetic Energy;Fixed Angular Momentum;arbitrary";
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[5];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = KeplerMotion.this.x;
            this.__state[n++] = KeplerMotion.this.y;
            this.__state[n++] = KeplerMotion.this.vx;
            this.__state[n++] = KeplerMotion.this.vy;
            this.__state[n++] = KeplerMotion.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(KeplerMotion.this.dt);
        }

        void step() {
            if (0.001 != this.__solver.getTolerance()) {
                this.__solver.setTolerance(0.001);
            }
            if (KeplerMotion.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(KeplerMotion.this.dt);
            }
            int n = 0;
            this.__state[n++] = KeplerMotion.this.x;
            this.__state[n++] = KeplerMotion.this.y;
            this.__state[n++] = KeplerMotion.this.vx;
            this.__state[n++] = KeplerMotion.this.vy;
            this.__state[n++] = KeplerMotion.this.t;
            this.__solver.step();
            n = 0;
            KeplerMotion.this.x = this.__state[n++];
            KeplerMotion.this.y = this.__state[n++];
            KeplerMotion.this.vx = this.__state[n++];
            KeplerMotion.this.vy = this.__state[n++];
            KeplerMotion.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            double d4 = dArray[n++];
            double d5 = dArray[n++];
            n = 0;
            dArray2[n++] = d3;
            dArray2[n++] = d4;
            dArray2[n++] = KeplerMotion.this.getF(d, d2) / KeplerMotion.this.m;
            dArray2[n++] = KeplerMotion.this.getF(d2, d) / KeplerMotion.this.m;
            dArray2[n++] = 1.0;
        }
    }
}

