/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.LogMeasurable;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.Drawable3D;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetTracePoint;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.displayejs.Point3D;
import org.opensourcephysics.displayejs.Style;
import org.opensourcephysics.tools.ToolForDataInfo;
import org.opensourcephysics.tools.ToolForDataUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveTrace
extends AbstractInteractiveElement
implements ToolForDataUser,
LogMeasurable {
    public static final int SHOW_ALL = 0;
    public static final int ORDER_OF_APPEARANCE = 1;
    public static final int X_COORDINATE = 2;
    public static final int Y_COORDINATE = 3;
    public static final int Z_COORDINATE = 4;
    public static final int BAR = 14;
    public static final int POST = 15;
    private static final int MAX_POINTS = 100000;
    protected boolean connected = true;
    protected boolean ignore = false;
    protected boolean active = true;
    protected boolean clearAtInput = false;
    protected int maxPoints = 100000;
    protected int skip = 0;
    protected int shapeSize;
    protected int drivenBy = 0;
    protected int memorySets = 1;
    private int shapeType = -1;
    protected Color memoryColor = null;
    protected String name = "trace";
    private int counter = 0;
    private int pointsAdded = 0;
    private int pointsNotProjected = 0;
    private double[] point = new double[3];
    protected ArrayList list;
    protected ArrayList displayList;
    private OnePoint nullPoint;
    private OnePoint lastPoint = this.nullPoint = new OnePoint(this, Double.NaN, Double.NaN, Double.NaN, false, 0, this.style);
    private OnePoint flushPoint = this.nullPoint;
    private Object3D[] minimalObjects = new Object3D[1];
    private AffineTransform transform = new AffineTransform();
    private ArrayList memoryLists = new ArrayList();
    protected double xmaxLogscale;
    protected double ymaxLogscale;
    protected double xminLogscale;
    protected double yminLogscale;
    private boolean showZ = false;
    private boolean allowTable = false;

    public InteractiveTrace() {
        this.list = new ArrayList();
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof InteractiveTrace) {
            this.setMaximumPoints(((InteractiveTrace)interactiveElement).getMaximumPoints());
            this.setConnected(((InteractiveTrace)interactiveElement).isConnected());
            this.setIgnoreEqualPoints(((InteractiveTrace)interactiveElement).isIgnoreEqualPoints());
            this.setActive(((InteractiveTrace)interactiveElement).isActive());
            this.setSkip(((InteractiveTrace)interactiveElement).getSkip());
            this.setMemorySets(((InteractiveTrace)interactiveElement).getMemorySets());
            this.setMemoryColor(((InteractiveTrace)interactiveElement).getMemoryColor());
            this.setName(((InteractiveTrace)interactiveElement).getName());
            this.setAllowTable(((InteractiveTrace)interactiveElement).allowTable);
        }
    }

    @Override
    public void initializeMemberOfSet() {
        this.setAllowTable(true);
    }

    public void setMaximumPoints(int n) {
        if (n < 0 || n == this.maxPoints) {
            return;
        }
        this.maxPoints = n == 0 ? 100000 : n;
        this.counter = 0;
        this.initialize();
    }

    public int getMaximumPoints() {
        return this.maxPoints;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setIgnoreEqualPoints(boolean bl) {
        this.ignore = bl;
    }

    public boolean isIgnoreEqualPoints() {
        return this.ignore;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setClearAtInput(boolean bl) {
        this.clearAtInput = bl;
    }

    public boolean isClearAtInput() {
        return this.clearAtInput;
    }

    public void setSkip(int n) {
        if (n == this.skip) {
            return;
        }
        this.skip = n;
        this.counter = 0;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setMemorySets(int n) {
        if (n == this.memorySets || n < 0) {
            return;
        }
        this.memoryLists.clear();
        this.memorySets = n;
    }

    public int getMemorySets() {
        return this.memorySets;
    }

    public void setMemoryDrivenBy(int n) {
        this.drivenBy = n;
    }

    public int getMemoryDrivenBy() {
        return this.drivenBy;
    }

    public void setMemoryColor(Color color) {
        this.memoryColor = color;
    }

    public Color getMemoryColor() {
        return this.memoryColor;
    }

    public void setAllowTable(boolean bl) {
        this.allowTable = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
        arrayList = this.memoryLists;
        synchronized (arrayList) {
            this.memoryLists.clear();
        }
        this.pointsNotProjected = 0;
        this.pointsAdded = 0;
        this.lastPoint = this.nullPoint;
        this.flushPoint = this.nullPoint;
        this.counter = 0;
        this.showZ = false;
    }

    public synchronized void initialize() {
        if (this.memorySets == 1) {
            return;
        }
        this.pointsNotProjected = 0;
        this.pointsAdded = 0;
        this.lastPoint = this.nullPoint;
        this.flushPoint = this.nullPoint;
        if (this.list.size() <= 0) {
            return;
        }
        switch (this.memorySets) {
            default: {
                if (this.memoryLists.size() < this.memorySets - 1) break;
                this.memoryLists.remove(0);
            }
            case 0: 
        }
        if (this.memoryColor != null) {
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                ((OnePoint)iterator.next()).style.setEdgeColor(this.memoryColor);
            }
        }
        this.memoryLists.add(this.list);
        this.list = new ArrayList();
    }

    public void addPoint(double d, double d2) {
        if (this.clearAtInput) {
            this.clear();
        }
        this.addThePoint(d, d2, 0.0);
    }

    public void addPoints(double[] dArray, double[] dArray2) {
        if (this.clearAtInput) {
            this.clear();
        }
        int n = Math.min(dArray.length, dArray2.length);
        int n2 = 0;
        while (n2 < n) {
            this.addThePoint(dArray[n2], dArray2[n2], 0.0);
            ++n2;
        }
    }

    public void addPoint(double d, double d2, double d3) {
        if (this.clearAtInput) {
            this.clear();
        }
        this.showZ = true;
        this.addThePoint(d, d2, d3);
    }

    public void addPoints(double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.clearAtInput) {
            this.clear();
        }
        int n = Math.min(Math.min(dArray.length, dArray2.length), dArray3.length);
        int n2 = 0;
        while (n2 < n) {
            this.addThePoint(dArray[n2], dArray2[n2], dArray3[n2]);
            ++n2;
        }
    }

    public void moveToPoint(double d, double d2) {
        if (this.clearAtInput) {
            this.clear();
        }
        boolean bl = this.connected;
        this.connected = false;
        this.addThePoint(d, d2, 0.0);
        this.connected = bl;
    }

    public void moveToPoint(double d, double d2, double d3) {
        if (this.clearAtInput) {
            this.clear();
        }
        this.showZ = true;
        boolean bl = this.connected;
        this.connected = false;
        this.addThePoint(d, d2, d3);
        this.connected = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addThePoint(double d, double d2, double d3) {
        if (this.ignore && d == this.lastPoint.coordinates[0] && d2 == this.lastPoint.coordinates[1] && d3 == this.lastPoint.coordinates[2]) {
            return;
        }
        if (this.skip > 0) {
            if (this.counter > 0) {
                ++this.counter;
                if (this.counter >= this.skip) {
                    this.counter = 0;
                }
                this.lastPoint = this.flushPoint = new OnePoint(this, d, d2, d3, this.connected && this.pointsAdded != 0, this.shapeType, this.style);
                return;
            }
            ++this.counter;
        }
        this.flushPoint = this.nullPoint;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.maxPoints > 0 && this.list.size() >= this.maxPoints) {
                this.list.remove(0);
                if (this.list.size() > 0) {
                    ((OnePoint)this.list.get((int)0)).connected = false;
                }
            }
            this.lastPoint = new OnePoint(this, d, d2, d3, this.connected && this.pointsAdded != 0, this.shapeType, this.style);
            this.list.add(this.lastPoint);
        }
        ++this.pointsAdded;
        ++this.pointsNotProjected;
    }

    public void setShapeType(int n) {
        if (this.shapeType == n) {
            return;
        }
        this.shapeType = n;
        switch (this.shapeType) {
            default: {
                this.style.displayObject = null;
                break;
            }
            case 1: {
                this.style.displayObject = new Ellipse2D.Float();
                break;
            }
            case 2: 
            case 14: 
            case 15: {
                this.style.displayObject = new Rectangle2D.Float();
                break;
            }
            case 3: {
                this.style.displayObject = new RoundRectangle2D.Float();
            }
        }
    }

    public void setShapeSize(int n) {
        this.shapeSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ToolForDataInfo getToolForDataInfo() {
        double[][] dArrayArray;
        Color color = new Color(125, 125, 125);
        if (this.getStyle().getFillPattern() instanceof Color) {
            color = (Color)this.getStyle().getFillPattern();
        }
        ArrayList arrayList = this.displayList;
        synchronized (arrayList) {
            int n = this.displayList.size();
            dArrayArray = new double[n][];
            int n2 = 0;
            while (n2 < n) {
                OnePoint onePoint = (OnePoint)this.displayList.get(n2);
                dArrayArray[n2] = (double[])onePoint.coordinates.clone();
                ++n2;
            }
        }
        return new ToolForDataInfo(this.name, this.getStyle().getEdgeColor(), color, dArrayArray);
    }

    @Override
    public List<ToolForDataUser> getToolForDataUsers() {
        return null;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.visible) {
            return null;
        }
        if (drawingPanel instanceof DrawingPanel3D) {
            if (this.hasChanged || drawingPanel != this.panelWithValidProjection) {
                this.projectPoints(drawingPanel, true);
            } else if (this.pointsNotProjected > 0) {
                this.projectPoints(drawingPanel, false);
            }
        } else {
            this.projectPoints(drawingPanel, true);
        }
        if (this.positionEnabled && Math.abs(this.lastPoint.pixel[0] - (double)n) < (double)SENSIBILITY && Math.abs(this.lastPoint.pixel[1] - (double)n2) < (double)SENSIBILITY) {
            return new InteractionTargetTracePoint(this, new Point3D(this.lastPoint.coordinates[0], this.lastPoint.coordinates[1], this.lastPoint.coordinates[2]));
        }
        if (this.allowTable) {
            for (OnePoint onePoint : this.displayList) {
                if (!(Math.abs(onePoint.pixel[0] - (double)n) < (double)SENSIBILITY) || !(Math.abs(onePoint.pixel[1] - (double)n2) < (double)SENSIBILITY)) continue;
                return this;
            }
        }
        return null;
    }

    @Override
    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (this.list.size() <= 0 || !this.visible) {
            return null;
        }
        if (this.hasChanged || drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D, true);
        } else if (this.pointsNotProjected > 0) {
            this.projectPoints(drawingPanel3D, false);
        }
        return this.displayList.toArray(this.minimalObjects);
    }

    @Override
    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        try {
            Object object;
            Graphics2D graphics2D2 = graphics2D;
            OnePoint onePoint = (OnePoint)this.displayList.get(n);
            Color color = drawingPanel3D.projectColor(onePoint.style.edgeColor, onePoint.distance);
            if (onePoint.connected) {
                graphics2D2.setColor(color);
                graphics2D2.setStroke(onePoint.style.edgeStroke);
                object = (OnePoint)this.displayList.get(n - 1);
                graphics2D2.drawLine((int)onePoint.pixel[0], (int)onePoint.pixel[1], (int)((OnePoint)object).pixel[0], (int)((OnePoint)object).pixel[1]);
            }
            if (onePoint.style.displayObject != null) {
                object = onePoint.style.fillPattern;
                if (object instanceof Color) {
                    object = drawingPanel3D.projectColor((Color)object, onePoint.distance);
                }
                this.drawMarker(graphics2D2, onePoint, color, (Paint)object);
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.list.size() <= 0 || !this.visible) {
            return;
        }
        this.projectPoints(drawingPanel, true);
        int n = 0;
        int n2 = 0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        for (OnePoint onePoint : this.displayList) {
            if (onePoint.style.edgeColor != null) {
                graphics2D.setColor(onePoint.style.edgeColor);
                graphics2D.setStroke(onePoint.style.edgeStroke);
                if (onePoint.connected) {
                    graphics2D.drawLine((int)onePoint.pixel[0], (int)onePoint.pixel[1], n, n2);
                }
                if (onePoint.style.displayObject != null) {
                    this.drawMarker(graphics2D, onePoint, onePoint.style.edgeColor, onePoint.style.fillPattern);
                }
            }
            n = (int)onePoint.pixel[0];
            n2 = (int)onePoint.pixel[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void projectPoints(DrawingPanel drawingPanel, boolean bl) {
        Iterator iterator;
        this.displayList = new ArrayList();
        if (this.memorySets != 1) {
            switch (this.drivenBy) {
                default: {
                    iterator = this.memoryLists.iterator();
                    while (iterator.hasNext()) {
                        this.displayList.addAll((ArrayList)iterator.next());
                    }
                    break;
                }
                case 1: {
                    int n;
                    int n2;
                    for (ArrayList arrayList : this.memoryLists) {
                        n2 = 0;
                        n = Math.min(this.pointsAdded, arrayList.size());
                        while (n2 < n) {
                            this.displayList.add(arrayList.get(n2));
                            ++n2;
                        }
                    }
                    break;
                }
                case 2: {
                    OnePoint onePoint;
                    int n;
                    int n2;
                    block12: for (ArrayList arrayList : this.memoryLists) {
                        n2 = 0;
                        n = arrayList.size();
                        while (n2 < n) {
                            onePoint = (OnePoint)arrayList.get(n2);
                            if (!(onePoint.coordinates[0] <= this.lastPoint.coordinates[0])) continue block12;
                            this.displayList.add(onePoint);
                            ++n2;
                        }
                    }
                    break;
                }
                case 3: {
                    OnePoint onePoint;
                    int n;
                    int n2;
                    block14: for (ArrayList arrayList : this.memoryLists) {
                        n2 = 0;
                        n = arrayList.size();
                        while (n2 < n) {
                            onePoint = (OnePoint)arrayList.get(n2);
                            if (!(onePoint.coordinates[1] <= this.lastPoint.coordinates[1])) continue block14;
                            this.displayList.add(onePoint);
                            ++n2;
                        }
                    }
                    break;
                }
                case 4: {
                    OnePoint onePoint;
                    int n;
                    int n2;
                    block16: for (ArrayList arrayList : this.memoryLists) {
                        n2 = 0;
                        n = arrayList.size();
                        while (n2 < n) {
                            onePoint = (OnePoint)arrayList.get(n2);
                            if (!(onePoint.coordinates[2] <= this.lastPoint.coordinates[2])) continue block16;
                            this.displayList.add(onePoint);
                            ++n2;
                        }
                    }
                }
            }
        }
        iterator = this.list;
        synchronized (iterator) {
            this.displayList.addAll((ArrayList)this.list.clone());
        }
        if (this.flushPoint != this.nullPoint) {
            this.displayList.add(this.flushPoint);
        }
        int n = 0;
        int n3 = this.displayList.size();
        while (n < n3) {
            ((OnePoint)this.displayList.get(n)).project(drawingPanel, n, bl);
            ++n;
        }
        this.hasChanged = false;
        this.panelWithValidProjection = drawingPanel;
        this.pointsNotProjected = 0;
    }

    private void drawMarker(Graphics2D graphics2D, OnePoint onePoint, Color color, Paint paint) {
        if (!(onePoint.style.displayObject instanceof RectangularShape)) {
            graphics2D.setColor(color);
            graphics2D.drawOval((int)onePoint.pixel[0], (int)onePoint.pixel[1], 1, 1);
            return;
        }
        RectangularShape rectangularShape = (RectangularShape)onePoint.style.displayObject;
        AffineTransform affineTransform = graphics2D.getTransform();
        this.transform.setTransform(affineTransform);
        this.transform.rotate(-onePoint.style.angle, onePoint.pixel[0], onePoint.pixel[1]);
        graphics2D.setTransform(this.transform);
        if (this.shapeType == 14) {
            if (onePoint.b1 < onePoint.zeroB) {
                rectangularShape.setFrame(onePoint.a1, onePoint.b1, this.shapeSize, onePoint.zeroB - onePoint.b1);
            } else {
                rectangularShape.setFrame(onePoint.a1, onePoint.zeroB, this.shapeSize, onePoint.b1 - onePoint.zeroB);
            }
        } else {
            rectangularShape.setFrame(onePoint.a1, onePoint.b1, this.shapeSize, this.shapeSize);
        }
        if (this.shapeType == 15) {
            graphics2D.setColor(color);
            graphics2D.drawLine(onePoint.zeroA, onePoint.b1, onePoint.zeroA, onePoint.zeroB);
        }
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(rectangularShape);
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(onePoint.style.edgeStroke);
        graphics2D.draw(rectangularShape);
        graphics2D.setTransform(affineTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getXMinLogscale() {
        double d;
        double d2 = Double.MAX_VALUE;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object object = this.list.iterator();
            while (object.hasNext()) {
                double d3 = ((OnePoint)object.next()).coordinates[0];
                if (!(d3 > 0.0)) continue;
                d2 = Math.min(d2, d3);
            }
        }
        if (this.flushPoint != this.nullPoint && (d = this.flushPoint.coordinates[0]) > 0.0) {
            d2 = Math.min(d2, d);
        }
        if (this.memorySets != 1) {
            for (Object object : this.memoryLists) {
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    double d4 = ((OnePoint)iterator.next()).coordinates[0];
                    if (!(d4 > 0.0)) continue;
                    d2 = Math.min(d2, d4);
                }
            }
        }
        if (this.group == null) {
            return this.x + d2 * this.sizex;
        }
        return this.group.x + (this.x + d2 * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getXMaxLogscale() {
        double d;
        double d2 = -1.7976931348623157E308;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object object = this.list.iterator();
            while (object.hasNext()) {
                double d3 = ((OnePoint)object.next()).coordinates[0];
                if (!(d3 > 0.0)) continue;
                d2 = Math.max(d2, d3);
            }
        }
        if (this.flushPoint != this.nullPoint && (d = this.flushPoint.coordinates[0]) > 0.0) {
            d2 = Math.max(d2, d);
        }
        if (this.memorySets != 1) {
            for (Object object : this.memoryLists) {
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    double d4 = ((OnePoint)iterator.next()).coordinates[0];
                    if (!(d4 > 0.0)) continue;
                    d2 = Math.max(d2, d4);
                }
            }
        }
        if (this.group == null) {
            return this.x + d2 * this.sizex;
        }
        return this.group.x + (this.x + d2 * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getYMinLogscale() {
        double d;
        double d2 = Double.MAX_VALUE;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object object = this.list.iterator();
            while (object.hasNext()) {
                double d3 = ((OnePoint)object.next()).coordinates[1];
                if (!(d3 > 0.0)) continue;
                d2 = Math.min(d2, d3);
            }
        }
        if (this.flushPoint != this.nullPoint && (d = this.flushPoint.coordinates[1]) > 0.0) {
            d2 = Math.min(d2, d);
        }
        if (this.memorySets != 1) {
            for (Object object : this.memoryLists) {
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    double d4 = ((OnePoint)iterator.next()).coordinates[1];
                    if (!(d4 > 0.0)) continue;
                    d2 = Math.min(d2, d4);
                }
            }
        }
        if (this.group == null) {
            return this.y + d2 * this.sizey;
        }
        return this.group.y + (this.y + d2 * this.sizey) * this.group.sizey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getYMaxLogscale() {
        double d;
        double d2 = -1.7976931348623157E308;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object object = this.list.iterator();
            while (object.hasNext()) {
                double d3 = ((OnePoint)object.next()).coordinates[1];
                if (!(d3 > 0.0)) continue;
                d2 = Math.max(d2, d3);
            }
        }
        if (this.flushPoint != this.nullPoint && (d = this.flushPoint.coordinates[1]) > 0.0) {
            d2 = Math.max(d2, d);
        }
        if (this.memorySets != 1) {
            for (Object object : this.memoryLists) {
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    double d4 = ((OnePoint)iterator.next()).coordinates[1];
                    if (!(d4 > 0.0)) continue;
                    d2 = Math.max(d2, d4);
                }
            }
        }
        if (this.group == null) {
            return this.y + d2 * this.sizey;
        }
        return this.group.y + (this.y + d2 * this.sizey) * this.group.sizey;
    }

    @Override
    public boolean isMeasured() {
        return this.canBeMeasured && this.visible && this.list.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getXMin() {
        double d = Double.MAX_VALUE;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object object = this.list.iterator();
            while (object.hasNext()) {
                d = Math.min(d, ((OnePoint)object.next()).coordinates[0]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            d = Math.min(d, this.flushPoint.coordinates[0]);
        }
        if (this.memorySets != 1) {
            for (Object object : this.memoryLists) {
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    d = Math.min(d, ((OnePoint)iterator.next()).coordinates[0]);
                }
            }
        }
        if (this.group == null) {
            return this.x + d * this.sizex;
        }
        return this.group.x + (this.x + d * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getXMax() {
        double d = -1.7976931348623157E308;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object object = this.list.iterator();
            while (object.hasNext()) {
                d = Math.max(d, ((OnePoint)object.next()).coordinates[0]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            d = Math.max(d, this.flushPoint.coordinates[0]);
        }
        if (this.memorySets != 1) {
            for (Object object : this.memoryLists) {
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    d = Math.max(d, ((OnePoint)iterator.next()).coordinates[0]);
                }
            }
        }
        if (this.group == null) {
            return this.x + d * this.sizex;
        }
        return this.group.x + (this.x + d * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getYMin() {
        double d = Double.MAX_VALUE;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object object = this.list.iterator();
            while (object.hasNext()) {
                d = Math.min(d, ((OnePoint)object.next()).coordinates[1]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            d = Math.min(d, this.flushPoint.coordinates[1]);
        }
        if (this.memorySets != 1) {
            for (Object object : this.memoryLists) {
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    d = Math.min(d, ((OnePoint)iterator.next()).coordinates[1]);
                }
            }
        }
        if (this.group == null) {
            return this.y + d * this.sizey;
        }
        return this.group.y + (this.y + d * this.sizey) * this.group.sizey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getYMax() {
        double d = -1.7976931348623157E308;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object object = this.list.iterator();
            while (object.hasNext()) {
                d = Math.max(d, ((OnePoint)object.next()).coordinates[1]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            d = Math.max(d, this.flushPoint.coordinates[1]);
        }
        if (this.memorySets != 1) {
            for (Object object : this.memoryLists) {
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    d = Math.max(d, ((OnePoint)iterator.next()).coordinates[1]);
                }
            }
        }
        if (this.group == null) {
            return this.y + d * this.sizey;
        }
        return this.group.y + (this.y + d * this.sizey) * this.group.sizey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getZMin() {
        double d = Double.MAX_VALUE;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object object = this.list.iterator();
            while (object.hasNext()) {
                d = Math.min(d, ((OnePoint)object.next()).coordinates[2]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            d = Math.min(d, this.flushPoint.coordinates[2]);
        }
        if (this.memorySets != 1) {
            for (Object object : this.memoryLists) {
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    d = Math.min(d, ((OnePoint)iterator.next()).coordinates[2]);
                }
            }
        }
        if (this.group == null) {
            return this.z + d * this.sizez;
        }
        return this.group.z + (this.z + d * this.sizez) * this.group.sizez;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getZMax() {
        double d = -1.7976931348623157E308;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object object = this.list.iterator();
            while (object.hasNext()) {
                d = Math.max(d, ((OnePoint)object.next()).coordinates[2]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            d = Math.max(d, this.flushPoint.coordinates[2]);
        }
        if (this.memorySets != 1) {
            for (Object object : this.memoryLists) {
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    d = Math.max(d, ((OnePoint)iterator.next()).coordinates[2]);
                }
            }
        }
        if (this.group == null) {
            return this.z + d * this.sizez;
        }
        return this.group.z + (this.z + d * this.sizez) * this.group.sizez;
    }

    private class OnePoint
    extends Object3D {
        boolean connected;
        boolean alreadyProjected;
        double[] coordinates;
        double[] pixel;
        int a1;
        int b1;
        int zeroA;
        int zeroB;
        int shapeType;
        Style style;

        OnePoint(Drawable3D drawable3D, double d, double d2, double d3, boolean bl, int n, Style style) {
            super(drawable3D, -1);
            this.coordinates = new double[3];
            this.pixel = new double[3];
            this.zeroA = 0;
            this.zeroB = 0;
            this.style = null;
            this.coordinates[0] = d;
            this.coordinates[1] = d2;
            this.coordinates[2] = d3;
            this.connected = bl;
            this.shapeType = n;
            if (style != null) {
                this.style = new Style(style);
            }
            this.alreadyProjected = false;
        }

        protected void project(DrawingPanel drawingPanel, int n, boolean bl) {
            this.index = n;
            if (!bl && this.alreadyProjected) {
                return;
            }
            if (this.shapeType == 14 || this.shapeType == 15) {
                if (InteractiveTrace.this.group == null) {
                    ((InteractiveTrace)InteractiveTrace.this).point[0] = InteractiveTrace.this.x + this.coordinates[0] * InteractiveTrace.this.sizex;
                    ((InteractiveTrace)InteractiveTrace.this).point[1] = 0.0;
                    ((InteractiveTrace)InteractiveTrace.this).point[2] = 0.0;
                } else {
                    ((InteractiveTrace)InteractiveTrace.this).point[0] = InteractiveTrace.this.group.x + (InteractiveTrace.this.x + this.coordinates[0] * InteractiveTrace.this.sizex) * InteractiveTrace.this.group.sizex;
                    ((InteractiveTrace)InteractiveTrace.this).point[1] = 0.0;
                    ((InteractiveTrace)InteractiveTrace.this).point[2] = 0.0;
                }
                drawingPanel.project(InteractiveTrace.this.point, this.pixel);
                this.zeroA = (int)this.pixel[0];
                this.zeroB = (int)this.pixel[1];
            }
            if (InteractiveTrace.this.group == null) {
                ((InteractiveTrace)InteractiveTrace.this).point[0] = InteractiveTrace.this.x + this.coordinates[0] * InteractiveTrace.this.sizex;
                ((InteractiveTrace)InteractiveTrace.this).point[1] = InteractiveTrace.this.y + this.coordinates[1] * InteractiveTrace.this.sizey;
                ((InteractiveTrace)InteractiveTrace.this).point[2] = InteractiveTrace.this.z + this.coordinates[2] * InteractiveTrace.this.sizez;
            } else {
                ((InteractiveTrace)InteractiveTrace.this).point[0] = InteractiveTrace.this.group.x + (InteractiveTrace.this.x + this.coordinates[0] * InteractiveTrace.this.sizex) * InteractiveTrace.this.group.sizex;
                ((InteractiveTrace)InteractiveTrace.this).point[1] = InteractiveTrace.this.group.y + (InteractiveTrace.this.y + this.coordinates[1] * InteractiveTrace.this.sizey) * InteractiveTrace.this.group.sizey;
                ((InteractiveTrace)InteractiveTrace.this).point[2] = InteractiveTrace.this.group.z + (InteractiveTrace.this.z + this.coordinates[2] * InteractiveTrace.this.sizez) * InteractiveTrace.this.group.sizez;
            }
            drawingPanel.project(InteractiveTrace.this.point, this.pixel);
            this.alreadyProjected = true;
            this.distance = this.pixel[2];
            if (this.style.displayObject instanceof RectangularShape) {
                double d;
                double d2;
                RectangularShape rectangularShape = (RectangularShape)this.style.displayObject;
                switch (this.style.position) {
                    default: {
                        d2 = rectangularShape.getWidth() / 2.0;
                        d = rectangularShape.getHeight() / 2.0;
                        break;
                    }
                    case 1: {
                        d2 = rectangularShape.getWidth() / 2.0;
                        d = 0.0;
                        break;
                    }
                    case 2: {
                        d2 = rectangularShape.getWidth() / 2.0;
                        d = rectangularShape.getHeight();
                        break;
                    }
                    case 3: {
                        d2 = rectangularShape.getWidth();
                        d = rectangularShape.getHeight() / 2.0;
                        break;
                    }
                    case 7: {
                        d2 = rectangularShape.getWidth();
                        d = rectangularShape.getHeight();
                        break;
                    }
                    case 5: {
                        d2 = rectangularShape.getWidth();
                        d = 0.0;
                        break;
                    }
                    case 4: {
                        d2 = 0.0;
                        d = rectangularShape.getHeight() / 2.0;
                        break;
                    }
                    case 8: {
                        d2 = 0.0;
                        d = rectangularShape.getHeight();
                        break;
                    }
                    case 6: {
                        d2 = 0.0;
                        d = 0.0;
                    }
                }
                if (this.shapeType == 14) {
                    this.a1 = (int)(this.pixel[0] - d2);
                    this.b1 = (int)this.pixel[1];
                } else {
                    this.a1 = (int)(this.pixel[0] - d2);
                    this.b1 = (int)(this.pixel[1] - d);
                }
            }
        }
    }
}

