/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.carmotion_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.RK4;
import org.opensourcephysics.tools.ResourceLoader;
import users.ntnu.fkh.carmotion_pkg.carmotionSimulation;
import users.ntnu.fkh.carmotion_pkg.carmotionView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class carmotion
extends AbstractModel {
    public carmotionSimulation _simulation = null;
    public carmotionView _view = null;
    public carmotion _model = this;
    public double range = 200.0;
    public double xmin = -this.range;
    public double xmax = this.range;
    public double ymin = -this.range / 2.0;
    public double ymax = this.range / 2.0;
    public double t = 0.0;
    public double dt = 0.05;
    public double size = this.range / 10.0;
    public double size2 = this.size / 2.0;
    public double stroke = 2.0;
    public double w = 8.0 * this.size;
    public double h = 3.0 * this.size;
    public double g = 10.0;
    public double m = 20.0;
    public double fcst = 0.4;
    public double zero = 0.0;
    public double x = 0.0;
    public double y = 0.0;
    public double vx = 0.0;
    public double vy = 0.0;
    public double cta = 0.0;
    public double T = 3.0;
    public double omega0 = Math.PI * 2 / this.T;
    public double omega = 0.0;
    public double pi = Math.PI;
    public double NA = 0.0;
    public double NB = 0.0;
    public int ng = 12;
    public int ng2 = this.ng * 2;
    public int ng4 = this.ng * 4;
    public double[] GX;
    public double[] GY;
    public boolean bgmove = true;
    public double gvx = 0.0;
    public double gvy = 0.0;
    public double gx = 0.0;
    public double gy = 0.0;
    public String l_play = "play";
    public String l_pause = "pause";
    public String l_reset = "reset";
    public String l_init = "initialize";
    public String label = this.l_pause;
    public String l_step = "step";
    public String l_engine = "engine power=0.0";
    public String l_power = "power on";
    public String l_showF2 = "rear tire force";
    public String l_showF1 = "front tire force";
    public String l_showN = "Normal force";
    public double d = this.w / 2.5;
    public double k = 10.0;
    public double b = 0.2;
    public double a = 0.0;
    public boolean power = false;
    public double fr = 0.0;
    public double cta2 = 0.0;
    private _ODE_evolution1 _ODEi_evolution1;
    double gdx;
    double gdy;

    public static String _getEjsModel() {
        return "users/ntnu/fkh/carmotion.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
        }
        carmotion carmotion2 = new carmotion(stringArray);
    }

    public carmotion() {
        this(null, null, null, null, null, false);
    }

    public carmotion(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public carmotion(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new carmotionSimulation(this, string, frame, uRL, bl);
        this._view = (carmotionView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.gridinit();
    }

    public void _constraints1() {
        this.checkgrid();
        if (this.power) {
            this.omega = -this.omega0;
            this.fr = -this.k * this.omega;
        } else {
            this.omega = 0.0;
            this.fr = this.a;
        }
    }

    public void zh_tw() {
        this.l_play = "\u64ad\u653e";
        this.l_init = "\u521d\u59cb\u5316";
        this.l_reset = "\u91cd\u8a2d";
        this.l_pause = "\u66ab\u505c";
        this.l_step = "\u524d\u9032\u4e00\u683c";
        this.l_engine = "\u5f15\u64ce\u99ac\u529b=0.0";
        this.l_power = "\u958b\u555f\u5f15\u64ce";
        this.l_showF1 = "\u524d\u8f2a\u53d7\u529b";
        this.l_showF2 = "\u5f8c\u8f2a\u53d7\u529b";
        this.l_showN = "\u6b63\u5411\u529b";
        this.label = this.l_pause;
        this._initialize();
    }

    public void locale(String string) {
        if (string.equals("zh_tw")) {
            this.zh_tw();
        }
    }

    public void gridinit() {
        this.gdx = (this.xmax - this.xmin) / (double)(this.ng - 2);
        this.gdy = (this.ymax - this.ymin) / (double)(this.ng - 2);
        for (int i = 0; i < this.ng2; i += 2) {
            double d = this.xmin - this.gdx + (double)(i / 2) * this.gdx;
            this.GX[i + 1] = d;
            this.GX[i] = d;
            double d2 = this.ymin - this.gdy + (double)(i / 2) * this.gdy;
            this.GY[this.ng2 + i + 1] = d2;
            this.GY[this.ng2 + i] = d2;
            if (i / 2 % 2 == 0) {
                this.GY[i] = this.ymin - this.gdy;
                this.GY[i + 1] = this.ymax;
                this.GX[this.ng2 + i] = this.xmax;
                this.GX[this.ng2 + i + 1] = this.xmin - this.gdx;
                continue;
            }
            this.GY[i] = this.ymax;
            this.GY[i + 1] = this.ymin - this.gdy;
            this.GX[this.ng2 + i] = this.xmin - this.gdx;
            this.GX[this.ng2 + i + 1] = this.xmax;
        }
        this.gy = 0.0;
        this.gx = 0.0;
    }

    public void checkgrid() {
        if (this.gx > this.gdx) {
            this.gx -= this.gdx;
        } else if (this.gx < 0.0) {
            this.gx += this.gdx;
        }
        if (this.gy > this.gdy) {
            this.gy -= this.gdy;
        } else if (this.gy < 0.0) {
            this.gy += this.gdy;
        }
    }

    public void playpause() {
        if (this.label == this.l_play) {
            this.label = this.l_pause;
            this._play();
        } else {
            this.label = this.l_play;
            this._pause();
        }
    }

    public double _method_for_base_y() {
        return this.y - this.h / 2.0 - this.size2;
    }

    public double _method_for_base_sizex() {
        return this.xmax - this.xmin;
    }

    public double _method_for_base_sizey() {
        return this.y - this.h / 2.0 - this.size2 - this.ymin;
    }

    public double _method_for_car2_x() {
        return this.x + this.w / 2.0;
    }

    public double _method_for_car2_sizex() {
        return this.h / 2.0;
    }

    public double _method_for_car2_sizey() {
        return this.h / 2.0;
    }

    public double _method_for_engine_x() {
        return this.x + this.w / 2.0 + this.h / 4.0;
    }

    public double _method_for_engine_y() {
        return this.y - this.h / 4.0;
    }

    public double _method_for_ArrowVX_sizex() {
        return -this.gvx;
    }

    public double _method_for_ArrowL_x() {
        return this.x + this.w / 2.0 + this.h / 4.0;
    }

    public double _method_for_ArrowL_y() {
        return this.y - this.h / 4.0 + this.size / 4.0;
    }

    public double _method_for_ArrowL_sizex() {
        return -this.size2 / 2.0 - this.h / 2.0;
    }

    public double _method_for_ArrowL_sizey() {
        return -this.h / 4.0 + this.size / 8.0;
    }

    public double _method_for_ArrowR_x() {
        return this.x + this.w / 2.0 + this.h / 4.0;
    }

    public double _method_for_ArrowR_y() {
        return this.y - this.h / 4.0 - this.size / 4.0;
    }

    public double _method_for_ArrowR_sizex() {
        return this.size2 / 2.0 - this.h / 2.0;
    }

    public double _method_for_ArrowR_sizey() {
        return -this.h / 4.0;
    }

    public double _method_for_tireA_x() {
        return this.x + this.d;
    }

    public double _method_for_tireA_y() {
        return this.y - this.h / 2.0;
    }

    public double _method_for_tireB_x() {
        return this.x - this.d;
    }

    public double _method_for_tireB_y() {
        return this.y - this.h / 2.0;
    }

    public double _method_for_ArrowFrA_x() {
        return this.x + this.d;
    }

    public double _method_for_ArrowFrA_y() {
        return this.y - this.h / 2.0 - this.size2 / 1.2;
    }

    public double _method_for_ArrowFrB_x() {
        return this.x - this.d;
    }

    public double _method_for_ArrowFrB_y() {
        return this.y - this.h / 2.0 - this.size2 / 1.2;
    }

    public double _method_for_ArrowFrB_sizex() {
        return -this.fr / 3.0;
    }

    public double _method_for_ArrowNB_x() {
        return this.x - this.d;
    }

    public double _method_for_ArrowNB_y() {
        return this.y - this.h / 2.0 - this.size2;
    }

    public double _method_for_ArrowNB_sizey() {
        return this.m * (this.g / 2.0 - this.a * (this.h / 4.0 + this.size2) / (2.0 * this.d));
    }

    public double _method_for_Arrowmg_sizey() {
        return -this.m * this.g;
    }

    public double _method_for_ArrowNA_x() {
        return this.x + this.d;
    }

    public double _method_for_ArrowNA_y() {
        return this.y - this.h / 2.0 - this.size2;
    }

    public double _method_for_ArrowNA_sizey() {
        return this.m * (this.g / 2.0 + this.a * (this.h / 4.0 + this.size2) / (2.0 * this.d));
    }

    public double _method_for_Slideromega_minimum() {
        return -1.2 * this.pi;
    }

    public double _method_for_Slideromega_maximum() {
        return 1.2 * this.pi;
    }

    public void _method_for_reset_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_initialize_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_playpause_enabled() {
        return this.gvx != 0.0 || this.power;
    }

    public void _method_for_playpause_action() {
        this._simulation.disableLoop();
        this.playpause();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.range = 200.0;
        this.xmin = -this.range;
        this.xmax = this.range;
        this.ymin = -this.range / 2.0;
        this.ymax = this.range / 2.0;
        this.t = 0.0;
        this.dt = 0.05;
        this.size = this.range / 10.0;
        this.size2 = this.size / 2.0;
        this.stroke = 2.0;
        this.w = 8.0 * this.size;
        this.h = 3.0 * this.size;
        this.g = 10.0;
        this.m = 20.0;
        this.fcst = 0.4;
        this.zero = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.vx = 0.0;
        this.vy = 0.0;
        this.cta = 0.0;
        this.T = 3.0;
        this.omega0 = Math.PI * 2 / this.T;
        this.omega = 0.0;
        this.pi = Math.PI;
        this.NA = 0.0;
        this.NB = 0.0;
        this.ng = 12;
        this.ng2 = this.ng * 2;
        this.ng4 = this.ng * 4;
        this.GX = new double[this.ng4];
        for (n = 0; n < this.ng4; ++n) {
            this.GX[n] = 0.0;
        }
        this.GY = new double[this.ng4];
        for (n = 0; n < this.ng4; ++n) {
            this.GY[n] = 0.0;
        }
        this.bgmove = true;
        this.gvx = 0.0;
        this.gvy = 0.0;
        this.gx = 0.0;
        this.gy = 0.0;
        this.l_play = "play";
        this.l_pause = "pause";
        this.l_reset = "reset";
        this.l_init = "initialize";
        this.label = this.l_pause;
        this.l_step = "step";
        this.l_engine = "engine power=0.0";
        this.l_power = "power on";
        this.l_showF2 = "rear tire force";
        this.l_showF1 = "front tire force";
        this.l_showN = "Normal force";
        this.d = this.w / 2.5;
        this.k = 10.0;
        this.b = 0.2;
        this.a = 0.0;
        this.power = false;
        this.fr = 0.0;
        this.cta2 = 0.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.GX = null;
        this.GY = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private RK4 __solver = null;
        private double[] __state = null;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[6];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = carmotion.this.gx;
            this.__state[n++] = carmotion.this.gvx;
            this.__state[n++] = carmotion.this.gy;
            this.__state[n++] = carmotion.this.cta;
            this.__state[n++] = carmotion.this.cta2;
            this.__state[n++] = carmotion.this.t;
            this.__solver = new RK4(this);
            this.__solver.initialize(carmotion.this.dt);
        }

        void step() {
            if (carmotion.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(carmotion.this.dt);
            }
            int n = 0;
            this.__state[n++] = carmotion.this.gx;
            this.__state[n++] = carmotion.this.gvx;
            this.__state[n++] = carmotion.this.gy;
            this.__state[n++] = carmotion.this.cta;
            this.__state[n++] = carmotion.this.cta2;
            this.__state[n++] = carmotion.this.t;
            this.__solver.step();
            n = 0;
            carmotion.this.gx = this.__state[n++];
            carmotion.this.gvx = this.__state[n++];
            carmotion.this.gy = this.__state[n++];
            carmotion.this.cta = this.__state[n++];
            carmotion.this.cta2 = this.__state[n++];
            carmotion.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            double d4 = dArray[n++];
            double d5 = dArray[n++];
            double d6 = dArray[n++];
            n = 0;
            dArray2[n++] = d2;
            dArray2[n++] = carmotion.this.a = carmotion.this.k * carmotion.this.omega - carmotion.this.b * d2;
            dArray2[n++] = carmotion.this.gvy;
            dArray2[n++] = carmotion.this.omega * 5.0;
            dArray2[n++] = d2 / carmotion.this.size2;
            dArray2[n++] = 1.0;
        }
    }
}

