/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarTool
implements Tool,
Runnable {
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int YES_TO_ALL = 2;
    public static final int NO_TO_ALL = 3;
    private static final String BUNDLE_NAME = "org.opensourcephysics.resources.tools.tools";
    private static ResourceBundle res = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.tools");
    private static JarTool TOOL = new JarTool();
    private static JFileChooser chooser;
    private static int overwritePolicy;
    private static Frame ownerFrame;
    private static Map<String, Map<String, ZipEntry>> jarContents;
    private ArrayList<String> instanceSources;
    private File instanceParent;
    private File instanceTarget;
    private Manifest instanceManifest;
    private OverwriteValue instancePolicy;
    private Frame instanceOwnerFrame;

    static {
        overwritePolicy = 1;
        ownerFrame = null;
        jarContents = new HashMap<String, Map<String, ZipEntry>>();
    }

    public static void setLocale(Locale locale) {
        res = ResourceBundle.getBundle(BUNDLE_NAME, locale);
    }

    public static String getString(String string) {
        try {
            return res.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + string + '!';
        }
    }

    public static JarTool getTool() {
        if (TOOL == null) {
            TOOL = new JarTool();
        }
        return TOOL;
    }

    private JarTool() {
        String string = "JarTool";
        chooser = OSPRuntime.createChooser("JAR, ZIP", new String[]{"zip", "jar"});
        Toolbox.addTool(string, this);
    }

    @Override
    public void run() {
        JarTool.compressList(this.instanceSources, this.instanceParent, this.instanceTarget, this.instanceManifest, this.instancePolicy, this.instanceOwnerFrame);
    }

    private JarTool(ArrayList<String> arrayList, File file, File file2, Manifest manifest, OverwriteValue overwriteValue, Frame frame) {
        this();
        this.instanceSources = arrayList;
        this.instanceParent = file;
        this.instanceTarget = file2;
        this.instanceManifest = manifest;
        this.instancePolicy = overwriteValue;
        this.instanceOwnerFrame = frame;
    }

    @Override
    public void send(Job job, Tool tool) throws RemoteException {
    }

    public static void disableWarning() {
        JarTool.alwaysOverwrite();
    }

    public static void neverOverwrite() {
        overwritePolicy = 3;
    }

    public static void alwaysOverwrite() {
        overwritePolicy = 2;
    }

    public static void setOwnerFrame(Frame frame) {
        ownerFrame = frame;
    }

    public File create(ArrayList<String> arrayList, File file, File file2, Manifest manifest) {
        OverwriteValue overwriteValue;
        block11: {
            int n;
            String string;
            boolean bl;
            block10: {
                overwriteValue = new OverwriteValue(overwritePolicy);
                overwritePolicy = 1;
                if (arrayList.size() <= 0) {
                    return null;
                }
                try {
                    bl = true;
                    if (file2 != null) {
                        chooser.setCurrentDirectory(file2.getParentFile());
                        chooser.setSelectedFile(file2);
                    } else {
                        chooser.setSelectedFile(new File("default.jar"));
                    }
                    string = OSPRuntime.chooseFilename(chooser);
                    if (string != null) break block10;
                    return null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            if (!string.toLowerCase().endsWith(".jar") && !string.toLowerCase().endsWith(".zip")) {
                string = String.valueOf(string) + ".jar";
            } else {
                bl = false;
            }
            file2 = new File(string);
            if (XML.forwardSlash(file2.getAbsolutePath()).equals(OSPRuntime.getLaunchJarPath())) {
                String[] stringArray = new String[]{res.getString("JarTool.JarNotCreated"), String.valueOf(res.getString("JarTool.FileIsForbidden")) + " " + file2};
                JOptionPane.showMessageDialog(null, stringArray, res.getString("JarTool.Error"), 2);
                return this.create(arrayList, file, file2, manifest);
            }
            if (!bl || !file2.exists() || (n = JOptionPane.showConfirmDialog(null, String.valueOf(DisplayRes.getString("DrawingFrame.ReplaceExisting_message")) + " " + file2.getName() + DisplayRes.getString("DrawingFrame.QuestionMark"), DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"), 1)) == 0) break block11;
            return null;
        }
        JarTool jarTool = new JarTool(arrayList, file, file2, manifest, overwriteValue, ownerFrame);
        Thread thread = new Thread(jarTool);
        thread.setPriority(5);
        thread.start();
        return file2;
    }

    public File append(ArrayList<String> arrayList, File file, String string) {
        File file2;
        OverwriteValue overwriteValue;
        block5: {
            overwriteValue = new OverwriteValue(overwritePolicy);
            overwritePolicy = 1;
            if (arrayList.size() <= 0) {
                return null;
            }
            try {
                file2 = new File(file, string);
                if (file2.exists()) break block5;
                String[] stringArray = new String[]{res.getString("JarTool.JarNotCreated"), String.valueOf(res.getString("JarTool.FileDoesntExist")) + " " + string};
                JOptionPane.showMessageDialog(null, stringArray, res.getString("JarTool.Error"), 2);
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if (!arrayList.contains(string)) {
            arrayList.add(0, string);
        }
        return JarTool.compressList(arrayList, file, file2, JarTool.getManifest(file2), overwriteValue, ownerFrame);
    }

    public static Manifest createManifest(String string, String string2) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Manifest-Version: 1.0\n");
            stringBuffer.append("Built-By: Open Source Physics JarTool\n");
            if (string != null) {
                stringBuffer.append("Class-Path: " + string + "\n");
            }
            if (string2 != null) {
                stringBuffer.append("Main-Class: " + string2 + "\n");
            }
            stringBuffer.append("\n");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF-8"));
            return new Manifest(byteArrayInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Manifest getManifest(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            return jarFile.getManifest();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static File extract(File file, String string, String string2) {
        return JarTool.extract(file, string, new File(string2));
    }

    public static File extract(File file, String string, File file2) {
        if (!file.exists() || string == null || string.trim().length() < 1 || file2 == null) {
            return null;
        }
        boolean bl = string.lastIndexOf("/") == string.length() - 1;
        try {
            int n;
            Object object2;
            Map<String, ZipEntry> map = jarContents.get(file.getPath());
            if (map == null) {
                ZipEntry zipEntry;
                map = new HashMap<String, ZipEntry>();
                jarContents.put(file.getPath(), map);
                object2 = new ZipInputStream(new FileInputStream(file));
                Object object3 = null;
                while ((zipEntry = ((ZipInputStream)object2).getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) continue;
                    map.put(zipEntry.getName(), zipEntry);
                }
                ((ZipInputStream)object2).close();
            }
            if (bl) {
                for (String string2 : map.keySet()) {
                    if (!string2.startsWith(string)) continue;
                    ZipEntry zipEntry = map.get(string2);
                    int n2 = string.length();
                    File file3 = new File(file2, zipEntry.getName().substring(n2));
                    JarTool.extract(file, string2, file3);
                }
                return file2;
            }
            object2 = map.get(string);
            ZipFile zipFile = new ZipFile(file);
            InputStream inputStream = zipFile.getInputStream((ZipEntry)object2);
            file2.getParentFile().mkdirs();
            byte[] byArray = new byte[1024];
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            zipFile.close();
            return file2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static File extract(ClassLoader classLoader, String string, File file) {
        URL uRL;
        block5: {
            if (string == null || string.trim().length() <= 0 || file == null) {
                return null;
            }
            uRL = classLoader.getResource(string);
            if (uRL != null) break block5;
            return null;
        }
        try {
            int n;
            file.getParentFile().mkdirs();
            byte[] byArray = new byte[1024];
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            bufferedInputStream.close();
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static File extract(String string, File file) {
        InputStream inputStream;
        block5: {
            if (string == null || string.trim().length() <= 0 || file == null) {
                return null;
            }
            inputStream = ResourceLoader.getResource(string, false).openInputStream();
            if (inputStream != null) break block5;
            return null;
        }
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            file.getParentFile().mkdirs();
            byte[] byArray = new byte[1024];
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            bufferedInputStream.close();
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean extract(Object var0, List<?> var1_1, File var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CASE], 0[SWITCH]], but top level block is 4[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean copy(File file, File file2) {
        block4: {
            if (file.exists()) break block4;
            return false;
        }
        try {
            int n;
            file2.getParentFile().mkdirs();
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean compress(File file, File file2, Manifest manifest) {
        block12: {
            if (file.exists() & file.isDirectory()) break block12;
            return false;
        }
        try {
            Object object;
            if (file2.exists()) {
                file2.delete();
            }
            ZipOutputStream zipOutputStream = null;
            boolean bl = file2.getName().toLowerCase().endsWith(".jar");
            if (bl) {
                object = new File(file, "META-INF");
                JarTool.remove((File)object);
                zipOutputStream = manifest != null ? new JarOutputStream((OutputStream)new FileOutputStream(file2), manifest) : new JarOutputStream(new FileOutputStream(file2));
            } else {
                zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            }
            object = JarTool.getContents(file);
            String string = file.getAbsolutePath().replace('\\', '/');
            if (!string.endsWith("/")) {
                string = String.valueOf(string) + "/";
            }
            int n = string.length();
            byte[] byArray = new byte[1024];
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                int n2;
                File file3 = (File)iterator.next();
                FileInputStream fileInputStream = new FileInputStream(file3);
                String string2 = file3.getAbsolutePath().replace('\\', '/');
                if (string2.startsWith(string)) {
                    string2 = string2.substring(n);
                }
                if (bl) {
                    zipOutputStream.putNextEntry(new JarEntry(string2));
                } else {
                    zipOutputStream.putNextEntry(new ZipEntry(string2));
                }
                while ((n2 = fileInputStream.read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n2);
                }
                fileInputStream.close();
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean compress(ArrayList<File> arrayList, File file, Manifest manifest) {
        block12: {
            if (arrayList != null && arrayList.size() != 0) break block12;
            return false;
        }
        try {
            if (file.exists()) {
                file.delete();
            }
            ZipOutputStream zipOutputStream = null;
            boolean bl = file.getName().toLowerCase().endsWith(".jar");
            zipOutputStream = bl ? (manifest != null ? new JarOutputStream((OutputStream)new FileOutputStream(file), manifest) : new JarOutputStream(new FileOutputStream(file))) : new ZipOutputStream(new FileOutputStream(file));
            String string = arrayList.get(0).getParentFile().getAbsolutePath().replace('\\', '/');
            if (!string.endsWith("/")) {
                string = String.valueOf(string) + "/";
            }
            int n = string.length();
            ArrayList<File> arrayList2 = new ArrayList<File>();
            for (File file2 : arrayList) {
                if (bl && manifest != null && file2.getName().equals("META-INF")) continue;
                if (file2.isDirectory()) {
                    arrayList2.addAll(JarTool.getContents(file2));
                    continue;
                }
                arrayList2.add(file2);
            }
            Object object = new byte[1024];
            int n2 = 0;
            int n3 = arrayList2.size();
            while (n2 < n3) {
                int n4;
                File file3 = (File)arrayList2.get(n2);
                FileInputStream fileInputStream = new FileInputStream(file3);
                String string2 = file3.getAbsolutePath().replace('\\', '/');
                if (string2.startsWith(string)) {
                    string2 = string2.substring(n);
                }
                if (bl) {
                    zipOutputStream.putNextEntry(new JarEntry(string2));
                } else {
                    zipOutputStream.putNextEntry(new ZipEntry(string2));
                }
                while ((n4 = fileInputStream.read((byte[])object)) != -1) {
                    zipOutputStream.write((byte[])object, 0, n4);
                }
                fileInputStream.close();
                zipOutputStream.closeEntry();
                ++n2;
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean remove(File file) {
        if (file.exists() && file.isDirectory()) {
            return JarTool.recursiveClearDirectory(file, FileSystemView.getFileSystemView());
        }
        return false;
    }

    public static Collection<File> getContents(File file) {
        if (file.exists() && file.isDirectory()) {
            return JarTool.recursiveGetDirectory(file, FileSystemView.getFileSystemView());
        }
        return new HashSet<File>();
    }

    public static boolean unzip(File file, File file2) {
        return JarTool.unzipWithWarning(file, file2, new OverwriteValue(2));
    }

    public static boolean unzipNoOverwrite(File file, File file2) {
        return JarTool.unzipWithWarning(file, file2, new OverwriteValue(3));
    }

    public static boolean unzipWithAWarning(File file, File file2) {
        return JarTool.unzipWithWarning(file, file2, new OverwriteValue(1));
    }

    public static int confirmOverwrite(String string) {
        final JDialog jDialog = new JDialog();
        final OverwriteValue overwriteValue = new OverwriteValue(1);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                String string = abstractButton.getActionCommand();
                if (string.equals("yes")) {
                    overwriteValue.value = 0;
                } else if (string.equals("no")) {
                    overwriteValue.value = 1;
                } else if (string.equals("yesToAll")) {
                    overwriteValue.value = 2;
                } else if (string.equals("noToAll")) {
                    overwriteValue.value = 3;
                }
                jDialog.setVisible(false);
            }
        };
        JButton jButton = new JButton(res.getString("JarTool.Yes"));
        jButton.setActionCommand("yes");
        jButton.addMouseListener(mouseAdapter);
        JButton jButton2 = new JButton(res.getString("JarTool.No"));
        jButton2.setActionCommand("no");
        jButton2.addMouseListener(mouseAdapter);
        JButton jButton3 = new JButton(res.getString("JarTool.YesToAll"));
        jButton3.setActionCommand("yesToAll");
        jButton3.addMouseListener(mouseAdapter);
        JButton jButton4 = new JButton(res.getString("JarTool.NoToAll"));
        jButton4.setActionCommand("noToAll");
        jButton4.addMouseListener(mouseAdapter);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(jButton3);
        jPanel.add(jButton2);
        jPanel.add(jButton4);
        JLabel jLabel = new JLabel(String.valueOf(DisplayRes.getString("DrawingFrame.ReplaceExisting_message")) + " " + string + DisplayRes.getString("DrawingFrame.QuestionMark"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jDialog.setTitle(DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"));
        jDialog.getContentPane().setLayout(new BorderLayout(5, 0));
        jDialog.getContentPane().add((Component)jLabel, "Center");
        jDialog.getContentPane().add((Component)jPanel, "South");
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                overwriteValue.value = 1;
            }
        });
        jDialog.validate();
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setModal(true);
        jDialog.setVisible(true);
        return overwriteValue.value;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean unzipWithWarning(File var0, File var1_1, OverwriteValue var2_2) {
        try {
            if (!var0.exists()) {
                return false;
            }
            var3_3 = new ZipInputStream(new FileInputStream(var0));
            var4_5 = null;
            var5_6 = new byte[1024];
            block9: while (true) lbl-1000:
            // 5 sources

            {
                if ((var4_5 = var3_3.getNextEntry()) == null) {
                    var3_3.close();
                    return true;
                }
                if (var4_5.isDirectory()) continue;
                var6_7 = new File(var1_1, var4_5.getName());
                if (var6_7.exists()) {
                    switch (var2_2.value) {
                        case 3: {
                            continue block9;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            var2_2.value = JarTool.confirmOverwrite(var4_5.getName());
                            switch (var2_2.value) {
                                case 1: 
                                case 3: {
                                    ** break;
                                }
                            }
                        }
                    }
                }
                var6_7.getParentFile().mkdirs();
                var8_9 = new FileOutputStream(var6_7);
                while (true) {
                    if ((var7_8 = var3_3.read(var5_6)) == -1) {
                        var8_9.close();
                        var3_3.closeEntry();
                        continue block9;
                    }
                    var8_9.write(var5_6, 0, var7_8);
                }
                break;
            }
        }
        catch (Exception var3_4) {
            var3_4.printStackTrace();
            return false;
        }
    }

    private static File compressList(ArrayList<String> arrayList, File file, File file2, Manifest manifest, OverwriteValue overwriteValue, Frame frame) {
        String string;
        File file3 = null;
        try {
            file3 = File.createTempFile("JarTool", ".tmp", file2.getParentFile());
            file3.delete();
        }
        catch (Exception exception) {
            file3 = null;
        }
        if (file3 == null || !file3.mkdirs()) {
            String[] stringArray = new String[]{res.getString("JarTool.JarNotCreated"), res.getString("JarTool.CantCreateTemp")};
            JOptionPane.showMessageDialog(null, stringArray, res.getString("JarTool.Error"), 2);
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = arrayList.size();
        int n2 = 1;
        int n3 = 0;
        if (n > 10) {
            n2 = Math.round((float)n / 10.0f);
            n = 10;
        }
        ProgressDialog progressDialog = new ProgressDialog(frame, n + 2, "JarTool", new Dimension(350, 150));
        String string2 = res.getString("JarTool.ProcessingFile");
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (n3 % n2 == 0) {
                progressDialog.reportProgress(string2);
            }
            ++n3;
            string = iterator.next().toString();
            if (string == null) continue;
            stringBuffer.append(JarTool.processFile(string, new File(file, string), file3, overwriteValue));
        }
        boolean bl = false;
        string = stringBuffer.toString().trim();
        if (string.length() > 0) {
            String[] stringArray = new String[]{res.getString("JarTool.JarNotCreated"), string};
            JOptionPane.showMessageDialog(null, stringArray, res.getString("JarTool.Error"), 2);
        } else {
            progressDialog.reportProgress(res.getString("JarTool.CompressingFile"));
            if (JarTool.compress(file3, file2, manifest)) {
                bl = true;
            } else {
                String[] stringArray = new String[]{res.getString("JarTool.JarNotCreated"), String.valueOf(res.getString("JarTool.CantCompress")) + " " + file2.getAbsolutePath()};
                JOptionPane.showMessageDialog(null, stringArray, res.getString("JarTool.Error"), 2);
            }
        }
        progressDialog.reportProgress(res.getString("JarTool.CleaningTempFile"));
        JarTool.remove(file3);
        progressDialog.dispose();
        if (bl) {
            return file2;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static StringBuffer processFile(String var0, File var1_1, File var2_2, OverwriteValue var3_3) {
        if (!var1_1.exists() && var0.indexOf("!") == -1) {
            return new StringBuffer(String.valueOf(JarTool.res.getString("JarTool.FileDoesntExist")) + " " + var1_1.getAbsolutePath() + ".\n");
        }
        if (var1_1.isDirectory()) {
            var4_4 = new StringBuffer();
            var5_6 = FileSystemView.getFileSystemView();
            var6_8 = var5_6.getFiles(var1_1, false);
            var7_11 = 0;
            var8_13 = var6_8.length;
            while (var7_11 < var8_13) {
                var4_4.append(JarTool.processFile(String.valueOf(var0) + "/" + var6_8[var7_11].getName(), var6_8[var7_11], var2_2, var3_3));
                ++var7_11;
            }
            return var4_4;
        }
        var4_5 = var1_1.getName().toLowerCase();
        if (var4_5.endsWith(".jar") || var4_5.endsWith(".zip")) {
            if (JarTool.unzipWithWarning(var1_1, var2_2, var3_3)) {
                return new StringBuffer();
            }
            return new StringBuffer(String.valueOf(JarTool.res.getString("JarTool.CantUncompress")) + " " + var1_1.getAbsolutePath() + ".\n");
        }
        var5_7 = var0.indexOf("!");
        if (var5_7 <= -1) ** GOTO lbl29
        var6_9 = var0.substring(var5_7 + 2);
        var7_12 = var1_1.getAbsolutePath();
        var8_14 = new File(var7_12.substring(0, var7_12.indexOf("!")));
        if (JarTool.extract(var8_14, var6_9, var9_15 = new File(var2_2, var6_9)) != null) {
            return new StringBuffer();
        }
        return new StringBuffer(String.valueOf(JarTool.res.getString("JarTool.CantCopy")) + " " + var0 + " --> " + var2_2.getName() + ".\n");
lbl-1000:
        // 1 sources

        {
            var0 = var0.substring(3);
lbl29:
            // 2 sources

            ** while (var0.startsWith((String)"../"))
        }
lbl30:
        // 1 sources

        var6_10 = new File(var2_2, var0);
        if (var6_10.exists()) {
            switch (var3_3.value) {
                case 3: {
                    return new StringBuffer();
                }
                case 2: {
                    break;
                }
                default: {
                    var3_3.value = JarTool.confirmOverwrite(var0);
                    switch (var3_3.value) {
                        case 1: 
                        case 3: {
                            return new StringBuffer();
                        }
                    }
                }
            }
        }
        if (JarTool.copy(var1_1, var6_10)) {
            return new StringBuffer();
        }
        return new StringBuffer(String.valueOf(JarTool.res.getString("JarTool.CantCopy")) + " " + var0 + " --> " + var2_2.getName() + ".\n");
    }

    private static boolean recursiveClearDirectory(File file, FileSystemView fileSystemView) {
        File[] fileArray = fileSystemView.getFiles(file, false);
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory() ? !JarTool.recursiveClearDirectory(fileArray[n], fileSystemView) : !fileArray[n].delete()) {
                return false;
            }
            ++n;
        }
        return file.delete();
    }

    private static Collection<File> recursiveGetDirectory(File file, FileSystemView fileSystemView) {
        File[] fileArray = fileSystemView.getFiles(file, false);
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                arrayList.addAll(JarTool.recursiveGetDirectory(fileArray[n], fileSystemView));
            } else {
                arrayList.add(fileArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    private static class OverwriteValue {
        int value = 1;

        OverwriteValue(int n) {
            this.value = n;
        }
    }

    private static class ProgressDialog
    extends JDialog {
        private int totalSteps;
        private int currentStep = 0;
        private JLabel progressLabel = null;
        private JProgressBar progressBar = null;

        public ProgressDialog(Frame frame, int n, String string, Dimension dimension) {
            super(frame);
            this.totalSteps = n;
            this.setTitle(string);
            this.setSize(dimension);
            this.setModal(false);
            this.getContentPane().setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(){

                public Insets getInsets() {
                    return new Insets(15, 10, 5, 10);
                }
            };
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.getContentPane().add((Component)jPanel, "Center");
            Dimension dimension2 = new Dimension(dimension.width, 20);
            this.progressLabel = new JLabel(string);
            this.progressLabel.setAlignmentX(0.5f);
            this.progressLabel.setMaximumSize(dimension2);
            this.progressLabel.setPreferredSize(dimension2);
            jPanel.add(this.progressLabel);
            jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
            this.progressBar = new JProgressBar(0, this.totalSteps);
            this.progressBar.setStringPainted(true);
            this.progressLabel.setLabelFor(this.progressBar);
            this.progressBar.setAlignmentX(0.5f);
            jPanel.add(this.progressBar);
            Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension3.width - dimension.width) / 2, (dimension3.height - dimension.width) / 2);
            this.getContentPane().add((Component)jPanel, "Center");
            this.setCursor(new Cursor(3));
            this.setVisible(true);
        }

        public void reportProgress(String string) {
            ++this.currentStep;
            this.progressBar.setValue(this.currentStep);
            this.progressLabel.setText(string);
        }
    }
}

