/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Toolkit;
import java.text.ParseException;
import org.opensourcephysics.media.core.NumberField;

public class IntegerField
extends NumberField {
    public IntegerField(int n) {
        super(n);
        this.fixedPattern = true;
        this.format.setParseIntegerOnly(true);
        this.setIntValue((int)this.prevValue);
    }

    public int getIntValue() {
        int n;
        try {
            n = this.format.parse(this.getText()).intValue();
            if (this.minValue != null && n < this.minValue.intValue()) {
                this.setIntValue(this.minValue.intValue());
                return this.minValue.intValue();
            }
            if (this.maxValue != null && n > this.maxValue.intValue()) {
                this.setIntValue(this.maxValue.intValue());
                return this.maxValue.intValue();
            }
        }
        catch (ParseException parseException) {
            Toolkit.getDefaultToolkit().beep();
            this.setIntValue((int)this.prevValue);
            return (int)this.prevValue;
        }
        return n;
    }

    public void setIntValue(int n) {
        if (this.minValue != null) {
            n = Math.max(n, this.minValue.intValue());
        }
        if (this.maxValue != null) {
            n = Math.min(n, this.maxValue.intValue());
        }
        this.setText(this.format.format(n));
        this.prevValue = n;
    }
}

