/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.opensourcephysics.display.CellBorder;
import org.opensourcephysics.tools.DataToolTable;
import org.opensourcephysics.tools.ToolsRes;

public class DataToolStatsTable
extends JTable {
    DataToolTable dataTable;
    StatsTableModel statsModel;
    DataToolTable.LabelRenderer labelRenderer;
    NumberRenderer numberRenderer = new NumberRenderer(3);
    Object[][] statsData;

    public DataToolStatsTable(DataToolTable dataToolTable) {
        this.dataTable = dataToolTable;
        this.statsModel = new StatsTableModel();
        this.init();
    }

    protected void init() {
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
                DataToolStatsTable.this.refreshTable();
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                DataToolStatsTable.this.refreshTable();
            }
        });
        this.refreshStatistics();
        this.setModel(this.statsModel);
        this.setGridColor(Color.blue);
        this.setTableHeader(null);
        this.labelRenderer = this.dataTable.labelRenderer;
        this.setAutoResizeMode(0);
        ListSelectionModel listSelectionModel = this.dataTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getFirstIndex() > -1) {
                    DataToolStatsTable.this.refreshStatistics();
                }
            }
        });
        this.refreshCellWidths();
    }

    private String[] getStatLabels() {
        return new String[]{ToolsRes.getString("Table.Entry.Max"), ToolsRes.getString("Table.Entry.Min"), ToolsRes.getString("Table.Entry.Mean"), ToolsRes.getString("Table.Entry.StandardDev"), ToolsRes.getString("Table.Entry.StandardError"), ToolsRes.getString("Table.Entry.Count")};
    }

    private Object[] getStatistics(double[] dArray) {
        double d;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (!Double.isNaN(dArray[n2])) {
                ++n;
                d2 = Math.max(d2, dArray[n2]);
                d3 = Math.min(d3, dArray[n2]);
                d4 += dArray[n2];
                d5 += dArray[n2] * dArray[n2];
            }
            ++n2;
        }
        double d6 = d4 / (double)n;
        double d7 = d = n < 2 ? Double.NaN : Math.sqrt((d5 - (double)n * d6 * d6) / (double)(n - 1));
        if (d2 == -1.7976931348623157E308) {
            d2 = Double.NaN;
        }
        if (d3 == Double.MAX_VALUE) {
            d3 = Double.NaN;
        }
        return new Object[]{new Double(d2), new Double(d3), new Double(d6), new Double(d), new Double(d / Math.sqrt(n)), new Integer(n)};
    }

    public void refreshTable() {
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                DataToolStatsTable.this.tableChanged(new TableModelEvent(DataToolStatsTable.this.statsModel, -1));
                DataToolStatsTable.this.refreshCellWidths();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void refreshStatistics() {
        TableModel tableModel = this.dataTable.getModel();
        int[] nArray = this.dataTable.getSelectedRows();
        int[] nArray2 = this.dataTable.getSelectedColumns();
        this.statsData = new Object[tableModel.getColumnCount()][0];
        ArrayList<Double> arrayList = new ArrayList<Double>();
        this.statsData[0] = this.getStatLabels();
        int n = 1;
        while (n < tableModel.getColumnCount()) {
            Object object;
            arrayList.clear();
            int n2 = 0;
            while (n2 < tableModel.getRowCount()) {
                object = (Double)tableModel.getValueAt(n2, n);
                if (object == null) {
                    object = new Double(Double.NaN);
                }
                arrayList.add((Double)object);
                ++n2;
            }
            double[] dArray = new double[arrayList.size()];
            int n3 = 0;
            while (n3 < dArray.length) {
                dArray[n3] = (Double)arrayList.get(n3);
                ++n3;
            }
            object = dArray;
            if (nArray.length > 0) {
                boolean bl = false;
                int n4 = this.dataTable.convertColumnIndexToView(n);
                int n5 = 0;
                while (n5 < nArray2.length) {
                    bl = bl || n4 == nArray2[n5];
                    ++n5;
                }
                if (bl) {
                    object = new double[nArray.length];
                    n5 = 0;
                    while (n5 < nArray.length) {
                        object[n5] = dArray[nArray[n5]];
                        ++n5;
                    }
                }
            }
            this.statsData[n] = this.getStatistics((double[])object);
            ++n;
        }
        this.refreshTable();
    }

    public void refreshCellWidths() {
        if (this.getColumnCount() != this.dataTable.getColumnCount()) {
            return;
        }
        int n = 0;
        while (n < this.getColumnCount()) {
            TableColumn tableColumn = this.getColumnModel().getColumn(n);
            TableColumn tableColumn2 = this.dataTable.getColumnModel().getColumn(n);
            tableColumn.setMaxWidth(tableColumn2.getWidth());
            tableColumn.setMinWidth(tableColumn2.getWidth());
            tableColumn.setWidth(tableColumn2.getWidth());
            ++n;
        }
    }

    public void refreshGUI() {
        this.refreshStatistics();
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3 = this.dataTable.convertColumnIndexToModel(n2);
        if (n3 == 0) {
            return this.labelRenderer;
        }
        return this.numberRenderer;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.numberRenderer != null) {
            this.numberRenderer.font = font;
        }
        this.setRowHeight(font.getSize() + 4);
    }

    class NumberRenderer
    extends JLabel
    implements TableCellRenderer {
        NumberFormat format = NumberFormat.getInstance();
        Font font;

        public NumberRenderer(int n) {
            n = Math.min(n, 6);
            if (this.format instanceof DecimalFormat) {
                String string = "0.0";
                int n2 = 0;
                while (n2 < n - 1) {
                    string = String.valueOf(string) + "0";
                    ++n2;
                }
                string = String.valueOf(string) + "E0";
                ((DecimalFormat)this.format).applyPattern(string);
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.font == null) {
                this.font = DataToolStatsTable.this.getDefaultRenderer(String.class).getTableCellRendererComponent(DataToolStatsTable.this, "", false, false, 0, 0).getFont();
            }
            this.setFont(this.font);
            this.setHorizontalAlignment(11);
            this.setBorder(new CellBorder(new Color(240, 240, 240)));
            if (object instanceof Integer) {
                this.setText(String.valueOf(object));
            } else {
                this.setText(this.format.format(object));
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StatsTableModel
    extends AbstractTableModel {
        StatsTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            return DataToolStatsTable.this.dataTable.getColumnName(n);
        }

        @Override
        public int getRowCount() {
            return DataToolStatsTable.this.statsData[0].length;
        }

        @Override
        public int getColumnCount() {
            return DataToolStatsTable.this.dataTable.getModel().getColumnCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            int n3 = DataToolStatsTable.this.dataTable.convertColumnIndexToModel(n2);
            return DataToolStatsTable.this.statsData[n3][n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

