/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractionSource;
import org.opensourcephysics.displayejs.Drawable3D;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.InteractionTargetSetElement;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Measurable3D;
import org.opensourcephysics.displayejs.Object3D;

public class ElementSet
extends AbstractInteractionSource
implements Interactive,
Drawable3D,
Measurable3D {
    protected int numElements = 0;
    protected Class classType;
    protected int elementInteracted = -1;
    protected String name = "";
    protected boolean canBeMeasured = true;
    protected InteractiveElement[] elements = null;
    protected ArrayList list3D = new ArrayList();
    protected Object3D[] minimalObjects = new Object3D[1];

    public ElementSet(int n, Class clazz) {
        if (n < 1) {
            System.out.println("ElementSet error: An element set must contain at least one element!");
            n = 1;
        }
        this.classType = clazz;
        this.setNumberOfElements(n);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int getNumberOfElements() {
        return this.numElements;
    }

    public synchronized void setNumberOfElements(int n) {
        int n2;
        if (n == this.numElements || n < 1) {
            return;
        }
        InteractiveElement[] interactiveElementArray = this.elements;
        this.elements = new InteractiveElement[n];
        try {
            n2 = 0;
            while (n2 < n) {
                this.elements[n2] = (InteractiveElement)this.classType.newInstance();
                this.elements[n2].setSet(this, n2);
                ++n2;
            }
            this.numElements = n;
        }
        catch (Exception exception) {
            System.out.println("Error: ElementSet requires a class that extends InteractiveElement!");
            exception.printStackTrace();
            this.numElements = 0;
            return;
        }
        if (interactiveElementArray == null) {
            return;
        }
        n2 = 0;
        int n3 = Math.min(this.elements.length, interactiveElementArray.length);
        while (n2 < n3) {
            this.elements[n2].copyFrom(interactiveElementArray[n2]);
            ++n2;
        }
        if (this.elements.length > interactiveElementArray.length) {
            n2 = interactiveElementArray.length;
            n3 = this.elements.length;
            while (n2 < n3) {
                this.elements[n2].copyFrom(interactiveElementArray[0]);
                ++n2;
            }
        }
        interactiveElementArray = null;
        this.setName(this.name);
    }

    public InteractiveElement elementAt(int n) {
        return this.elements[n];
    }

    public void setXs(double[] dArray) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            this.elements[n2].setX(dArray[n2]);
            ++n2;
        }
    }

    public double[] getXs() {
        double[] dArray = new double[this.numElements];
        int n = 0;
        while (n < this.numElements) {
            dArray[n] = this.elements[n].getX();
            ++n;
        }
        return dArray;
    }

    public void setYs(double[] dArray) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            this.elements[n2].setY(dArray[n2]);
            ++n2;
        }
    }

    public double[] getYs() {
        double[] dArray = new double[this.numElements];
        int n = 0;
        while (n < this.numElements) {
            dArray[n] = this.elements[n].getY();
            ++n;
        }
        return dArray;
    }

    public void setZs(double[] dArray) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            this.elements[n2].setZ(dArray[n2]);
            ++n2;
        }
    }

    public double[] getZs() {
        double[] dArray = new double[this.numElements];
        int n = 0;
        while (n < this.numElements) {
            dArray[n] = this.elements[n].getZ();
            ++n;
        }
        return dArray;
    }

    public void setXYZs(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        if (n > dArray2.length) {
            n = dArray2.length;
        }
        if (n > dArray3.length) {
            n = dArray3.length;
        }
        int n2 = 0;
        while (n2 < n) {
            this.elements[n2].setXYZ(dArray[n2], dArray2[n2], dArray3[n2]);
            ++n2;
        }
    }

    public void setSizeXs(double[] dArray) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            this.elements[n2].setSizeX(dArray[n2]);
            ++n2;
        }
    }

    public double[] getSizeXs() {
        double[] dArray = new double[this.numElements];
        int n = 0;
        while (n < this.numElements) {
            dArray[n] = this.elements[n].getSizeX();
            ++n;
        }
        return dArray;
    }

    public void setSizeYs(double[] dArray) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            this.elements[n2].setSizeY(dArray[n2]);
            ++n2;
        }
    }

    public double[] getSizeYs() {
        double[] dArray = new double[this.numElements];
        int n = 0;
        while (n < this.numElements) {
            dArray[n] = this.elements[n].getSizeY();
            ++n;
        }
        return dArray;
    }

    public void setSizeZs(double[] dArray) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            this.elements[n2].setSizeZ(dArray[n2]);
            ++n2;
        }
    }

    public double[] getSizeZs() {
        double[] dArray = new double[this.numElements];
        int n = 0;
        while (n < this.numElements) {
            dArray[n] = this.elements[n].getSizeZ();
            ++n;
        }
        return dArray;
    }

    public void setSizeXYZs(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        if (n > dArray2.length) {
            n = dArray2.length;
        }
        if (n > dArray3.length) {
            n = dArray3.length;
        }
        int n2 = 0;
        while (n2 < n) {
            this.elements[n2].setSizeXYZ(dArray[n2], dArray2[n2], dArray3[n2]);
            ++n2;
        }
    }

    public void setVisible(boolean bl) {
        int n = 0;
        while (n < this.numElements) {
            this.elements[n].setVisible(bl);
            ++n;
        }
    }

    public boolean isVisible() {
        int n = 0;
        while (n < this.numElements) {
            if (this.elements[n].isVisible()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setVisibles(boolean[] blArray) {
        int n = this.numElements;
        if (n > blArray.length) {
            n = blArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            this.elements[n2].setVisible(blArray[n2]);
            ++n2;
        }
    }

    public void setEnabled(boolean bl) {
        int n = 0;
        while (n < this.numElements) {
            this.elements[n].setEnabled(bl);
            ++n;
        }
    }

    public boolean isEnabled() {
        int n = 0;
        while (n < this.numElements) {
            if (this.elements[n].isEnabled()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setEnabled(int n, boolean bl) {
        int n2 = 0;
        while (n2 < this.numElements) {
            this.elements[n2].setEnabled(n, bl);
            ++n2;
        }
    }

    public boolean isEnabled(int n) {
        int n2 = 0;
        while (n2 < this.numElements) {
            if (this.elements[n2].isEnabled(n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setEnableds(boolean[] blArray) {
        int n = this.numElements;
        if (n > blArray.length) {
            n = blArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            this.elements[n2].setEnabled(blArray[n2]);
            ++n2;
        }
    }

    public void setEnableds(int n, boolean[] blArray) {
        int n2 = this.numElements;
        if (n2 > blArray.length) {
            n2 = blArray.length;
        }
        int n3 = 0;
        while (n3 < n2) {
            this.elements[n3].setEnabled(n, blArray[n3]);
            ++n3;
        }
    }

    public String toXML() {
        return this.toString();
    }

    public int getElementInteracted() {
        return this.elementInteracted;
    }

    public int getInteractedIndex() {
        return this.elementInteracted;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        int n3 = 0;
        while (n3 < this.numElements) {
            Interactive interactive = this.elements[n3].findInteractive(drawingPanel, n, n2);
            if (interactive != null) {
                this.elementInteracted = n3;
                if (interactive instanceof InteractionTarget) {
                    return new InteractionTargetSetElement(this, n3, (InteractionTarget)interactive);
                }
                return interactive;
            }
            ++n3;
        }
        this.elementInteracted = -1;
        return null;
    }

    public void needsToProject(DrawingPanel drawingPanel) {
        int n = 0;
        while (n < this.numElements) {
            this.elements[n].needsToProject(drawingPanel);
            ++n;
        }
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (this.numElements <= 0) {
            return null;
        }
        this.list3D.clear();
        int n = 0;
        while (n < this.numElements) {
            Object3D[] object3DArray = this.elements[n].getObjects3D(drawingPanel3D);
            if (object3DArray != null) {
                int n2 = 0;
                while (n2 < object3DArray.length) {
                    this.list3D.add(object3DArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        if (this.list3D.size() == 0) {
            return null;
        }
        return this.list3D.toArray(this.minimalObjects);
    }

    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        System.out.println("ElementSet draw (i): I should not be called!");
    }

    public void drawQuickly(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D) {
        int n = this.numElements - 1;
        while (n >= 0) {
            this.elements[n].drawQuickly(drawingPanel3D, graphics2D);
            --n;
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n = this.numElements - 1;
        while (n >= 0) {
            this.elements[n].draw(drawingPanel, graphics);
            --n;
        }
    }

    public void canBeMeasured(boolean bl) {
        this.canBeMeasured = bl;
    }

    public final boolean isMeasured() {
        return this.numElements > 0 && this.canBeMeasured;
    }

    public double getXMin() {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.numElements) {
            double d2;
            double d3 = this.elements[n].getXMin();
            if (d2 < d) {
                d = d3;
            }
            ++n;
        }
        return d;
    }

    public double getXMax() {
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.numElements) {
            double d2;
            double d3 = this.elements[n].getXMax();
            if (d2 > d) {
                d = d3;
            }
            ++n;
        }
        return d;
    }

    public double getYMin() {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.numElements) {
            double d2;
            double d3 = this.elements[n].getYMin();
            if (d2 < d) {
                d = d3;
            }
            ++n;
        }
        return d;
    }

    public double getYMax() {
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.numElements) {
            double d2;
            double d3 = this.elements[n].getYMax();
            if (d2 > d) {
                d = d3;
            }
            ++n;
        }
        return d;
    }

    public double getZMin() {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.numElements) {
            double d2;
            double d3 = this.elements[n].getZMin();
            if (d2 < d) {
                d = d3;
            }
            ++n;
        }
        return d;
    }

    public double getZMax() {
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.numElements) {
            double d2;
            double d3 = this.elements[n].getZMax();
            if (d2 > d) {
                d = d3;
            }
            ++n;
        }
        return d;
    }

    public void setXY(double d, double d2) {
    }

    public void setX(double d) {
    }

    public void setY(double d) {
    }

    public double getX() {
        return Double.NaN;
    }

    public double getY() {
        return Double.NaN;
    }
}

