/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.ballup_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.RK4;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ntnu.fkh.ballup_pkg.ballupSimulation;
import users.ntnu.fkh.ballup_pkg.ballupView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ballup
extends AbstractModel {
    public ballupSimulation _simulation = null;
    public ballupView _view = null;
    public ballup _model = this;
    public double range = 100.0;
    public double xmin = -this.range;
    public double xmax = this.range;
    public double ymin = -this.range / 2.0;
    public double ymax = this.range / 2.0;
    public double t = 0.0;
    public double dt = 0.05;
    public double size = this.range / 5.0;
    public double size2 = this.size / 2.0;
    public double stroke = 2.0;
    public double r = this.size2;
    public double x0;
    public double x = this.x0 = this.xmin + this.size;
    public double y1;
    public double y = this.y1 = this.ymin + this.size;
    public double vx0;
    public double vx = this.vx0 = this.xmax / 4.0;
    public double vy = 0.0;
    public double x2 = this.x + this.size;
    public double vx2 = 0.0;
    public double R = 3.0 * this.size;
    public double cta = 0.0;
    public double omega = 0.0;
    public double g = 10.0;
    public double m = 1.0;
    public double M = 5.0;
    public double L = this.R - this.r;
    public String l_play = "play";
    public String l_pause = "pause";
    public String l_reset = "reset";
    public String l_init = "initialize";
    public String label = "play";
    public String l_step = "step";
    public String l_msg1 = "Vx(red)/Vy(cyan)/ Vx2(blue)";
    public String l_msg2 = "K1(red)/V1(cyan)/K2(blue)/E(green)";
    public String l_show = "Normal Force";
    public int n = 31;
    public double[] px;
    public double[] py;
    public double K1 = 0.0;
    public double K2 = 0.0;
    public double V1 = 0.0;
    public double K = 0.0;
    public int stage = 0;
    public double mu = 0.0;
    public double mu2 = 0.0;
    public double fcst = 2.0;
    public double Nx = 0.0;
    public double Ny = 0.0;
    public double ax2 = 0.0;
    public double alpha = 0.0;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ntnu/fkh/ballup.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
        }
        ballup ballup2 = new ballup(stringArray);
    }

    public ballup() {
        this(null, null, null, null, null, false);
    }

    public ballup(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public ballup(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new ballupSimulation(this, string, frame, uRL, bl);
        this._view = (ballupView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        double d = 1.5707963267948966 / (double)(this.n - 2);
        this.px[0] = this.R;
        this.py[0] = this.y1 - this.size2;
        for (int i = 1; i < this.n; ++i) {
            double d2 = (double)(i - 1) * d;
            this.px[i] = this.R * Math.sin(d2);
            this.py[i] = this.y1 + this.R - this.size2 - this.R * Math.cos(d2);
        }
        this.vx = this.vx0;
        this.vy = 0.0;
        this.t = 0.0;
        this.x = this.x0;
        this.y = this.y1;
        this.x2 = this.x + this.size;
        this.cta = 0.0;
        this.omega = 0.0;
        this.stage = 0;
        this.mu = this.m / (this.m + this.M);
        this.mu2 = 1.0 - this.mu;
        this.vx2 = 0.0;
    }

    public void _constraints1() {
        if (this.stage == 1) {
            this.x = this.x2 + this.L * Math.sin(this.cta);
            this.y = this.y1 + this.L * (1.0 - Math.cos(this.cta));
            this.vx = this.vx2 + this.L * Math.cos(this.cta) * this.omega;
            this.vy = this.L * Math.sin(this.cta) * this.omega;
            this.Nx = -this.M * this.ax2;
            this.Ny = this.m * (this.L * (Math.cos(this.cta) * this.omega * this.omega + Math.sin(this.cta) * this.alpha) + this.g);
        } else {
            this.Nx = 0.0;
            this.Ny = this.stage == 0 ? this.m * this.g : 0.0;
        }
        if (this._isPlaying()) {
            if (this.x2 + this.R > this.xmax || this.x - this.size2 < this.xmin) {
                this.playpause();
            }
            if (this.stage == 2 && this.y < this.y1 + (this.R - this.r) && (this.x - this.x2) * (this.x - this.x2) + (this.y1 + this.L - this.y) * (this.y1 + this.L - this.y) > this.L * this.L) {
                this.playpause();
            }
        }
        this.K1 = 0.5 * this.m * this.vx * this.vx + 0.5 * this.m * this.vy * this.vy;
        this.V1 = this.m * this.g * (this.y - this.y1);
        this.K2 = 0.5 * this.M * this.vx2 * this.vx2;
        this.K = this.K1 + this.K2 + this.V1;
    }

    public void zh_tw() {
        this.l_play = "\u64ad\u653e";
        this.l_init = "\u521d\u59cb\u5316";
        this.l_reset = "\u91cd\u8a2d";
        this.l_pause = "\u66ab\u505c";
        this.l_step = "\u524d\u9032\u4e00\u683c";
        this.l_msg1 = "Vx1(\u7d05)/Vy1(\u6de1\u85cd)/ Vx2(\u6df1\u85cd)";
        this.l_msg2 = "\u52d5\u80fd1(\u7d05)/\u4f4d\u80fd1(\u6de1\u85cd)/\u52d5\u80fd2(\u6df1\u85cd)/\u7e3d\u80fd(\u7da0)";
        this.label = this.l_play;
        this.l_show = "\u6b63\u5411\u529b";
    }

    public void locale(String string) {
        if (string.equals("zh_tw")) {
            this.zh_tw();
        }
    }

    public void playpause() {
        if (this.label == this.l_play) {
            this.label = this.l_pause;
            this._play();
        } else {
            this.label = this.l_play;
            this._pause();
        }
    }

    public double getAlpha(int n, double d, double d2) {
        if (n == 1) {
            return -(this.mu * Math.cos(d) * d2 * d2 + this.g / this.L) * Math.sin(d) / (1.0 - this.mu * Math.cos(d) * Math.cos(d));
        }
        return 0.0;
    }

    public double getAx2(int n, double d, double d2) {
        if (n == 1) {
            return this.mu * this.L * (Math.sin(d) * this.omega * this.omega - Math.cos(this.cta) * this.alpha);
        }
        return 0.0;
    }

    public double getAy(int n) {
        if (n == 2) {
            if (this.vx > 0.0 && this.y > this.y1) {
                return -this.g;
            }
            return 0.0;
        }
        return 0.0;
    }

    public double _method_for_base_sizex() {
        return this.xmax - this.xmin;
    }

    public double _method_for_Arrowvx2_x() {
        return this.x2 + this.R - this.size;
    }

    public double _method_for_N_x() {
        return this.x + this.r * Math.sin(this.cta);
    }

    public double _method_for_N_y() {
        return this.y - this.r * Math.cos(this.cta);
    }

    public double _method_for_Arrowmg_sizey() {
        return -this.m * this.g;
    }

    public double _method_for_TextM_x() {
        return this.x2 + this.R;
    }

    public double _method_for_TextM_y() {
        return this.y1 - this.r;
    }

    public void _method_for_Sliderm_dragaction() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_SliderM_dragaction() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public double _method_for_SliderV0_maximum() {
        return this.xmax / 2.0;
    }

    public void _method_for_SliderV0_dragaction() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_reset_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_initialize_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_playpause_action() {
        this._simulation.disableLoop();
        this.playpause();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.range = 100.0;
        this.xmin = -this.range;
        this.xmax = this.range;
        this.ymin = -this.range / 2.0;
        this.ymax = this.range / 2.0;
        this.t = 0.0;
        this.dt = 0.05;
        this.size = this.range / 5.0;
        this.size2 = this.size / 2.0;
        this.stroke = 2.0;
        this.r = this.size2;
        this.x = this.x0 = this.xmin + this.size;
        this.y = this.y1 = this.ymin + this.size;
        this.vx = this.vx0 = this.xmax / 4.0;
        this.vy = 0.0;
        this.x2 = this.x + this.size;
        this.vx2 = 0.0;
        this.R = 3.0 * this.size;
        this.cta = 0.0;
        this.omega = 0.0;
        this.g = 10.0;
        this.m = 1.0;
        this.M = 5.0;
        this.L = this.R - this.r;
        this.l_play = "play";
        this.l_pause = "pause";
        this.l_reset = "reset";
        this.l_init = "initialize";
        this.label = "play";
        this.l_step = "step";
        this.l_msg1 = "Vx(red)/Vy(cyan)/ Vx2(blue)";
        this.l_msg2 = "K1(red)/V1(cyan)/K2(blue)/E(green)";
        this.l_show = "Normal Force";
        this.n = 31;
        this.px = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.px[n] = 0.0;
        }
        this.py = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.py[n] = 0.0;
        }
        this.K1 = 0.0;
        this.K2 = 0.0;
        this.V1 = 0.0;
        this.K = 0.0;
        this.stage = 0;
        this.mu = 0.0;
        this.mu2 = 0.0;
        this.fcst = 2.0;
        this.Nx = 0.0;
        this.Ny = 0.0;
        this.ax2 = 0.0;
        this.alpha = 0.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.px = null;
        this.py = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[8];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = ballup.this.x;
            this.__state[n++] = ballup.this.y;
            this.__state[n++] = ballup.this.vy;
            this.__state[n++] = ballup.this.cta;
            this.__state[n++] = ballup.this.omega;
            this.__state[n++] = ballup.this.x2;
            this.__state[n++] = ballup.this.vx2;
            this.__state[n++] = ballup.this.t;
            this.__solver = new ODEBisectionEventSolver(this, RK4.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.initialize(ballup.this.dt);
        }

        void step() {
            if (ballup.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(ballup.this.dt);
            }
            int n = 0;
            this.__state[n++] = ballup.this.x;
            this.__state[n++] = ballup.this.y;
            this.__state[n++] = ballup.this.vy;
            this.__state[n++] = ballup.this.cta;
            this.__state[n++] = ballup.this.omega;
            this.__state[n++] = ballup.this.x2;
            this.__state[n++] = ballup.this.vx2;
            this.__state[n++] = ballup.this.t;
            this.__solver.step();
            n = 0;
            ballup.this.x = this.__state[n++];
            ballup.this.y = this.__state[n++];
            ballup.this.vy = this.__state[n++];
            ballup.this.cta = this.__state[n++];
            ballup.this.omega = this.__state[n++];
            ballup.this.x2 = this.__state[n++];
            ballup.this.vx2 = this.__state[n++];
            ballup.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            double d4 = dArray[n++];
            double d5 = dArray[n++];
            double d6 = dArray[n++];
            double d7 = dArray[n++];
            double d8 = dArray[n++];
            n = 0;
            dArray2[n++] = ballup.this.vx;
            dArray2[n++] = d3;
            dArray2[n++] = ballup.this.getAy(ballup.this.stage);
            dArray2[n++] = d5;
            dArray2[n++] = ballup.this.alpha = ballup.this.getAlpha(ballup.this.stage, d4, d5);
            dArray2[n++] = d7;
            dArray2[n++] = ballup.this.ax2 = ballup.this.getAx2(ballup.this.stage, d4, d5);
            dArray2[n++] = 1.0;
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "\u4e8b\u4ef6";
            }

            public double getTolerance() {
                return 0.001;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                double d = dArray[n++];
                double d2 = dArray[n++];
                double d3 = dArray[n++];
                double d4 = dArray[n++];
                double d5 = dArray[n++];
                double d6 = dArray[n++];
                double d7 = dArray[n++];
                double d8 = dArray[n++];
                if (ballup.this.stage == 0) {
                    return d6 - d;
                }
                if (ballup.this.stage == 1) {
                    if (d2 - ballup.this.y1 < ballup.this.L) {
                        return d4;
                    }
                    return ballup.this.L - (d2 - ballup.this.y1);
                }
                return 1.0;
            }

            public boolean action() {
                int n = 0;
                ballup.this.x = _ODE_evolution1.this.__state[n++];
                ballup.this.y = _ODE_evolution1.this.__state[n++];
                ballup.this.vy = _ODE_evolution1.this.__state[n++];
                ballup.this.cta = _ODE_evolution1.this.__state[n++];
                ballup.this.omega = _ODE_evolution1.this.__state[n++];
                ballup.this.x2 = _ODE_evolution1.this.__state[n++];
                ballup.this.vx2 = _ODE_evolution1.this.__state[n++];
                ballup.this.t = _ODE_evolution1.this.__state[n++];
                boolean bl = this.userDefinedAction();
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = ballup.this.x;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = ballup.this.y;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = ballup.this.vy;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = ballup.this.cta;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = ballup.this.omega;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = ballup.this.x2;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = ballup.this.vx2;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = ballup.this.t;
                return bl;
            }

            private boolean userDefinedAction() {
                if (ballup.this.stage == 0) {
                    ballup.this.stage = 1;
                    ballup.this.omega = ballup.this.vx0 / ballup.this.L;
                } else if (ballup.this.stage == 1) {
                    if (ballup.this.omega > 0.0) {
                        ballup.this.stage = 2;
                    } else {
                        ballup.this.stage = 3;
                        ballup.this.vx = ballup.this.mu * ballup.this.vx0 + ballup.this.mu2 * ballup.this.L * Math.cos(ballup.this.cta) * ballup.this.omega;
                        ballup.this.ax2 = 0.0;
                        ballup.this.vy = 0.0;
                    }
                }
                return true;
            }
        }
    }
}

