/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.opensourcephysics.display.AppFrame;
import org.opensourcephysics.display.Hidable;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ToolsRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSPFrame
extends JFrame
implements Hidable,
AppFrame {
    static final String OSP_ICON_FILE = "/org/opensourcephysics/resources/controls/images/osp_icon.gif";
    protected ArrayList<JButton> customButtons = new ArrayList();
    static int topx = 10;
    static int topy = 100;
    protected boolean animated = false;
    protected boolean autoclear = false;
    private volatile boolean wishesToExit = false;
    public ThreadGroup constructorThreadGroup = Thread.currentThread().getThreadGroup();
    protected boolean keepHidden = false;
    protected BufferStrategy strategy;
    protected JPanel buttonPanel = new JPanel();
    protected Collection<JFrame> childFrames = new ArrayList<JFrame>();

    public static JFileChooser getChooser() {
        return OSPRuntime.getChooser();
    }

    public OSPFrame(String string) {
        super(TeXParser.parseTeX(string));
        if (OSPRuntime.appletMode) {
            this.keepHidden = true;
        }
        this.buttonPanel.setVisible(false);
        this.setLocation(topx, topy);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        topx = Math.min(topx + 20, (int)dimension.getWidth() - 100);
        topy = Math.min(topy + 20, (int)dimension.getHeight() - 100);
        this.setDefaultCloseOperation(1);
        this.setFontLevel(FontSizer.getLevel());
        FontSizer.addPropertyChangeListener("level", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                OSPFrame.this.setFontLevel(n);
            }
        });
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                OSPFrame.this.refreshGUI();
            }
        });
        try {
            URL uRL = OSPFrame.class.getResource(OSP_ICON_FILE);
            ImageIcon imageIcon = new ImageIcon(uRL);
            this.setIconImage(imageIcon.getImage());
        }
        catch (Exception exception) {}
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                OSPFrame.this.disposeChildWindows();
            }
        });
    }

    void disposeChildWindows() {
        for (JFrame jFrame : this.childFrames) {
            if (!jFrame.isDisplayable()) continue;
            if (jFrame instanceof OSPFrame) {
                ((OSPFrame)jFrame).setKeepHidden(true);
            } else {
                jFrame.setVisible(false);
            }
            jFrame.dispose();
        }
        this.childFrames.clear();
    }

    public OSPFrame() {
        this("Open Source Physics");
    }

    public OSPFrame(Container container) {
        this();
        this.setContentPane(container);
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(TeXParser.parseTeX(string));
    }

    public void addChildFrame(JFrame jFrame) {
        if (jFrame == null || !jFrame.isDisplayable()) {
            return;
        }
        this.childFrames.add(jFrame);
    }

    public void clearChildFrames() {
        this.childFrames.clear();
    }

    public Collection<JFrame> getChildFrames() {
        return new ArrayList<JFrame>(this.childFrames);
    }

    public boolean isIconified() {
        return (this.getExtendedState() & 1) == 1;
    }

    public void invalidateImage() {
    }

    protected void setFontLevel(int n) {
        FontSizer.setFonts(this.getJMenuBar(), n);
        FontSizer.setFonts(this.getContentPane(), n);
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean bl) {
        this.animated = bl;
    }

    public boolean isAutoclear() {
        return this.autoclear;
    }

    public void setAutoclear(boolean bl) {
        this.autoclear = bl;
    }

    protected JMenu loadDisplayMenu() {
        return null;
    }

    protected JMenu loadToolsMenu() {
        return null;
    }

    public void clearData() {
    }

    public void clearDataAndRepaint() {
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.validate();
    }

    @Override
    public void show() {
        if (!this.keepHidden) {
            super.show();
        }
    }

    @Override
    public void dispose() {
        this.keepHidden = true;
        this.clearData();
        this.disposeChildWindows();
        super.dispose();
    }

    @Override
    public void setVisible(boolean bl) {
        if (!this.keepHidden) {
            boolean bl2 = !this.isVisible() && this.animated;
            super.setVisible(bl);
            if (bl2) {
                this.render();
            }
        }
    }

    @Override
    public void setKeepHidden(boolean bl) {
        this.keepHidden = bl;
        if (this.keepHidden) {
            super.setVisible(false);
        }
    }

    @Override
    public boolean isKeepHidden() {
        return this.keepHidden;
    }

    public ThreadGroup getConstructorThreadGroup() {
        return this.constructorThreadGroup;
    }

    public void createBufferStrategy() {
        this.createBufferStrategy(2);
        this.strategy = this.getBufferStrategy();
    }

    public void bufferStrategyShow() {
        if (this.strategy == null) {
            this.createBufferStrategy();
        }
        if (this.isIconified() || !this.isShowing()) {
            return;
        }
        Graphics graphics = this.strategy.getDrawGraphics();
        this.paintComponents(graphics);
        graphics.dispose();
        this.strategy.show();
    }

    public void render() {
    }

    public JMenu getMenu(String string) {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        string = string.trim();
        JMenu jMenu = null;
        int n = 0;
        while (n < jMenuBar.getMenuCount()) {
            JMenu jMenu2 = jMenuBar.getMenu(n);
            if (jMenu2.getText().trim().equals(string)) {
                jMenu = jMenu2;
                break;
            }
            ++n;
        }
        return jMenu;
    }

    public JMenu removeMenu(String string) {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        string = string.trim();
        JMenu jMenu = null;
        int n = 0;
        while (n < jMenuBar.getMenuCount()) {
            JMenu jMenu2 = jMenuBar.getMenu(n);
            if (jMenu2.getText().trim().equals(string)) {
                jMenu = jMenu2;
                jMenuBar.remove(n);
                break;
            }
            ++n;
        }
        return jMenu;
    }

    public JMenuItem removeMenuItem(String string, String string2) {
        JMenu jMenu = this.getMenu(string);
        if (jMenu == null) {
            return null;
        }
        string2 = string2.trim();
        JMenuItem jMenuItem = null;
        int n = 0;
        while (n < jMenu.getItemCount()) {
            JMenuItem jMenuItem2 = jMenu.getItem(n);
            if (jMenuItem2.getText().trim().equals(string2)) {
                jMenuItem = jMenuItem2;
                jMenu.remove(n);
                break;
            }
            ++n;
        }
        return jMenuItem;
    }

    public void parseXMLMenu(String string) {
        this.parseXMLMenu(string, null);
    }

    public void parseXMLMenu(String string, Class<?> clazz) {
        System.out.println("The parseXMLMenu method has been disabled to reduce the size OSP jar files.");
    }

    protected void refreshGUI() {
        for (TranslatableButton translatableButton : this.customButtons) {
            translatableButton.refreshGUI();
        }
        this.buttonPanel.validate();
    }

    public JButton addButton(String string, String string2, String string3, final Object object) {
        TranslatableButton translatableButton = new TranslatableButton(string2, string3, object);
        if (OSPRuntime.translator != null) {
            string2 = OSPRuntime.translator.getProperty(object.getClass(), "custom_button." + string2, string2);
            string3 = OSPRuntime.translator.getProperty(object.getClass(), "custom_button." + string3, string3);
        }
        translatableButton.setText(string2);
        translatableButton.setToolTipText(string3);
        Class[] classArray = new Class[]{};
        try {
            final Method method = object.getClass().getMethod(string, classArray);
            translatableButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = new Object[]{};
                    try {
                        method.invoke(object, objectArray);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.err.println(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        System.err.println(invocationTargetException);
                    }
                }
            });
            this.buttonPanel.setVisible(true);
            this.buttonPanel.add(translatableButton);
            this.validate();
            this.pack();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Error adding custom button " + string2 + ". The method " + string + "() does not exist.");
        }
        this.customButtons.add(translatableButton);
        return translatableButton;
    }

    @Override
    public void setDefaultCloseOperation(int n) {
        if (n == 3 && OSPRuntime.launchingInSingleVM) {
            n = 2;
            this.wishesToExit = true;
        }
        try {
            super.setDefaultCloseOperation(n);
        }
        catch (Exception exception) {}
    }

    @Override
    public boolean wishesToExit() {
        return this.wishesToExit;
    }

    class TranslatableButton
    extends JButton {
        String text;
        String tip;
        Object target;

        public TranslatableButton(String string, String string2, Object object) {
            this.text = string;
            this.tip = string2;
            this.target = object;
        }

        void refreshGUI() {
            if (OSPRuntime.translator != null) {
                this.setText(OSPRuntime.translator.getProperty(this.target.getClass(), "custom_button." + this.text, this.text));
                this.setToolTipText(OSPRuntime.translator.getProperty(this.target.getClass(), "custom_button." + this.tip, this.tip));
            }
        }
    }
}

