/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractionTargetElementSize;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.displayejs.Point3D;
import org.opensourcephysics.displayejs.Resolution;
import org.opensourcephysics.displayejs.utils.VectorAlgebra;

public class InteractiveSpring
extends AbstractInteractiveElement {
    protected int loops = -1;
    protected int pointsPerLoop = -1;
    protected double solenoid = 0.0;
    protected boolean thinExtremes = true;
    protected double radius = 0.1;
    private int segments = 0;
    private int[] aPoints = null;
    private int[] bPoints = null;
    private double[][] pointCoordinates = null;
    private double[] pixel = new double[3];
    private Object3D[] objects = null;

    public InteractiveSpring() {
        this(0.1);
    }

    public InteractiveSpring(double d) {
        this.setRadius(d);
        this.resolution = new Resolution(8, 15);
    }

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof InteractiveSpring) {
            this.setRadius(((InteractiveSpring)interactiveElement).getRadius());
        }
    }

    public void setRadius(double d) {
        this.radius = d;
        this.hasChanged = true;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setSolenoid(double d) {
        this.solenoid = d;
        this.hasChanged = true;
    }

    public void setThinExtremes(boolean bl) {
        this.thinExtremes = bl;
        this.hasChanged = true;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged) {
            this.computePoints();
            this.projectPoints(drawingPanel);
        } else if (drawingPanel != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel);
        }
        if (this.sizeEnabled && Math.abs(this.aPoints[this.segments] - n) < SENSIBILITY && Math.abs(this.bPoints[this.segments] - n2) < SENSIBILITY) {
            return new InteractionTargetElementSize(this);
        }
        if (this.positionEnabled && Math.abs(this.aPoints[0] - n) < SENSIBILITY && Math.abs(this.bPoints[0] - n2) < SENSIBILITY) {
            return new InteractionTargetElementPosition(this);
        }
        return null;
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged) {
            this.computePoints();
            this.projectPoints(drawingPanel3D);
        } else if (drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        return this.objects;
    }

    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        Color color = drawingPanel3D.projectColor(this.style.edgeColor, this.objects[n].distance);
        graphics2D.setStroke(this.style.edgeStroke);
        graphics2D.setColor(color);
        graphics2D.drawLine(this.aPoints[n], this.bPoints[n], this.aPoints[n + 1], this.bPoints[n + 1]);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged) {
            this.computePoints();
            this.projectPoints(drawingPanel);
        } else {
            this.projectPoints(drawingPanel);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(this.style.edgeStroke);
        graphics2D.setColor(this.style.edgeColor);
        graphics2D.drawPolyline(this.aPoints, this.bPoints, this.segments + 1);
    }

    public double getXMin() {
        if (this.group == null) {
            return this.x + Math.min(this.sizex, 0.0);
        }
        return this.group.x + this.x + Math.min(this.sizex * this.group.sizex, 0.0);
    }

    public double getXMax() {
        if (this.group == null) {
            return this.x + Math.max(this.sizex, 0.0);
        }
        return this.group.x + this.x + Math.max(this.sizex * this.group.sizex, 0.0);
    }

    public double getYMin() {
        if (this.group == null) {
            return this.y + Math.min(this.sizey, 0.0);
        }
        return this.group.y + this.y + Math.min(this.sizey * this.group.sizey, 0.0);
    }

    public double getYMax() {
        if (this.group == null) {
            return this.y + Math.max(this.sizey, 0.0);
        }
        return this.group.y + this.y + Math.max(this.sizey * this.group.sizey, 0.0);
    }

    public double getZMin() {
        if (this.group == null) {
            return this.z + Math.min(this.sizez, 0.0);
        }
        return this.group.z + this.z + Math.min(this.sizez * this.group.sizez, 0.0);
    }

    public double getZMax() {
        if (this.group == null) {
            return this.z + Math.max(this.sizez, 0.0);
        }
        return this.group.z + this.z + Math.max(this.sizez * this.group.sizez, 0.0);
    }

    protected void projectPoints(DrawingPanel drawingPanel) {
        if (this.group == null) {
            int n = 0;
            while (n < this.segments) {
                drawingPanel.project(this.pointCoordinates[n], this.pixel);
                this.aPoints[n] = (int)this.pixel[0];
                this.bPoints[n] = (int)this.pixel[1];
                this.objects[n].distance = this.pixel[2];
                ++n;
            }
            drawingPanel.project(this.pointCoordinates[this.segments], this.pixel);
            this.aPoints[this.segments] = (int)this.pixel[0];
            this.bPoints[this.segments] = (int)this.pixel[1];
        } else {
            double[] dArray = new double[3];
            int n = 0;
            while (n < this.segments) {
                dArray[0] = this.group.x + this.pointCoordinates[n][0] * this.group.sizex;
                dArray[1] = this.group.y + this.pointCoordinates[n][1] * this.group.sizey;
                dArray[2] = this.group.z + this.pointCoordinates[n][2] * this.group.sizez;
                drawingPanel.project(dArray, this.pixel);
                this.aPoints[n] = (int)this.pixel[0];
                this.bPoints[n] = (int)this.pixel[1];
                this.objects[n].distance = this.pixel[2];
                ++n;
            }
            dArray[0] = this.group.x + this.pointCoordinates[this.segments][0] * this.group.sizex;
            dArray[1] = this.group.y + this.pointCoordinates[this.segments][1] * this.group.sizey;
            dArray[2] = this.group.z + this.pointCoordinates[this.segments][2] * this.group.sizez;
            drawingPanel.project(dArray, this.pixel);
            this.aPoints[this.segments] = (int)this.pixel[0];
            this.bPoints[this.segments] = (int)this.pixel[1];
        }
        this.panelWithValidProjection = drawingPanel;
    }

    private void computePoints() {
        int n = this.loops;
        int n2 = this.pointsPerLoop;
        if (this.resolution != null) {
            switch (this.resolution.type) {
                case 0: {
                    n = Math.max(this.resolution.n1, 0);
                    n2 = Math.max(this.resolution.n2, 1);
                }
            }
        }
        if (n != this.loops || n2 != this.pointsPerLoop) {
            this.loops = n;
            this.pointsPerLoop = n2;
            this.segments = this.loops * this.pointsPerLoop;
            this.pointCoordinates = new double[this.segments + 1][3];
            this.aPoints = new int[this.segments + 1];
            this.bPoints = new int[this.segments + 1];
            this.objects = new Object3D[this.segments];
            int n3 = 0;
            while (n3 < this.segments) {
                this.objects[n3] = new Object3D(this, n3);
                ++n3;
            }
        }
        Point3D point3D = new Point3D(this.sizex, this.sizey, this.sizez);
        Point3D point3D2 = VectorAlgebra.normalTo(point3D);
        Point3D point3D3 = VectorAlgebra.normalize(VectorAlgebra.crossProduct(point3D, point3D2));
        double d = Math.PI * 2 / (double)this.pointsPerLoop;
        if (this.radius < 0.0) {
            d *= -1.0;
        }
        int n4 = this.pointsPerLoop / 2;
        int n5 = 0;
        while (n5 <= this.segments) {
            int n6 = this.thinExtremes ? (n5 < n4 ? 0 : (n5 < this.pointsPerLoop ? n5 - n4 : (n5 > this.segments - n4 ? 0 : (n5 > this.segments - this.pointsPerLoop ? this.segments - n5 - n4 : n4)))) : n4;
            double d2 = 1.5707963267948966 + (double)n5 * d;
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            this.pointCoordinates[n5][0] = this.x + (double)n5 * point3D.x / (double)this.segments + (double)n6 * this.radius * (d3 * point3D2.x + d4 * point3D3.x) / (double)n4;
            this.pointCoordinates[n5][1] = this.y + (double)n5 * point3D.y / (double)this.segments + (double)n6 * this.radius * (d3 * point3D2.y + d4 * point3D3.y) / (double)n4;
            this.pointCoordinates[n5][2] = this.z + (double)n5 * point3D.z / (double)this.segments + (double)n6 * this.radius * (d3 * point3D2.z + d4 * point3D3.z) / (double)n4;
            if (this.solenoid != 0.0) {
                double d5 = (double)n6 * Math.cos((double)(n5 * 2) * Math.PI / (double)this.pointsPerLoop) / (double)n4;
                double[] dArray = this.pointCoordinates[n5];
                dArray[0] = dArray[0] + this.solenoid * d5 * point3D.x;
                double[] dArray2 = this.pointCoordinates[n5];
                dArray2[1] = dArray2[1] + this.solenoid * d5 * point3D.y;
                double[] dArray3 = this.pointCoordinates[n5];
                dArray3[2] = dArray3[2] + this.solenoid * d5 * point3D.z;
            }
            ++n5;
        }
        this.hasChanged = false;
    }
}

